/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Callback;
import artofillusion.ModellingApp;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.WireframeMesh;
import artofillusion.animation.ActorEditorWindow;
import artofillusion.animation.ActorPose;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Actor
extends Object3D {
    Object3D theObject;
    ActorPose[] pose;
    String[] poseName;
    int[] poseID;
    int nextPoseID;
    ActorKeyframe currentPose;
    TextureParameter[] texParam;
    static /* synthetic */ Class class$java$io$DataInputStream;
    static /* synthetic */ Class class$artofillusion$Scene;
    static /* synthetic */ Class class$java$lang$Object;

    public Actor(Object3D obj) {
        this.theObject = obj;
        this.pose = new ActorPose[]{(ActorPose)obj.getPoseKeyframe()};
        this.poseName = new String[]{"Default Pose"};
        this.poseID = new int[]{0};
        this.nextPoseID = 1;
        this.currentPose = new ActorKeyframe();
        this.texParam = obj.getTextureMapping().getParameters();
    }

    public Object3D getObject() {
        return this.theObject;
    }

    public void addPose(ActorPose p, String name) {
        int num = this.pose.length;
        ActorPose[] newpose = new ActorPose[num + 1];
        String[] newname = new String[num + 1];
        int[] newID = new int[num + 1];
        System.arraycopy(this.pose, 0, newpose, 0, num);
        System.arraycopy(this.poseName, 0, newname, 0, num);
        System.arraycopy(this.poseID, 0, newID, 0, num);
        newpose[num] = p;
        newname[num] = name;
        ++this.nextPoseID;
        this.pose = newpose;
        this.poseName = newname;
        this.poseID = newID;
    }

    public void deletePose(int id) {
        int which = 0;
        while (which < this.poseID.length && this.poseID[which] != id) {
            ++which;
        }
        if (which == this.poseID.length) {
            return;
        }
        int num = this.pose.length;
        ActorPose[] newpose = new ActorPose[num - 1];
        String[] newname = new String[num - 1];
        int[] newID = new int[num - 1];
        int j = 0;
        int i = 0;
        while (i < num) {
            if (i != which) {
                newpose[j] = this.pose[i];
                newname[j] = this.poseName[i];
                newID[j] = this.poseID[i];
                ++j;
            }
            ++i;
        }
        this.pose = newpose;
        this.poseName = newname;
        this.poseID = newID;
    }

    public Object3D duplicate() {
        Actor a = new Actor(this.theObject.duplicate());
        a.pose = new ActorPose[this.pose.length];
        a.poseName = new String[this.pose.length];
        a.poseID = new int[this.pose.length];
        int i = 0;
        while (i < this.pose.length) {
            a.pose[i] = (ActorPose)this.pose[i].duplicate(a.theObject);
            a.poseName[i] = this.poseName[i];
            a.poseID[i] = this.poseID[i];
            ++i;
        }
        a.nextPoseID = this.nextPoseID;
        a.currentPose = (ActorKeyframe)this.currentPose.duplicate(a);
        return a;
    }

    public void copyObject(Object3D obj) {
        Actor a = (Actor)obj;
        this.theObject = a.theObject.duplicate();
        this.pose = new ActorPose[a.pose.length];
        this.poseName = new String[a.pose.length];
        this.poseID = new int[a.pose.length];
        int i = 0;
        while (i < this.pose.length) {
            this.pose[i] = (ActorPose)a.pose[i].duplicate(this.theObject);
            this.poseName[i] = a.poseName[i];
            this.poseID[i] = a.poseID[i];
            ++i;
        }
        this.nextPoseID = a.nextPoseID;
        this.currentPose = (ActorKeyframe)a.currentPose.duplicate(this);
    }

    public BoundingBox getBounds() {
        return this.theObject.getBounds();
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean isClosed() {
        return this.theObject.isClosed();
    }

    public boolean editable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        new ActorEditorWindow(parent, info, this, null, cb);
    }

    public Skeleton getSkeleton() {
        if (this.theObject instanceof Mesh) {
            return ((Mesh)((Object)this.theObject)).getSkeleton();
        }
        return null;
    }

    public boolean canSetTexture() {
        return this.theObject.canSetTexture();
    }

    public boolean canSetMaterial() {
        return this.theObject.canSetMaterial();
    }

    public void setTexture(Texture tex) {
        this.theObject.setTexture(tex);
    }

    public Texture getTexture() {
        return this.theObject.getTexture();
    }

    public void setMaterial(Material mat) {
        this.theObject.setMaterial(mat);
    }

    public Material getMaterial() {
        return this.theObject.getMaterial();
    }

    public void setTextureMapping(TextureMapping mapping) {
        TextureParameter[] newparam = mapping.getParameters();
        this.theObject.setTextureMapping(mapping);
        if (this.texParam != null) {
            int i = 0;
            while (i < this.pose.length) {
                this.pose[i].textureChanged(this.texParam, newparam);
                ++i;
            }
        }
        this.texParam = newparam;
    }

    public TextureMapping getTextureMapping() {
        return this.theObject.getTextureMapping();
    }

    public void setMaterialMapping(MaterialMapping mapping) {
        this.theObject.setMaterialMapping(mapping);
    }

    public MaterialMapping getMaterialMapping() {
        return this.theObject.getMaterialMapping();
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        return this.theObject.getRenderingMesh(tol, interactive, info);
    }

    public WireframeMesh getWireframeMesh() {
        return this.theObject.getWireframeMesh();
    }

    public void setTextureParameter(TextureParameter param, double[] value) {
        if (!(this.theObject instanceof Mesh)) {
            return;
        }
        TextureParameter[] allParams = this.theObject.getTextureMapping().getParameters();
        int which = 0;
        while (which < allParams.length && !allParams[which].equals(param)) {
            ++which;
        }
        if (which == allParams.length) {
            return;
        }
        MeshVertex[] vert = ((Mesh)((Object)this.theObject)).getVertices();
        int i = 0;
        while (i < value.length) {
            vert[i].param[which] = value[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.pose.length) {
            this.pose[i2].setTextureParameter(param, value);
            ++i2;
        }
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.theObject.getClass().getName());
        this.theObject.writeToFile(out, theScene);
        out.writeInt(this.nextPoseID);
        out.writeUTF(this.pose[0].getClass().getName());
        out.writeInt(this.pose.length);
        int i = 0;
        while (i < this.pose.length) {
            out.writeInt(this.poseID[i]);
            out.writeUTF(this.poseName[i]);
            this.pose[i].writeToStream(out);
            ++i;
        }
        this.currentPose.writeToStream(out);
    }

    public Actor(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        try {
            Class cls = ModellingApp.getClass(in.readUTF());
            Constructor con = cls.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = Actor.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$artofillusion$Scene == null ? (class$artofillusion$Scene = Actor.class$("artofillusion.Scene")) : class$artofillusion$Scene);
            this.theObject = (Object3D)con.newInstance(in, theScene);
            this.nextPoseID = in.readInt();
            cls = ModellingApp.getClass(in.readUTF());
            con = cls.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = Actor.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$java$lang$Object == null ? (class$java$lang$Object = Actor.class$("java.lang.Object")) : class$java$lang$Object);
            int num = in.readInt();
            this.pose = new ActorPose[num];
            this.poseName = new String[num];
            this.poseID = new int[num];
            int i = 0;
            while (i < num) {
                this.poseID[i] = in.readInt();
                this.poseName[i] = in.readUTF();
                this.pose[i] = (ActorPose)con.newInstance(in, this.theObject);
                ++i;
            }
            this.currentPose = new ActorKeyframe(in, this);
            this.texParam = this.theObject.getTextureMapping().getParameters();
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
            throw new IOException();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
    }

    public Keyframe getPoseKeyframe() {
        return this.currentPose.duplicate(this);
    }

    public void applyPoseKeyframe(Keyframe k) {
        this.currentPose = (ActorKeyframe)k.duplicate(this);
        Vector<ActorPose> poseVec = new Vector<ActorPose>();
        Vector<Double> weightVec = new Vector<Double>();
        int i = 0;
        while (i < this.currentPose.id.length) {
            int which = this.findPoseIndex(this.currentPose.id[i]);
            if (which > -1) {
                poseVec.addElement(this.pose[which]);
                weightVec.addElement(new Double(this.currentPose.weight[i]));
            }
            ++i;
        }
        ActorPose[] blendPose = new ActorPose[poseVec.size()];
        double[] blendWeight = new double[poseVec.size()];
        int i2 = 0;
        while (i2 < blendPose.length) {
            blendPose[i2] = (ActorPose)poseVec.elementAt(i2);
            blendWeight[i2] = (Double)weightVec.elementAt(i2);
            ++i2;
        }
        this.theObject.applyPoseKeyframe(this.pose[0].blend(blendPose, blendWeight));
    }

    int findPoseIndex(int id) {
        int min = 0;
        int max = this.poseID.length - 1;
        int current = min + max >> 1;
        while (this.poseID[current] != id) {
            if (this.poseID[current] > id) {
                max = current - 1;
            } else {
                min = current + 1;
            }
            if (min >= max) {
                if (min < this.poseID.length && this.poseID[min] == id) {
                    return min;
                }
                return -1;
            }
            current = min + max >> 1;
        }
        return current;
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        new ActorEditorWindow(parent, info, this, (ActorKeyframe)k, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ActorKeyframe
    implements Keyframe {
        int[] id;
        double[] weight;

        public ActorKeyframe() {
            this.id = new int[0];
            this.weight = new double[0];
        }

        public void addPose(int addID, double addWeight) {
            int[] newid = new int[this.id.length + 1];
            double[] newweight = new double[this.weight.length + 1];
            System.arraycopy(this.id, 0, newid, 0, this.id.length);
            System.arraycopy(this.weight, 0, newweight, 0, this.weight.length);
            newid[this.id.length] = addID;
            newweight[this.weight.length] = addWeight;
            this.id = newid;
            this.weight = newweight;
        }

        public void deletePose(int which) {
            int[] newid = new int[this.id.length - 1];
            double[] newweight = new double[this.weight.length - 1];
            int i = 0;
            int j = 0;
            while (i < this.id.length) {
                if (i != which) {
                    newid[j] = this.id[i];
                    newweight[j++] = this.weight[i];
                }
                ++i;
            }
            this.id = newid;
            this.weight = newweight;
        }

        public Keyframe duplicate(Object owner) {
            return this.duplicate();
        }

        public Keyframe duplicate() {
            ActorKeyframe k = new ActorKeyframe();
            k.id = new int[this.id.length];
            k.weight = new double[this.weight.length];
            System.arraycopy(this.id, 0, k.id, 0, this.id.length);
            System.arraycopy(this.weight, 0, k.weight, 0, this.weight.length);
            return k;
        }

        public void copy(ActorKeyframe key) {
            this.id = new int[key.id.length];
            this.weight = new double[key.weight.length];
            System.arraycopy(key.id, 0, this.id, 0, this.id.length);
            System.arraycopy(key.weight, 0, this.weight, 0, this.weight.length);
        }

        public double[] getGraphValues() {
            return new double[0];
        }

        public void setGraphValues(double[] values) {
        }

        private void addWeightsToTable(ActorKeyframe k, Hashtable table, double scale) {
            int i = 0;
            while (i < k.id.length) {
                Integer key = new Integer(k.id[i]);
                Double weight = (Double)table.get(key);
                weight = weight == null ? new Double(k.weight[i] * scale) : new Double(k.weight[i] * scale + weight);
                table.put(key, weight);
                ++i;
            }
        }

        private ActorKeyframe getKeyframeFromTable(Hashtable table) {
            Object weight;
            ActorKeyframe k = new ActorKeyframe();
            k.id = new int[table.size()];
            k.weight = new double[k.id.length];
            Enumeration enumeration = table.keys();
            int j = 0;
            int i = 0;
            while (i < k.id.length) {
                Integer key = (Integer)enumeration.nextElement();
                weight = (Double)table.get(key);
                k.id[j] = key;
                k.weight[j] = (Double)weight;
                if (k.weight[j] != 0.0) {
                    ++j;
                }
                ++i;
            }
            if (j < k.id.length) {
                int[] id = new int[j];
                weight = new double[j];
                System.arraycopy(k.id, 0, id, 0, j);
                System.arraycopy(k.weight, 0, weight, 0, j);
                k.id = id;
                k.weight = (double[])weight;
            }
            return k;
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            Hashtable table = new Hashtable();
            this.addWeightsToTable(this, table, weight1);
            this.addWeightsToTable((ActorKeyframe)o2, table, weight2);
            return this.getKeyframeFromTable(table);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            Hashtable table = new Hashtable();
            this.addWeightsToTable(this, table, weight1);
            this.addWeightsToTable((ActorKeyframe)o2, table, weight2);
            this.addWeightsToTable((ActorKeyframe)o3, table, weight3);
            return this.getKeyframeFromTable(table);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            Hashtable table = new Hashtable();
            this.addWeightsToTable(this, table, weight1);
            this.addWeightsToTable((ActorKeyframe)o2, table, weight2);
            this.addWeightsToTable((ActorKeyframe)o3, table, weight3);
            this.addWeightsToTable((ActorKeyframe)o4, table, weight4);
            return this.getKeyframeFromTable(table);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof ActorKeyframe)) {
                return false;
            }
            ActorKeyframe key = (ActorKeyframe)k;
            if (this.id.length != key.id.length) {
                return false;
            }
            int i = 0;
            while (i < this.id.length) {
                if (this.id[i] != key.id[i] || this.weight[i] != key.weight[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeInt(this.id.length);
            int i = 0;
            while (i < this.id.length) {
                out.writeInt(this.id[i]);
                out.writeDouble(this.weight[i]);
                ++i;
            }
        }

        public ActorKeyframe(DataInputStream in, Object parent) throws IOException {
            int num = in.readInt();
            this.id = new int[num];
            this.weight = new double[num];
            int i = 0;
            while (i < num) {
                this.id[i] = in.readInt();
                this.weight[i] = in.readDouble();
                ++i;
            }
        }
    }
}

