/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Callback;
import artofillusion.LayoutWindow;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.animation.Actor;
import artofillusion.animation.ActorPose;
import artofillusion.animation.Joint;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.EntriesDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ShortLabel;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.text.NumberFormat;

public class ActorEditorWindow
extends Dialog
implements ActionListener,
ItemListener,
TextListener {
    Actor theObject;
    Actor oldObject;
    ObjectInfo objInfo;
    EditingWindow theWindow;
    List poseList;
    List currentPoseList;
    Button addButton;
    Button removeButton;
    Button saveButton;
    Button extractButton;
    Button editButton;
    Button renameButton;
    Button copyButton;
    Button deleteButton;
    Button okButton;
    Button cancelButton;
    ValueField weightField;
    Actor.ActorKeyframe currentPose;
    Actor.ActorKeyframe key;
    ObjectPreviewCanvas preview;
    Callback onClose;

    public ActorEditorWindow(EditingWindow parent, ObjectInfo info, Actor obj, Actor.ActorKeyframe key, Callback cb) {
        super((Frame)((Object)parent), key == null ? info.name : "Edit Keyframe for " + info.name, false);
        this.objInfo = info;
        this.oldObject = obj;
        this.theObject = (Actor)obj.duplicate();
        this.theWindow = parent;
        this.key = key;
        if (key != null) {
            this.theObject.applyPoseKeyframe(key);
        }
        this.currentPose = (Actor.ActorKeyframe)this.theObject.getPoseKeyframe();
        this.onClose = cb;
        int i = this.currentPose.id.length - 1;
        while (i >= 0) {
            int which = this.theObject.findPoseIndex(this.currentPose.id[i]);
            if (which == -1) {
                this.currentPose.deletePose(i);
            }
            --i;
        }
        Panel center = new Panel();
        this.add((Component)center, "Center");
        center.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        GridBagConstraints gc2 = new GridBagConstraints();
        gc2.gridy = 0;
        gc2.fill = 1;
        gc2.weightx = 1.0;
        gc2.gridheight = 2;
        Panel p = new Panel();
        center.add((Component)p, gc2);
        p.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.poseList = new List(10);
        p.add((Component)this.poseList, gc);
        int i2 = 0;
        while (i2 < this.theObject.poseName.length) {
            this.poseList.add(this.theObject.poseName[i2]);
            ++i2;
        }
        gc.weighty = 0.0;
        gc.fill = 2;
        gc.insets.right = 5;
        gc.insets.left = 5;
        gc.insets.top = 5;
        this.editButton = new Button("Edit");
        p.add((Component)this.editButton, gc);
        this.renameButton = new Button("Rename");
        p.add((Component)this.renameButton, gc);
        this.copyButton = new Button("Duplicate");
        p.add((Component)this.copyButton, gc);
        this.deleteButton = new Button("Delete");
        p.add((Component)this.deleteButton, gc);
        gc2.gridheight = 1;
        p = new Panel();
        center.add((Component)p, gc2);
        p.setLayout(new GridBagLayout());
        gc.weightx = 0.0;
        this.addButton = new Button("Add >>");
        p.add((Component)this.addButton, gc);
        this.removeButton = new Button("<< Remove");
        p.add((Component)this.removeButton, gc);
        this.saveButton = new Button("Save...");
        p.add((Component)this.saveButton, gc);
        this.extractButton = new Button("Extract...");
        p.add((Component)this.extractButton, gc);
        p = new Panel();
        center.add((Component)p, gc2);
        p.setLayout(new GridBagLayout());
        gc.anchor = 11;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        gc.insets.right = 0;
        gc.insets.left = 0;
        gc.insets.top = 0;
        p.add((Component)new ShortLabel("Current Pose:"), gc);
        gc.weighty = 1.0;
        gc.fill = 1;
        this.currentPoseList = new List(4);
        p.add((Component)this.currentPoseList, gc);
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        gc.fill = 0;
        p.add((Component)new Label("Weight: "), gc);
        gc.gridx = 1;
        this.weightField = new ValueField(Double.NaN, 0, 5);
        p.add((Component)this.weightField, gc);
        this.weightField.addTextListener(this);
        this.buildCurrentPoseList();
        gc2.gridwidth = 2;
        gc2.gridx = 1;
        gc2.gridy = 1;
        gc2.weighty = 1.0;
        this.preview = new ObjectPreviewCanvas(new ObjectInfo(this.theObject, new CoordinateSystem(), ""));
        center.add((Component)this.preview, gc2);
        p = new Panel();
        this.add((Component)p, "South");
        this.okButton = Translate.button("ok", this);
        p.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this);
        p.add(this.cancelButton);
        this.editButton.addActionListener(this);
        this.renameButton.addActionListener(this);
        this.copyButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.extractButton.addActionListener(this);
        this.poseList.addItemListener(this);
        this.poseList.addActionListener(this);
        this.currentPoseList.addItemListener(this);
        this.pack();
        this.updateComponents();
        this.show();
    }

    private void buildCurrentPoseList() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        this.currentPoseList.removeAll();
        int i = 0;
        while (i < this.currentPose.id.length) {
            int which = this.theObject.findPoseIndex(this.currentPose.id[i]);
            this.currentPoseList.add(this.theObject.poseName[which] + " (" + nf.format(this.currentPose.weight[i]) + ")");
            ++i;
        }
        int items = this.currentPoseList.getItemCount();
        if (items > 0) {
            this.currentPoseList.select(items - 1);
            this.weightField.setValue(this.currentPose.weight[items - 1]);
        } else {
            this.weightField.setValue(Double.NaN);
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.addButton) {
            this.currentPose.addPose(this.theObject.poseID[this.poseList.getSelectedIndex()], 1.0);
            this.buildCurrentPoseList();
            this.updateComponents();
            this.updateDisplay();
        } else if (ev.getSource() == this.removeButton) {
            this.currentPose.deletePose(this.currentPoseList.getSelectedIndex());
            this.buildCurrentPoseList();
            this.updateComponents();
            this.updateDisplay();
        } else if (ev.getSource() == this.saveButton) {
            EntriesDialog dlg = new EntriesDialog((Window)this, "Save the current pose as a new gesture:", new String[]{Translate.text("Name")}, new String[]{"New Gesture"});
            if (dlg.getEntries() == null) {
                return;
            }
            this.theObject.addPose((ActorPose)this.theObject.theObject.getPoseKeyframe(), dlg.getEntries()[0]);
            this.poseList.add(dlg.getEntries()[0]);
            this.poseList.select(this.poseList.getItemCount() - 1);
            this.updateComponents();
        } else if (ev.getSource() == this.extractButton) {
            EntriesDialog dlg = new EntriesDialog((Window)this, "Save the current pose as a new object:", new String[]{Translate.text("Name")}, new String[]{"Extracted Pose"});
            if (dlg.getEntries() == null) {
                return;
            }
            ObjectInfo info = new ObjectInfo(this.theObject.theObject.duplicate(), new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), dlg.getEntries()[0]);
            info.addTrack(new PositionTrack(info), 0);
            info.addTrack(new RotationTrack(info), 1);
            if (this.theWindow instanceof LayoutWindow) {
                ((LayoutWindow)this.theWindow).addObject(info, null);
            } else {
                this.theWindow.getScene().addObject(info, null);
            }
            this.theWindow.updateImage();
        } else if (ev.getSource() == this.editButton || ev.getSource() == this.poseList) {
            this.editGesture(this.poseList.getSelectedIndex());
        } else if (ev.getSource() == this.renameButton) {
            int which = this.poseList.getSelectedIndex();
            EntriesDialog dlg = new EntriesDialog((Window)this, "Enter a new name for the gesture:", new String[]{Translate.text("Name")}, new String[]{this.theObject.poseName[which]});
            if (dlg.getEntries() == null) {
                return;
            }
            this.theObject.poseName[which] = dlg.getEntries()[0];
            this.poseList.replaceItem(this.theObject.poseName[which], which);
            this.poseList.select(which);
        } else if (ev.getSource() == this.copyButton) {
            int which = this.poseList.getSelectedIndex();
            EntriesDialog dlg = new EntriesDialog((Window)this, "Enter name for new gesture:", new String[]{Translate.text("Name")}, new String[]{"Copy of " + this.theObject.poseName[which]});
            if (dlg.getEntries() == null) {
                return;
            }
            this.theObject.addPose((ActorPose)this.theObject.pose[which].duplicate(this.theObject.theObject), dlg.getEntries()[0]);
            this.poseList.add(dlg.getEntries()[0]);
            this.poseList.select(this.poseList.getItemCount() - 1);
            this.updateComponents();
            this.editGesture(this.poseList.getItemCount() - 1);
        } else if (ev.getSource() == this.deleteButton) {
            int which = this.poseList.getSelectedIndex();
            MessageDialog dlg = new MessageDialog((Window)this, "Delete '" + this.theObject.poseName[which] + "'?", new String[]{"Yes", "No"});
            if (dlg.getChoice() == 1) {
                return;
            }
            int i = 0;
            while (i < this.currentPose.id.length) {
                if (this.currentPose.id[i] == this.theObject.poseID[which]) {
                    this.currentPose.deletePose(i);
                }
                ++i;
            }
            this.theObject.deletePose(this.theObject.poseID[which]);
            this.poseList.remove(which);
            this.buildCurrentPoseList();
            this.updateComponents();
        } else if (ev.getSource() == this.okButton) {
            this.oldObject.copyObject(this.theObject);
            if (this.key != null) {
                this.key.copy(this.currentPose);
                this.theWindow.getScene().applyTracksToObject(this.objInfo);
                this.theWindow.updateImage();
            }
            this.dispose();
            if (this.onClose != null) {
                this.onClose.execute();
            }
        } else {
            this.dispose();
        }
    }

    private void editGesture(int which) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object3D editObj = this.theObject.theObject.duplicate();
        editObj.applyPoseKeyframe(this.theObject.pose[which]);
        EditCallback cb = new EditCallback(editObj, this.theObject.poseID[which]);
        ObjectInfo info = this.objInfo.duplicate(editObj);
        info.name = this.theObject.poseName[which];
        editObj.editGesture(this.theWindow, info, cb, this.objInfo);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(ItemEvent ev) {
        this.updateComponents();
    }

    public void textValueChanged(TextEvent e) {
        int selected = this.currentPoseList.getSelectedIndex();
        if (selected == -1 || this.currentPose.weight[selected] == this.weightField.getValue()) {
            return;
        }
        this.currentPose.weight[selected] = this.weightField.getValue();
        int which = this.theObject.findPoseIndex(this.currentPose.id[selected]);
        this.currentPoseList.replaceItem(this.theObject.poseName[which] + " (" + this.currentPose.weight[selected] + ")", selected);
        this.currentPoseList.select(selected);
        this.updateDisplay();
    }

    private void updateComponents() {
        int selected = this.poseList.getSelectedIndex();
        if (selected == -1) {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.copyButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.renameButton.setEnabled(selected > 0);
            this.copyButton.setEnabled(true);
            this.deleteButton.setEnabled(selected > 0);
            int id = this.theObject.poseID[this.poseList.getSelectedIndex()];
            int i = 0;
            while (i < this.currentPose.id.length && this.currentPose.id[i] != id) {
                ++i;
            }
            this.addButton.setEnabled(selected > 0 && i == this.currentPose.id.length);
        }
        selected = this.currentPoseList.getSelectedIndex();
        this.removeButton.setEnabled(selected != -1);
        if (selected == -1) {
            this.weightField.setValue(Double.NaN);
            this.weightField.setEnabled(false);
        } else {
            this.weightField.setValue(this.currentPose.weight[this.currentPoseList.getSelectedIndex()]);
            this.weightField.setEnabled(true);
        }
    }

    private void updateDisplay() {
        this.theObject.applyPoseKeyframe(this.currentPose);
        this.preview.objectChanged();
        this.preview.updateImage();
    }

    private class EditCallback
    implements Callback {
        public Object3D editObject;
        public int editID;

        public EditCallback(Object3D obj, int id) {
            this.editObject = obj;
            this.editID = id;
        }

        public void execute() {
            int which = ActorEditorWindow.this.theObject.findPoseIndex(this.editID);
            ActorEditorWindow.this.theObject.theObject.copyObject(this.editObject);
            ActorEditorWindow.this.theObject.pose[which] = (ActorPose)ActorEditorWindow.this.theObject.theObject.getPoseKeyframe();
            Skeleton s = ActorEditorWindow.this.theObject.pose[which].getSkeleton();
            if (s != null) {
                int i = 0;
                while (i < ActorEditorWindow.this.theObject.pose.length) {
                    if (i != which) {
                        Skeleton olds = ActorEditorWindow.this.theObject.pose[i].getSkeleton();
                        Skeleton news = s.duplicate();
                        Joint[] joint = news.getJoints();
                        int j = 0;
                        while (j < joint.length) {
                            Joint j2 = olds.getJoint(joint[j].id);
                            if (j2 != null) {
                                joint[j].copy(j2);
                            }
                            ++j;
                        }
                        ActorEditorWindow.this.theObject.pose[i].setSkeleton(news);
                    }
                    ++i;
                }
            }
            ActorEditorWindow.this.updateDisplay();
        }
    }
}

