/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefTreeElement;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.TreeList;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ObjectRefSelector
extends Panel
implements ActionListener {
    private Label nameLabel;
    private Button setButton;
    private ObjectRef ref;
    private LayoutWindow window;
    private String prompt;
    private ObjectInfo exclude;

    public ObjectRefSelector(ObjectRef obj, LayoutWindow win, String prompt, ObjectInfo exclude) {
        this.ref = obj.duplicate();
        this.window = win;
        this.prompt = prompt;
        this.exclude = exclude;
        this.setButton = new Button("Set:");
        this.add(this.setButton);
        this.nameLabel = new Label(obj.toString()){

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (dim.width < 150) {
                    dim.width = 150;
                }
                return dim;
            }
        };
        this.add(this.nameLabel);
        this.setButton.addActionListener(this);
    }

    public ObjectRef getSelection() {
        return this.ref;
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.setButton.setEnabled(enable);
        this.nameLabel.setEnabled(enable);
    }

    public void actionPerformed(ActionEvent ev) {
        TreeList tree = new TreeList(this.window);
        Scene sc = this.window.getScene();
        ScrollPane p = new ScrollPane(){

            public Dimension getPreferredSize() {
                return new Dimension(150, 200);
            }
        };
        tree.setUpdateEnabled(false);
        int i = 0;
        while (i < sc.getNumObjects()) {
            ObjectInfo info = sc.getObject(i);
            if (info.parent == null) {
                tree.addElement(new ObjectRefTreeElement(new ObjectRef(info), null, tree, this.exclude));
            }
            ++i;
        }
        tree.setUpdateEnabled(true);
        tree.setPreferredSize(250, 100);
        tree.setAllowMultiple(false);
        tree.setBackground(Color.white);
        tree.setSelected(this.ref, true);
        tree.expandToShowObject(this.ref);
        p.add(tree);
        ComponentsDialog dlg = new ComponentsDialog((Window)this.window, this.prompt, new Component[]{p}, new String[]{""});
        if (!dlg.clickedOk()) {
            return;
        }
        Object[] sel = tree.getSelectedObjects();
        this.ref = sel.length > 0 ? (ObjectRef)sel[0] : new ObjectRef();
        this.nameLabel.setText(this.ref.toString());
    }
}

