/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Smoothness;
import artofillusion.animation.VectorKeyframe;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.text.NumberFormat;
import java.util.Vector;

public class PathFromCurveDialog
extends Dialog
implements ActionListener,
ItemListener,
TextListener {
    LayoutWindow window;
    Scene theScene;
    List objList;
    List curveList;
    Vector objects;
    Vector curves;
    Checkbox orientBox;
    Choice spacingChoice;
    ValueField startTimeField;
    ValueField endTimeField;
    ValueField startSpeedField;
    ValueField endSpeedField;
    ValueField accelField;
    Label speedLabel;
    Label lengthLabel;
    Button okButton;
    Button cancelButton;
    Vec3[] subdiv;
    double curveLength;
    boolean processEvents;

    public PathFromCurveDialog(LayoutWindow win, Object[] sel) {
        super(win, "Set Path From Curve", true);
        this.window = win;
        this.theScene = this.window.getScene();
        this.objects = new Vector();
        this.curves = new Vector();
        this.objList = new List();
        this.curveList = new List();
        int i = 0;
        while (i < sel.length) {
            ObjectInfo info = (ObjectInfo)sel[i];
            if (info.object instanceof Curve) {
                this.curves.addElement(info);
                this.curveList.add(info.name);
            } else {
                this.objects.addElement(info);
                this.objList.add(info.name);
            }
            ++i;
        }
        this.objList.select(0);
        this.curveList.select(0);
        this.objList.addItemListener(this);
        this.curveList.addItemListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.anchor = 10;
        gc.fill = 1;
        gc.insets.right = 5;
        this.add((Component)new Label("Set path of"), gc);
        this.add((Component)this.objList, gc);
        this.add((Component)new Label("from curve"), gc);
        this.add((Component)this.curveList, gc);
        gc.gridy = 1;
        gc.gridwidth = 4;
        gc.fill = 0;
        this.orientBox = new Checkbox("Orientation Follows Curve", true);
        this.add((Component)this.orientBox, gc);
        this.orientBox.addItemListener(this);
        gc.gridy = 2;
        Panel p = new Panel();
        this.add((Component)p, gc);
        p.add(new Label("Keyframe Spacing:"));
        this.spacingChoice = new Choice();
        p.add(this.spacingChoice);
        this.spacingChoice.add("Uniform Spacing");
        this.spacingChoice.add("Constant Speed");
        this.spacingChoice.add("Constant Acceleration");
        this.spacingChoice.select(1);
        this.spacingChoice.addItemListener(this);
        gc.gridy = 3;
        p = new Panel();
        this.add((Component)p, gc);
        p.setLayout(new GridBagLayout());
        GridBagConstraints gc2 = new GridBagConstraints();
        gc2.gridx = 0;
        gc2.anchor = 13;
        p.add((Component)new Label("Curve Length:"), gc2);
        p.add((Component)new Label("Start Time:"), gc2);
        p.add((Component)new Label("End Time:"), gc2);
        this.speedLabel = new Label("Initial Speed:", 2);
        p.add((Component)this.speedLabel, gc2);
        p.add((Component)new Label("Final Speed:"), gc2);
        p.add((Component)new Label("Acceleration:"), gc2);
        gc2.gridx = 1;
        gc2.insets.left = 5;
        gc2.anchor = 17;
        this.lengthLabel = new Label();
        p.add((Component)this.lengthLabel, gc2);
        this.startTimeField = new ValueField(0.0, 0, 5);
        p.add((Component)this.startTimeField, gc2);
        this.endTimeField = new ValueField(1.0, 0, 5);
        p.add((Component)this.endTimeField, gc2);
        this.startSpeedField = new ValueField(1.0, 0, 5);
        p.add((Component)this.startSpeedField, gc2);
        this.endSpeedField = new ValueField(1.0, 0, 5);
        p.add((Component)this.endSpeedField, gc2);
        this.accelField = new ValueField(0.0, 0, 5);
        p.add((Component)this.accelField, gc2);
        KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                PathFromCurveDialog.this.processEvents = true;
                if (ev.getKeyCode() == 27) {
                    PathFromCurveDialog.this.dispose();
                }
            }
        };
        this.startTimeField.addKeyListener(listener);
        this.endTimeField.addKeyListener(listener);
        this.startSpeedField.addKeyListener(listener);
        this.endSpeedField.addKeyListener(listener);
        this.accelField.addKeyListener(listener);
        this.startTimeField.addTextListener(this);
        this.endTimeField.addTextListener(this);
        this.startSpeedField.addTextListener(this);
        this.endSpeedField.addTextListener(this);
        this.accelField.addTextListener(this);
        this.startTimeField.addActionListener(this);
        this.endTimeField.addActionListener(this);
        this.startSpeedField.addActionListener(this);
        this.endSpeedField.addActionListener(this);
        this.accelField.addActionListener(this);
        listener = new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.getKeyCode() == 10) {
                    PathFromCurveDialog.this.addTracks();
                    PathFromCurveDialog.this.dispose();
                }
                if (ev.getKeyCode() == 27) {
                    PathFromCurveDialog.this.dispose();
                }
            }
        };
        this.objList.addKeyListener(listener);
        this.curveList.addKeyListener(listener);
        gc.gridy = 4;
        p = new Panel();
        this.add((Component)p, gc);
        this.okButton = Translate.button("ok", this);
        p.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this);
        p.add(this.cancelButton);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.updateComponents();
        this.endTimeField.setValue(this.curveLength);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.cancelButton) {
            this.addTracks();
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.curveList) {
            this.adjustTextFields(this.startTimeField);
        }
        this.updateComponents();
        if (e.getSource() == this.spacingChoice) {
            this.startTimeField.requestFocus();
        }
    }

    private void updateComponents() {
        int spacing = this.spacingChoice.getSelectedIndex();
        this.speedLabel.setText(spacing == 2 ? "Initial Speed:" : "Speed:");
        this.speedLabel.invalidate();
        this.startSpeedField.setEnabled(spacing != 0);
        this.endSpeedField.setEnabled(spacing == 2);
        this.accelField.setEnabled(spacing == 2);
        this.okButton.setEnabled(this.objList.getSelectedIndex() > -1 && this.curveList.getSelectedIndex() > -1 && (spacing == 0 || this.startTimeField.getValue() != this.endTimeField.getValue()));
        if (this.curveList.getSelectedIndex() > -1) {
            ObjectInfo info = (ObjectInfo)this.curves.elementAt(this.curveList.getSelectedIndex());
            Curve cv = (Curve)info.object;
            MeshVertex[] vert = cv.getVertices();
            Vec3[] v = new Vec3[vert.length];
            Mat4 trans = info.coords.fromLocal();
            int i = 0;
            while (i < v.length) {
                v[i] = trans.times(vert[i].r);
                ++i;
            }
            this.subdiv = new Curve(v, cv.getSmoothness(), cv.getSmoothingMethod(), cv.isClosed()).subdivideCurve(4).getVertexPositions();
            this.curveLength = 0.0;
            int i2 = 1;
            while (i2 < this.subdiv.length) {
                this.curveLength += this.subdiv[i2].distance(this.subdiv[i2 - 1]);
                ++i2;
            }
            if (cv.isClosed()) {
                this.curveLength += this.subdiv[this.subdiv.length - 1].distance(this.subdiv[0]);
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3);
            this.lengthLabel.setText(nf.format(this.curveLength));
            this.lengthLabel.invalidate();
        }
        this.speedLabel.getParent().validate();
    }

    public void textValueChanged(TextEvent ev) {
        if (this.processEvents) {
            this.adjustTextFields(ev.getSource());
        }
        this.processEvents = false;
    }

    private void adjustTextFields(Object src) {
        int spacing = this.spacingChoice.getSelectedIndex();
        double startTime = this.startTimeField.getValue();
        double endTime = this.endTimeField.getValue();
        double startSpeed = this.startSpeedField.getValue();
        double endSpeed = this.endSpeedField.getValue();
        double accel = this.accelField.getValue();
        double time = endTime - startTime;
        if (startTime == endTime) {
            this.okButton.setEnabled(false);
            return;
        }
        if (spacing == 0) {
            return;
        }
        if (spacing == 1) {
            if (src == this.startSpeedField) {
                this.endTimeField.setValue(startTime + this.curveLength / startSpeed);
            } else {
                this.startSpeedField.setValue(this.curveLength / (endTime - startTime));
            }
            this.okButton.setEnabled(true);
            return;
        }
        if (src == this.accelField) {
            if (accel == 0.0) {
                if (endSpeed == 0.0) {
                    endSpeed = startSpeed;
                } else {
                    startSpeed = endSpeed;
                }
                if (startSpeed == 0.0) {
                    this.okButton.setEnabled(false);
                    return;
                }
                time = this.curveLength / startSpeed;
            } else {
                time = (-startSpeed + Math.sqrt(startSpeed * startSpeed + 2.0 * accel * this.curveLength)) / accel;
                endSpeed = startSpeed + time * accel;
            }
            this.endTimeField.setValue(startTime + time);
            this.startSpeedField.setValue(startSpeed);
            this.endSpeedField.setValue(endSpeed);
            this.okButton.setEnabled(true);
            return;
        }
        if (startSpeed == 0.0 && endSpeed == 0.0) {
            this.okButton.setEnabled(false);
            return;
        }
        if (src == this.startSpeedField || src == this.endSpeedField) {
            accel = (endSpeed * endSpeed - startSpeed * startSpeed) / (2.0 * this.curveLength);
            endTime = accel == 0.0 ? startTime + this.curveLength / startSpeed : startTime + (endSpeed - startSpeed) / accel;
            this.accelField.setValue(accel);
            this.endTimeField.setValue(endTime);
        } else {
            accel = 2.0 * (this.curveLength - startSpeed * time) / (time * time);
            endSpeed = startSpeed + accel * time;
            this.accelField.setValue(accel);
            this.endSpeedField.setValue(endSpeed);
        }
        this.okButton.setEnabled(true);
    }

    private void addTracks() {
        ObjectInfo info = (ObjectInfo)this.curves.elementAt(this.curveList.getSelectedIndex());
        Mat4 trans = info.coords.fromLocal();
        Curve cv = (Curve)info.object;
        MeshVertex[] vert = cv.getVertices();
        int n = cv.isClosed() ? vert.length + 1 : vert.length;
        double[] dist = new double[n];
        double[] time = new double[n];
        String curveName = info.name;
        int k = cv.getSmoothingMethod() == 0 ? 1 : 16;
        int i = 1;
        while (i < vert.length) {
            dist[i] = dist[i - 1];
            int j = 0;
            while (j < k) {
                int n2 = i;
                dist[n2] = dist[n2] + this.subdiv[(i - 1) * k + j].distance(this.subdiv[(i - 1) * k + 1 + j]);
                ++j;
            }
            ++i;
        }
        if (cv.isClosed()) {
            dist[n - 1] = this.curveLength;
        }
        int spacing = this.spacingChoice.getSelectedIndex();
        int fps = this.theScene.getFramesPerSecond();
        double startTime = this.startTimeField.getValue();
        double endTime = this.endTimeField.getValue();
        double startSpeed = this.startSpeedField.getValue();
        double endSpeed = this.endSpeedField.getValue();
        double accel = this.accelField.getValue();
        double totalTime = endTime - startTime;
        int i2 = 0;
        while (i2 < n) {
            time[i2] = spacing == 0 ? startTime + (double)i2 * totalTime / (double)(n - 1) : (spacing == 1 || accel == 0.0 ? startTime + dist[i2] / startSpeed : startTime + (-startSpeed + Math.sqrt(startSpeed * startSpeed + 2.0 * accel * dist[i2])) / accel);
            time[i2] = (double)Math.round(time[i2] * (double)fps) / (double)fps;
            ++i2;
        }
        info = (ObjectInfo)this.objects.elementAt(this.objList.getSelectedIndex());
        this.window.setUndoRecord(new UndoRecord(this.window, false, 11, new Object[]{info, info.tracks}));
        float[] smoothness = cv.getSmoothness();
        PositionTrack tr = new PositionTrack(info);
        tr.setName(curveName + " Position");
        int i3 = 0;
        while (i3 < vert.length) {
            tr.setKeyframe(time[i3], new VectorKeyframe(trans.times(vert[i3].r)), new Smoothness(smoothness[i3]));
            ++i3;
        }
        if (n > vert.length) {
            tr.setKeyframe(time[vert.length], new VectorKeyframe(trans.times(vert[0].r)), new Smoothness(smoothness[0]));
        }
        if (cv.getSmoothingMethod() == 0) {
            tr.setSmoothingMethod(1);
        } else if (cv.getSmoothingMethod() == 2) {
            tr.setSmoothingMethod(2);
        } else {
            tr.setSmoothingMethod(3);
        }
        info.addTrack(tr, 0);
        if (this.orientBox.getState()) {
            RotationTrack tr2 = new RotationTrack(info);
            tr2.setName(curveName + " Rotation");
            Vec3 zdir = k != 1 && cv.isClosed() ? this.subdiv[1].minus(this.subdiv[this.subdiv.length - 1]) : this.subdiv[1].minus(this.subdiv[0]);
            zdir.normalize();
            Vec3 updir = Vec3.vy();
            double dot = zdir.dot(updir);
            if (Math.abs(dot) > 0.99) {
                updir = Vec3.vx();
                dot = zdir.dot(updir);
            }
            updir.subtract(zdir.times(dot));
            updir.normalize();
            CoordinateSystem coords = new CoordinateSystem(new Vec3(), zdir, updir);
            RotationKeyframe lastKey = new RotationKeyframe(coords);
            tr2.setKeyframe(time[0], lastKey, new Smoothness(smoothness[0]));
            double d = 0.0;
            int interval = cv.getSmoothingMethod() == 0 ? 1 : 8;
            int i4 = 1;
            while (i4 < this.subdiv.length) {
                zdir = i4 == this.subdiv.length - 1 ? (!cv.isClosed() ? this.subdiv[this.subdiv.length - 1].minus(this.subdiv[this.subdiv.length - 2]) : (k == 1 ? this.subdiv[0].minus(this.subdiv[this.subdiv.length - 1]) : this.subdiv[0].minus(this.subdiv[this.subdiv.length - 2]))) : (k == 1 ? this.subdiv[i4 + 1].minus(this.subdiv[i4]) : this.subdiv[i4 + 1].minus(this.subdiv[i4 - 1]));
                zdir.normalize();
                updir = updir.minus(zdir.times(zdir.dot(updir)));
                updir.normalize();
                d += this.subdiv[i4 - 1].distance(this.subdiv[i4]);
                if (i4 % interval == 0) {
                    coords.setOrientation(zdir, updir);
                    RotationKeyframe nextKey = new RotationKeyframe(coords);
                    if (nextKey.x - lastKey.x > 180.0) {
                        nextKey.x -= 360.0;
                    }
                    if (nextKey.x - lastKey.x < -180.0) {
                        nextKey.x += 360.0;
                    }
                    if (nextKey.y - lastKey.y > 180.0) {
                        nextKey.y -= 360.0;
                    }
                    if (nextKey.y - lastKey.y < -180.0) {
                        nextKey.y += 360.0;
                    }
                    if (nextKey.z - lastKey.z > 180.0) {
                        nextKey.z -= 360.0;
                    }
                    if (nextKey.z - lastKey.z < -180.0) {
                        nextKey.z += 360.0;
                    }
                    double t = spacing == 0 ? startTime + (double)i4 * totalTime / (double)(this.subdiv.length - 1) : (spacing == 1 || accel == 0.0 ? startTime + d / startSpeed : startTime + (-startSpeed + Math.sqrt(startSpeed * startSpeed + 2.0 * accel * d)) / accel);
                    t = (double)Math.round(t * (double)fps) / (double)fps;
                    this.validateKeyframe(lastKey, nextKey);
                    if (k == 1 || i4 % k == 0 && (double)smoothness[i4 / k] == 0.0) {
                        tr2.setKeyframe(t - 1.0 / (double)fps, new RotationKeyframe(lastKey.x, lastKey.y, lastKey.z), new Smoothness());
                    }
                    tr2.setKeyframe(t, nextKey, new Smoothness());
                    lastKey = nextKey;
                }
                ++i4;
            }
            if (cv.getSmoothingMethod() == 0) {
                tr2.setSmoothingMethod(1);
            } else if (cv.getSmoothingMethod() == 2) {
                tr2.setSmoothingMethod(2);
            } else {
                tr2.setSmoothingMethod(3);
            }
            tr2.setUseQuaternion(true);
            info.addTrack(tr2, 1);
        }
        startTime = (double)Math.round(startTime * (double)fps) / (double)fps;
        this.window.getScore().rebuildList();
        this.window.setTime(startTime);
    }

    private void validateKeyframe(RotationKeyframe r1, RotationKeyframe r2) {
        CoordinateSystem coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        RotationKeyframe r3 = (RotationKeyframe)r1.blend(r2, 0.75, 0.25);
        Vec3 mid = new Vec3();
        coords.setOrientation(r1.x, r1.y, r1.z);
        Vec3 u1 = new Vec3(coords.getUpDirection());
        Vec3 z1 = new Vec3(coords.getZDirection());
        coords.setOrientation(r2.x, r2.y, r2.z);
        Vec3 u2 = new Vec3(coords.getUpDirection());
        Vec3 z2 = new Vec3(coords.getZDirection());
        coords.setOrientation(r3.x, r3.y, r3.z);
        Vec3 u3 = new Vec3(coords.getUpDirection());
        Vec3 z3 = new Vec3(coords.getZDirection());
        boolean upcheck = u1.dot(u3) < 0.0 || u2.dot(u3) < 0.0;
        boolean zcheck = z1.dot(z3) < 0.0 || z2.dot(z3) < 0.0;
        mid.set(u1.x + u2.x, u1.y + u2.y, u1.z + u2.z);
        mid.normalize();
        upcheck = mid.dot(u3) < 0.2;
        mid.set(z1.x + z2.x, z1.y + z2.y, z1.z + z2.z);
        mid.normalize();
        boolean bl = zcheck = mid.dot(z3) < 0.2;
        if (upcheck || zcheck) {
            r2.z = r2.z < r1.z ? (r2.z += 360.0) : (r2.z -= 360.0);
        }
    }
}

