/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import java.awt.Choice;
import java.awt.Component;
import java.awt.TextField;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;

public class PoseTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;
    int smoothingMethod;
    boolean relative;
    WeightTrack theWeight;
    static /* synthetic */ Class class$java$io$DataInputStream;
    static /* synthetic */ Class class$java$lang$Object;

    public PoseTrack(ObjectInfo info) {
        super("Pose");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.theWeight = new WeightTrack(this);
    }

    public void apply(double time) {
        Keyframe pose = this.tc.evaluate(time, this.smoothingMethod);
        if (pose == null) {
            return;
        }
        if (this.info.pose == null) {
            this.info.pose = pose;
        } else {
            double weight = this.theWeight.getWeight(time);
            this.info.pose = this.relative ? this.info.pose.blend(pose, 1.0, weight) : this.info.pose.blend(pose, 1.0 - weight, weight);
        }
    }

    public Track duplicate(Object obj) {
        PoseTrack t = new PoseTrack((ObjectInfo)obj);
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        PoseTrack t = (PoseTrack)tr;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        Keyframe pose = this.info.object.getPoseKeyframe();
        this.tc.addTimepoint(pose, time, new Smoothness());
        return pose;
    }

    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        Keyframe pose2;
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        Keyframe pose1 = this.tc.evaluate(time, this.smoothingMethod);
        Keyframe keyframe = pose2 = this.info.pose == null ? this.info.object.getPoseKeyframe() : this.info.pose;
        if (!pose1.equals(pose2)) {
            return this.setKeyframe(time, sc);
        }
        return null;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo && ((ObjectInfo)obj).object == this.info.object;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        return this.info.object.getPoseValueNames();
    }

    public double[] getDefaultGraphValues() {
        return this.info.object.getDefaultPoseValues();
    }

    public double[][] getValueRange() {
        return this.info.object.getPoseValueRange();
    }

    public void writeToStream(DataOutputStream out, Scene sc) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeBoolean(this.relative);
        out.writeInt(t.length);
        if (t.length > 0) {
            out.writeUTF(v[0].getClass().getName());
        }
        int i = 0;
        while (i < t.length) {
            out.writeDouble(t[i]);
            v[i].writeToStream(out);
            s[i].writeToStream(out);
            ++i;
        }
        this.theWeight.writeToStream(out, sc);
    }

    public PoseTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.info = (ObjectInfo)parent;
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.relative = version > 0 ? in.readBoolean() : false;
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        if (keys > 0) {
            try {
                Class cl = ModellingApp.getClass(in.readUTF());
                Constructor con = cl.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = PoseTrack.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$java$lang$Object == null ? (class$java$lang$Object = PoseTrack.class$("java.lang.Object")) : class$java$lang$Object);
                int i = 0;
                while (i < keys) {
                    t[i] = in.readDouble();
                    v[i] = (Keyframe)con.newInstance(in, this.info);
                    s[i] = new Smoothness(in);
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new InvalidObjectException("");
            }
        }
        this.tc = new Timecourse(v, t, s);
        this.theWeight = new WeightTrack(in, this, scene);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        this.info.object.editKeyframe(win, this.tc.getValues()[which], this.info);
    }

    public void edit(LayoutWindow win) {
        TextField nameField = new TextField(this.getName());
        Choice smoothChoice = new Choice();
        smoothChoice.add("Discontinuous");
        smoothChoice.add("Linear");
        smoothChoice.add("Interpolating");
        smoothChoice.add("Approximating");
        smoothChoice.select(this.smoothingMethod);
        Choice modeChoice = new Choice();
        modeChoice.add("Absolute");
        modeChoice.add("Relative");
        modeChoice.select(this.relative ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog((Window)win, "Options for Pose Track", new Component[]{nameField, smoothChoice, modeChoice}, new String[]{"Track Name:", "Smoothing Method:", "Track Mode:"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.relative = modeChoice.getSelectedIndex() == 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

