/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class RotationTrack
extends Track {
    private ObjectInfo info;
    private boolean quaternion;
    private Timecourse tc;
    private int smoothingMethod;
    private int mode;
    private int relCoords;
    private int joint;
    private ObjectRef relObject;
    private WeightTrack theWeight;
    private boolean enablex;
    private boolean enabley;
    private boolean enablez;
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE = 1;
    public static final int WORLD = 0;
    public static final int PARENT = 1;
    public static final int OBJECT = 2;
    public static final int LOCAL = 3;

    public RotationTrack(ObjectInfo info) {
        this(info, "Rotation", true, true, true, true);
    }

    public RotationTrack(ObjectInfo info, String name, boolean useQuaternion, boolean affectX, boolean affectY, boolean affectZ) {
        super(name);
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.mode = 0;
        this.relCoords = 1;
        this.relObject = new ObjectRef();
        this.theWeight = new WeightTrack(this);
        this.quaternion = useQuaternion;
        this.enablex = affectX;
        this.enabley = affectY;
        this.enablez = affectZ;
        this.joint = -1;
    }

    public void apply(double time) {
        Joint j;
        RotationKeyframe rot = (RotationKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        double weight = this.theWeight.getWeight(time);
        if (rot == null) {
            return;
        }
        Mat4 pre = null;
        Mat4 post = null;
        if (this.relCoords == 1 && this.info.parent != null) {
            pre = this.info.parent.coords.toLocal();
            post = this.info.parent.coords.fromLocal();
        } else if (this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pre = coords.toLocal();
                post = coords.fromLocal();
            }
        } else if (this.mode == 1 && this.relCoords == 3) {
            pre = this.info.coords.fromLocal();
            post = this.info.coords.toLocal();
        }
        rot.applyToCoordinates(this.info.coords, weight, pre, post, this.mode == 1, this.enablex, this.enabley, this.enablez);
        Joint joint = j = this.joint > -1 ? this.info.getSkeleton().getJoint(this.joint) : null;
        if (j != null && this.mode == 0) {
            if (this.info.pose != null && !this.info.pose.equals(this.info.object.getPoseKeyframe())) {
                this.info.object.applyPoseKeyframe(this.info.pose);
                j = this.info.getSkeleton().getJoint(this.joint);
            }
            Mat4 m = this.info.coords.fromLocal().times(j.coords.toLocal().times(this.info.coords.toLocal()));
            this.info.coords.transformAxes(m);
        }
    }

    public Track duplicate(Object obj) {
        RotationTrack t = new RotationTrack((ObjectInfo)obj);
        t.mode = this.mode;
        t.relCoords = this.relCoords;
        t.smoothingMethod = this.smoothingMethod;
        t.quaternion = this.quaternion;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.relObject = this.relObject.duplicate();
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.enablex = this.enablex;
        t.enabley = this.enabley;
        t.enablez = this.enablez;
        t.joint = this.joint;
        return t;
    }

    public void copy(Track tr) {
        RotationTrack t = (RotationTrack)tr;
        this.mode = t.mode;
        this.relCoords = t.relCoords;
        this.smoothingMethod = t.smoothingMethod;
        this.quaternion = t.quaternion;
        this.tc = t.tc.duplicate(this.info);
        this.relObject = t.relObject.duplicate();
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.enablex = t.enablex;
        this.enabley = t.enabley;
        this.enablez = t.enablez;
        this.joint = t.joint;
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        ((RotationKeyframe)k).setUseQuaternion(this.quaternion);
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        CoordinateSystem coords;
        Joint j;
        RotationKeyframe r = null;
        CoordinateSystem c = null;
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            c = new ObjectRef(this.info, j).getCoords().duplicate();
        }
        if (c == null) {
            c = this.info.coords.duplicate();
        }
        if (this.relCoords == 1 && this.info.parent != null) {
            c.transformAxes(this.info.parent.coords.toLocal());
            r = new RotationKeyframe(c);
        } else if (this.relCoords == 2 && (coords = this.relObject.getCoords()) != null) {
            c.transformAxes(coords.toLocal());
            r = new RotationKeyframe(c);
        }
        if (r == null) {
            r = new RotationKeyframe(c);
        }
        r.setUseQuaternion(this.quaternion);
        this.tc.addTimepoint(r, time, new Smoothness());
        return r;
    }

    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        double[] q2;
        double[] q1;
        double dot;
        CoordinateSystem coords;
        CoordinateSystem c;
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        RotationKeyframe rot = (RotationKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        RotationKeyframe current = null;
        Joint j = this.joint > -1 && this.mode == 0 ? this.info.getSkeleton().getJoint(this.joint) : null;
        CoordinateSystem coordinateSystem = c = j == null ? this.info.coords : new ObjectRef(this.info, j).getCoords();
        if (this.relCoords == 1 && this.info.parent != null) {
            c = c.duplicate();
            c.transformAxes(this.info.parent.coords.toLocal());
        } else if (this.relCoords == 2 && (coords = this.relObject.getCoords()) != null) {
            c = c.duplicate();
            c.transformAxes(coords.toLocal());
        }
        current = new RotationKeyframe(c);
        if (this.quaternion ? 1.0 - (dot = (q1 = rot.getQuaternion())[0] * (q2 = current.getQuaternion())[0] + q1[1] * q2[1] + q1[2] * q2[2] + q1[3] * q2[3]) < 1.0E-10 : !(this.enablex && !(Math.abs(rot.x - current.x) < 1.0E-10) || this.enabley && !(Math.abs(rot.y - current.y) < 1.0E-10) || this.enablez && !(Math.abs(rot.z - current.z) < 1.0E-10))) {
            return null;
        }
        return this.setKeyframe(time, sc);
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public boolean affectsX() {
        return this.enablex || this.quaternion;
    }

    public boolean affectsY() {
        return this.enabley || this.quaternion;
    }

    public boolean affectsZ() {
        return this.enablez || this.quaternion;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public boolean getUseQuaternion() {
        return this.quaternion;
    }

    public void setUseQuaternion(boolean use) {
        Keyframe[] val = this.tc.getValues();
        this.quaternion = use;
        int i = 0;
        while (i < val.length) {
            RotationKeyframe v = (RotationKeyframe)val[i];
            v.setUseQuaternion(use);
            ++i;
        }
    }

    public int getCoordinateSystem() {
        return this.relCoords;
    }

    public void setCoordinateSystem(int system) {
        this.relCoords = system;
    }

    public ObjectRef getCoordsObject() {
        return this.relObject;
    }

    public void setCoordsObject(ObjectRef obj) {
        this.relObject = obj;
        this.relCoords = 2;
    }

    public String[] getValueNames() {
        return new String[]{"X Angle", "Y Angle", "Z Angle"};
    }

    public double[] getDefaultGraphValues() {
        return this.info.coords.getRotationAngles();
    }

    public double[][] getValueRange() {
        double[][] range = new double[3][2];
        int i = 0;
        while (i < range.length) {
            range[i][0] = -1.7976931348623157E308;
            range[i][1] = Double.MAX_VALUE;
            ++i;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        ObjectInfo info;
        if (this.relCoords == 2 && (info = this.relObject.getObject()) != null) {
            return new ObjectInfo[]{info};
        }
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
        if (this.relObject.getObject() == obj) {
            this.relObject = new ObjectRef();
        }
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(this.mode);
        out.writeInt(this.relCoords);
        out.writeInt(this.joint);
        out.writeBoolean(this.quaternion);
        out.writeBoolean(this.enablex);
        out.writeBoolean(this.enabley);
        out.writeBoolean(this.enablez);
        out.writeInt(t.length);
        int i = 0;
        while (i < t.length) {
            RotationKeyframe k = (RotationKeyframe)v[i];
            out.writeDouble(t[i]);
            k.writeToStream(out);
            s[i].writeToStream(out);
            ++i;
        }
        if (this.relCoords == 2) {
            this.relObject.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public RotationTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.mode = in.readInt();
        this.relCoords = in.readInt();
        this.joint = version == 0 ? -1 : in.readInt();
        this.quaternion = in.readBoolean();
        this.enablex = in.readBoolean();
        this.enabley = in.readBoolean();
        this.enablez = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        int i = 0;
        while (i < keys) {
            t[i] = in.readDouble();
            RotationKeyframe k = new RotationKeyframe(in, this.info);
            k.setUseQuaternion(this.quaternion);
            v[i] = k;
            s[i] = new Smoothness(in);
            ++i;
        }
        this.info = (ObjectInfo)parent;
        this.tc = new Timecourse(v, t, s);
        this.relObject = this.relCoords == 2 ? new ObjectRef(in, scene) : new ObjectRef();
        this.theWeight = new WeightTrack(in, this, scene);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        RotationKeyframe key = (RotationKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField xField = new ValueField(key.x, 0, 5);
        ValueField yField = new ValueField(key.y, 0, 5);
        ValueField zField = new ValueField(key.z, 0, 5);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final Checkbox sameBox = new Checkbox("Separate Left and Right Smoothness", !s.isForceSame());
        final Label leftLabel = new Label(" (" + Translate.text("left") + ")");
        final Label rightLabel = new Label(" (" + Translate.text("right") + ")");
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)new Label("X"), gc);
        p.add((Component)new Label("Y"), gc);
        p.add((Component)new Label("Z"), gc);
        p.add((Component)new Label(Translate.text("Time")), gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)xField, gc);
        p.add((Component)yField, gc);
        p.add((Component)zField, gc);
        p.add((Component)timeField, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.anchor = 10;
        p.add((Component)sameBox, gc);
        p.add((Component)new Label(Translate.text("Smoothness") + ':'), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)leftLabel, gc);
        p.add((Component)rightLabel, gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)s1Slider, gc);
        p.add((Component)s2Slider, gc);
        leftLabel.setEnabled(sameBox.getState());
        rightLabel.setEnabled(sameBox.getState());
        s2Slider.setEnabled(sameBox.getState());
        sameBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                leftLabel.setEnabled(sameBox.getState());
                rightLabel.setEnabled(sameBox.getState());
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        PanelDialog dlg = new PanelDialog((Window)win, "Edit Keyframe", p);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        key.set(xField.getValue(), yField.getValue(), zField.getValue());
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        final Checkbox xbox = new Checkbox("X", this.enablex);
        final Checkbox ybox = new Checkbox("Y", this.enabley);
        final Checkbox zbox = new Checkbox("Z", this.enablez);
        final Checkbox isoBox = new Checkbox("Isotropic (Quaternion) Rotations", this.quaternion);
        Skeleton s = this.info.getSkeleton();
        Joint[] j = s == null ? null : s.getJoints();
        TextField nameField = new TextField(this.getName());
        Choice smoothChoice = new Choice();
        smoothChoice.add("Discontinuous");
        smoothChoice.add("Linear");
        smoothChoice.add("Interpolating");
        smoothChoice.add("Approximating");
        smoothChoice.select(this.smoothingMethod);
        final Choice modeChoice = new Choice();
        modeChoice.add("Absolute");
        modeChoice.add("Relative");
        modeChoice.select(this.mode);
        Choice jointChoice = new Choice();
        jointChoice.add("Object Origin");
        if (j != null) {
            int i = 0;
            while (i < j.length) {
                jointChoice.add(j[i].name);
                ++i;
            }
            int i2 = 0;
            while (i2 < j.length) {
                if (j[i2].id == this.joint) {
                    jointChoice.select(i2 + 1);
                }
                ++i2;
            }
        }
        final Choice coordsChoice = new Choice();
        coordsChoice.add("World");
        coordsChoice.add("Parent");
        coordsChoice.add("Other Object...");
        if (this.mode == 1) {
            coordsChoice.add("Local");
        }
        coordsChoice.select(this.relCoords);
        final ObjectRefSelector objSelector = new ObjectRefSelector(this.relObject, win, "Position Relative To:", this.info);
        objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
        modeChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                int sel = modeChoice.getSelectedIndex();
                if (sel == 0 && coordsChoice.getItemCount() == 4) {
                    coordsChoice.remove(3);
                }
                if (sel == 1 && coordsChoice.getItemCount() == 3) {
                    coordsChoice.add("Local");
                }
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        coordsChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        isoBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                xbox.setEnabled(!isoBox.getState());
                ybox.setEnabled(!isoBox.getState());
                zbox.setEnabled(!isoBox.getState());
            }
        });
        xbox.setEnabled(!this.quaternion);
        ybox.setEnabled(!this.quaternion);
        zbox.setEnabled(!this.quaternion);
        Panel p = new Panel();
        p.setLayout(new FlowLayout(0));
        p.add(xbox);
        p.add(ybox);
        p.add(zbox);
        ComponentsDialog dlg = new ComponentsDialog((Window)win, "Options for Rotation Track", new Component[]{nameField, smoothChoice, modeChoice, jointChoice, coordsChoice, objSelector, isoBox, p}, new String[]{"Track Name:", "Smoothing Method:", "Track Mode:", "Apply To:", "Coordinate System:", "", "", "Track Affects:"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.mode = modeChoice.getSelectedIndex();
        this.relCoords = coordsChoice.getSelectedIndex();
        this.relObject = objSelector.getSelection();
        this.joint = jointChoice.getSelectedIndex() == 0 ? -1 : j[jointChoice.getSelectedIndex() - 1].id;
        this.setUseQuaternion(isoBox.getState());
        this.enablex = xbox.getState();
        this.enabley = ybox.getState();
        this.enablez = zbox.getState();
    }
}

