/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Camera;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Joint;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import java.awt.Color;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class Skeleton {
    private Joint[] joint;
    private int nextID;
    private static final int MARKER_WIDTH = 10;
    private static final double BONE_WIDTH = 0.15;
    private static final double WIDEST_POINT = 0.8;

    public Skeleton() {
        this.joint = new Joint[0];
        this.nextID = 1;
    }

    public Skeleton duplicate() {
        Skeleton s = new Skeleton();
        s.nextID = this.nextID;
        s.joint = new Joint[this.joint.length];
        int i = 0;
        while (i < this.joint.length) {
            s.joint[i] = this.joint[i].duplicate();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.joint.length) {
            if (this.joint[i2].parent != null) {
                s.joint[i2].parent = s.joint[s.findJointIndex(this.joint[i2].parent.id)];
            }
            s.joint[i2].children = new Joint[this.joint[i2].children.length];
            int j = 0;
            while (j < this.joint[i2].children.length) {
                s.joint[i2].children[j] = s.joint[s.findJointIndex(this.joint[i2].children[j].id)];
                ++j;
            }
            ++i2;
        }
        return s;
    }

    public void copy(Skeleton s) {
        this.nextID = s.nextID;
        this.joint = new Joint[s.joint.length];
        int i = 0;
        while (i < this.joint.length) {
            this.joint[i] = s.joint[i].duplicate();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.joint.length) {
            if (s.joint[i2].parent != null) {
                this.joint[i2].parent = this.joint[this.findJointIndex(s.joint[i2].parent.id)];
            }
            this.joint[i2].children = new Joint[s.joint[i2].children.length];
            int j = 0;
            while (j < this.joint[i2].children.length) {
                this.joint[i2].children[j] = this.joint[this.findJointIndex(s.joint[i2].children[j].id)];
                ++j;
            }
            ++i2;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Skeleton)) {
            return false;
        }
        Skeleton s = (Skeleton)o;
        if (this.joint.length != s.joint.length) {
            return false;
        }
        int i = 0;
        while (i < this.joint.length) {
            if (!this.joint[i].equals(s.joint[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addJoint(Joint j, int parentID) {
        Joint parent;
        int parentIndex;
        Joint[] newjoint = new Joint[this.joint.length + 1];
        System.arraycopy(this.joint, 0, newjoint, 0, this.joint.length);
        newjoint[this.joint.length] = j;
        this.joint = newjoint;
        if (j.id == -1) {
            j.id = this.nextID++;
        }
        if ((parentIndex = this.findJointIndex(parentID)) == -1) {
            j.parent = null;
            return;
        }
        j.parent = parent = this.joint[parentIndex];
        Joint[] newchildren = new Joint[parent.children.length + 1];
        System.arraycopy(parent.children, 0, newchildren, 0, parent.children.length);
        newchildren[parent.children.length] = j;
        parent.children = newchildren;
    }

    public void deleteJoint(int id) {
        int which = this.findJointIndex(id);
        Joint j = this.joint[which];
        Joint parent = j.parent;
        while (j.children.length > 0) {
            this.deleteJoint(j.children[0].id);
        }
        which = this.findJointIndex(id);
        Joint[] newjoint = new Joint[this.joint.length - 1];
        int i = 0;
        int k = 0;
        while (i < this.joint.length) {
            if (i != which) {
                newjoint[k++] = this.joint[i];
            }
            ++i;
        }
        this.joint = newjoint;
        if (parent == null) {
            return;
        }
        Joint[] newchildren = new Joint[parent.children.length - 1];
        int i2 = 0;
        int k2 = 0;
        while (i2 < parent.children.length) {
            if (parent.children[i2] != j) {
                newchildren[k2++] = parent.children[i2];
            }
            ++i2;
        }
        parent.children = newchildren;
    }

    public int findJointIndex(int id) {
        int min = 0;
        int max = this.joint.length - 1;
        int current = min + max >> 1;
        if (this.joint.length == 0) {
            return -1;
        }
        while (this.joint[current].id != id) {
            if (this.joint[current].id > id) {
                max = current - 1;
            } else {
                min = current + 1;
            }
            if (min >= max) {
                if (min < this.joint.length && this.joint[min].id == id) {
                    return min;
                }
                return -1;
            }
            current = min + max >> 1;
        }
        return current;
    }

    public Joint getJoint(int id) {
        int which = this.findJointIndex(id);
        if (which < 0 || which >= this.joint.length) {
            return null;
        }
        return this.joint[which];
    }

    public Joint[] getJoints() {
        Joint[] j = new Joint[this.joint.length];
        int i = 0;
        while (i < j.length) {
            j[i] = this.joint[i];
            ++i;
        }
        return j;
    }

    public int getNumJoints() {
        return this.joint.length;
    }

    public int getNextJointID() {
        return this.nextID;
    }

    public void scale(double x, double y, double z) {
        int i = 0;
        while (i < this.joint.length) {
            Vec3 pos = this.joint[i].coords.getOrigin();
            pos.x *= x;
            pos.y *= y;
            pos.z *= z;
            this.joint[i].coords.setOrigin(pos);
            Vec3 zdir = this.joint[i].coords.getZDirection();
            Vec3 newzdir = new Vec3(zdir.x * x, zdir.y * y, zdir.z * z);
            double len = newzdir.length();
            if (len > 0.0) {
                zdir = newzdir.times(1.0 / len);
            }
            Vec3 updir = this.joint[i].coords.getUpDirection();
            Vec3 newupdir = new Vec3(updir.x * x, updir.y * y, updir.z * z);
            len = newupdir.length();
            if (len > 0.0) {
                updir = newupdir.times(1.0 / len);
            }
            this.joint[i].coords.setOrientation(zdir, updir);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.joint.length) {
            if (this.joint[i2].parent == null) {
                this.joint[i2].calcAnglesFromCoords(true);
            } else {
                this.joint[i2].length.pos = this.joint[i2].coords.getOrigin().distance(this.joint[i2].parent.coords.getOrigin());
            }
            ++i2;
        }
    }

    public void draw(ViewerCanvas canvas, int selectedID, int baseID, Color color) {
        Camera cam = canvas.getCamera();
        int mode = canvas.getRenderMode();
        boolean render = mode == 1 || mode == 2;
        Vec2[] p = new Vec2[this.joint.length];
        Vec2 v1 = new Vec2();
        Vec2 v2 = new Vec2();
        Point[] screenVert = new Point[this.joint.length];
        Point p1 = new Point();
        Point p2 = new Point();
        double[] screenZ = new double[this.joint.length];
        int i = 0;
        while (i < this.joint.length) {
            Joint j = this.joint[i];
            Vec3 pos = j.coords.getOrigin();
            p[i] = cam.getObjectToScreen().timesXY(pos);
            screenVert[i] = new Point((int)p[i].x, (int)p[i].y);
            screenZ[i] = cam.getObjectToView().timesZ(pos);
            ++i;
        }
        Color col = color;
        int colInt = col.getRGB();
        int i2 = 0;
        while (i2 < this.joint.length) {
            Joint j = this.joint[i2];
            Joint parent = j.parent;
            if (parent != null) {
                int parentIndex = this.findJointIndex(parent.id);
                Vec3 para = j.coords.getOrigin().minus(parent.coords.getOrigin());
                double length = para.length();
                Vec3 perp = j.coords.getUpDirection().times(0.15 * length);
                para.scale(0.8);
                Vec3 center = parent.coords.getOrigin().plus(para);
                Vec2 pos1 = cam.getObjectToScreen().timesXY(center.plus(perp));
                Vec2 pos2 = cam.getObjectToScreen().timesXY(center.minus(perp));
                if (render) {
                    double z1 = cam.getObjectToScreen().timesZ(center.plus(perp));
                    double z2 = cam.getObjectToScreen().timesZ(center.minus(perp));
                    canvas.renderLine(p[i2], screenZ[i2], p[parentIndex], screenZ[parentIndex], cam, colInt);
                    canvas.renderLine(pos1, z1, p[parentIndex], screenZ[parentIndex], cam, colInt);
                    canvas.renderLine(pos2, z2, p[parentIndex], screenZ[parentIndex], cam, colInt);
                    canvas.renderLine(p[i2], screenZ[i2], pos1, z1, cam, colInt);
                    canvas.renderLine(p[i2], screenZ[i2], pos2, z2, cam, colInt);
                    canvas.renderLine(pos1, z1, pos2, z2, cam, colInt);
                } else {
                    p1.x = (int)pos1.x;
                    p1.y = (int)pos1.y;
                    p2.x = (int)pos2.x;
                    p2.y = (int)pos2.y;
                    canvas.drawLine(screenVert[i2], screenVert[parentIndex], col);
                    canvas.drawLine(p1, screenVert[parentIndex], col);
                    canvas.drawLine(p2, screenVert[parentIndex], col);
                    canvas.drawLine(screenVert[i2], p1, col);
                    canvas.drawLine(screenVert[i2], p2, col);
                    canvas.drawLine(p1, p2, col);
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.joint.length) {
            Joint j = this.joint[i3];
            col = j.id == baseID ? Color.green : (j.id == selectedID ? Color.magenta : color);
            if (render) {
                v1.x = v2.x = p[i3].x;
                v1.y = p[i3].y - 10.0;
                v2.y = p[i3].y + 10.0;
                canvas.renderLine(v1, screenZ[i3], v2, screenZ[i3], cam, col.getRGB());
                v1.y = v2.y = p[i3].y;
                v1.x = p[i3].x - 10.0;
                v2.x = p[i3].x + 10.0;
                canvas.renderLine(v1, screenZ[i3], v2, screenZ[i3], cam, col.getRGB());
            } else {
                p1.x = p2.x = screenVert[i3].x;
                p1.y = screenVert[i3].y - 10;
                p2.y = screenVert[i3].y + 10;
                canvas.drawLine(p1, p2, col);
                p1.y = p2.y = screenVert[i3].y;
                p1.x = screenVert[i3].x - 10;
                p2.x = screenVert[i3].x + 10;
                canvas.drawLine(p1, p2, col);
            }
            ++i3;
        }
    }

    public static void adjustMesh(Mesh oldMesh, Mesh newMesh) {
        Skeleton s1 = oldMesh.getSkeleton();
        Skeleton s2 = newMesh.getSkeleton();
        MeshVertex[] v1 = oldMesh.getVertices();
        MeshVertex[] v2 = newMesh.getVertices();
        Vec3[] v = new Vec3[v2.length];
        Vec3 temp = new Vec3();
        int i = 0;
        while (i < v2.length) {
            v[i] = v2[i].r;
            if (v2[i].ikJoint != -1) {
                Joint j1 = s1.getJoint(v1[i].ikJoint);
                Joint j2 = s2.getJoint(v2[i].ikJoint);
                if (j1 != null && j2 != null) {
                    double weight = j2.parent == null ? 1.0 : v2[i].ikWeight;
                    v[i].set(v1[i].r);
                    j1.coords.toLocal().transform(v[i]);
                    j2.coords.fromLocal().transform(v[i]);
                    if (weight < 1.0) {
                        v[i].scale(weight);
                        temp.set(v1[i].r);
                        j1.parent.coords.toLocal().transform(temp);
                        j2.parent.coords.fromLocal().transform(temp);
                        temp.scale(1.0 - weight);
                        v[i].add(temp);
                    }
                    double olddist = v1[i].r.distance2(j1.coords.getOrigin());
                    double newdist = v[i].distance2(j2.coords.getOrigin());
                    if (olddist > 0.0 && newdist > 0.0) {
                        v[i].subtract(j2.coords.getOrigin());
                        v[i].scale(Math.pow(olddist / newdist, 0.5 * v1[i].ikWeight));
                        v[i].add(j2.coords.getOrigin());
                    }
                }
            }
            ++i;
        }
        newMesh.setVertices(v);
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeInt(this.joint.length);
        int i = 0;
        while (i < this.joint.length) {
            Joint j = this.joint[i];
            out.writeInt(j.id);
            out.writeUTF(j.name);
            j.coords.writeToFile(out);
            j.angle1.writeToStream(out);
            j.angle2.writeToStream(out);
            j.twist.writeToStream(out);
            j.length.writeToStream(out);
            out.writeInt(j.parent == null ? -1 : j.parent.id);
            out.writeInt(j.children.length);
            int k = 0;
            while (k < j.children.length) {
                out.writeInt(j.children[k].id);
                ++k;
            }
            ++i;
        }
    }

    public Skeleton(DataInputStream in) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.nextID = 1;
        this.joint = new Joint[in.readInt()];
        int[] parentID = new int[this.joint.length];
        int[][] childID = new int[this.joint.length][];
        int i = 0;
        while (i < this.joint.length) {
            Joint j;
            int id = in.readInt();
            String name = in.readUTF();
            this.joint[i] = j = new Joint(new CoordinateSystem(in), null, name);
            j.id = id;
            j.angle1 = j.new Joint.DOF(in);
            j.angle2 = j.new Joint.DOF(in);
            j.twist = j.new Joint.DOF(in);
            j.length = j.new Joint.DOF(in);
            j.length.loop = false;
            parentID[i] = in.readInt();
            childID[i] = new int[in.readInt()];
            int k = 0;
            while (k < childID[i].length) {
                childID[i][k] = in.readInt();
                ++k;
            }
            if (j.id >= this.nextID) {
                this.nextID = j.id + 1;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.joint.length) {
            this.joint[i2].parent = this.getJoint(parentID[i2]);
            this.joint[i2].children = new Joint[childID[i2].length];
            int k = 0;
            while (k < childID[i2].length) {
                this.joint[i2].children[k] = this.getJoint(childID[i2][k]);
                ++k;
            }
            ++i2;
        }
    }
}

