/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Callback;
import artofillusion.Camera;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.IKSolver;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.EventProcessor;
import artofillusion.ui.Translate;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class SkeletonTool
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Vec3 clickPos;
    IKSolver ik;
    Mesh oldMesh;
    Mesh mesh;
    UndoRecord undo;
    EventProcessor process;
    private static final int CLICK_TOL = 6;

    public SkeletonTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("skeleton.gif");
        selectedIcon = this.loadImage("selected/skeleton.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("skeletonTool.helpText"));
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        MeshViewer mv = (MeshViewer)view;
        this.mesh = (Mesh)((Object)mv.getObject().object);
        Skeleton s = this.mesh.getSkeleton();
        Camera cam = mv.getCamera();
        CoordinateSystem objCoords = mv.getDisplayCoordinates();
        this.clickPoint = e.getPoint();
        if (e.isControlDown()) {
            Joint j;
            this.undo = new UndoRecord(this.theWindow, false, 0, new Object[]{this.mesh, this.mesh.duplicate()});
            Joint parent = s.getJoint(mv.getSelectedJoint());
            if (parent == null) {
                double distToJoint = cam.getDistToScreen();
                this.clickPos = cam.convertScreenToWorld(this.clickPoint, distToJoint);
                objCoords.toLocal().transform(this.clickPos);
                j = new Joint(new CoordinateSystem(this.clickPos, Vec3.vz(), Vec3.vy()), null, "Root " + s.getNextJointID());
                j.angle2.fixed = true;
                j.angle1.fixed = true;
                s.addJoint(j, -1);
                if (s.getNumJoints() == 1) {
                    mv.setBaseJoint(j.id);
                }
            } else {
                double distToJoint = cam.getWorldToView().timesZ(parent.coords.getOrigin());
                this.clickPos = cam.convertScreenToWorld(this.clickPoint, distToJoint);
                objCoords.toLocal().transform(this.clickPos);
                Vec3 zdir = this.clickPos.minus(parent.coords.getOrigin());
                zdir.normalize();
                Vec3 ydir = cam.getCameraCoordinates().getZDirection().cross(zdir);
                ydir.normalize();
                j = new Joint(new CoordinateSystem(this.clickPos, zdir, ydir), parent, "Bone " + s.getNextJointID());
                s.addJoint(j, parent.id);
            }
            mv.setSelectedJoint(j.id);
            this.ik = new IKSolver(s, mv.getBaseJoint(), mv.getSelectedJoint());
            view.updateImage();
            view.repaint();
            this.theWindow.updateMenus();
            this.oldMesh = (Mesh)((Object)this.mesh.duplicate());
            this.process = new EventProcessor();
            return;
        }
        Joint[] joint = s.getJoints();
        Mat4 objToScreen = cam.getWorldToScreen().times(objCoords.fromLocal());
        int i = 0;
        while (i < joint.length) {
            Vec2 pos = objToScreen.timesXY(joint[i].coords.getOrigin());
            if ((double)this.clickPoint.x > pos.x - 6.0 && (double)this.clickPoint.x < pos.x + 6.0 && (double)this.clickPoint.y > pos.y - 6.0 && (double)this.clickPoint.y < pos.y + 6.0) break;
            ++i;
        }
        if (i == joint.length) {
            mv.setSelectedJoint(-1);
            view.updateImage();
            view.repaint();
            this.theWindow.updateMenus();
            return;
        }
        if (e.isShiftDown()) {
            mv.setBaseJoint(joint[i].id);
            view.updateImage();
            view.repaint();
            return;
        }
        mv.setSelectedJoint(joint[i].id);
        this.clickPos = joint[i].coords.getOrigin();
        view.updateImage();
        view.repaint();
        this.theWindow.updateMenus();
        this.ik = new IKSolver(s, mv.getBaseJoint(), mv.getSelectedJoint());
        this.oldMesh = (Mesh)((Object)this.mesh.duplicate());
        this.process = new EventProcessor();
    }

    public void mouseDragged(final MouseEvent e, ViewerCanvas view) {
        final MeshViewer mv = (MeshViewer)view;
        final CoordinateSystem objCoords = mv.getDisplayCoordinates();
        if (this.ik == null) {
            return;
        }
        Callback c = new Callback(){

            public void execute() {
                Camera cam = mv.getCamera();
                Vec3 jointPos = objCoords.fromLocal().times(SkeletonTool.this.ik.getDraggedJoint().coords.getOrigin());
                double distToJoint = cam.getWorldToView().timesZ(jointPos);
                Vec3 goal = cam.convertScreenToWorld(e.getPoint(), distToJoint);
                objCoords.toLocal().transform(goal);
                Mesh mesh = (Mesh)((Object)mv.getObject().object);
                Skeleton s = mesh.getSkeleton();
                if (SkeletonTool.this.undo == null) {
                    SkeletonTool.this.undo = new UndoRecord(SkeletonTool.this.getWindow(), false, 0, new Object[]{mesh, mesh.duplicate()});
                }
                SkeletonTool.this.ik.solve(goal);
                if (!mv.getSkeletonDetached()) {
                    Skeleton.adjustMesh(SkeletonTool.this.oldMesh, mesh);
                }
                mv.objectChanged();
                mv.updateImage();
                mv.repaint();
            }
        };
        this.process.addEvent(c);
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        if (this.process != null) {
            this.process.stopProcessing();
        }
        this.process = null;
        this.ik = null;
        this.oldMesh = null;
        this.mesh = null;
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        this.undo = null;
    }
}

