/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Marker;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Score;
import artofillusion.animation.SelectionInfo;
import artofillusion.animation.TimeAxis;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.TrackDisplay;
import artofillusion.animation.VerticalAxis;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class TrackGraph
extends Panel
implements MouseListener,
MouseMotionListener,
TrackDisplay {
    LayoutWindow window;
    double hscale;
    double vscale;
    double hstart;
    double vstart;
    double[] dragKeyTime;
    double[][] dragKeyValue;
    int subdivisions;
    int selected;
    int dragValue;
    int mode;
    int oldHeight;
    int effectiveMode;
    Score theScore;
    TimeAxis timeAxis;
    VerticalAxis vertAxis;
    Point lastPos;
    Point dragPos;
    boolean draggingBox;
    boolean lineAtBottom;
    Vector markers;
    TrackInfo[] tracks;
    UndoRecord undo;
    public static final int HANDLE_SIZE = 5;
    public static final int TICK_SIZE = 6;
    public static final Color[] LINE_COLOR = new Color[]{new Color(0, 0, 255), new Color(0, 175, 0), new Color(255, 128, 0), new Color(0, 170, 170), new Color(192, 0, 255), new Color(192, 192, 0)};
    public static final Color[] LIGHT_LINE_COLOR = new Color[LINE_COLOR.length];
    public static final Color SELECTED_VALUE_COLOR;
    public static final Color SELECTED_KEY_COLOR;

    public TrackGraph(LayoutWindow win, Score sc, TimeAxis ta) {
        this.window = win;
        this.theScore = sc;
        this.timeAxis = ta;
        this.vertAxis = new VerticalAxis();
        this.hstart = win.getScore().getStartTime();
        this.hscale = win.getScore().getScale();
        this.subdivisions = win.getScene().getFramesPerSecond();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.tracks = new TrackInfo[0];
        this.markers = new Vector();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (TrackGraph.this.vscale <= 0.0) {
                    TrackGraph.this.setDefaultGraphRange(false);
                } else {
                    Dimension dim = TrackGraph.this.getSize();
                    if (TrackGraph.this.oldHeight <= 0 || dim.height <= 0) {
                        return;
                    }
                    TrackGraph.this.vscale *= (double)((float)dim.height / (float)TrackGraph.this.oldHeight);
                    TrackGraph.this.oldHeight = dim.height;
                }
                TrackGraph.this.repaint();
            }
        });
    }

    public void setStartTime(double time) {
        this.hstart = time;
    }

    public void setScale(double s) {
        this.hscale = s;
    }

    public void setSubdivisions(int s) {
        this.subdivisions = s;
    }

    public void setYOffset(int offset) {
    }

    public void addMarker(Marker m) {
        this.markers.addElement(m);
    }

    public void setMode(int m) {
        this.mode = m;
    }

    public VerticalAxis getAxis() {
        return this.vertAxis;
    }

    public void setTracks(Track[] t) {
        boolean listChanged = t.length != this.tracks.length;
        int i = 0;
        while (i < t.length && i < this.tracks.length) {
            if (t[i] != this.tracks[i].track) {
                listChanged = true;
            }
            ++i;
        }
        this.tracks = new TrackInfo[t.length];
        int i2 = 0;
        while (i2 < t.length) {
            this.tracks[i2] = new TrackInfo(t[i2]);
            ++i2;
        }
        this.selectionChanged();
        this.setDefaultGraphRange(!listChanged);
    }

    public void showLineAtBottom(boolean show) {
        this.lineAtBottom = show;
    }

    private void setDefaultGraphRange(boolean largerOnly) {
        Dimension dim = this.getSize();
        double oldmin = this.vstart;
        double oldmax = this.vstart + (double)dim.height / this.vscale;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int which = 0;
        while (which < this.tracks.length) {
            TrackInfo info = this.tracks[which];
            int i = 0;
            while (i < info.keyValue.length) {
                int j = 0;
                while (j < info.keyValue[i].length) {
                    if (!info.disabled[j]) {
                        if (info.keyValue[i][j] < min) {
                            min = info.keyValue[i][j];
                        }
                        if (info.keyValue[i][j] > max) {
                            max = info.keyValue[i][j];
                        }
                    }
                    ++j;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < info.graphValue.length) {
                int j = 0;
                while (j < info.graphValue[i2].length) {
                    if (!info.disabled[j]) {
                        if (info.graphValue[i2][j] < min) {
                            min = info.graphValue[i2][j];
                        }
                        if (info.graphValue[i2][j] > max) {
                            max = info.graphValue[i2][j];
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            ++which;
        }
        if (min == Double.MAX_VALUE) {
            min = 0.0;
            max = 1.0;
        }
        if (max == min && min >= 0.0 && min <= 1.0) {
            min = 0.0;
            max = 1.0;
        }
        if (max == min) {
            min = Math.floor(min);
            max = min + 1.0;
        }
        double extra = 0.05 * (max - min);
        min -= extra;
        max += extra;
        if (largerOnly && min > oldmin) {
            min = oldmin;
        }
        if (largerOnly && max < oldmax) {
            max = oldmax;
        }
        this.vstart = min;
        this.vscale = (double)dim.height / (max - min);
        this.vertAxis.setGraphRange(min, max);
        this.oldHeight = dim.height;
    }

    public void tracksModified() {
        int i = 0;
        while (i < this.tracks.length) {
            this.tracks[i].findValues();
            ++i;
        }
        this.selectionChanged();
        this.repaint();
    }

    public void selectionChanged() {
        int i = 0;
        while (i < this.tracks.length) {
            TrackInfo info = this.tracks[i];
            int j = 0;
            while (j < info.selected.length) {
                info.selected[j] = false;
                ++j;
            }
            SelectionInfo[] selection = this.theScore.getSelectedKeyframes();
            j = 0;
            while (j < selection.length) {
                if (selection[j].track == info.track) {
                    info.selected[selection[j].keyIndex] = true;
                }
                ++j;
            }
            ++i;
        }
    }

    private void findInitialKeyValues() {
        SelectionInfo[] sel = this.theScore.getSelectedKeyframes();
        this.dragKeyTime = new double[sel.length];
        this.dragKeyValue = new double[sel.length][];
        int i = 0;
        while (i < sel.length) {
            double[] t = sel[i].track.getKeyTimes();
            this.dragKeyTime[i] = t[sel[i].keyIndex];
            Keyframe[] key = sel[i].track.getTimecourse().getValues();
            this.dragKeyValue[i] = key[sel[i].keyIndex].getGraphValues();
            ++i;
        }
    }

    public void mousePressed(MouseEvent ev) {
        this.lastPos = ev.getPoint();
        this.undo = null;
        this.dragPos = null;
        this.draggingBox = false;
        int n = this.effectiveMode = ev.isMetaDown() ? 1 : this.mode;
        if (this.effectiveMode != 0) {
            return;
        }
        Dimension dim = this.getSize();
        int i = 0;
        while (i < this.tracks.length) {
            int j = 0;
            while (j < this.tracks[i].keyValue.length) {
                int x = (int)Math.round(this.hscale * (this.tracks[i].keyTime[j] - this.hstart));
                if (this.lastPos.x >= x - 2 && this.lastPos.x <= x + 2) {
                    int k = this.tracks[i].keyValue[j].length - 1;
                    while (k >= 0) {
                        int y;
                        if (!this.tracks[i].disabled[k] && this.lastPos.y >= (y = dim.height - (int)Math.round(this.vscale * (this.tracks[i].keyValue[j][k] - this.vstart))) - 2 && this.lastPos.y <= y + 2) {
                            Keyframe key = this.tracks[i].track.getTimecourse().getValues()[j];
                            SelectionInfo newsel = new SelectionInfo(this.tracks[i].track, key);
                            int m = 0;
                            while (m < newsel.selected.length) {
                                newsel.selected[m] = m == k;
                                ++m;
                            }
                            if (ev.isShiftDown()) {
                                if (this.theScore.isKeyframeSelected(key, k)) {
                                    this.theScore.removeSelectedKeyframe(key);
                                } else {
                                    this.theScore.addSelectedKeyframes(new SelectionInfo[]{newsel});
                                }
                            } else if (!this.theScore.isKeyframeSelected(key, k)) {
                                this.theScore.setSelectedKeyframes(new SelectionInfo[]{newsel});
                            }
                            this.findInitialKeyValues();
                            this.selectionChanged();
                            this.theScore.repaintGraphs();
                            return;
                        }
                        --k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!ev.isShiftDown()) {
            this.theScore.setSelectedKeyframes(new SelectionInfo[0]);
        }
        this.selectionChanged();
        this.draggingBox = true;
        this.theScore.repaintGraphs();
    }

    public void mouseDragged(MouseEvent ev) {
        Point pos = ev.getPoint();
        if (this.effectiveMode == 0) {
            int j;
            int i;
            if (this.draggingBox) {
                Graphics g = this.getGraphics();
                g.setXORMode(Color.white);
                g.setColor(Color.black);
                if (this.dragPos != null) {
                    g.drawRect(Math.min(this.lastPos.x, this.dragPos.x), Math.min(this.lastPos.y, this.dragPos.y), Math.abs(this.dragPos.x - this.lastPos.x), Math.abs(this.dragPos.y - this.lastPos.y));
                }
                this.dragPos = pos;
                g.drawRect(Math.min(this.lastPos.x, this.dragPos.x), Math.min(this.lastPos.y, this.dragPos.y), Math.abs(this.dragPos.x - this.lastPos.x), Math.abs(this.dragPos.y - this.lastPos.y));
                g.dispose();
                return;
            }
            SelectionInfo[] sel = this.theScore.getSelectedKeyframes();
            if (this.undo == null) {
                this.undo = new UndoRecord(this.window, false);
                i = 0;
                while (i < sel.length) {
                    Track tr = sel[i].track;
                    j = 0;
                    while (j < i && tr != sel[j].track) {
                        ++j;
                    }
                    if (j == i) {
                        this.undo.addCommand(12, new Object[]{tr, tr.duplicate(tr.getParent())});
                    }
                    ++i;
                }
                this.window.setUndoRecord(this.undo);
            }
            double dt = (double)(pos.x - this.lastPos.x) / this.hscale;
            double dv = (double)(this.lastPos.y - pos.y) / this.vscale;
            i = 0;
            while (i < sel.length) {
                Track tr = sel[i].track;
                j = 0;
                while (j < this.tracks.length && tr != this.tracks[j].track) {
                    ++j;
                }
                if (j != this.tracks.length) {
                    int k = 0;
                    while (k < sel[i].selected.length) {
                        if (sel[i].selected[k]) {
                            double newval = this.dragKeyValue[i][k] + dv;
                            if (newval < this.tracks[j].valueRange[k][0]) {
                                newval = this.tracks[j].valueRange[k][0];
                            }
                            if (newval > this.tracks[j].valueRange[k][1]) {
                                newval = this.tracks[j].valueRange[k][1];
                            }
                            this.tracks[j].keyValue[sel[i].keyIndex][k] = newval;
                        }
                        ++k;
                    }
                    sel[i].key.setGraphValues(this.tracks[j].keyValue[sel[i].keyIndex]);
                }
                ++i;
            }
            i = 0;
            while (i < sel.length) {
                int newindex;
                int oldindex = sel[i].keyIndex;
                double t = this.dragKeyTime[i] + dt;
                if (sel[i].track.isQuantized()) {
                    t = (double)Math.round(t * (double)this.subdivisions) / (double)this.subdivisions;
                }
                if (oldindex != (newindex = sel[i].track.moveKeyframe(oldindex, t))) {
                    j = 0;
                    while (j < sel.length) {
                        if (sel[j].keyIndex < oldindex && sel[j].keyIndex > newindex) {
                            ++sel[j].keyIndex;
                        } else if (sel[j].keyIndex > oldindex && sel[j].keyIndex < newindex) {
                            --sel[j].keyIndex;
                        }
                        ++j;
                    }
                    sel[i].keyIndex = newindex;
                }
                ++i;
            }
            this.theScore.tracksModified(false);
            return;
        }
        if (this.effectiveMode != 1) {
            return;
        }
        Dimension dim = this.getSize();
        if (ev.isShiftDown()) {
            this.hscale *= Math.pow(1.01, pos.x - this.lastPos.x);
            this.vscale *= Math.pow(1.01, this.lastPos.y - pos.y);
            this.vertAxis.setGraphRange(this.vstart, this.vstart + (double)dim.height / this.vscale);
            if (pos.x == this.lastPos.x) {
                this.repaint();
                this.vertAxis.repaint();
            } else {
                this.theScore.setScale(this.hscale);
            }
            this.lastPos = pos;
            return;
        }
        this.hstart -= (double)(pos.x - this.lastPos.x) / this.hscale;
        this.vstart -= (double)(this.lastPos.y - pos.y) / this.vscale;
        this.vertAxis.setGraphRange(this.vstart, this.vstart + (double)dim.height / this.vscale);
        if (pos.x == this.lastPos.x) {
            this.repaint();
            this.vertAxis.repaint();
        } else {
            this.theScore.setStartTime(this.hstart);
        }
        this.lastPos = pos;
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.dragPos == null) {
            if (this.effectiveMode == 0) {
                this.theScore.tracksModified(true);
            }
            return;
        }
        int x1 = Math.min(this.lastPos.x, this.dragPos.x);
        int x2 = Math.max(this.lastPos.x, this.dragPos.x);
        int y1 = Math.min(this.lastPos.y, this.dragPos.y);
        int y2 = Math.max(this.lastPos.y, this.dragPos.y);
        Vector<SelectionInfo> v = new Vector<SelectionInfo>();
        Dimension dim = this.getSize();
        int i = 0;
        while (i < this.tracks.length) {
            int j = 0;
            while (j < this.tracks[i].keyValue.length) {
                int x = (int)Math.round(this.hscale * (this.tracks[i].keyTime[j] - this.hstart));
                if (x >= x1 && x <= x2) {
                    Keyframe key = this.tracks[i].track.getTimecourse().getValues()[j];
                    SelectionInfo newsel = new SelectionInfo(this.tracks[i].track, key);
                    boolean any = false;
                    int k = 0;
                    while (k < this.tracks[i].keyValue[j].length) {
                        int y;
                        newsel.selected[k] = false;
                        if (!this.tracks[i].disabled[k] && (y = dim.height - (int)Math.round(this.vscale * (this.tracks[i].keyValue[j][k] - this.vstart))) >= y1 && y <= y2) {
                            any = true;
                            newsel.selected[k] = true;
                        }
                        ++k;
                    }
                    if (any) {
                        v.addElement(newsel);
                    }
                }
                ++j;
            }
            ++i;
        }
        SelectionInfo[] sel = new SelectionInfo[v.size()];
        int i2 = 0;
        while (i2 < sel.length) {
            sel[i2] = (SelectionInfo)v.elementAt(i2);
            ++i2;
        }
        this.theScore.addSelectedKeyframes(sel);
        this.selectionChanged();
        this.theScore.repaintGraphs();
    }

    public void mouseClicked(MouseEvent ev) {
        if (ev.getClickCount() == 2 && this.effectiveMode == 0) {
            this.theScore.editSelectedKeyframe();
        }
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }

    public void paint(Graphics g) {
        int y;
        int x;
        int i;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int fontHeight = fm.getMaxAscent() + fm.getMaxDescent();
        int labels = 0;
        Dimension dim = this.getSize();
        SelectionInfo[] selection = this.theScore.getSelectedKeyframes();
        int which = 0;
        while (which < this.tracks.length) {
            TrackInfo info = this.tracks[which];
            int num = info.valueName.length;
            i = 0;
            while (i < num) {
                if (!info.disabled[i]) {
                    g.setColor(info.dimmed ? LIGHT_LINE_COLOR[labels % LINE_COLOR.length] : LINE_COLOR[labels % LINE_COLOR.length]);
                    this.plotLine(g, info.graphTime, info.graphValue, i, dim);
                    int j = 0;
                    while (j < info.keyTime.length) {
                        g.setColor(LINE_COLOR[labels % LINE_COLOR.length]);
                        if (info.selected[j]) {
                            int k = 0;
                            while (k < selection.length) {
                                if (selection[k].track == info.track && selection[k].keyIndex == j) {
                                    if (selection[k].selected[i]) {
                                        g.setColor(SELECTED_VALUE_COLOR);
                                    } else {
                                        g.setColor(SELECTED_KEY_COLOR);
                                    }
                                }
                                ++k;
                            }
                        }
                        x = (int)Math.round(this.hscale * (info.keyTime[j] - this.hstart));
                        y = dim.height - (int)Math.round(this.vscale * (info.keyValue[j][i] - this.vstart));
                        g.fillRect(x - 2, y - 2, 5, 5);
                        ++j;
                    }
                    g.setColor(LINE_COLOR[labels % LINE_COLOR.length]);
                    y = fontHeight * labels + fontHeight / 2;
                    g.drawLine(dim.width - 15, y, dim.width - 5, y);
                    x = dim.width - 20 - fm.stringWidth(info.valueName[i]);
                    g.drawString(info.valueName[i], x, fontHeight * (labels + 1));
                    ++labels;
                }
                ++i;
            }
            ++which;
        }
        String message = null;
        if (this.tracks.length == 0) {
            message = "No tracks are selected to display.";
        } else if (labels == 0) {
            message = this.tracks.length == 1 ? "The track '" + this.tracks[0].track.getName() + "' has no graphable parameters." : "The selected tracks have no graphable parameters.";
        }
        if (message != null) {
            x = (dim.width - fm.stringWidth(message)) / 2;
            y = (dim.height + fontHeight) / 2;
            g.drawString(message, x, y);
        }
        i = 0;
        while (i < this.markers.size()) {
            Marker m = (Marker)this.markers.elementAt(i);
            g.setColor(m.color);
            x = (int)Math.round(this.hscale * (m.position - this.hstart));
            g.drawLine(x, 0, x, dim.height);
            ++i;
        }
        if (this.lineAtBottom) {
            g.setColor(Color.black);
            g.drawLine(0, dim.height - 1, dim.width, dim.height - 1);
        }
    }

    private void plotLine(Graphics g, double[] x, double[][] y, int which, Dimension dim) {
        int toX = (int)Math.round(this.hscale * (x[0] - this.hstart));
        int toY = dim.height - (int)Math.round(this.vscale * (y[0][which] - this.vstart));
        if (toX > 0) {
            g.drawLine(0, toY, toX, toY);
        }
        int i = 1;
        while (i < x.length) {
            int fromX = toX;
            int fromY = toY;
            toX = (int)Math.round(this.hscale * (x[i] - this.hstart));
            toY = dim.height - (int)Math.round(this.vscale * (y[i][which] - this.vstart));
            g.drawLine(fromX, fromY, toX, toY);
            ++i;
        }
        if (toX < dim.width) {
            g.drawLine(toX, toY, dim.width, toY);
        }
    }

    static {
        int i = 0;
        while (i < LINE_COLOR.length) {
            TrackGraph.LIGHT_LINE_COLOR[i] = new Color(191 + LINE_COLOR[i].getRed() / 4, 191 + LINE_COLOR[i].getGreen() / 4, 191 + LINE_COLOR[i].getBlue() / 4);
            ++i;
        }
        SELECTED_VALUE_COLOR = Color.red;
        SELECTED_KEY_COLOR = Color.magenta;
    }

    private class TrackInfo {
        Track track;
        String[] valueName;
        double[] keyTime;
        double[][] keyValue;
        double[] graphTime;
        double[][] graphValue;
        double[][] valueRange;
        boolean[] disabled;
        boolean[] selected;
        boolean dimmed;

        public TrackInfo(Track tr) {
            this.track = tr;
            this.findValues();
        }

        public void findValues() {
            Keyframe[] graphKeyframe;
            Track tr;
            Timecourse tc = this.track.getTimecourse();
            if (tc == null) {
                this.valueName = new String[0];
                this.keyTime = new double[0];
                this.keyValue = new double[0][0];
                this.graphTime = new double[0];
                this.graphValue = new double[0][0];
                this.disabled = new boolean[0];
                this.selected = new boolean[0];
                return;
            }
            this.valueName = this.track.getValueNames();
            int num = this.valueName.length;
            this.valueRange = this.track.getValueRange();
            this.keyTime = tc.getTimes();
            Keyframe[] keyframe = tc.getValues();
            if (this.track instanceof PositionTrack) {
                tr = (PositionTrack)this.track;
                this.disabled = new boolean[]{!((PositionTrack)tr).affectsX(), !((PositionTrack)tr).affectsY(), !((PositionTrack)tr).affectsZ()};
            } else if (this.track instanceof RotationTrack) {
                tr = (RotationTrack)this.track;
                this.disabled = new boolean[]{!((RotationTrack)tr).affectsX(), !((RotationTrack)tr).affectsY(), !((RotationTrack)tr).affectsZ()};
            } else {
                this.disabled = new boolean[num];
            }
            if (this.selected == null || this.selected.length != this.keyTime.length) {
                this.selected = new boolean[this.keyTime.length];
            }
            boolean bl = this.dimmed = this.track instanceof RotationTrack && ((RotationTrack)this.track).getUseQuaternion();
            if (this.keyTime.length == 0) {
                this.graphTime = new double[]{0.0};
                this.graphValue = new double[1][];
                this.graphValue[0] = this.track.getDefaultGraphValues();
                this.keyValue = new double[0][0];
                return;
            }
            if (this.track.getSmoothingMethod() == 0) {
                this.graphTime = new double[keyframe.length * 2 - 1];
                graphKeyframe = new Keyframe[keyframe.length * 2 - 1];
                int i = 0;
                while (i < keyframe.length) {
                    graphKeyframe[i * 2] = keyframe[i];
                    this.graphTime[i * 2] = this.keyTime[i];
                    if (i < keyframe.length - 1) {
                        graphKeyframe[i * 2 + 1] = keyframe[i];
                        this.graphTime[i * 2 + 1] = this.keyTime[i + 1];
                    }
                    ++i;
                }
            } else {
                Timecourse sub = tc.subdivide(this.track.getSmoothingMethod());
                sub = sub.subdivide(this.track.getSmoothingMethod());
                sub = sub.subdivide(this.track.getSmoothingMethod());
                this.graphTime = sub.getTimes();
                graphKeyframe = sub.getValues();
            }
            this.keyValue = new double[keyframe.length][];
            int i = 0;
            while (i < keyframe.length) {
                this.keyValue[i] = keyframe[i].getGraphValues();
                ++i;
            }
            this.graphValue = new double[graphKeyframe.length][1];
            int i2 = 0;
            while (i2 < graphKeyframe.length) {
                this.graphValue[i2] = graphKeyframe[i2].getGraphValues();
                ++i2;
            }
        }
    }
}

