/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.distortion.Distortion;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;

public class BendDistortion
implements Distortion {
    private int axis;
    private int direction;
    private double angle;
    private Mat4 preTransform;
    private Mat4 postTransform;
    private Distortion previous;
    private boolean forward;
    public static final int POS_X = 0;
    public static final int NEG_X = 1;
    public static final int POS_Y = 2;
    public static final int NEG_Y = 3;
    public static final int POS_Z = 4;
    public static final int NEG_Z = 5;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;

    public BendDistortion(int axis, int direction, double angle, boolean forward, Mat4 preTransform, Mat4 postTransform) {
        this.axis = axis;
        this.direction = direction;
        this.angle = angle;
        this.forward = forward;
        this.preTransform = preTransform;
        this.postTransform = postTransform;
    }

    public void setPreviousDistortion(Distortion previous) {
        this.previous = previous;
    }

    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof BendDistortion)) {
            return false;
        }
        BendDistortion s = (BendDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.axis != s.axis || this.direction != s.direction || this.angle != s.angle || this.forward != s.forward) {
            return false;
        }
        if (this.preTransform == s.preTransform && this.postTransform == s.postTransform) {
            return true;
        }
        return this.preTransform != null && this.preTransform.equals(s.preTransform) && this.postTransform != null && this.postTransform.equals(s.postTransform);
    }

    public Distortion duplicate() {
        BendDistortion d = new BendDistortion(this.axis, this.direction, this.angle, this.forward, this.preTransform, this.postTransform);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    public Mesh transform(Mesh obj) {
        double b;
        double a;
        double b2;
        int i;
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        Mesh newmesh = (Mesh)((Object)obj.duplicate());
        MeshVertex[] vert = newmesh.getVertices();
        Vec3[] newvert = new Vec3[vert.length];
        Vec3 origin = new Vec3();
        int i2 = 0;
        while (i2 < newvert.length) {
            newvert[i2] = vert[i2].r;
            if (this.preTransform != null) {
                this.preTransform.transform(newvert[i2]);
            }
            ++i2;
        }
        if (this.preTransform != null) {
            this.preTransform.transform(origin);
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int i3 = 0;
        while (i3 < newvert.length) {
            double value = this.axis == 0 ? newvert[i3].x : (this.axis == 1 ? newvert[i3].y : newvert[i3].z);
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            ++i3;
        }
        if (min >= max) {
            return obj;
        }
        if (!this.forward) {
            double temp = min;
            min = max;
            max = temp;
        }
        double theta = this.angle * (Math.PI / 180);
        double scale = theta / (max - min);
        double radius = (max - min) / theta;
        if (this.axis == 0) {
            if (this.direction == 1) {
                i = 0;
                while (i < newvert.length) {
                    double a2 = scale * (newvert[i].x - min);
                    b2 = newvert[i].y - origin.y - radius;
                    newvert[i].set(min - Math.sin(a2) * b2, origin.y + radius + Math.cos(a2) * b2, newvert[i].z);
                    ++i;
                }
            } else {
                int i4 = 0;
                while (i4 < newvert.length) {
                    a = scale * (newvert[i4].x - min);
                    b = newvert[i4].z - origin.z - radius;
                    newvert[i4].set(min - Math.sin(a) * b, newvert[i4].y, origin.z + radius + Math.cos(a) * b);
                    ++i4;
                }
            }
        } else if (this.axis == 1) {
            if (this.direction == 0) {
                i = 0;
                while (i < newvert.length) {
                    double a3 = scale * (newvert[i].y - min);
                    b2 = newvert[i].x - origin.x - radius;
                    newvert[i].set(origin.x + radius + Math.cos(a3) * b2, min - Math.sin(a3) * b2, newvert[i].z);
                    ++i;
                }
            } else {
                int i5 = 0;
                while (i5 < newvert.length) {
                    a = scale * (newvert[i5].y - min);
                    b = newvert[i5].z - origin.z - radius;
                    newvert[i5].set(newvert[i5].x, min - Math.sin(a) * b, origin.z + radius + Math.cos(a) * b);
                    ++i5;
                }
            }
        } else if (this.direction == 0) {
            i = 0;
            while (i < newvert.length) {
                double a4 = scale * (newvert[i].z - min);
                b2 = newvert[i].x - origin.x - radius;
                newvert[i].set(origin.x + radius + Math.cos(a4) * b2, newvert[i].y, min - Math.sin(a4) * b2);
                ++i;
            }
        } else {
            int i6 = 0;
            while (i6 < newvert.length) {
                a = scale * (newvert[i6].z - min);
                b = newvert[i6].y - origin.y - radius;
                newvert[i6].set(newvert[i6].x, origin.y + radius + Math.cos(a) * b, min - Math.sin(a) * b);
                ++i6;
            }
        }
        if (this.postTransform != null) {
            i = 0;
            while (i < newvert.length) {
                this.postTransform.transform(newvert[i]);
                ++i;
            }
        }
        newmesh.setVertices(newvert);
        return newmesh;
    }
}

