/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.ArrayKeyframe;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.animation.distortion.CustomDistortion;
import artofillusion.object.ObjectInfo;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class CustomDistortionTrack
extends Track
implements ProcedureOwner {
    ObjectInfo info;
    Procedure proc;
    Timecourse tc;
    TextureParameter[] parameter;
    int smoothingMethod;
    int procVersion;
    WeightTrack theWeight;
    boolean worldCoords;

    public CustomDistortionTrack(ObjectInfo info) {
        super("Deform");
        this.info = info;
        this.proc = new Procedure(new OutputModule[]{new OutputModule("X", "X", 0.0, null, 0), new OutputModule("Y", "Y", 0.0, null, 0), new OutputModule("Z", "Z", 0.0, null, 0)});
        this.parameter = new TextureParameter[0];
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.worldCoords = false;
        this.theWeight = new WeightTrack(this);
    }

    public void apply(double time) {
        PointInfo point = new PointInfo();
        OutputModule[] output = this.proc.getOutputModules();
        ArrayKeyframe params = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        point.t = time;
        if (params != null) {
            point.param = params.val;
        }
        double weight = this.theWeight.getWeight(time);
        if (this.worldCoords) {
            this.info.addDistortion(new CustomDistortion(this.proc, this.procVersion, point, weight, this.info.coords.fromLocal(), this.info.coords.toLocal()));
        } else {
            this.info.addDistortion(new CustomDistortion(this.proc, this.procVersion, point, weight, null, null));
        }
    }

    public Track duplicate(Object obj) {
        CustomDistortionTrack t = new CustomDistortionTrack((ObjectInfo)obj);
        t.proc.copy(this.proc);
        t.worldCoords = this.worldCoords;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        CustomDistortionTrack t = (CustomDistortionTrack)tr;
        this.proc.copy(t.proc);
        this.worldCoords = t.worldCoords;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        double[] p;
        if (this.parameter.length == 0) {
            return null;
        }
        ArrayKeyframe params = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (params == null) {
            p = this.getDefaultGraphValues();
        } else {
            p = new double[params.val.length];
            System.arraycopy(params.val, 0, p, 0, p.length);
        }
        ArrayKeyframe k = new ArrayKeyframe(p);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return false;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        String[] names = new String[this.parameter.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.parameter[i].name;
            ++i;
        }
        return names;
    }

    public double[] getDefaultGraphValues() {
        double[] val = new double[this.parameter.length];
        int i = 0;
        while (i < val.length) {
            val[i] = this.parameter[i].defaultVal;
            ++i;
        }
        return val;
    }

    public double[][] getValueRange() {
        double[][] range = new double[this.parameter.length][2];
        int i = 0;
        while (i < range.length) {
            range[i][0] = this.parameter[i].minVal;
            range[i][1] = this.parameter[i].maxVal;
            ++i;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
    }

    private TextureParameter[] findParameters() {
        Module[] module = this.proc.getModules();
        int count = 0;
        int i = 0;
        while (i < module.length) {
            if (module[i] instanceof ParameterModule) {
                ++count;
            }
            ++i;
        }
        TextureParameter[] params = new TextureParameter[count];
        count = 0;
        int i2 = 0;
        while (i2 < module.length) {
            if (module[i2] instanceof ParameterModule) {
                params[count] = ((ParameterModule)module[i2]).getParameter(this);
                ((ParameterModule)module[i2]).setIndex(count++);
            }
            ++i2;
        }
        return params;
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        this.proc.writeToStream(out, scene);
        out.writeInt(this.smoothingMethod);
        out.writeBoolean(this.worldCoords);
        out.writeInt(t.length);
        int i = 0;
        while (i < t.length) {
            out.writeDouble(t[i]);
            ((ArrayKeyframe)v[i]).writeToStream(out);
            s[i].writeToStream(out);
            ++i;
        }
        this.theWeight.writeToStream(out, scene);
    }

    public CustomDistortionTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.proc = new Procedure(new OutputModule[]{new OutputModule("X", "X", 0.0, null, 0), new OutputModule("Y", "Y", 0.0, null, 0), new OutputModule("Z", "Z", 0.0, null, 0)});
        this.proc.readFromStream(in, scene);
        this.smoothingMethod = in.readInt();
        this.worldCoords = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        int i = 0;
        while (i < keys) {
            t[i] = in.readDouble();
            v[i] = new ArrayKeyframe(in, this);
            s[i] = new Smoothness(in);
            ++i;
        }
        this.info = (ObjectInfo)parent;
        this.tc = new Timecourse(v, t, s);
        this.theWeight = new WeightTrack(in, this, scene);
        this.parameter = this.findParameters();
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ArrayKeyframe key = (ArrayKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField[] valField = new ValueField[this.parameter.length];
        ValueSlider[] valSlider = new ValueSlider[this.parameter.length];
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final Checkbox sameBox = new Checkbox("Separate Left and Right Smoothness", !s.isForceSame());
        final Label leftLabel = new Label(" (" + Translate.text("left") + ")");
        final Label rightLabel = new Label(" (" + Translate.text("right") + ")");
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        int i = 0;
        while (i < this.parameter.length) {
            if (this.parameter[i].minVal == -1.7976931348623157E308 || this.parameter[i].maxVal == Double.MAX_VALUE) {
                final TextureParameter tp = this.parameter[i];
                valField[i] = new ValueField(key.val[i], 0, 5);
                valField[i].setValueChecker(new ValueChecker(){

                    public boolean isValid(double v) {
                        return v >= tp.minVal && v <= tp.maxVal;
                    }
                });
            } else {
                valSlider[i] = new ValueSlider(this.parameter[i].minVal, this.parameter[i].maxVal, 50, key.val[i]);
            }
            ++i;
        }
        p.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        int i2 = 0;
        while (i2 < this.parameter.length) {
            p.add((Component)new Label(this.parameter[i2].name), gc);
            ++i2;
        }
        p.add((Component)new Label(Translate.text("Time")), gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        int i3 = 0;
        while (i3 < this.parameter.length) {
            if (valField[i3] != null) {
                p.add((Component)valField[i3], gc);
            } else {
                p.add((Component)valSlider[i3], gc);
            }
            ++i3;
        }
        p.add((Component)timeField, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.anchor = 10;
        p.add((Component)sameBox, gc);
        p.add((Component)new Label(Translate.text("Smoothness") + ':'), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)leftLabel, gc);
        p.add((Component)rightLabel, gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)s1Slider, gc);
        p.add((Component)s2Slider, gc);
        leftLabel.setEnabled(sameBox.getState());
        rightLabel.setEnabled(sameBox.getState());
        s2Slider.setEnabled(sameBox.getState());
        sameBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                leftLabel.setEnabled(sameBox.getState());
                rightLabel.setEnabled(sameBox.getState());
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        PanelDialog dlg = new PanelDialog((Window)win, "Edit Keyframe", p);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        int i4 = 0;
        while (i4 < valField.length) {
            key.val[i4] = valField[i4] != null ? valField[i4].getValue() : valSlider[i4].getValue();
            ++i4;
        }
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        ProcedureEditor editor = new ProcedureEditor(this.proc, this, win.getScene());
        editor.setEditingWindow(win);
    }

    public String getWindowTitle() {
        return "Custom Deformation Track";
    }

    public Object getPreview(ProcedureEditor editor) {
        return null;
    }

    public void updatePreview(Object preview) {
    }

    public void disposePreview(Object preview) {
    }

    public boolean allowParameters() {
        return true;
    }

    public boolean canEditName() {
        return true;
    }

    public void acceptEdits(ProcedureEditor editor) {
        EditingWindow win = editor.getEditingWindow();
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        TextureParameter[] newparams = this.findParameters();
        int[] index = new int[newparams.length];
        int i = 0;
        while (i < newparams.length) {
            index[i] = -1;
            int j = 0;
            while (j < this.parameter.length) {
                if (this.parameter[j].equals(newparams[i])) {
                    index[i] = j;
                }
                ++j;
            }
            ++i;
        }
        this.parameter = newparams;
        Keyframe[] key = this.tc.getValues();
        int i2 = 0;
        while (i2 < key.length) {
            double[] newval = new double[this.parameter.length];
            int j = 0;
            while (j < newval.length) {
                newval[j] = index[j] > -1 ? ((ArrayKeyframe)key[i2]).val[index[j]] : this.parameter[j].defaultVal;
                ++j;
            }
            ((ArrayKeyframe)key[i2]).val = newval;
            ++i2;
        }
        ++this.procVersion;
        ((LayoutWindow)win).getScore().finishEditingTrack(this);
    }

    public void editProperties(ProcedureEditor editor) {
        Choice smoothChoice = new Choice();
        smoothChoice.add("Discontinuous");
        smoothChoice.add("Linear");
        smoothChoice.add("Interpolating");
        smoothChoice.add("Approximating");
        smoothChoice.select(this.smoothingMethod);
        Choice coordsChoice = new Choice();
        coordsChoice.add("Local");
        coordsChoice.add("World");
        coordsChoice.select(this.worldCoords ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog((Window)editor.getParentFrame(), "Deformation Track Properties", new Component[]{smoothChoice, coordsChoice}, new String[]{"Parameter Smoothing Method:", "Coordinate System:"});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.worldCoords = coordsChoice.getSelectedIndex() == 1;
    }
}

