/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.VectorKeyframe;
import artofillusion.animation.WeightTrack;
import artofillusion.animation.distortion.ScaleDistortion;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ScaleTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;
    int smoothingMethod;
    WeightTrack theWeight;
    boolean worldCoords;

    public ScaleTrack(ObjectInfo info) {
        super("Scale");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.theWeight = new WeightTrack(this);
        this.worldCoords = false;
    }

    public void apply(double time) {
        VectorKeyframe scale = (VectorKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (scale == null) {
            return;
        }
        double weight = this.theWeight.getWeight(time);
        double w2 = 1.0 - weight;
        if (this.worldCoords) {
            this.info.addDistortion(new ScaleDistortion(scale.x * weight + w2, scale.y * weight + w2, scale.z * weight + w2, this.info.coords.fromLocal(), this.info.coords.toLocal()));
        } else {
            this.info.addDistortion(new ScaleDistortion(scale.x * weight + w2, scale.y * weight + w2, scale.z * weight + w2, null, null));
        }
    }

    public Track duplicate(Object obj) {
        ScaleTrack t = new ScaleTrack((ObjectInfo)obj);
        t.smoothingMethod = this.smoothingMethod;
        t.worldCoords = this.worldCoords;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        ScaleTrack t = (ScaleTrack)tr;
        this.smoothingMethod = t.smoothingMethod;
        this.worldCoords = t.worldCoords;
        this.tc = t.tc.duplicate(this.info);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        Keyframe k = this.tc.evaluate(time, this.smoothingMethod);
        k = k == null ? new VectorKeyframe(1.0, 1.0, 1.0) : k.duplicate();
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        return new String[]{"X Scale", "Y Scale", "Z Scale"};
    }

    public double[] getDefaultGraphValues() {
        return new double[]{1.0, 1.0, 1.0};
    }

    public double[][] getValueRange() {
        double[][] range = new double[3][2];
        int i = 0;
        while (i < range.length) {
            range[i][0] = -1.7976931348623157E308;
            range[i][1] = Double.MAX_VALUE;
            ++i;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeBoolean(this.worldCoords);
        out.writeInt(t.length);
        int i = 0;
        while (i < t.length) {
            out.writeDouble(t[i]);
            ((VectorKeyframe)v[i]).writeToFile(out);
            s[i].writeToStream(out);
            ++i;
        }
        this.theWeight.writeToStream(out, scene);
    }

    public ScaleTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.worldCoords = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        int i = 0;
        while (i < keys) {
            t[i] = in.readDouble();
            v[i] = new VectorKeyframe(new Vec3(in));
            s[i] = new Smoothness(in);
            ++i;
        }
        this.info = (ObjectInfo)parent;
        this.tc = new Timecourse(v, t, s);
        this.theWeight = new WeightTrack(in, this, scene);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        VectorKeyframe key = (VectorKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField xField = new ValueField(key.x, 0, 5);
        ValueField yField = new ValueField(key.y, 0, 5);
        ValueField zField = new ValueField(key.z, 0, 5);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final Checkbox sameBox = new Checkbox("Separate Left and Right Smoothness", !s.isForceSame());
        final Label leftLabel = new Label(" (" + Translate.text("left") + ")");
        final Label rightLabel = new Label(" (" + Translate.text("right") + ")");
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)new Label("X Scale"), gc);
        p.add((Component)new Label("Y Scale"), gc);
        p.add((Component)new Label("Z Scale"), gc);
        p.add((Component)new Label(Translate.text("Time")), gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)xField, gc);
        p.add((Component)yField, gc);
        p.add((Component)zField, gc);
        p.add((Component)timeField, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.anchor = 10;
        p.add((Component)sameBox, gc);
        p.add((Component)new Label(Translate.text("Smoothness") + ':'), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)leftLabel, gc);
        p.add((Component)rightLabel, gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)s1Slider, gc);
        p.add((Component)s2Slider, gc);
        leftLabel.setEnabled(sameBox.getState());
        rightLabel.setEnabled(sameBox.getState());
        s2Slider.setEnabled(sameBox.getState());
        sameBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                leftLabel.setEnabled(sameBox.getState());
                rightLabel.setEnabled(sameBox.getState());
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        PanelDialog dlg = new PanelDialog((Window)win, "Edit Keyframe", p);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        key.x = xField.getValue();
        key.y = yField.getValue();
        key.z = zField.getValue();
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        TextField nameField = new TextField(this.getName());
        Choice smoothChoice = new Choice();
        smoothChoice.add("Discontinuous");
        smoothChoice.add("Linear");
        smoothChoice.add("Interpolating");
        smoothChoice.add("Approximating");
        smoothChoice.select(this.smoothingMethod);
        Choice coordsChoice = new Choice();
        coordsChoice.add("Local");
        coordsChoice.add("World");
        coordsChoice.select(this.worldCoords ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog((Window)win, "Options for Scale Track", new Component[]{nameField, smoothChoice, coordsChoice}, new String[]{"Track Name:", "Smoothing Method:", "Coordinate System:"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.worldCoords = coordsChoice.getSelectedIndex() == 1;
    }
}

