/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.distortion.Distortion;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;

public class TwistDistortion
implements Distortion {
    private int axis;
    private double angle;
    private Mat4 preTransform;
    private Mat4 postTransform;
    private Distortion previous;
    private boolean forward;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;

    public TwistDistortion(int axis, double angle, boolean forward, Mat4 preTransform, Mat4 postTransform) {
        this.axis = axis;
        this.angle = angle;
        this.forward = forward;
        this.preTransform = preTransform;
        this.postTransform = postTransform;
    }

    public void setPreviousDistortion(Distortion previous) {
        this.previous = previous;
    }

    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof TwistDistortion)) {
            return false;
        }
        TwistDistortion s = (TwistDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.axis != s.axis || this.angle != s.angle || this.forward != s.forward) {
            return false;
        }
        if (this.preTransform == s.preTransform && this.postTransform == s.postTransform) {
            return true;
        }
        return this.preTransform != null && this.preTransform.equals(s.preTransform) && this.postTransform != null && this.postTransform.equals(s.postTransform);
    }

    public Distortion duplicate() {
        TwistDistortion d = new TwistDistortion(this.axis, this.angle, this.forward, this.preTransform, this.postTransform);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    public Mesh transform(Mesh obj) {
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        Mesh newmesh = (Mesh)((Object)obj.duplicate());
        MeshVertex[] vert = newmesh.getVertices();
        Vec3[] newvert = new Vec3[vert.length];
        int i = 0;
        while (i < newvert.length) {
            newvert[i] = vert[i].r;
            if (this.preTransform != null) {
                this.preTransform.transform(newvert[i]);
            }
            ++i;
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int i2 = 0;
        while (i2 < newvert.length) {
            double value = this.axis == 0 ? newvert[i2].x : (this.axis == 1 ? newvert[i2].y : newvert[i2].z);
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            ++i2;
        }
        if (min >= max) {
            return obj;
        }
        if (!this.forward) {
            double temp = min;
            min = max;
            max = temp;
        }
        double scale = this.angle * (Math.PI / 180);
        if (this.axis == 0) {
            int i3 = 0;
            while (i3 < newvert.length) {
                double c = Math.cos(scale * (newvert[i3].x - min));
                double s = Math.sin(scale * (newvert[i3].x - min));
                newvert[i3].set(newvert[i3].x, newvert[i3].y * c - newvert[i3].z * s, newvert[i3].y * s + newvert[i3].z * c);
                ++i3;
            }
        } else if (this.axis == 1) {
            int i4 = 0;
            while (i4 < newvert.length) {
                double c = Math.cos(scale * (newvert[i4].y - min));
                double s = Math.sin(scale * (newvert[i4].y - min));
                newvert[i4].set(newvert[i4].x * c - newvert[i4].z * s, newvert[i4].y, newvert[i4].x * s + newvert[i4].z * c);
                ++i4;
            }
        } else {
            int i5 = 0;
            while (i5 < newvert.length) {
                double c = Math.cos(scale * (newvert[i5].z - min));
                double s = Math.sin(scale * (newvert[i5].z - min));
                newvert[i5].set(newvert[i5].x * c - newvert[i5].y * s, newvert[i5].x * s + newvert[i5].y * c, newvert[i5].z);
                ++i5;
            }
        }
        if (this.postTransform != null) {
            int i6 = 0;
            while (i6 < newvert.length) {
                this.postTransform.transform(newvert[i6]);
                ++i6;
            }
        }
        newmesh.setVertices(newvert);
        return newmesh;
    }
}

