/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.IOException;

public class BMPEncoder {
    public static final int[] HEADER_PART1 = new int[]{66, 77};
    public static final int[] HEADER_PART2 = new int[]{0, 0, 0, 0, 54, 0, 0, 0, 40, 0, 0, 0};
    public static final int[] HEADER_PART3 = new int[]{1, 0, 24, 0, 0, 0, 0, 0, 104, 133, 21, 0, 97, 15, 0, 0, 97, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int IMAGE_WIDTH = 18;
    public static final int IMAGE_LENGTH = 22;
    public static final int IMAGE_START = 54;
    private Image im;
    int width;
    int height;
    int lineSize;
    int linePad;
    private int imageDataSize;
    private byte[] description;
    private int[] data;

    public BMPEncoder(Image im) throws InterruptedException {
        this.im = im;
        this.recordData();
        this.width = im.getWidth(null);
        if (this.width == -1) {
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.width = im.getWidth(null);
        }
        this.height = im.getHeight(null);
        this.lineSize = this.width * 3;
        this.linePad = 4 - this.lineSize % 4;
        if (this.linePad == 4) {
            this.linePad = 0;
        }
        this.lineSize += this.linePad;
        this.imageDataSize = this.lineSize * this.height;
    }

    protected static void writeIA(DataOutputStream out, int[] data) throws IOException {
        int i = 0;
        while (i < data.length) {
            out.writeByte(data[i]);
            ++i;
        }
    }

    protected static int[] formatLittleEndian(int data) {
        int[] result = new int[4];
        int i = 0;
        while (i < 4) {
            result[i] = data & 0xFF;
            data >>= 8;
            ++i;
        }
        return result;
    }

    public void writeImage(DataOutputStream out) throws IOException {
        this.writeHeader(out);
        this.writeImageData(out);
    }

    private void recordData() throws InterruptedException {
        PixelGrabber pg = new PixelGrabber(this.im, 0, 0, -1, -1, true);
        pg.grabPixels();
        this.data = (int[])pg.getPixels();
    }

    private void writeHeader(DataOutputStream out) throws IOException {
        BMPEncoder.writeIA(out, HEADER_PART1);
        BMPEncoder.writeIA(out, BMPEncoder.formatLittleEndian(54 + this.imageDataSize - 40));
        BMPEncoder.writeIA(out, HEADER_PART2);
        BMPEncoder.writeIA(out, BMPEncoder.formatLittleEndian(this.width));
        BMPEncoder.writeIA(out, BMPEncoder.formatLittleEndian(this.height));
        BMPEncoder.writeIA(out, HEADER_PART3);
    }

    private void writeImageData(DataOutputStream out) throws IOException {
        int[] padbytes = new int[this.linePad];
        int l = this.height - 1;
        while (l >= 0) {
            int start = l * this.width;
            int end = (l + 1) * this.width;
            int i = start;
            while (i < end) {
                out.writeByte(this.data[i] & 0xFF);
                out.writeByte(this.data[i] >> 8 & 0xFF);
                out.writeByte(this.data[i] >> 16 & 0xFF);
                ++i;
            }
            BMPEncoder.writeIA(out, padbytes);
            --l;
        }
    }

    private void makeDescriptionString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Art of Illusion v1.4\n");
        sb.append("");
        this.description = new String(sb).getBytes();
        this.description[this.description.length - 1] = 0;
    }
}

