/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import java.awt.Image;
import java.awt.image.PixelGrabber;

public class ComplexImage {
    Image img;
    float[][] pixelData;
    int[] intImage;
    int width;
    int height;
    public static final int BLUE = 0;
    public static final int GREEN = 1;
    public static final int RED = 2;
    public static final int ALPHA = 3;

    public ComplexImage(Image image) {
        this.img = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.pixelData = new float[4][];
    }

    public void setComponentValues(int component, float[] values) {
        this.pixelData[component] = values;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage() {
        return this.img;
    }

    public boolean hasFloatData(int component) {
        return this.pixelData[component] != null;
    }

    public float getPixelComponent(int x, int y, int component) {
        if (this.pixelData[component] != null) {
            return this.pixelData[component][x + y * this.width];
        }
        if (this.intImage == null) {
            try {
                PixelGrabber pg = new PixelGrabber(this.img, 0, 0, -1, -1, true);
                pg.grabPixels();
                this.intImage = (int[])pg.getPixels();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        return (float)(this.intImage[x + y * this.width] >> component * 8 & 0xFF) * 0.003921569f;
    }
}

