/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.image.HDRImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class HDRDecoder {
    /*
     * WARNING - void declaration
     */
    public static HDRImage createImage(File file) throws IOException {
        int xres;
        int yres;
        String s;
        byte[] signature = "#?RADIANCE".getBytes("ISO-8859-1");
        byte[] fileSignature = new byte[signature.length];
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        in.mark(signature.length);
        in.read(fileSignature, 0, signature.length);
        int i = 0;
        while (i < signature.length) {
            if (signature[i] != fileSignature[i]) {
                in.close();
                throw new IOException("Not an .hdr file");
            }
            ++i;
        }
        in.reset();
        boolean xyze = false;
        while ((s = HDRDecoder.readLine(in)).length() > 0) {
            void var6_6;
            if (!var6_6.startsWith("FORMAT")) continue;
            boolean bl = xyze = var6_6.indexOf("xyze") > -1;
        }
        String resolution = HDRDecoder.readLine(in);
        StringTokenizer st = new StringTokenizer(resolution);
        String[] res = new String[4];
        int i2 = 0;
        while (i2 < 4) {
            if (!st.hasMoreTokens()) {
                in.close();
                throw new IOException("Error parsing image file.");
            }
            res[i2] = st.nextToken();
            ++i2;
        }
        boolean flipY = res[0].startsWith("+");
        boolean flipX = res[2].startsWith("-");
        try {
            yres = Integer.parseInt(res[1]);
            xres = Integer.parseInt(res[3]);
        }
        catch (NumberFormatException ex) {
            in.close();
            throw new IOException("Error parsing image file.");
        }
        byte[][] map = new byte[4][xres * yres];
        byte[] buf = new byte[4];
        int row = 0;
        while (row < yres) {
            int col;
            int step;
            int start = flipY ? (yres - row - 1) * xres : row * xres;
            if (flipX) {
                step = -1;
                start += xres - 1;
            } else {
                step = 1;
            }
            in.readFully(buf);
            if (buf[0] == 2 && buf[1] == 2 && buf[2] >= 0) {
                int component = 0;
                while (component < 4) {
                    col = 0;
                    int pos = start;
                    while (col < xres) {
                        int count = in.read();
                        if (count <= 128) {
                            int i3 = 0;
                            while (i3 < count) {
                                map[component][pos] = (byte)in.read();
                                pos += step;
                                ++i3;
                            }
                        } else {
                            byte repeat = (byte)in.read();
                            count -= 128;
                            int i4 = 0;
                            while (i4 < count) {
                                map[component][pos] = repeat;
                                pos += step;
                                ++i4;
                            }
                        }
                        col += count;
                    }
                    ++component;
                }
            } else {
                int pos = start;
                col = 0;
                while (col < xres) {
                    if (col > 0) {
                        in.readFully(buf);
                    }
                    if (buf[0] == 1 && buf[1] == 1 && buf[2] == 1) {
                        int count = buf[3] & 0xFF;
                        byte r = map[0][pos - step];
                        byte g = map[1][pos - step];
                        byte b = map[2][pos - step];
                        byte e = map[3][pos - step];
                        int i5 = 0;
                        while (i5 < count) {
                            map[0][pos] = r;
                            map[1][pos] = g;
                            map[2][pos] = b;
                            map[3][pos] = e;
                            pos += step;
                            ++i5;
                        }
                        col += count - 1;
                    } else {
                        map[0][pos] = buf[0];
                        map[1][pos] = buf[1];
                        map[2][pos] = buf[2];
                        map[3][pos] = buf[3];
                        pos += step;
                    }
                    ++col;
                }
            }
            ++row;
        }
        in.close();
        if (xyze) {
            int i6 = 0;
            while (i6 < map[0].length) {
                int x = map[0][i6] & 0xFF;
                int y = map[1][i6] & 0xFF;
                int z = map[2][i6] & 0xFF;
                map[0][i6] = (byte)(3.24 * (double)x - 1.54 * (double)y - 0.5 * (double)z);
                map[1][i6] = (byte)(-0.97 * (double)x + 1.88 * (double)y + 0.42 * (double)z);
                map[2][i6] = (byte)(0.06 * (double)x - 0.2 * (double)y + 1.06 * (double)z);
                ++i6;
            }
        }
        return new HDRImage(map[0], map[1], map[2], map[3], xres, yres);
    }

    /*
     * WARNING - void declaration
     */
    private static String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = in.read()) > -1 && c != 10) {
            void var2_2;
            buf.append((char)var2_2);
        }
        return buf.toString();
    }
}

