/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.image.ComplexImage;
import artofillusion.image.HDRImage;
import artofillusion.math.RGBColor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class HDREncoder {
    public static void writeImage(ComplexImage img, OutputStream out) throws IOException {
        int rows = img.getHeight();
        int cols = img.getWidth();
        RGBColor color = new RGBColor();
        byte[] rgbe = new byte[4];
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
        boolean hasAlpha = img.hasFloatData(3);
        pw.print("#?RADIANCE\n");
        pw.print("# Generated by Art of Illusion 1.4\n");
        pw.print("FORMAT=32-bit_rle_rgbe\n");
        pw.print("\n");
        pw.print("-Y " + rows + " +X " + cols + "\n");
        pw.flush();
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                float red = img.getPixelComponent(j, i, 2);
                float green = img.getPixelComponent(j, i, 1);
                float blue = img.getPixelComponent(j, i, 0);
                if (hasAlpha) {
                    float alpha = img.getPixelComponent(j, i, 3);
                    red *= alpha;
                    green *= alpha;
                    blue *= alpha;
                }
                color.setRGB(red, green, blue);
                HDRImage.calcRGBE(color, rgbe);
                out.write(rgbe);
                ++j;
            }
            ++i;
        }
        out.flush();
    }
}

