/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.image.ImageMap;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class HDRImage
extends ImageMap {
    private int[] width;
    private int[] height;
    private byte[][][] maps;
    private float[] average;
    private double[] xscale;
    private double[] yscale;
    private double[] scale;
    private double[] scaleMult;
    private Image preview;
    private RGBColor tempColor;
    private RGBColor tempColor2;
    private Vec2 tempVec;
    private static final float SCALE = 0.003921569f;
    private static final float INVLOG2 = 1.0f / (float)Math.log(2.0);
    private static final float[] EXP_SCALE = new float[256];

    public HDRImage(byte[] r, byte[] g, byte[] b, byte[] e, int xres, int yres) {
        this.tempColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempColor2 = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempVec = new Vec2(0.0, 0.0);
        this.buildMipMaps(r, g, b, e, xres, yres);
        this.findAverage();
        this.createPreview();
    }

    private void buildMipMaps(byte[] r, byte[] g, byte[] b, byte[] e, int w, int h) {
        int k;
        int j;
        int i;
        byte[][] map0 = new byte[][]{r, g, b, e};
        int w1 = 2;
        while (w1 < w) {
            w1 *= 2;
        }
        int h1 = 2;
        while (h1 < h) {
            h1 *= 2;
        }
        float wratio = (float)(w1 /= 2) / (float)w;
        float hratio = (float)(h1 /= 2) / (float)h;
        if (w > 1 && (double)wratio > 0.75) {
            w1 /= 2;
            wratio = (float)((double)wratio * 0.5);
        }
        if (h > 1 && (double)hratio > 0.75) {
            h1 /= 2;
            hratio = (float)((double)hratio * 0.5);
        }
        int num = 0;
        while (1 << num < w1 && 1 << num < h1) {
            ++num;
        }
        num += 2;
        if (w == 1 || h == 1) {
            num = 1;
        }
        this.maps = new byte[num][][];
        this.width = new int[num];
        this.height = new int[num];
        this.scale = new double[num];
        this.xscale = new double[num];
        this.yscale = new double[num];
        this.scaleMult = new double[num - 1];
        this.maps[0] = map0;
        this.width[0] = w;
        this.height[0] = h;
        this.scale[0] = 1.0 / (double)Math.min(w, h);
        if (num > 1) {
            this.width[1] = w1;
            this.height[1] = h1;
            this.scale[1] = 1.0 / (double)Math.min(w1, h1);
            this.maps[1] = new byte[4][w1 * h1];
            float widthScale = (float)w / (float)w1;
            float heightScale = (float)h / (float)h1;
            i = 0;
            while (i < 4) {
                byte[] componentMap0 = this.maps[0][i];
                byte[] componentMap1 = this.maps[1][i];
                j = 0;
                while (j < h1) {
                    int pos1 = j * w1;
                    float pos0 = (int)((float)j * heightScale) * w;
                    k = 0;
                    while (k < w1) {
                        componentMap1[pos1++] = componentMap0[(int)pos0];
                        pos0 += widthScale;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        RGBColor avg = new RGBColor();
        byte[] rgbe = new byte[4];
        i = 2;
        while (i < num) {
            w = this.width[i] = this.width[i - 1] / 2;
            h = this.height[i] = this.height[i - 1] / 2;
            this.scale[i] = 2.0 * this.scale[i - 1];
            this.maps[i] = new byte[4][w * h];
            k = 0;
            while (k < w) {
                int m = 0;
                while (m < h) {
                    j = 2 * k + 4 * w * m;
                    HDRImage.calcPixelColor(this.tempColor, this.maps[i - 1][0][j], this.maps[i - 1][1][j], this.maps[i - 1][2][j], this.maps[i - 1][3][j]);
                    avg.copy(this.tempColor);
                    j = 2 * k + 1 + 4 * w * m;
                    HDRImage.calcPixelColor(this.tempColor, this.maps[i - 1][0][j], this.maps[i - 1][1][j], this.maps[i - 1][2][j], this.maps[i - 1][3][j]);
                    avg.add(this.tempColor);
                    j = 2 * k + 2 * w * (2 * m + 1);
                    HDRImage.calcPixelColor(this.tempColor, this.maps[i - 1][0][j], this.maps[i - 1][1][j], this.maps[i - 1][2][j], this.maps[i - 1][3][j]);
                    avg.add(this.tempColor);
                    j = 2 * k + 1 + 2 * w * (2 * m + 1);
                    HDRImage.calcPixelColor(this.tempColor, this.maps[i - 1][0][j], this.maps[i - 1][1][j], this.maps[i - 1][2][j], this.maps[i - 1][3][j]);
                    avg.add(this.tempColor);
                    avg.scale(0.25);
                    HDRImage.calcRGBE(avg, rgbe);
                    this.maps[i][0][k + w * m] = rgbe[0];
                    this.maps[i][1][k + w * m] = rgbe[1];
                    this.maps[i][2][k + w * m] = rgbe[2];
                    this.maps[i][3][k + w * m] = rgbe[3];
                    ++m;
                }
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < num - 1) {
            this.scaleMult[i] = 1.0 / (this.scale[i + 1] - this.scale[i]);
            ++i;
        }
        i = 0;
        while (i < num) {
            this.xscale[i] = this.width[i];
            this.yscale[i] = this.height[i];
            ++i;
        }
    }

    private void findAverage() {
        byte[][] map = this.maps[this.maps.length - 1];
        RGBColor avg = new RGBColor();
        int len = map[0].length;
        int i = 0;
        while (i < len) {
            HDRImage.calcPixelColor(this.tempColor, map[0][i], map[1][i], map[2][i], map[3][i]);
            avg.add(this.tempColor);
            ++i;
        }
        avg.scale(1.0 / (double)len);
        this.average = new float[]{avg.getRed(), avg.getGreen(), avg.getBlue()};
    }

    private void createPreview() {
        int h;
        int w;
        if (this.width[0] <= 50 && this.height[0] <= 50) {
            w = this.width[0];
            h = this.height[0];
        } else if (this.width[0] < this.height[0]) {
            w = (int)((float)(this.width[0] * 50) / (float)this.height[0]);
            h = 50;
        } else {
            w = 50;
            h = (int)((float)(this.height[0] * 50) / (float)this.width[0]);
        }
        int[] data = new int[w * h];
        float xstep = (float)this.width[0] / (float)w;
        float ystep = (float)this.height[0] / (float)h;
        byte[][] map0 = this.maps[0];
        int i = 0;
        while (i < h) {
            float pos = (int)((float)i * ystep) * this.width[0];
            int base = i * w;
            int j = 0;
            while (j < w) {
                int ipos = (int)pos;
                HDRImage.calcPixelColor(this.tempColor, map0[0][ipos], map0[1][ipos], map0[2][ipos], map0[3][ipos]);
                data[base + j] = this.tempColor.getARGB();
                pos += xstep;
                ++j;
            }
            ++i;
        }
        MemoryImageSource src = new MemoryImageSource(w, h, data, 0, w);
        this.preview = Toolkit.getDefaultToolkit().createImage(src);
    }

    public int getWidth() {
        return this.width[0];
    }

    public int getHeight() {
        return this.height[0];
    }

    public int getComponents() {
        return 3;
    }

    public float getComponent(int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        if (component > 2) {
            return 1.0f;
        }
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            return this.getMapComponent(component, 0, wrapx, wrapy, x, y);
        }
        if (size >= this.scale[this.maps.length - 1]) {
            return this.average[component];
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        float frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        return (1.0f - frac) * this.getMapComponent(component, which, wrapx, wrapy, x, y) + frac * this.getMapComponent(component, which + 1, wrapx, wrapy, x, y);
    }

    private float getMapComponent(int component, int which, boolean wrapx, boolean wrapy, double x, double y) {
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[][] map = this.maps[which];
        float frac1 = (float)(x * this.xscale[which]);
        int i1 = (int)frac1;
        frac1 -= (float)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        float frac2 = (float)(y * this.yscale[which]);
        int j1 = (int)frac2;
        frac2 -= (float)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        float w1 = (1.0f - frac1) * (1.0f - frac2);
        float w2 = (1.0f - frac1) * frac2;
        float w3 = frac1 * (1.0f - frac2);
        float w4 = frac1 * frac2;
        float value1 = (float)(map[component][ind1] & 0xFF) * EXP_SCALE[map[3][ind1] & 0xFF];
        float value2 = (float)(map[component][ind2] & 0xFF) * EXP_SCALE[map[3][ind2] & 0xFF];
        float value3 = (float)(map[component][ind3] & 0xFF) * EXP_SCALE[map[3][ind3] & 0xFF];
        float value4 = (float)(map[component][ind4] & 0xFF) * EXP_SCALE[map[3][ind4] & 0xFF];
        return value1 * w1 + value2 * w2 + value3 * w3 + value4 * w4;
    }

    public float getAverageComponent(int component) {
        if (component >= 3) {
            return 0.0f;
        }
        return this.average[component];
    }

    public void getColor(RGBColor theColor, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            this.getMapColor(theColor, 0, wrapx, wrapy, x, y);
            return;
        }
        if (size >= this.scale[this.maps.length - 1]) {
            this.getMapColor(theColor, this.maps.length - 1, wrapx, wrapy, x, y);
            return;
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        float frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        this.getMapColor(this.tempColor, which, wrapx, wrapy, x, y);
        this.getMapColor(theColor, which + 1, wrapx, wrapy, x, y);
        this.tempColor.scale(1.0f - frac);
        theColor.scale(frac);
        theColor.add(this.tempColor);
    }

    private void getMapColor(RGBColor theColor, int which, boolean wrapx, boolean wrapy, double x, double y) {
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[][] map = this.maps[which];
        float frac1 = (float)(x * this.xscale[which]);
        int i1 = (int)frac1;
        frac1 -= (float)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        float frac2 = (float)(y * this.yscale[which]);
        int j1 = (int)frac2;
        frac2 -= (float)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        float w1 = (1.0f - frac1) * (1.0f - frac2);
        float w2 = (1.0f - frac1) * frac2;
        float w3 = frac1 * (1.0f - frac2);
        float w4 = frac1 * frac2;
        HDRImage.calcPixelColor(theColor, map[0][ind1], map[1][ind1], map[2][ind1], map[3][ind1]);
        theColor.scale(w1);
        HDRImage.calcPixelColor(this.tempColor2, map[0][ind2], map[1][ind2], map[2][ind2], map[3][ind2]);
        this.tempColor2.scale(w2);
        theColor.add(this.tempColor2);
        HDRImage.calcPixelColor(this.tempColor2, map[0][ind3], map[1][ind3], map[2][ind3], map[3][ind3]);
        this.tempColor2.scale(w3);
        theColor.add(this.tempColor2);
        HDRImage.calcPixelColor(this.tempColor2, map[0][ind4], map[1][ind4], map[2][ind4], map[3][ind4]);
        this.tempColor2.scale(w4);
        theColor.add(this.tempColor2);
    }

    public void getGradient(Vec2 grad, int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            this.getMapGradient(grad, component, 0, wrapx, wrapy, x, y);
            return;
        }
        if (size >= this.scale[this.maps.length - 1]) {
            grad.set(0.0, 0.0);
            return;
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        double frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        this.getMapGradient(grad, component, which, wrapx, wrapy, x, y);
        this.getMapGradient(this.tempVec, component, which + 1, wrapx, wrapy, x, y);
        grad.scale(1.0 - frac);
        this.tempVec.scale(frac);
        grad.add(this.tempVec);
        grad.y = -grad.y;
    }

    private void getMapGradient(Vec2 grad, int component, int which, boolean wrapx, boolean wrapy, double x, double y) {
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[][] map = this.maps[which];
        double frac1 = x * this.xscale[which];
        int i1 = (int)frac1;
        frac1 -= (double)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        double frac2 = y * this.yscale[which];
        int j1 = (int)frac2;
        frac2 -= (double)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        double v1 = (float)(map[component][ind1] & 0xFF) * EXP_SCALE[map[3][ind1] & 0xFF];
        double v2 = (float)(map[component][ind2] & 0xFF) * EXP_SCALE[map[3][ind2] & 0xFF];
        double v3 = (float)(map[component][ind3] & 0xFF) * EXP_SCALE[map[3][ind3] & 0xFF];
        double v4 = (float)(map[component][ind4] & 0xFF) * EXP_SCALE[map[3][ind4] & 0xFF];
        grad.x = ((v3 - v1) * (1.0 - frac2) + (v4 - v2) * frac2) * this.xscale[which];
        grad.y = ((v2 - v1) * (1.0 - frac1) + (v4 - v3) * frac1) * this.yscale[which];
    }

    public Image getPreview() {
        return this.preview;
    }

    public HDRImage(DataInputStream in) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("Illegal version for HDRImage");
        }
        int w = in.readInt();
        int h = in.readInt();
        byte[][] map = new byte[4][];
        int i = 0;
        while (i < 4) {
            map[i] = new byte[w * h];
            in.readFully(map[i]);
            ++i;
        }
        this.tempColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempColor2 = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempVec = new Vec2(0.0, 0.0);
        this.buildMipMaps(map[0], map[1], map[2], map[3], w, h);
        this.findAverage();
        this.createPreview();
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeInt(this.width[0]);
        out.writeInt(this.height[0]);
        int i = 0;
        while (i < 4) {
            out.write(this.maps[0][i]);
            ++i;
        }
    }

    public static void calcPixelColor(RGBColor color, byte r, byte g, byte b, byte e) {
        float scale = EXP_SCALE[e & 0xFF];
        color.setRGB((float)(r & 0xFF) * scale, (float)(g & 0xFF) * scale, (float)(b & 0xFF) * scale);
    }

    public static void calcRGBE(RGBColor color, byte[] rgbe) {
        float red = color.getRed();
        float green = color.getGreen();
        float blue = color.getBlue();
        float max = red;
        if (green > max) {
            max = green;
        }
        if (blue > max) {
            max = blue;
        }
        if (max * 0.003921569f < EXP_SCALE[0]) {
            rgbe[0] = 0;
            rgbe[1] = 0;
            rgbe[2] = 0;
            rgbe[3] = 0;
            return;
        }
        int e = 128 + (int)Math.ceil(Math.log(max) * (double)INVLOG2);
        rgbe[3] = (byte)e;
        float scale = 1.0f / EXP_SCALE[e];
        rgbe[0] = (byte)(red * scale);
        rgbe[1] = (byte)(green * scale);
        rgbe[2] = (byte)(blue * scale);
    }

    static {
        int i = 0;
        while (i < 256) {
            HDRImage.EXP_SCALE[i] = (float)(0.003921568859368563 * Math.pow(2.0, i - 128));
            ++i;
        }
    }
}

