/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.image.HDRDecoder;
import artofillusion.image.MIPMappedImage;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import java.awt.Image;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public abstract class ImageMap {
    private int id = nextID++;
    public static final int PREVIEW_WIDTH = 50;
    public static final int PREVIEW_HEIGHT = 50;
    private static int nextID;

    public static ImageMap loadImage(File file) throws Exception {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".hdr") || name.endsWith(".pic")) {
            try {
                return HDRDecoder.createImage(file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new MIPMappedImage(file);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getComponents();

    public abstract float getComponent(int var1, boolean var2, boolean var3, double var4, double var6, double var8, double var10);

    public abstract float getAverageComponent(int var1);

    public abstract void getColor(RGBColor var1, boolean var2, boolean var3, double var4, double var6, double var8, double var10);

    public abstract void getGradient(Vec2 var1, int var2, boolean var3, boolean var4, double var5, double var7, double var9, double var11);

    public abstract Image getPreview();

    public int getID() {
        return this.id;
    }

    public abstract void writeToStream(DataOutputStream var1) throws IOException;
}

