/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.ModellingApp;
import artofillusion.image.BMPEncoder;
import artofillusion.image.ComplexImage;
import artofillusion.image.HDREncoder;
import artofillusion.image.MovieEncoder;
import artofillusion.image.TIFFEncoder;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ValueSlider;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import jpegencoder.JpegEncoder;

public class ImageSaver {
    private int format;
    private int index;
    private String name;
    private String directory;
    private boolean ok;
    private boolean premultiply;
    private double quality;
    private Frame parent;
    private MovieEncoder movie;
    public static final int FORMAT_JPEG = 0;
    public static final int FORMAT_TIFF = 1;
    public static final int FORMAT_MOVIE = 2;
    public static final int FORMAT_BMP = 3;
    public static final int FORMAT_HDR = 4;
    private static boolean premultiplyDefault = true;
    private static double qualityDefault = 50.0;

    public ImageSaver(Frame parent) {
        this.init(parent, false);
    }

    public ImageSaver(Frame parent, int width, int height, int fps) {
        this.init(parent, true);
        if (this.format == 2 && this.clickedOk()) {
            this.movie = new MovieEncoder(width, height, fps, this.directory + this.name);
            this.movie.doIt();
        }
    }

    private void init(Frame parent, boolean animate) {
        this.parent = parent;
        this.index = animate ? 1 : -1;
        CheckboxGroup formatGroup = new CheckboxGroup();
        final Checkbox jpegBox = new Checkbox("JPEG", true, formatGroup);
        final Checkbox tiffBox = new Checkbox("TIFF", false, formatGroup);
        Checkbox bmpBox = new Checkbox("BMP", false, formatGroup);
        Checkbox hdrBox = new Checkbox("HDR", false, formatGroup);
        final Checkbox quickBox = new Checkbox("Quicktime", false);
        if (this.gotJMF() && animate) {
            quickBox.setCheckboxGroup(formatGroup);
        }
        Checkbox premultBox = new Checkbox("Premultiply Transparency", premultiplyDefault);
        ValueSlider qualitySlider = new ValueSlider(0.0, 100.0, 100, qualityDefault);
        final CardLayout card = new CardLayout();
        Panel mainPanel = new Panel();
        Panel formatsPanel = new Panel();
        final Panel optionsPanel = new Panel();
        Panel p = new Panel();
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (jpegBox.getState() || quickBox.getState()) {
                    card.show(optionsPanel, "jpeg");
                } else if (tiffBox.getState()) {
                    card.show(optionsPanel, "tiff");
                } else {
                    card.show(optionsPanel, "nooption");
                }
            }
        };
        GridBagConstraints gc = new GridBagConstraints();
        mainPanel.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.insets.bottom = 5;
        formatsPanel.setLayout(new GridLayout(0, 1));
        mainPanel.add((Component)formatsPanel, gc);
        formatsPanel.add((Component)jpegBox, gc);
        formatsPanel.add((Component)tiffBox, gc);
        formatsPanel.add((Component)bmpBox, gc);
        formatsPanel.add((Component)hdrBox, gc);
        if (quickBox.getCheckboxGroup() != null) {
            formatsPanel.add((Component)quickBox, gc);
        }
        mainPanel.add((Component)optionsPanel, gc);
        optionsPanel.setLayout(card);
        p.setLayout(new GridBagLayout());
        p.add((Component)new Label("Quality"), gc);
        gc.gridx = 1;
        p.add((Component)qualitySlider, gc);
        optionsPanel.add((Component)p, "jpeg");
        optionsPanel.add((Component)premultBox, "tiff");
        optionsPanel.add((Component)new Panel(), "nooption");
        premultBox.setEnabled(true);
        jpegBox.addItemListener(il);
        tiffBox.addItemListener(il);
        bmpBox.addItemListener(il);
        hdrBox.addItemListener(il);
        if (quickBox.getCheckboxGroup() != null) {
            quickBox.addItemListener(il);
        }
        il.itemStateChanged(null);
        PanelDialog dlg = new PanelDialog((Window)parent, "Select Format For Output File:", mainPanel);
        if (dlg.clickedOk()) {
            this.premultiply = premultiplyDefault = premultBox.getState();
            this.quality = qualityDefault = qualitySlider.getValue();
            if (jpegBox.getState()) {
                this.format = 0;
            } else if (quickBox.getState()) {
                this.format = 2;
            } else if (bmpBox.getState()) {
                this.format = 3;
            } else if (tiffBox.getState()) {
                this.format = 1;
            } else if (hdrBox.getState()) {
                this.format = 4;
            }
            FileDialog fd = new FileDialog(parent, "Save Image", 1);
            String sep = System.getProperty("file.separator");
            if (jpegBox.getState()) {
                fd.setFile("Untitled.jpg");
            } else if (quickBox.getState()) {
                fd.setFile("Untitled.mov");
            } else if (bmpBox.getState()) {
                fd.setFile("Untitled.bmp");
            } else if (tiffBox.getState()) {
                fd.setFile("Untitled.tif");
            } else if (hdrBox.getState()) {
                fd.setFile("Untitled.hdr");
            }
            if (ModellingApp.currentDirectory != null) {
                fd.setDirectory(ModellingApp.currentDirectory);
            }
            fd.show();
            this.name = fd.getFile();
            this.directory = fd.getDirectory();
            this.ok = this.name != null;
        }
    }

    private boolean gotJMF() {
        try {
            Class<?> c = Class.forName("javax.media.protocol.DataSource");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public boolean saveImage(Image im) {
        return this.saveImage(new ComplexImage(im));
    }

    public boolean saveImage(ComplexImage img) {
        String filename = this.name;
        if (this.movie != null) {
            Image im = img.getImage();
            im = ImageSaver.premultiplyTransparency(im);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            JpegEncoder jpg = new JpegEncoder(im, (int)this.quality, bos);
            jpg.Compress();
            this.movie.pushBytes(baos.toByteArray());
            try {
                bos.close();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
            return true;
        }
        if (this.index > 0) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(4);
            nf.setGroupingUsed(false);
            int i = this.name.lastIndexOf(46);
            filename = i == -1 || i == this.name.length() - 1 ? filename + nf.format(this.index++) : this.name.substring(0, i) + nf.format(this.index++) + this.name.substring(i);
        }
        try {
            if (this.format == 1 && this.premultiply) {
                img = new ComplexImage(ImageSaver.premultiplyTransparency(img.getImage()));
            }
            return ImageSaver.saveImage(img, new File(this.directory, filename), this.format, (int)this.quality);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new MessageDialog((Window)this.parent, new String[]{"An error occurred while saving the image.", ex.getMessage()});
            return false;
        }
    }

    public static boolean saveImage(Image im, File f, int format, int quality) throws IOException, InterruptedException {
        return ImageSaver.saveImage(new ComplexImage(im), f, format, quality);
    }

    public static boolean saveImage(ComplexImage img, File f, int format, int quality) throws IOException, InterruptedException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
        Image im = img.getImage();
        if (format == 0) {
            im = ImageSaver.premultiplyTransparency(im);
            JpegEncoder jpg = new JpegEncoder(im, quality, bos);
            jpg.Compress();
            bos.close();
            return true;
        }
        if (format == 1) {
            DataOutputStream dos = new DataOutputStream(bos);
            TIFFEncoder tiff = new TIFFEncoder(im);
            tiff.writeImage(dos);
            dos.close();
            return true;
        }
        if (format == 3) {
            im = ImageSaver.premultiplyTransparency(im);
            DataOutputStream dos = new DataOutputStream(bos);
            BMPEncoder bmp = new BMPEncoder(im);
            bmp.writeImage(dos);
            dos.close();
            return true;
        }
        if (format == 4) {
            HDREncoder.writeImage(img, bos);
            bos.close();
            return true;
        }
        bos.close();
        return false;
    }

    public void lastMovieImage() {
        if (this.movie != null) {
            this.movie.signalDone();
            this.movie = null;
        }
    }

    private static Image premultiplyTransparency(Image im) {
        int[] data;
        try {
            PixelGrabber pg = new PixelGrabber(im, 0, 0, -1, -1, true);
            pg.grabPixels();
            data = (int[])pg.getPixels();
        }
        catch (InterruptedException ex) {
            return im;
        }
        int i = 0;
        while (i < data.length && (data[i] & 0xFF000000) == -16777216) {
            ++i;
        }
        if (i == data.length) {
            return im;
        }
        i = 0;
        while (i < data.length) {
            int alpha = data[i] >> 24 & 0xFF;
            int red = data[i] >> 16 & 0xFF;
            int green = data[i] >> 8 & 0xFF;
            int blue = data[i] & 0xFF;
            red = red * (alpha + 1) >> 8;
            green = green * (alpha + 1) >> 8;
            blue = blue * (alpha + 1) >> 8;
            data[i] = (alpha << 24) + (red << 16) + (green << 8) + blue;
            ++i;
        }
        MemoryImageSource source = new MemoryImageSource(im.getWidth(null), im.getHeight(null), data, 0, im.getWidth(null));
        return Toolkit.getDefaultToolkit().createImage(source);
    }
}

