/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.ModellingApp;
import artofillusion.image.ImageMap;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;

public class MIPMappedImage
extends ImageMap {
    private int[] width;
    private int[] height;
    private int components;
    private byte[][][] maps;
    private float[] average;
    private double[] xscale;
    private double[] yscale;
    private double[] scale;
    private double[] scaleMult;
    private double[] gradXScale;
    private double[] gradYScale;
    private Image preview;
    private RGBColor tempColor;
    private Vec2 tempVec;
    private static final float SCALE = 0.003921569f;

    public MIPMappedImage(File file) throws InterruptedException {
        Image im = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        MediaTracker mt = new MediaTracker((Component)((Object)ModellingApp.getWindows()[0]));
        mt.addImage(im, 0);
        this.maps = new byte[1][][];
        mt.waitForID(0);
        this.buildMipMaps(im);
        this.preview = this.width[0] <= 50 && this.height[0] <= 50 ? im : (this.width[0] < this.height[0] ? im.getScaledInstance(-1, 50, 1) : im.getScaledInstance(50, -1, 1));
        this.findAverage();
        this.tempColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempVec = new Vec2(0.0, 0.0);
    }

    private void buildMipMaps(Image im) throws InterruptedException {
        byte[][] map0 = this.findComponentMaps(im);
        int w = im.getWidth(null);
        int h = im.getHeight(null);
        int w1 = 2;
        while (w1 < w) {
            w1 *= 2;
        }
        int h1 = 2;
        while (h1 < h) {
            h1 *= 2;
        }
        float wratio = (float)(w1 /= 2) / (float)w;
        float hratio = (float)(h1 /= 2) / (float)h;
        if (w > 1 && (double)wratio > 0.75) {
            w1 /= 2;
            wratio = (float)((double)wratio * 0.5);
        }
        if (h > 1 && (double)hratio > 0.75) {
            h1 /= 2;
            hratio = (float)((double)hratio * 0.5);
        }
        int num = 0;
        while (1 << num < w1 && 1 << num < h1) {
            ++num;
        }
        num += 2;
        if (w == 1 || h == 1) {
            num = 1;
        }
        this.maps = new byte[num][][];
        this.width = new int[num];
        this.height = new int[num];
        this.scale = new double[num];
        this.xscale = new double[num];
        this.yscale = new double[num];
        this.gradXScale = new double[num];
        this.gradYScale = new double[num];
        this.scaleMult = new double[num - 1];
        this.maps[0] = map0;
        this.width[0] = w;
        this.height[0] = h;
        this.scale[0] = 1.0 / (double)Math.min(w, h);
        if (num > 1) {
            this.width[1] = w1;
            this.height[1] = h1;
            this.scale[1] = 1.0 / (double)Math.min(w1, h1);
            Image im1 = im.getScaledInstance(w1, h1, 1);
            this.maps[1] = this.findComponentMaps(im1);
        }
        int i = 2;
        while (i < num) {
            w = this.width[i] = this.width[i - 1] / 2;
            h = this.height[i] = this.height[i - 1] / 2;
            this.scale[i] = 2.0 * this.scale[i - 1];
            this.maps[i] = new byte[this.components][w * h];
            int j = 0;
            while (j < this.components) {
                int k = 0;
                while (k < w) {
                    int m = 0;
                    while (m < h) {
                        this.maps[i][j][k + w * m] = (byte)((this.maps[i - 1][j][2 * k + 4 * w * m] & 0xFF) + (this.maps[i - 1][j][2 * k + 1 + 4 * w * m] & 0xFF) + (this.maps[i - 1][j][2 * k + 2 * w * (2 * m + 1)] & 0xFF) + (this.maps[i - 1][j][2 * k + 1 + 2 * w * (2 * m + 1)] & 0xFF) >> 2);
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < num - 1) {
            this.scaleMult[i] = 1.0 / (this.scale[i + 1] - this.scale[i]);
            ++i;
        }
        i = 0;
        while (i < num) {
            this.xscale[i] = this.width[i];
            this.yscale[i] = this.height[i];
            this.gradXScale[i] = 0.003921568859368563 * this.xscale[i];
            this.gradYScale[i] = 0.003921568859368563 * this.yscale[i];
            ++i;
        }
    }

    private byte[][] findComponentMaps(Image im) throws InterruptedException {
        PixelGrabber pg = new PixelGrabber(im, 0, 0, -1, -1, true);
        pg.grabPixels();
        int[] data = (int[])pg.getPixels();
        if (this.components == 0) {
            this.countComponents(data);
        }
        byte[][] map = new byte[this.components][data.length];
        int i = 0;
        while (i < data.length) {
            map[0][i] = (byte)(data[i] >> 16 & 0xFF);
            if (this.components > 1) {
                map[1][i] = (byte)(data[i] >> 8 & 0xFF);
            }
            if (this.components > 2) {
                map[2][i] = (byte)(data[i] & 0xFF);
            }
            if (this.components > 3) {
                map[3][i] = (byte)(data[i] >> 24 & 0xFF);
            }
            ++i;
        }
        return map;
    }

    private void countComponents(int[] data) {
        int i = 0;
        while (i < data.length) {
            int j = data[i];
            if ((j & 0xFF000000) != -16777216) {
                this.components = 4;
                return;
            }
            int k = j & 0xFF;
            if ((j >> 8 & 0xFF) != k || (j >> 16 & 0xFF) != k) {
                this.components = 3;
                return;
            }
            ++i;
        }
        this.components = 1;
    }

    private void findAverage() {
        byte[][] map = this.maps[this.maps.length - 1];
        long[] av = new long[this.components];
        int len = map[0].length;
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < this.components) {
                int n = j;
                av[n] = av[n] + (long)(map[j][i] & 0xFF);
                ++j;
            }
            ++i;
        }
        this.average = new float[this.components];
        i = 0;
        while (i < this.components) {
            this.average[i] = (float)(av[i] / (long)len) * 0.003921569f;
            ++i;
        }
    }

    public int getWidth() {
        return this.width[0];
    }

    public int getHeight() {
        return this.height[0];
    }

    public int getComponents() {
        return this.components;
    }

    public float getComponent(int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            return this.getMapComponent(component, 0, wrapx, wrapy, x, y);
        }
        if (size >= this.scale[this.maps.length - 1]) {
            return (float)this.maps[this.maps.length - 1][component][0] * 0.003921569f;
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        float frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        return (1.0f - frac) * this.getMapComponent(component, which, wrapx, wrapy, x, y) + frac * this.getMapComponent(component, which + 1, wrapx, wrapy, x, y);
    }

    private float getMapComponent(int component, int which, boolean wrapx, boolean wrapy, double x, double y) {
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[] map = this.maps[which][component];
        float frac1 = (float)(x * this.xscale[which]);
        int i1 = (int)frac1;
        frac1 -= (float)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        float frac2 = (float)(y * this.yscale[which]);
        int j1 = (int)frac2;
        frac2 -= (float)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        float w1 = (1.0f - frac1) * (1.0f - frac2);
        float w2 = (1.0f - frac1) * frac2;
        float w3 = frac1 * (1.0f - frac2);
        float w4 = frac1 * frac2;
        return ((float)(map[ind1] & 0xFF) * w1 + (float)(map[ind2] & 0xFF) * w2 + (float)(map[ind3] & 0xFF) * w3 + (float)(map[ind4] & 0xFF) * w4) * 0.003921569f;
    }

    public float getAverageComponent(int component) {
        if (component >= this.components) {
            return 0.0f;
        }
        return this.average[component];
    }

    public void getColor(RGBColor theColor, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            this.getMapColor(theColor, 0, wrapx, wrapy, x, y);
            return;
        }
        if (size >= this.scale[this.maps.length - 1]) {
            this.getMapColor(theColor, this.maps.length - 1, wrapx, wrapy, x, y);
            return;
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        float frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        this.getMapColor(this.tempColor, which, wrapx, wrapy, x, y);
        this.getMapColor(theColor, which + 1, wrapx, wrapy, x, y);
        this.tempColor.scale(1.0f - frac);
        theColor.scale(frac);
        theColor.add(this.tempColor);
    }

    private void getMapColor(RGBColor theColor, int which, boolean wrapx, boolean wrapy, double x, double y) {
        float green;
        float blue;
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[][] map = this.maps[which];
        float frac1 = (float)(x * this.xscale[which]);
        int i1 = (int)frac1;
        frac1 -= (float)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        float frac2 = (float)(y * this.yscale[which]);
        int j1 = (int)frac2;
        frac2 -= (float)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        float w1 = (1.0f - frac1) * (1.0f - frac2);
        float w2 = (1.0f - frac1) * frac2;
        float w3 = frac1 * (1.0f - frac2);
        float w4 = frac1 * frac2;
        float red = ((float)(map[0][ind1] & 0xFF) * w1 + (float)(map[0][ind2] & 0xFF) * w2 + (float)(map[0][ind3] & 0xFF) * w3 + (float)(map[0][ind4] & 0xFF) * w4) * 0.003921569f;
        if (this.components == 1) {
            green = blue = red;
        } else {
            green = ((float)(map[1][ind1] & 0xFF) * w1 + (float)(map[1][ind2] & 0xFF) * w2 + (float)(map[1][ind3] & 0xFF) * w3 + (float)(map[1][ind4] & 0xFF) * w4) * 0.003921569f;
            blue = ((float)(map[2][ind1] & 0xFF) * w1 + (float)(map[2][ind2] & 0xFF) * w2 + (float)(map[2][ind3] & 0xFF) * w3 + (float)(map[2][ind4] & 0xFF) * w4) * 0.003921569f;
        }
        theColor.setRGB(red, green, blue);
    }

    public void getGradient(Vec2 grad, int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            this.getMapGradient(grad, component, 0, wrapx, wrapy, x, y);
            return;
        }
        if (size >= this.scale[this.maps.length - 1]) {
            grad.set(0.0, 0.0);
            return;
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        double frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        this.getMapGradient(grad, component, which, wrapx, wrapy, x, y);
        this.getMapGradient(this.tempVec, component, which + 1, wrapx, wrapy, x, y);
        grad.scale(1.0 - frac);
        this.tempVec.scale(frac);
        grad.add(this.tempVec);
        grad.y = -grad.y;
    }

    private void getMapGradient(Vec2 grad, int component, int which, boolean wrapx, boolean wrapy, double x, double y) {
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[] map = this.maps[which][component];
        double frac1 = x * this.xscale[which];
        int i1 = (int)frac1;
        frac1 -= (double)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        double frac2 = y * this.yscale[which];
        int j1 = (int)frac2;
        frac2 -= (double)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        double v1 = map[ind1] & 0xFF;
        double v2 = map[ind2] & 0xFF;
        double v3 = map[ind3] & 0xFF;
        double v4 = map[ind4] & 0xFF;
        grad.x = ((v3 - v1) * (1.0 - frac2) + (v4 - v2) * frac2) * this.gradXScale[which];
        grad.y = ((v2 - v1) * (1.0 - frac1) + (v4 - v3) * frac1) * this.gradYScale[which];
    }

    public Image getPreview() {
        return this.preview;
    }

    public MIPMappedImage(DataInputStream in) throws IOException, InvalidObjectException {
        this(in, in.readShort());
    }

    public MIPMappedImage(DataInputStream in, short version) throws IOException, InvalidObjectException {
        if (version != 0) {
            throw new InvalidObjectException("Illegal version for MIPMappedImage");
        }
        int w = in.readInt();
        int h = in.readInt();
        this.components = in.readInt();
        byte[][] map = new byte[this.components][];
        int i = 0;
        while (i < this.components) {
            map[i] = new byte[w * h];
            in.readFully(map[i]);
            ++i;
        }
        int[] data = new int[w * h];
        if (this.components == 1) {
            i = 0;
            while (i < data.length) {
                data[i] = -16777216 + (map[0][i] << 16 & 0xFF0000) + (map[0][i] << 8 & 0xFF00) + (map[0][i] & 0xFF);
                ++i;
            }
        } else if (this.components == 3) {
            i = 0;
            while (i < data.length) {
                data[i] = -16777216 + (map[0][i] << 16 & 0xFF0000) + (map[1][i] << 8 & 0xFF00) + (map[2][i] & 0xFF);
                ++i;
            }
        } else {
            i = 0;
            while (i < data.length) {
                data[i] = (map[3][i] << 24 & 0xFF000000) + (map[0][i] << 16 & 0xFF0000) + (map[1][i] << 8 & 0xFF00) + (map[2][i] & 0xFF);
                ++i;
            }
        }
        MemoryImageSource src = new MemoryImageSource(w, h, data, 0, w);
        Image im = Toolkit.getDefaultToolkit().createImage(src);
        try {
            Frame fr = new Frame();
            this.buildMipMaps(im);
            fr.dispose();
        }
        catch (InterruptedException ex) {
            throw new IOException();
        }
        this.preview = w <= 50 && h <= 50 ? im : (w < h ? im.getScaledInstance(-1, 50, 1) : im.getScaledInstance(50, -1, 1));
        this.findAverage();
        this.tempColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempVec = new Vec2(0.0, 0.0);
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeInt(this.width[0]);
        out.writeInt(this.height[0]);
        out.writeInt(this.components);
        int i = 0;
        while (i < this.components) {
            out.write(this.maps[0][i]);
            ++i;
        }
    }
}

