/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;

public class MovieEncoder
implements ControllerListener,
DataSinkListener {
    public Processor p;
    public DataSink dsink;
    public ImageDataSource ids;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public void pushBytes(byte[] b) {
        this.ids.streams[0].putImageToCache(b);
    }

    public void signalDone() {
        this.ids.streams[0].signalDone();
        this.waitForFileDone();
        this.cleanUp();
    }

    public MovieEncoder(int width, int height, int frameRate, String url) {
        try {
            File file = new File(url);
            MediaLocator outML = new MediaLocator(file.toURL());
            this.ids = new ImageDataSource(width, height, frameRate);
            System.err.println("- create processor for the image datasource ..." + url);
            this.p = Manager.createProcessor((DataSource)this.ids);
            this.p.addControllerListener((ControllerListener)this);
            this.p.configure();
            if (!this.waitForState(this.p, 180)) {
                // empty if block
            }
            this.p.setContentDescriptor(new ContentDescriptor("video.quicktime"));
            TrackControl[] tcs = this.p.getTrackControls();
            Format[] f = tcs[0].getSupportedFormats();
            if (f == null || f.length <= 0) {
                throw new RuntimeException("The mux does not support the input format: " + tcs[0].getFormat());
            }
            tcs[0].setFormat(f[0]);
            System.err.println("Setting the track format to: " + f[0]);
            this.p.realize();
            if (!this.waitForState(this.p, 300)) {
                throw new RuntimeException("Failed to realize the processor.");
            }
            this.dsink = this.createDataSink(this.p, outML);
            if (this.dsink == null) {
                throw new RuntimeException("Failed to create a DataSink for the given output MediaLocator: " + outML);
            }
            this.dsink.addDataSinkListener((DataSinkListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean doIt() {
        try {
            this.p.start();
            this.dsink.start();
        }
        catch (IOException e) {
            System.err.println("IO error during processing");
            return false;
        }
        return true;
    }

    public void cleanUp() {
        System.err.println("Closing DataSink...");
        try {
            this.dsink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.p.removeControllerListener((ControllerListener)this);
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            System.err.println("Something is really wrong: the processor does not have an output DataSource");
            return null;
        }
        try {
            System.err.println("- create DataSink for: " + outML.getURL() + " " + outML.getProtocol());
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
            dsink.open();
        }
        catch (Exception e) {
            System.err.println("Cannot create the DataSink: ");
            e.printStackTrace();
            return null;
        }
        return dsink;
    }

    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
        }
    }

    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    class ImageSourceStream
    implements PullBufferStream {
        Vector cache = new Vector();
        int width;
        int height;
        VideoFormat format;
        Object waitLock = new Object();
        int nextImage = 0;
        boolean ended = false;
        boolean blocking = false;

        public ImageSourceStream(int width, int height, int frameRate) {
            this.width = width;
            this.height = height;
            this.format = new VideoFormat("jpeg", new Dimension(width, height), -1, Format.byteArray, (float)frameRate);
        }

        public boolean willReadBlock() {
            return this.blocking;
        }

        public void signalDone() {
            this.ended = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notifyAll();
            }
        }

        public void putImageToCache(byte[] image) {
            boolean wasEmpty = this.cache.isEmpty();
            this.cache.add(image);
            if (wasEmpty) {
                Object object = this.waitLock;
                synchronized (object) {
                    this.waitLock.notify();
                }
            }
        }

        private byte[] getImageFromCache() {
            if (this.cache.isEmpty() && !this.ended) {
                Object object = this.waitLock;
                synchronized (object) {
                    this.blocking = true;
                    try {
                        this.waitLock.wait();
                        if (this.ended || this.cache.isEmpty()) {
                            byte[] byArray = null;
                            return byArray;
                        }
                    }
                    catch (InterruptedException rupt) {
                        rupt.printStackTrace();
                    }
                }
                this.blocking = false;
            } else if (this.ended) {
                return null;
            }
            return (byte[])this.cache.remove(0);
        }

        public void read(Buffer buf) throws IOException {
            byte[] image = this.getImageFromCache();
            if (image == null) {
                System.err.println("Done reading all images.");
                buf.setEOM(true);
                buf.setOffset(0);
                buf.setLength(0);
                return;
            }
            buf.setData((Object)image);
            buf.setOffset(0);
            buf.setLength(image.length);
            buf.setFormat((Format)this.format);
            buf.setFlags(buf.getFlags() | 0x10);
        }

        public Format getFormat() {
            return this.format;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public long getContentLength() {
            return 0L;
        }

        public boolean endOfStream() {
            return this.ended;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }

    public class ImageDataSource
    extends PullBufferDataSource {
        protected ImageSourceStream[] streams = new ImageSourceStream[1];

        ImageDataSource(int width, int height, int frameRate) {
            this.streams[0] = new ImageSourceStream(width, height, frameRate);
        }

        public void setLocator(MediaLocator source) {
        }

        public MediaLocator getLocator() {
            return null;
        }

        public String getContentType() {
            return "raw";
        }

        public void connect() {
        }

        public void disconnect() {
        }

        public void start() {
        }

        public void stop() {
        }

        public PullBufferStream[] getStreams() {
            return this.streams;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }
}

