/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.material.Material;
import artofillusion.material.Material3D;
import artofillusion.material.MaterialSpec;
import artofillusion.math.RGBColor;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.FloatingDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProceduralMaterial3D
extends Material3D
implements ProcedureOwner {
    Procedure proc;
    boolean shadows;
    double stepSize;
    double antialiasing;
    PointInfo info;

    public ProceduralMaterial3D() {
        this.proc = new Procedure(new OutputModule[]{new OutputModule(Translate.text("MaterialColor"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Transparency"), Translate.text("gray"), 0.0, new RGBColor(0.5f, 0.5f, 0.5f), 1), new OutputModule(Translate.text("Density"), "0.5", 0.5, null, 0), new OutputModule(Translate.text("Scattering"), "0", 0.0, null, 0), new OutputModule(Translate.text("ScatteringColor"), Translate.text("gray"), 0.0, new RGBColor(0.5f, 0.5f, 0.5f), 1), new OutputModule(Translate.text("Eccentricity"), "0", 0.0, null, 0)});
        this.shadows = true;
        this.stepSize = 0.1;
        this.antialiasing = 1.0;
        this.info = new PointInfo();
    }

    public static String getTypeName() {
        return "Procedural";
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double step) {
        this.stepSize = step;
    }

    public void getMaterialSpec(MaterialSpec spec, double x, double y, double z, double xsize, double ysize, double zsize, double t) {
        OutputModule[] output = this.proc.getOutputModules();
        this.info.x = x;
        this.info.y = y;
        this.info.z = z;
        this.info.xsize = xsize * this.stepSize;
        this.info.ysize = ysize * this.stepSize;
        this.info.zsize = zsize * this.stepSize;
        this.info.t = t;
        this.info.param = null;
        this.proc.initForPoint(this.info);
        double density = output[2].getAverageValue(0, 0.0);
        double eccentricity = output[5].getAverageValue(0, 0.0);
        if (density < 0.0) {
            density = 0.0;
        }
        if (density > 1.0) {
            density = 1.0;
        }
        if (eccentricity < -1.0) {
            eccentricity = -1.0;
        }
        if (eccentricity > 1.0) {
            eccentricity = 1.0;
        }
        spec.eccentricity = eccentricity;
        output[0].getColor(0, spec.color, 0.0);
        if (density == 0.0) {
            spec.transparency.setRGB(1.0f, 1.0f, 1.0f);
            spec.scattering.setRGB(0.0f, 0.0f, 0.0f);
            return;
        }
        double scattering = output[3].getAverageValue(0, 0.0);
        if (scattering < 0.0) {
            scattering = 0.0;
        }
        if (scattering > 1.0) {
            scattering = 1.0;
        }
        output[1].getColor(0, spec.transparency, 0.0);
        spec.transparency.setRGB((float)Math.pow(spec.transparency.getRed(), density), (float)Math.pow(spec.transparency.getGreen(), density), (float)Math.pow(spec.transparency.getBlue(), density));
        output[4].getColor(0, spec.scattering, 0.0);
        spec.scattering.scale(density * scattering);
    }

    public boolean usesImage(ImageMap image) {
        Module[] modules = this.proc.getModules();
        int i = 0;
        while (i < modules.length) {
            if (modules[i] instanceof ImageModule && ((ImageModule)modules[i]).getMap() == image) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isScattering() {
        OutputModule[] output = this.proc.getOutputModules();
        return output[3].inputConnected(0);
    }

    public boolean castsShadows() {
        return this.shadows;
    }

    public Material duplicate() {
        ProceduralMaterial3D mat = new ProceduralMaterial3D();
        mat.proc.copy(this.proc);
        mat.setName(this.getName());
        mat.setIndexOfRefraction(this.indexOfRefraction());
        mat.shadows = this.shadows;
        mat.antialiasing = this.antialiasing;
        mat.stepSize = this.stepSize;
        return mat;
    }

    public void edit(Frame fr, Scene sc) {
        new ProcedureEditor(this.proc, this, sc);
    }

    public ProceduralMaterial3D(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setName(in.readUTF());
        this.proc = new Procedure(new OutputModule[]{new OutputModule(Translate.text("MaterialColor"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Transparency"), Translate.text("gray"), 0.0, new RGBColor(0.5f, 0.5f, 0.5f), 1), new OutputModule(Translate.text("Density"), "0.5", 0.5, null, 0), new OutputModule(Translate.text("Scattering"), "0", 0.0, null, 0), new OutputModule(Translate.text("ScatteringColor"), Translate.text("gray"), 0.0, new RGBColor(0.5f, 0.5f, 0.5f), 1), new OutputModule(Translate.text("Eccentricity"), "0", 0.0, null, 0)});
        this.setIndexOfRefraction(in.readDouble());
        this.shadows = in.readBoolean();
        this.antialiasing = in.readDouble();
        this.stepSize = in.readDouble();
        this.proc.readFromStream(in, theScene);
        this.info = new PointInfo();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.getName());
        out.writeDouble(this.indexOfRefraction());
        out.writeBoolean(this.shadows);
        out.writeDouble(this.antialiasing);
        out.writeDouble(this.stepSize);
        this.proc.writeToStream(out, theScene);
    }

    public String getWindowTitle() {
        return "Procedural Material";
    }

    public Object getPreview(ProcedureEditor editor) {
        FloatingDialog dlg = new FloatingDialog(editor.getParentFrame(), "Preview", false);
        MaterialPreviewer preview = new MaterialPreviewer(null, this, 200, 160);
        dlg.add(preview);
        dlg.pack();
        Rectangle parentBounds = editor.getParentFrame().getBounds();
        Point location = dlg.getLocation();
        location.y = parentBounds.y;
        location.x = parentBounds.x + parentBounds.width;
        ((Component)dlg).setLocation(location);
        dlg.show();
        return preview;
    }

    public void updatePreview(Object preview) {
        ((MaterialPreviewer)preview).render();
    }

    public void disposePreview(Object preview) {
        ((Dialog)((MaterialPreviewer)preview).getParent()).dispose();
    }

    public boolean allowParameters() {
        return false;
    }

    public boolean canEditName() {
        return true;
    }

    public void acceptEdits(ProcedureEditor editor) {
        int i = editor.getScene().indexOf(this);
        if (i > -1) {
            editor.getScene().changeMaterial(i);
        }
    }

    public void editProperties(ProcedureEditor editor) {
        ValueField refractField = new ValueField(this.indexOfRefraction(), 3);
        ValueField stepField = new ValueField(this.stepSize, 3);
        ValueField aliasField = new ValueField(this.antialiasing, 1);
        Checkbox shadowBox = new Checkbox(Translate.text("CastsShadows"), this.shadows);
        ComponentsDialog dlg = new ComponentsDialog((Window)editor.getParentFrame(), "Set Material Properties:", new Component[]{refractField, stepField, aliasField, shadowBox}, new String[]{Translate.text("IndexOfRefraction"), "Integration Step Size", "Antialiasing", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.setIndexOfRefraction(refractField.getValue());
        this.setStepSize(stepField.getValue());
        this.antialiasing = aliasField.getValue();
        this.shadows = shadowBox.getState();
        editor.updatePreview();
    }
}

