/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.material.UniformMaterialMapping;
import artofillusion.math.RGBColor;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UniformMaterial
extends Material {
    RGBColor transparencyColor;
    RGBColor matColor;
    RGBColor scatteringColor;
    RGBColor trueTrans;
    RGBColor trueScat;
    float density;
    float scattering;
    double eccentricity;
    boolean shadows;

    public UniformMaterial() {
        this.transparencyColor = new RGBColor(0.5f, 0.5f, 0.5f);
        this.matColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.scatteringColor = new RGBColor(0.5f, 0.5f, 0.5f);
        this.trueTrans = new RGBColor(0.0f, 0.0f, 0.0f);
        this.trueScat = new RGBColor(0.0f, 0.0f, 0.0f);
        this.density = 0.5f;
        this.scattering = 0.0f;
        this.eccentricity = 0.0;
        this.name = "";
        this.refraction = 1.0;
        this.shadows = true;
        this.recalcColors();
    }

    private void recalcColors() {
        this.trueTrans.setRGB((float)Math.pow(this.transparencyColor.red, this.density), (float)Math.pow(this.transparencyColor.green, this.density), (float)Math.pow(this.transparencyColor.blue, this.density));
        this.trueScat.copy(this.scatteringColor);
        this.trueScat.scale(this.density * this.scattering);
    }

    public static String getTypeName() {
        return "Uniform";
    }

    public boolean isScattering() {
        return (double)this.density > 0.0 && (double)this.scattering > 0.0;
    }

    public boolean castsShadows() {
        return this.shadows;
    }

    public void getMaterialSpec(MaterialSpec spec) {
        spec.transparency.copy(this.trueTrans);
        spec.color.copy(this.matColor);
        if ((double)this.scattering > 0.0) {
            spec.scattering.copy(this.trueScat);
            spec.eccentricity = this.eccentricity;
        }
    }

    public MaterialMapping getDefaultMapping() {
        return new UniformMaterialMapping(this);
    }

    public Material duplicate() {
        UniformMaterial m = new UniformMaterial();
        m.name = this.name;
        m.transparencyColor.copy(this.transparencyColor);
        m.matColor.copy(this.matColor);
        m.scatteringColor.copy(this.scatteringColor);
        m.refraction = this.refraction;
        m.density = this.density;
        m.scattering = this.scattering;
        m.eccentricity = this.eccentricity;
        m.shadows = this.shadows;
        m.recalcColors();
        return m;
    }

    public void edit(Frame fr, Scene sc) {
        new Editor(fr);
    }

    public UniformMaterial(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.refraction = in.readDouble();
        this.transparencyColor = new RGBColor(in);
        this.matColor = new RGBColor(in);
        this.scatteringColor = new RGBColor(in);
        this.density = in.readFloat();
        this.scattering = in.readFloat();
        this.eccentricity = in.readDouble();
        this.shadows = in.readBoolean();
        this.trueTrans = new RGBColor(0.0f, 0.0f, 0.0f);
        this.trueScat = new RGBColor(0.0f, 0.0f, 0.0f);
        this.recalcColors();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeDouble(this.refraction);
        this.transparencyColor.writeToFile(out);
        this.matColor.writeToFile(out);
        this.scatteringColor.writeToFile(out);
        out.writeFloat(this.density);
        out.writeFloat(this.scattering);
        out.writeDouble(this.eccentricity);
        out.writeBoolean(this.shadows);
    }

    class Editor
    extends Dialog
    implements MouseListener,
    ActionListener,
    AdjustmentListener,
    ItemListener,
    TextListener {
        TextField nameField;
        ValueField refractField;
        ValueSlider densitySlider;
        ValueSlider scatSlider;
        ValueSlider eccSlider;
        Panel transPatch;
        Panel colorPatch;
        Panel scatPatch;
        Checkbox shadowBox;
        MaterialPreviewer preview;
        UniformMaterial newMaterial;
        Frame parent;

        public Editor(Frame fr) {
            super(fr, true);
            GridBagConstraints gc = new GridBagConstraints();
            this.parent = fr;
            this.newMaterial = (UniformMaterial)UniformMaterial.this.duplicate();
            Panel p = new Panel();
            p.add(Translate.button("ok", this));
            p.add(Translate.button("cancel", this));
            this.add((Component)p, "South");
            p = new Panel();
            p.setLayout(new GridBagLayout());
            gc.gridwidth = 2;
            gc.anchor = 10;
            this.preview = new MaterialPreviewer(null, this.newMaterial, 200, 160);
            p.add((Component)this.preview, gc);
            gc.gridwidth = 1;
            gc.gridx = 0;
            gc.anchor = 13;
            gc.insets = new Insets(0, 0, 0, 5);
            p.add((Component)new Label(Translate.text("Name")), gc);
            p.add((Component)new Label(Translate.text("MaterialColor")), gc);
            p.add((Component)new Label(Translate.text("Transparency")), gc);
            p.add((Component)new Label(Translate.text("Density")), gc);
            p.add((Component)new Label(Translate.text("Scattering")), gc);
            p.add((Component)new Label(Translate.text("ScatteringColor")), gc);
            p.add((Component)new Label(Translate.text("Eccentricity")), gc);
            p.add((Component)new Label(Translate.text("IndexOfRefraction")), gc);
            gc.gridx = 1;
            gc.gridwidth = 2;
            gc.fill = 2;
            this.nameField = new TextField(UniformMaterial.this.name, 15);
            p.add((Component)this.nameField, gc);
            gc.gridwidth = 1;
            this.colorPatch = UniformMaterial.this.matColor.getSample(50, 30);
            p.add((Component)this.colorPatch, gc);
            this.transPatch = UniformMaterial.this.transparencyColor.getSample(50, 30);
            p.add((Component)this.transPatch, gc);
            gc.gridwidth = 2;
            this.densitySlider = new ValueSlider(0.0, 1.0, 100, UniformMaterial.this.density);
            p.add((Component)this.densitySlider, gc);
            this.densitySlider.addAdjustmentListener(this);
            this.scatSlider = new ValueSlider(0.0, 1.0, 100, UniformMaterial.this.scattering);
            p.add((Component)this.scatSlider, gc);
            this.scatSlider.addAdjustmentListener(this);
            gc.gridwidth = 1;
            this.scatPatch = UniformMaterial.this.scatteringColor.getSample(50, 30);
            p.add((Component)this.scatPatch, gc);
            gc.gridwidth = 2;
            this.eccSlider = new ValueSlider(-1.0, 1.0, 100, UniformMaterial.this.eccentricity);
            p.add((Component)this.eccSlider, gc);
            this.eccSlider.addAdjustmentListener(this);
            this.refractField = new ValueField(UniformMaterial.this.refraction, 3);
            p.add((Component)this.refractField, gc);
            this.refractField.addTextListener(this);
            this.shadowBox = new Checkbox(Translate.text("CastsShadows"), UniformMaterial.this.shadows);
            p.add((Component)this.shadowBox, gc);
            this.shadowBox.addItemListener(this);
            this.add((Component)p, "Center");
            this.nameField.addActionListener(this);
            this.densitySlider.addActionListener(this);
            this.scatSlider.addActionListener(this);
            this.refractField.addActionListener(this);
            this.transPatch.addMouseListener(this);
            this.colorPatch.addMouseListener(this);
            this.scatPatch.addMouseListener(this);
            this.pack();
            this.setResizable(false);
            ModellingApp.centerWindow(this);
            this.show();
        }

        public void actionPerformed(ActionEvent e) {
            if (!e.getActionCommand().equals("cancel")) {
                UniformMaterial.this.refraction = this.refractField.getValue();
                UniformMaterial.this.density = (float)this.densitySlider.getValue();
                UniformMaterial.this.scattering = (float)this.scatSlider.getValue();
                UniformMaterial.this.name = this.nameField.getText();
                UniformMaterial.this.transparencyColor.copy(this.newMaterial.transparencyColor);
                UniformMaterial.this.matColor.copy(this.newMaterial.matColor);
                UniformMaterial.this.scatteringColor.copy(this.newMaterial.scatteringColor);
                UniformMaterial.this.eccentricity = this.newMaterial.eccentricity;
                UniformMaterial.this.shadows = this.newMaterial.shadows;
                UniformMaterial.this.recalcColors();
            }
            this.dispose();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == this.transPatch) {
                new ColorChooser(this.parent, Translate.text("Transparency"), this.newMaterial.transparencyColor);
                this.transPatch.setBackground(this.newMaterial.transparencyColor.getColor());
                this.transPatch.repaint();
                this.newMaterial.recalcColors();
                this.preview.render();
            } else if (e.getSource() == this.colorPatch) {
                new ColorChooser(this.parent, Translate.text("MaterialColor"), this.newMaterial.matColor);
                this.colorPatch.setBackground(this.newMaterial.matColor.getColor());
                this.colorPatch.repaint();
                this.preview.render();
            } else if (e.getSource() == this.scatPatch) {
                new ColorChooser(this.parent, Translate.text("ScatteringColor"), this.newMaterial.scatteringColor);
                this.scatPatch.setBackground(this.newMaterial.scatteringColor.getColor());
                this.scatPatch.repaint();
                this.newMaterial.recalcColors();
                this.preview.render();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            this.newMaterial.density = (float)this.densitySlider.getValue();
            this.newMaterial.scattering = (float)this.scatSlider.getValue();
            this.newMaterial.eccentricity = (float)this.eccSlider.getValue();
            this.newMaterial.recalcColors();
            this.preview.render();
        }

        public void textValueChanged(TextEvent e) {
            this.newMaterial.refraction = this.refractField.getValue();
            this.preview.render();
        }

        public void itemStateChanged(ItemEvent e) {
            this.newMaterial.shadows = this.shadowBox.getState();
            this.preview.render();
        }
    }
}

