/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import artofillusion.math.Mat4;
import artofillusion.math.Vec3;

public class BoundingBox {
    public double minx;
    public double maxx;
    public double miny;
    public double maxy;
    public double minz;
    public double maxz;

    public BoundingBox(double x1, double x2, double y1, double y2, double z1, double z2) {
        this.minx = Math.min(x1, x2);
        this.maxx = Math.max(x1, x2);
        this.miny = Math.min(y1, y2);
        this.maxy = Math.max(y1, y2);
        this.minz = Math.min(z1, z2);
        this.maxz = Math.max(z1, z2);
    }

    public BoundingBox(Vec3 p1, Vec3 p2) {
        this.minx = Math.min(p1.x, p2.x);
        this.maxx = Math.max(p1.x, p2.x);
        this.miny = Math.min(p1.y, p2.y);
        this.maxy = Math.max(p1.y, p2.y);
        this.minz = Math.min(p1.z, p2.z);
        this.maxz = Math.max(p1.z, p2.z);
    }

    public Vec3 getSize() {
        return new Vec3(this.maxx - this.minx, this.maxy - this.miny, this.maxz - this.minz);
    }

    public Vec3 getCenter() {
        return new Vec3((this.maxx + this.minx) / 2.0, (this.maxy + this.miny) / 2.0, (this.maxz + this.minz) / 2.0);
    }

    public Vec3[] getCorners() {
        Vec3[] corner = new Vec3[]{new Vec3(this.minx, this.miny, this.minz), new Vec3(this.minx, this.miny, this.maxz), new Vec3(this.minx, this.maxy, this.minz), new Vec3(this.minx, this.maxy, this.maxz), new Vec3(this.maxx, this.miny, this.minz), new Vec3(this.maxx, this.miny, this.maxz), new Vec3(this.maxx, this.maxy, this.minz), new Vec3(this.maxx, this.maxy, this.maxz)};
        return corner;
    }

    public BoundingBox merge(BoundingBox b) {
        return new BoundingBox(Math.min(this.minx, b.minx), Math.max(this.maxx, b.maxx), Math.min(this.miny, b.miny), Math.max(this.maxy, b.maxy), Math.min(this.minz, b.minz), Math.max(this.maxz, b.maxz));
    }

    public final boolean contains(Vec3 p) {
        return !(p.x < this.minx || p.x > this.maxx || p.y < this.miny || p.y > this.maxy || p.z < this.minz) && !(p.z > this.maxz);
    }

    public final boolean intersects(BoundingBox b) {
        return !(this.minx > b.maxx || this.maxx < b.minx || this.miny > b.maxy || this.maxy < b.miny || this.minz > b.maxz) && !(this.maxz < b.minz);
    }

    public final double distanceToPoint(Vec3 p) {
        double x = p.x < this.minx ? this.minx - p.x : (p.x > this.maxx ? p.x - this.maxx : 0.0);
        double y = p.y < this.miny ? this.miny - p.y : (p.y > this.maxy ? p.y - this.maxy : 0.0);
        double z = p.z < this.minz ? this.minz - p.z : (p.z > this.maxz ? p.z - this.maxz : 0.0);
        return Math.sqrt(x * x + y * y + z * z);
    }

    public final void outset(double dist) {
        this.minx -= dist;
        this.miny -= dist;
        this.minz -= dist;
        this.maxx += dist;
        this.maxy += dist;
        this.maxz += dist;
    }

    public final BoundingBox translate(double dx, double dy, double dz) {
        return new BoundingBox(this.minx + dx, this.maxx + dx, this.miny + dy, this.maxy + dy, this.minz + dz, this.maxz + dz);
    }

    public final BoundingBox transformAndOutset(Mat4 m) {
        double newmaxz;
        double newmaxy;
        double newmaxx;
        Vec3[] corner = this.getCorners();
        Vec3 p = m.times(corner[0]);
        double newminx = newmaxx = p.x;
        double newminy = newmaxy = p.y;
        double newminz = newmaxz = p.z;
        int i = 1;
        while (i < 8) {
            p = m.times(corner[i]);
            if (p.x < newminx) {
                newminx = p.x;
            }
            if (p.x > newmaxx) {
                newmaxx = p.x;
            }
            if (p.y < newminy) {
                newminy = p.y;
            }
            if (p.y > newmaxy) {
                newmaxy = p.y;
            }
            if (p.z < newminz) {
                newminz = p.z;
            }
            if (p.z > newmaxz) {
                newmaxz = p.z;
            }
            ++i;
        }
        return new BoundingBox(newminx, newmaxx, newminy, newmaxy, newminz, newmaxz);
    }

    public String toString() {
        return "Box: {" + this.minx + ", " + this.maxx + "}   {" + this.miny + ", " + this.maxy + "}   {" + this.minz + ", " + this.maxz + "}";
    }
}

