/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Vec2 {
    public double x;
    public double y;

    public Vec2() {
    }

    public Vec2(double xval, double yval) {
        this.x = xval;
        this.y = yval;
    }

    public final void set(double xval, double yval) {
        this.x = xval;
        this.y = yval;
    }

    public final double dot(Vec2 v) {
        return this.x * v.x + this.y * v.y;
    }

    public final double cross(Vec2 v) {
        return this.x * v.y - this.y * v.x;
    }

    public final Vec2 plus(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    public final Vec2 minus(Vec2 v) {
        return new Vec2(this.x - v.x, this.y - v.y);
    }

    public final Vec2 times(double d) {
        return new Vec2(this.x * d, this.y * d);
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double length2() {
        return this.x * this.x + this.y * this.y;
    }

    public final void add(Vec2 v) {
        this.x += v.x;
        this.y += v.y;
    }

    public final void subtract(Vec2 v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public final void scale(double d) {
        this.x *= d;
        this.y *= d;
    }

    public final double distance(Vec2 v) {
        return Math.sqrt((v.x - this.x) * (v.x - this.x) + (v.y - this.y) * (v.y - this.y));
    }

    public final double distance2(Vec2 v) {
        return (v.x - this.x) * (v.x - this.x) + (v.y - this.y) * (v.y - this.y);
    }

    public final void normalize() {
        double len = Math.sqrt(this.x * this.x + this.y * this.y);
        if (len > 0.0) {
            this.x /= len;
            this.y /= len;
        }
    }

    public String toString() {
        return "Vec2: " + this.x + ", " + this.y;
    }

    public static Vec2 vx() {
        return new Vec2(1.0, 0.0);
    }

    public static Vec2 vy() {
        return new Vec2(0.0, 1.0);
    }

    public Vec2(DataInputStream in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }
}

