/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.TriMeshSimplifier;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.SVD;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import java.util.Vector;

public class CSGModeller {
    Vector vert1;
    Vector vert2;
    Vector face1;
    Vector face2;
    BoundingBox bounds1;
    BoundingBox bounds2;
    Texture tex;
    TextureMapping texMap;
    Material mat;
    MaterialMapping matMap;
    static final int VERTEX = 0;
    static final int FACE = 1;
    static final int EDGE = 2;
    static final int UNKNOWN = 0;
    static final int BOUNDARY = 1;
    static final int INSIDE = 2;
    static final int OUTSIDE = 3;
    static final int SAME = 4;
    static final int OPPOSITE = 5;
    static final double TOL = 1.0E-10;

    public CSGModeller(TriangleMesh obj1, TriangleMesh obj2, CoordinateSystem coords1, CoordinateSystem coords2) {
        this.tex = obj1.getTexture();
        this.texMap = obj1.getTextureMapping();
        this.mat = obj1.getMaterial();
        this.matMap = obj1.getMaterialMapping();
        this.vert1 = new Vector();
        this.vert2 = new Vector();
        this.face1 = new Vector();
        this.face2 = new Vector();
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])obj1.getVertices();
        Mat4 trans = coords1.fromLocal();
        int i = 0;
        while (i < vert.length) {
            this.vert1.addElement(new VertexInfo(trans.times(vert[i].r), vert[i].smoothness, vert[i].param));
            ++i;
        }
        this.bounds1 = obj1.getBounds().transformAndOutset(trans);
        vert = (TriangleMesh.Vertex[])obj2.getVertices();
        trans = coords2.fromLocal();
        i = 0;
        while (i < vert.length) {
            this.vert2.addElement(new VertexInfo(trans.times(vert[i].r), vert[i].smoothness, vert[i].param));
            ++i;
        }
        this.bounds2 = obj2.getBounds().transformAndOutset(trans);
        TriangleMesh.Edge[] edge = obj1.getEdges();
        TriangleMesh.Face[] face = obj1.getFaces();
        if (obj1.getSmoothingMethod() == 0) {
            i = 0;
            while (i < face.length) {
                this.face1.addElement(new FaceInfo(face[i].v1, face[i].v2, face[i].v3, this.vert1, 0.0f, 0.0f, 0.0f));
                ++i;
            }
        } else {
            i = 0;
            while (i < face.length) {
                this.face1.addElement(new FaceInfo(face[i].v1, face[i].v2, face[i].v3, this.vert1, edge[face[i].e1].smoothness, edge[face[i].e2].smoothness, edge[face[i].e3].smoothness));
                ++i;
            }
        }
        edge = obj2.getEdges();
        face = obj2.getFaces();
        if (obj2.getSmoothingMethod() == 0) {
            i = 0;
            while (i < face.length) {
                this.face2.addElement(new FaceInfo(face[i].v1, face[i].v2, face[i].v3, this.vert2, 0.0f, 0.0f, 0.0f));
                ++i;
            }
        } else {
            i = 0;
            while (i < face.length) {
                this.face2.addElement(new FaceInfo(face[i].v1, face[i].v2, face[i].v3, this.vert2, edge[face[i].e1].smoothness, edge[face[i].e2].smoothness, edge[face[i].e3].smoothness));
                ++i;
            }
        }
        this.splitFaces(this.vert1, this.face1, this.bounds1, this.vert2, this.face2, this.bounds2);
        this.splitFaces(this.vert2, this.face2, this.bounds2, this.vert1, this.face1, this.bounds1);
        this.splitFaces(this.vert1, this.face1, this.bounds1, this.vert2, this.face2, this.bounds2);
        this.findInsideVertices(this.vert1, this.face1, this.vert2, this.face2);
        this.findInsideVertices(this.vert2, this.face2, this.vert1, this.face1);
    }

    public TriangleMesh getMesh(int op) {
        int j;
        Vector<VertexInfo> allVert = new Vector<VertexInfo>();
        Vector<int[]> faceIndex = new Vector<int[]>();
        Vector<float[]> faceSmoothness = new Vector<float[]>();
        int[] index1 = new int[this.vert1.size()];
        int[] index2 = new int[this.vert2.size()];
        int firstBoundary = -1;
        int i = 0;
        while (i < this.vert1.size()) {
            VertexInfo v = (VertexInfo)this.vert1.elementAt(i);
            if (v.type == 2 && (op == 1 || op == 3)) {
                index1[i] = allVert.size();
                allVert.addElement(v);
            } else if (v.type == 3 && (op == 0 || op == 2)) {
                index1[i] = allVert.size();
                allVert.addElement(v);
            } else if (v.type == 4 && (op == 0 || op == 1)) {
                index1[i] = allVert.size();
                allVert.addElement(v);
            } else if (v.type == 5 && (op == 2 || op == 3)) {
                index1[i] = allVert.size();
                allVert.addElement(v);
            } else if (v.type == 1) {
                index1[i] = -1;
                if (firstBoundary == -1) {
                    firstBoundary = allVert.size();
                } else {
                    int j2 = firstBoundary;
                    while (index1[i] == -1 && j2 < allVert.size()) {
                        VertexInfo v2 = (VertexInfo)allVert.elementAt(j2);
                        if (v2.type == 1 && v2.r.distance(v.r) < 1.0E-10) {
                            index1[i] = j2;
                        }
                        ++j2;
                    }
                }
                if (index1[i] == -1) {
                    index1[i] = allVert.size();
                    allVert.addElement(v);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.vert2.size()) {
            VertexInfo v = (VertexInfo)this.vert2.elementAt(i2);
            if (v.type == 2 && (op == 1 || op == 2)) {
                index2[i2] = allVert.size();
                allVert.addElement(v);
            } else if (v.type == 3 && (op == 0 || op == 3)) {
                index2[i2] = allVert.size();
                allVert.addElement(v);
            } else if (v.type == 1) {
                index2[i2] = -1;
                int j3 = firstBoundary;
                while (index2[i2] == -1 && j3 < allVert.size()) {
                    VertexInfo v2 = (VertexInfo)allVert.elementAt(j3);
                    if (v2.type == 1 && v2.r.distance(v.r) < 1.0E-10) {
                        index2[i2] = j3;
                    }
                    ++j3;
                }
                if (index2[i2] == -1) {
                    System.out.println("Unknown!");
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.face1.size()) {
            FaceInfo f = (FaceInfo)this.face1.elementAt(i3);
            if (f.type == 2 && op == 1) {
                faceIndex.addElement(new int[]{index1[f.v1], index1[f.v2], index1[f.v3]});
                faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness2, f.smoothness3});
            } else if (f.type == 2 && op == 3) {
                faceIndex.addElement(new int[]{index1[f.v2], index1[f.v1], index1[f.v3]});
                faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness3, f.smoothness2});
            } else if (f.type == 3 && (op == 0 || op == 2)) {
                faceIndex.addElement(new int[]{index1[f.v1], index1[f.v2], index1[f.v3]});
                faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness2, f.smoothness3});
            } else if (f.type == 4 && (op == 0 || op == 1)) {
                faceIndex.addElement(new int[]{index1[f.v1], index1[f.v2], index1[f.v3]});
                faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness2, f.smoothness3});
            } else if (f.type == 5 && (op == 2 || op == 3)) {
                faceIndex.addElement(new int[]{index1[f.v1], index1[f.v2], index1[f.v3]});
                faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness2, f.smoothness3});
            }
            ++i3;
        }
        int faces1 = faceIndex.size();
        int i4 = 0;
        while (i4 < this.face2.size()) {
            FaceInfo f = (FaceInfo)this.face2.elementAt(i4);
            if (f.type == 2 && op == 1) {
                faceIndex.addElement(new int[]{index2[f.v1], index2[f.v2], index2[f.v3]});
                faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness2, f.smoothness3});
            } else if (f.type == 2 && op == 2) {
                faceIndex.addElement(new int[]{index2[f.v2], index2[f.v1], index2[f.v3]});
                faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness3, f.smoothness2});
            } else if (f.type == 3 && (op == 0 || op == 3)) {
                faceIndex.addElement(new int[]{index2[f.v1], index2[f.v2], index2[f.v3]});
                faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness2, f.smoothness3});
            }
            ++i4;
        }
        if (allVert.size() == 0 || faceIndex.size() == 0) {
            return new TriangleMesh(new Vec3[]{new Vec3()}, new int[0][0]);
        }
        Vec3[] v = new Vec3[allVert.size()];
        int i5 = 0;
        while (i5 < v.length) {
            v[i5] = new Vec3(((VertexInfo)allVert.elementAt((int)i5)).r);
            ++i5;
        }
        int[][] f = new int[faceIndex.size()][];
        int i6 = 0;
        while (i6 < f.length) {
            f[i6] = (int[])faceIndex.elementAt(i6);
            ++i6;
        }
        TriangleMesh mesh = new TriangleMesh(v, (int[][])f);
        TriangleMesh.Vertex[] mv = (TriangleMesh.Vertex[])mesh.getVertices();
        int i7 = 0;
        while (i7 < mv.length) {
            mv[i7].smoothness = ((VertexInfo)allVert.elementAt((int)i7)).smoothness;
            ++i7;
        }
        TriangleMesh.Edge[] edge = mesh.getEdges();
        TriangleMesh.Face[] face = mesh.getFaces();
        int i8 = 0;
        while (i8 < edge.length) {
            VertexInfo vi1 = (VertexInfo)allVert.elementAt(edge[i8].v1);
            VertexInfo vi2 = (VertexInfo)allVert.elementAt(edge[i8].v2);
            int k = 0;
            while (k < 2) {
                block57: {
                    float s;
                    block59: {
                        float[] smoothness;
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        block58: {
                                            int n = j = k == 0 ? edge[i8].f1 : edge[i8].f2;
                                            if (j == -1) break block57;
                                            smoothness = (float[])faceSmoothness.elementAt(j);
                                            if (face[j].v1 != edge[i8].v1 || face[j].v2 != edge[i8].v2) break block58;
                                            s = smoothness[0];
                                            break block59;
                                        }
                                        if (face[j].v1 != edge[i8].v2 || face[j].v2 != edge[i8].v1) break block60;
                                        s = smoothness[0];
                                        break block59;
                                    }
                                    if (face[j].v2 != edge[i8].v1 || face[j].v3 != edge[i8].v2) break block61;
                                    s = smoothness[1];
                                    break block59;
                                }
                                if (face[j].v2 != edge[i8].v2 || face[j].v3 != edge[i8].v1) break block62;
                                s = smoothness[1];
                                break block59;
                            }
                            if (face[j].v3 != edge[i8].v1 || face[j].v1 != edge[i8].v2) break block63;
                            s = smoothness[2];
                            break block59;
                        }
                        if (face[j].v3 != edge[i8].v2 || face[j].v1 != edge[i8].v1) break block57;
                        s = smoothness[2];
                    }
                    edge[i8].smoothness = Math.min(edge[i8].smoothness, s);
                }
                ++k;
            }
            if (edge[i8].f1 < faces1 && edge[i8].f2 >= faces1 || edge[i8].f2 < faces1 && edge[i8].f1 >= faces1) {
                edge[i8].smoothness = 0.0f;
            }
            ++i8;
        }
        mesh.setTexture(this.tex);
        mesh.setTextureMapping(this.texMap);
        mesh.setMaterial(this.mat);
        mesh.setMaterialMapping(this.matMap);
        if (((VertexInfo)allVert.elementAt((int)0)).param != null) {
            int i9 = 0;
            while (i9 < mv.length) {
                VertexInfo info = (VertexInfo)allVert.elementAt(i9);
                int j4 = 0;
                while (j4 < info.param.length) {
                    mv[i9].param[j4] = info.param[j4];
                    ++j4;
                }
                ++i9;
            }
            int i10 = 0;
            while (i10 < this.vert2.size()) {
                VertexInfo info = (VertexInfo)this.vert2.elementAt(i10);
                if (info.type == 1) {
                    j = 0;
                    while (j < info.param.length) {
                        mv[index2[i10]].param[j] = 0.5 * (mv[index2[i10]].param[j] + info.param[j]);
                        ++j;
                    }
                }
                ++i10;
            }
        }
        boolean[] candidate = new boolean[edge.length];
        int i11 = 0;
        while (i11 < edge.length) {
            VertexInfo vi1 = (VertexInfo)allVert.elementAt(edge[i11].v1);
            VertexInfo vi2 = (VertexInfo)allVert.elementAt(edge[i11].v2);
            candidate[i11] = vi1.type == 1 && vi2.type == 1;
            ++i11;
        }
        new TriMeshSimplifier(mesh, candidate, 1.0E-4, null);
        return mesh;
    }

    private void splitFaces(Vector v1, Vector f1, BoundingBox bounds1, Vector v2, Vector f2, BoundingBox bounds2) {
        if (!this.intersect(bounds1, bounds2)) {
            return;
        }
        int[] intersectVertA = new int[2];
        int[] intersectVertB = new int[2];
        double[] intersectDistA = new double[2];
        double[] intersectDistB = new double[2];
        int[] intersectTypeA = new int[2];
        double[][] m = new double[3][3];
        double[] b = new double[3];
        Vec3 root = new Vec3();
        int i = 0;
        while (i < f1.size()) {
            FaceInfo fa = (FaceInfo)f1.elementAt(i);
            if (this.intersect(fa.bounds, bounds2)) {
                VertexInfo va1 = (VertexInfo)v1.elementAt(fa.v1);
                VertexInfo va2 = (VertexInfo)v1.elementAt(fa.v2);
                VertexInfo va3 = (VertexInfo)v1.elementAt(fa.v3);
                int j = 0;
                while (j < f2.size()) {
                    FaceInfo fb = (FaceInfo)f2.elementAt(j);
                    if (this.intersect(fa.bounds, fb.bounds)) {
                        VertexInfo vb1 = (VertexInfo)v2.elementAt(fb.v1);
                        VertexInfo vb2 = (VertexInfo)v2.elementAt(fb.v2);
                        VertexInfo vb3 = (VertexInfo)v2.elementAt(fb.v3);
                        double dista1 = va1.r.dot(fb.norm) - fb.distRoot;
                        double dista2 = va2.r.dot(fb.norm) - fb.distRoot;
                        double dista3 = va3.r.dot(fb.norm) - fb.distRoot;
                        if (!(dista1 > 1.0E-10 && dista2 > 1.0E-10 && dista3 > 1.0E-10 || dista1 < -1.0E-10 && dista2 < -1.0E-10 && dista3 < -1.0E-10)) {
                            int signa3;
                            int signa2;
                            int signa1;
                            int n = dista1 > 1.0E-10 ? 1 : (signa1 = dista1 < -1.0E-10 ? -1 : 0);
                            int n2 = dista2 > 1.0E-10 ? 1 : (signa2 = dista2 < -1.0E-10 ? -1 : 0);
                            int n3 = dista3 > 1.0E-10 ? 1 : (signa3 = dista3 < -1.0E-10 ? -1 : 0);
                            if (signa1 != 0 || signa2 != 0 || signa3 != 0) {
                                double distb1 = vb1.r.dot(fa.norm) - fa.distRoot;
                                double distb2 = vb2.r.dot(fa.norm) - fa.distRoot;
                                double distb3 = vb3.r.dot(fa.norm) - fa.distRoot;
                                if (!(distb1 > 1.0E-10 && distb2 > 1.0E-10 && distb3 > 1.0E-10 || distb1 < -1.0E-10 && distb2 < -1.0E-10 && distb3 < -1.0E-10)) {
                                    int signb2;
                                    int signb1;
                                    int spanTypeA;
                                    Vec3 line = fa.norm.cross(fb.norm);
                                    line.normalize();
                                    int index = 0;
                                    if (signa1 == 0) {
                                        intersectVertA[index] = fa.v1;
                                        intersectDistA[index] = line.dot(va1.r);
                                        intersectTypeA[index++] = 0;
                                        if (signa2 == signa3) {
                                            intersectVertA[index] = fa.v1;
                                            intersectDistA[index] = intersectDistA[index - 1];
                                            intersectTypeA[index++] = 0;
                                        }
                                    }
                                    if (signa2 == 0) {
                                        intersectVertA[index] = fa.v2;
                                        intersectDistA[index] = line.dot(va2.r);
                                        intersectTypeA[index++] = 0;
                                        if (signa1 == signa3) {
                                            intersectVertA[index] = fa.v2;
                                            intersectDistA[index] = intersectDistA[index - 1];
                                            intersectTypeA[index++] = 0;
                                        }
                                    }
                                    if (signa3 == 0) {
                                        intersectVertA[index] = fa.v3;
                                        intersectDistA[index] = line.dot(va3.r);
                                        intersectTypeA[index++] = 0;
                                        if (signa1 == signa2) {
                                            intersectVertA[index] = fa.v3;
                                            intersectDistA[index] = intersectDistA[index - 1];
                                            intersectTypeA[index++] = 0;
                                        }
                                    }
                                    if (index == 2) {
                                        spanTypeA = intersectVertA[0] == intersectVertA[1] ? 0 : 2;
                                    } else {
                                        double fract;
                                        if (signa1 == 1 && signa2 == -1 || signa1 == -1 && signa2 == 1) {
                                            intersectVertA[index] = fa.v1;
                                            fract = dista2 / (dista2 - dista1);
                                            intersectDistA[index] = fract * line.dot(va1.r) + (1.0 - fract) * line.dot(va2.r);
                                            intersectTypeA[index++] = 2;
                                        }
                                        if (signa2 == 1 && signa3 == -1 || signa2 == -1 && signa3 == 1) {
                                            intersectVertA[index] = fa.v2;
                                            fract = dista3 / (dista3 - dista2);
                                            intersectDistA[index] = fract * line.dot(va2.r) + (1.0 - fract) * line.dot(va3.r);
                                            intersectTypeA[index++] = 2;
                                        }
                                        if (signa3 == 1 && signa1 == -1 || signa3 == -1 && signa1 == 1) {
                                            intersectVertA[index] = fa.v3;
                                            fract = dista1 / (dista1 - dista3);
                                            intersectDistA[index] = fract * line.dot(va3.r) + (1.0 - fract) * line.dot(va1.r);
                                            intersectTypeA[index++] = 2;
                                        }
                                        spanTypeA = 1;
                                    }
                                    int n4 = distb1 > 1.0E-10 ? 1 : (signb1 = distb1 < -1.0E-10 ? -1 : 0);
                                    int n5 = distb2 > 1.0E-10 ? 1 : (signb2 = distb2 < -1.0E-10 ? -1 : 0);
                                    int signb3 = distb3 > 1.0E-10 ? 1 : (distb3 < -1.0E-10 ? -1 : 0);
                                    index = 0;
                                    if (signb1 == 0) {
                                        intersectVertB[index] = fb.v1;
                                        intersectDistB[index] = line.dot(vb1.r);
                                        ++index;
                                        if (signb2 == signb3) {
                                            intersectVertB[index] = fb.v1;
                                            intersectDistB[index] = intersectDistB[index - 1];
                                            ++index;
                                        }
                                    }
                                    if (signb2 == 0) {
                                        intersectVertB[index] = fb.v2;
                                        intersectDistB[index] = line.dot(vb2.r);
                                        ++index;
                                        if (signb1 == signb3) {
                                            intersectVertB[index] = fb.v2;
                                            intersectDistB[index] = intersectDistB[index - 1];
                                            ++index;
                                        }
                                    }
                                    if (signb3 == 0) {
                                        intersectVertB[index] = fb.v3;
                                        intersectDistB[index] = line.dot(vb3.r);
                                        ++index;
                                        if (signb1 == signb2) {
                                            intersectVertB[index] = fb.v3;
                                            intersectDistB[index] = intersectDistB[index - 1];
                                            ++index;
                                        }
                                    }
                                    if (index != 2) {
                                        double fract;
                                        if (signb1 == 1 && signb2 == -1 || signb1 == -1 && signb2 == 1) {
                                            intersectVertB[index] = fb.v1;
                                            fract = distb2 / (distb2 - distb1);
                                            intersectDistB[index] = fract * line.dot(vb1.r) + (1.0 - fract) * line.dot(vb2.r);
                                            ++index;
                                        }
                                        if (signb2 == 1 && signb3 == -1 || signb2 == -1 && signb3 == 1) {
                                            intersectVertB[index] = fb.v2;
                                            fract = distb3 / (distb3 - distb2);
                                            intersectDistB[index] = fract * line.dot(vb2.r) + (1.0 - fract) * line.dot(vb3.r);
                                            ++index;
                                        }
                                        if (signb3 == 1 && signb1 == -1 || signb3 == -1 && signb1 == 1) {
                                            intersectVertB[index] = fb.v3;
                                            fract = distb1 / (distb1 - distb3);
                                            intersectDistB[index] = fract * line.dot(vb3.r) + (1.0 - fract) * line.dot(vb1.r);
                                            ++index;
                                        }
                                    }
                                    if (!(Math.max(intersectDistA[0], intersectDistA[1]) < Math.min(intersectDistB[0], intersectDistB[1]) + 1.0E-10) && !(Math.max(intersectDistB[0], intersectDistB[1]) < Math.min(intersectDistA[0], intersectDistA[1]) + 1.0E-10)) {
                                        m[0][0] = fa.norm.x;
                                        m[0][1] = fa.norm.y;
                                        m[0][2] = fa.norm.z;
                                        m[1][0] = fb.norm.x;
                                        m[1][1] = fb.norm.y;
                                        m[1][2] = fb.norm.z;
                                        m[2][0] = line.x;
                                        m[2][1] = line.y;
                                        m[2][2] = line.z;
                                        b[0] = fa.distRoot;
                                        b[1] = fb.distRoot;
                                        b[2] = 0.0;
                                        SVD.solve(m, b);
                                        root.set(b[0], b[1], b[2]);
                                        int oldSize = f1.size();
                                        this.splitOneFace(v1, f1, i, intersectVertA, intersectDistA, intersectDistB, intersectTypeA, spanTypeA, line, root);
                                        if (f1.size() != oldSize) {
                                            --i;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void splitOneFace(Vector vert, Vector face, int which, int[] intersectVert, double[] distA, double[] distB, int[] typeA, int spanTypeA, Vec3 line, Vec3 root) {
        int newindex;
        int endType;
        double endDist;
        int startType;
        double startDist;
        double swap1;
        FaceInfo f = (FaceInfo)face.elementAt(which);
        VertexInfo v1 = (VertexInfo)vert.elementAt(f.v1);
        VertexInfo v2 = (VertexInfo)vert.elementAt(f.v2);
        VertexInfo v3 = (VertexInfo)vert.elementAt(f.v3);
        VertexInfo startVert = (VertexInfo)vert.elementAt(intersectVert[0]);
        VertexInfo endVert = (VertexInfo)vert.elementAt(intersectVert[1]);
        double[] startParams = null;
        double[] endParams = null;
        if (distA[0] > distA[1]) {
            swap1 = distA[0];
            distA[0] = distA[1];
            distA[1] = swap1;
            int swap2 = typeA[0];
            typeA[0] = typeA[1];
            typeA[1] = swap2;
            VertexInfo swap3 = startVert;
            startVert = endVert;
            endVert = swap3;
        }
        if (distB[0] > distB[1]) {
            swap1 = distB[0];
            distB[0] = distB[1];
            distB[1] = swap1;
        }
        if (distB[0] > distA[0] + 1.0E-10) {
            startDist = distB[0];
            startType = spanTypeA;
        } else {
            startDist = distA[0];
            startType = typeA[0];
        }
        if (distB[1] < distA[1] - 1.0E-10) {
            endDist = distB[1];
            endType = spanTypeA;
        } else {
            endDist = distA[1];
            endType = typeA[1];
        }
        if (startType == 0 && endType == 0) {
            endVert.type = 1;
            startVert.type = 1;
            return;
        }
        Vec3 startPos = null;
        Vec3 endPos = null;
        if (startType == 0) {
            startVert.type = 1;
        } else {
            double d = startDist;
            startPos = new Vec3(root.x + d * line.x, root.y + d * line.y, root.z + d * line.z);
            startParams = this.interpTextureParams(startPos, v1, v2, v3, f);
        }
        if (endType == 0) {
            endVert.type = 1;
        } else {
            double d = endDist;
            endPos = new Vec3(root.x + d * line.x, root.y + d * line.y, root.z + d * line.z);
            endParams = this.interpTextureParams(endPos, v1, v2, v3, f);
        }
        if (spanTypeA == 2) {
            int splitEdge = startVert == v1 && endVert == v2 || startVert == v2 && endVert == v1 ? 1 : (startVert == v2 && endVert == v3 || startVert == v3 && endVert == v2 ? 2 : 3);
            if (startType == 0) {
                int newindex2 = vert.size();
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                face.removeElementAt(which);
                if (splitEdge == 1) {
                    face.addElement(new FaceInfo(f.v1, newindex2, f.v3, vert, startVert == v1 ? 0.0f : f.smoothness1, 1.0f, f.smoothness3));
                    face.addElement(new FaceInfo(newindex2, f.v2, f.v3, vert, startVert == v2 ? 0.0f : f.smoothness1, f.smoothness2, 1.0f));
                } else if (splitEdge == 2) {
                    face.addElement(new FaceInfo(f.v2, newindex2, f.v1, vert, startVert == v2 ? 0.0f : f.smoothness2, 1.0f, f.smoothness1));
                    face.addElement(new FaceInfo(newindex2, f.v3, f.v1, vert, startVert == v3 ? 0.0f : f.smoothness2, f.smoothness3, 1.0f));
                } else {
                    face.addElement(new FaceInfo(f.v3, newindex2, f.v2, vert, startVert == v3 ? 0.0f : f.smoothness3, 1.0f, f.smoothness2));
                    face.addElement(new FaceInfo(newindex2, f.v1, f.v2, vert, startVert == v1 ? 0.0f : f.smoothness3, f.smoothness1, 1.0f));
                }
                return;
            }
            if (endType == 0) {
                int newindex3 = vert.size();
                vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                face.removeElementAt(which);
                if (splitEdge == 1) {
                    face.addElement(new FaceInfo(f.v1, newindex3, f.v3, vert, endVert == v1 ? 0.0f : f.smoothness1, 1.0f, f.smoothness3));
                    face.addElement(new FaceInfo(newindex3, f.v2, f.v3, vert, endVert == v2 ? 0.0f : f.smoothness1, f.smoothness2, 1.0f));
                } else if (splitEdge == 2) {
                    face.addElement(new FaceInfo(f.v2, newindex3, f.v1, vert, endVert == v2 ? 0.0f : f.smoothness2, 1.0f, f.smoothness1));
                    face.addElement(new FaceInfo(newindex3, f.v3, f.v1, vert, endVert == v3 ? 0.0f : f.smoothness2, f.smoothness3, 1.0f));
                } else {
                    face.addElement(new FaceInfo(f.v3, newindex3, f.v2, vert, endVert == v3 ? 0.0f : f.smoothness3, 1.0f, f.smoothness2));
                    face.addElement(new FaceInfo(newindex3, f.v1, f.v2, vert, endVert == v1 ? 0.0f : f.smoothness3, f.smoothness1, 1.0f));
                }
                return;
            }
            if (startDist == endDist) {
                int newindex4 = vert.size();
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                face.removeElementAt(which);
                if (splitEdge == 1) {
                    face.addElement(new FaceInfo(f.v1, newindex4, f.v3, vert, f.smoothness1, 1.0f, f.smoothness3));
                    face.addElement(new FaceInfo(newindex4, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 1.0f));
                } else if (splitEdge == 2) {
                    face.addElement(new FaceInfo(f.v2, newindex4, f.v1, vert, f.smoothness2, 1.0f, f.smoothness1));
                    face.addElement(new FaceInfo(newindex4, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 1.0f));
                } else {
                    face.addElement(new FaceInfo(f.v3, newindex4, f.v2, vert, f.smoothness3, 1.0f, f.smoothness2));
                    face.addElement(new FaceInfo(newindex4, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 1.0f));
                }
            } else {
                int newindex5 = vert.size();
                if (startVert == v1 && endVert == v2 || startVert == v2 && endVert == v3 || startVert == v3 && endVert == v1) {
                    vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                    vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                } else {
                    vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                    vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                }
                face.removeElementAt(which);
                if (splitEdge == 1) {
                    face.addElement(new FaceInfo(f.v1, newindex5, f.v3, vert, f.smoothness1, 1.0f, f.smoothness3));
                    face.addElement(new FaceInfo(newindex5, newindex5 + 1, f.v3, vert, 0.0f, 1.0f, 1.0f));
                    face.addElement(new FaceInfo(newindex5 + 1, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 1.0f));
                } else if (splitEdge == 2) {
                    face.addElement(new FaceInfo(f.v2, newindex5, f.v1, vert, f.smoothness2, 1.0f, f.smoothness1));
                    face.addElement(new FaceInfo(newindex5, newindex5 + 1, f.v1, vert, 0.0f, 1.0f, 1.0f));
                    face.addElement(new FaceInfo(newindex5 + 1, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 1.0f));
                } else {
                    face.addElement(new FaceInfo(f.v3, newindex5, f.v2, vert, f.smoothness3, 1.0f, f.smoothness2));
                    face.addElement(new FaceInfo(newindex5, newindex5 + 1, f.v2, vert, 0.0f, 1.0f, 1.0f));
                    face.addElement(new FaceInfo(newindex5 + 1, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 1.0f));
                }
            }
            return;
        }
        if (startType == 0 && endType == 2) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            face.removeElementAt(which);
            if (endVert == v1) {
                face.addElement(new FaceInfo(f.v1, newindex, f.v3, vert, f.smoothness1, 0.0f, f.smoothness3));
                face.addElement(new FaceInfo(newindex, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 0.0f));
            } else if (endVert == v2) {
                face.addElement(new FaceInfo(f.v2, newindex, f.v1, vert, f.smoothness2, 0.0f, f.smoothness1));
                face.addElement(new FaceInfo(newindex, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 0.0f));
            } else {
                face.addElement(new FaceInfo(f.v3, newindex, f.v2, vert, f.smoothness3, 0.0f, f.smoothness2));
                face.addElement(new FaceInfo(newindex, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 0.0f));
            }
        } else if (startType == 2 && endType == 0) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            face.removeElementAt(which);
            if (startVert == v1) {
                face.addElement(new FaceInfo(f.v1, newindex, f.v3, vert, f.smoothness1, 0.0f, f.smoothness3));
                face.addElement(new FaceInfo(newindex, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 0.0f));
            } else if (startVert == v2) {
                face.addElement(new FaceInfo(f.v2, newindex, f.v1, vert, f.smoothness2, 0.0f, f.smoothness1));
                face.addElement(new FaceInfo(newindex, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 0.0f));
            } else {
                face.addElement(new FaceInfo(f.v3, newindex, f.v2, vert, f.smoothness3, 0.0f, f.smoothness2));
                face.addElement(new FaceInfo(newindex, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 0.0f));
            }
        } else if (startType == 0 && endType == 1) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            face.removeElementAt(which);
            if (startVert == v1) {
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 0.0f, 1.0f));
            } else if (startVert == v2) {
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 0.0f, 1.0f));
            } else {
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 0.0f, 1.0f));
            }
        } else if (startType == 1 && endType == 0) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            face.removeElementAt(which);
            if (endVert == v1) {
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 0.0f, 1.0f));
            } else if (endVert == v2) {
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 0.0f, 1.0f));
            } else {
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 0.0f, 1.0f));
            }
        } else if (startType == 2 && endType == 2) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            face.removeElementAt(which);
            if (startVert == v1 && endVert == v2) {
                face.addElement(new FaceInfo(f.v1, newindex, newindex + 1, vert, f.smoothness1, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, newindex + 1, f.v3, vert, 1.0f, f.smoothness2, f.smoothness3));
                face.addElement(new FaceInfo(newindex, f.v2, newindex + 1, vert, f.smoothness1, f.smoothness2, 0.0f));
            } else if (startVert == v2 && endVert == v1) {
                face.addElement(new FaceInfo(f.v1, newindex + 1, newindex, vert, f.smoothness1, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, newindex, f.v3, vert, 1.0f, f.smoothness2, f.smoothness3));
                face.addElement(new FaceInfo(newindex + 1, f.v2, newindex, vert, f.smoothness1, f.smoothness2, 0.0f));
            } else if (startVert == v2 && endVert == v3) {
                face.addElement(new FaceInfo(f.v2, newindex, newindex + 1, vert, f.smoothness2, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, newindex + 1, f.v1, vert, 1.0f, f.smoothness3, f.smoothness1));
                face.addElement(new FaceInfo(newindex, f.v3, newindex + 1, vert, f.smoothness2, f.smoothness3, 0.0f));
            } else if (startVert == v3 && endVert == v2) {
                face.addElement(new FaceInfo(f.v2, newindex + 1, newindex, vert, f.smoothness2, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, newindex, f.v1, vert, 1.0f, f.smoothness3, f.smoothness1));
                face.addElement(new FaceInfo(newindex + 1, f.v3, newindex, vert, f.smoothness2, f.smoothness3, 0.0f));
            } else if (startVert == v3 && endVert == v1) {
                face.addElement(new FaceInfo(f.v3, newindex, newindex + 1, vert, f.smoothness3, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, newindex + 1, f.v2, vert, 1.0f, f.smoothness1, f.smoothness2));
                face.addElement(new FaceInfo(newindex, f.v1, newindex + 1, vert, f.smoothness3, f.smoothness1, 0.0f));
            } else {
                face.addElement(new FaceInfo(f.v3, newindex + 1, newindex, vert, f.smoothness3, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, newindex, f.v2, vert, 1.0f, f.smoothness1, f.smoothness2));
                face.addElement(new FaceInfo(newindex + 1, f.v1, newindex, vert, f.smoothness3, f.smoothness1, 0.0f));
            }
        } else if (startType == 2 && endType == 1) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            face.removeElementAt(which);
            if (startVert == v1) {
                face.addElement(new FaceInfo(f.v1, newindex, newindex + 1, vert, f.smoothness1, 0.0f, 1.0f));
                face.addElement(new FaceInfo(newindex, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 1.0f));
            } else if (startVert == v2) {
                face.addElement(new FaceInfo(f.v2, newindex, newindex + 1, vert, f.smoothness2, 0.0f, 1.0f));
                face.addElement(new FaceInfo(newindex, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 1.0f));
            } else {
                face.addElement(new FaceInfo(f.v3, newindex, newindex + 1, vert, f.smoothness3, 0.0f, 1.0f));
                face.addElement(new FaceInfo(newindex, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 1.0f));
            }
        } else if (startType == 1 && endType == 2) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            face.removeElementAt(which);
            if (endVert == v1) {
                face.addElement(new FaceInfo(f.v1, newindex, newindex + 1, vert, f.smoothness1, 0.0f, 1.0f));
                face.addElement(new FaceInfo(newindex, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 1.0f));
            } else if (endVert == v2) {
                face.addElement(new FaceInfo(f.v2, newindex, newindex + 1, vert, f.smoothness2, 0.0f, 1.0f));
                face.addElement(new FaceInfo(newindex, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 1.0f));
            } else {
                face.addElement(new FaceInfo(f.v3, newindex, newindex + 1, vert, f.smoothness3, 0.0f, 1.0f));
                face.addElement(new FaceInfo(newindex, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 0.0f));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 1.0f));
            }
        } else if (startType == 1 && endType == 1) {
            Vec3 onLinePos;
            int onLine;
            double dx = startPos.x - endPos.x;
            double dy = startPos.y - endPos.y;
            double dz = startPos.z - endPos.z;
            if (dx < 1.0E-10 && dx > -1.0E-10 && dy < 1.0E-10 && dy > -1.0E-10 && dz < 1.0E-10 && dz > -1.0E-10) {
                int newindex6 = vert.size();
                vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                face.removeElementAt(which);
                face.addElement(new FaceInfo(f.v1, f.v2, newindex6, vert, f.smoothness1, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex6, vert, f.smoothness2, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex6, vert, f.smoothness3, 1.0f, 1.0f));
                return;
            }
            Vec3 d = new Vec3(endPos.x - v1.r.x, endPos.y - v1.r.y, endPos.z - v1.r.z);
            double dot1 = Math.abs((d.x * dx + d.y * dy + d.z * dz) / d.length());
            d.set(endPos.x - v2.r.x, endPos.y - v2.r.y, endPos.z - v2.r.z);
            double dot2 = Math.abs((d.x * dx + d.y * dy + d.z * dz) / d.length());
            d.set(endPos.x - v3.r.x, endPos.y - v3.r.y, endPos.z - v3.r.z);
            double dot3 = Math.abs((d.x * dx + d.y * dy + d.z * dz) / d.length());
            if (dot1 > dot2 && dot1 > dot3) {
                onLine = 1;
                onLinePos = v1.r;
            } else if (dot2 > dot3 && dot2 > dot1) {
                onLine = 2;
                onLinePos = v2.r;
            } else {
                onLine = 3;
                onLinePos = v3.r;
            }
            int newindex7 = vert.size();
            if (onLinePos.distance(startPos) > onLinePos.distance(endPos)) {
                vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            } else {
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            }
            face.removeElementAt(which);
            if (onLine == 3) {
                face.addElement(new FaceInfo(f.v1, f.v2, newindex7, vert, f.smoothness1, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, newindex7, newindex7 + 1, vert, 1.0f, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, newindex7 + 1, newindex7, vert, 1.0f, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, newindex7 + 1, f.v3, vert, 1.0f, 1.0f, f.smoothness3));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex7 + 1, vert, f.smoothness2, 1.0f, 1.0f));
            } else if (onLine == 1) {
                face.addElement(new FaceInfo(f.v2, f.v3, newindex7, vert, f.smoothness2, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, newindex7, newindex7 + 1, vert, 1.0f, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, newindex7 + 1, newindex7, vert, 1.0f, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v2, newindex7 + 1, f.v1, vert, 1.0f, 1.0f, f.smoothness1));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex7 + 1, vert, f.smoothness3, 1.0f, 1.0f));
            } else {
                face.addElement(new FaceInfo(f.v3, f.v1, newindex7, vert, f.smoothness3, 1.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, newindex7, newindex7 + 1, vert, 1.0f, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v1, newindex7 + 1, newindex7, vert, 1.0f, 0.0f, 1.0f));
                face.addElement(new FaceInfo(f.v3, newindex7 + 1, f.v2, vert, 1.0f, 1.0f, f.smoothness2));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex7 + 1, vert, f.smoothness1, 1.0f, 1.0f));
            }
        }
    }

    private void findInsideVertices(Vector v1, Vector f1, Vector v2, Vector f2) {
        FaceInfo f;
        Vec3 orig = new Vec3();
        Vec3 dir2 = new Vec3();
        int[] faceCount = new int[v1.size()];
        int i = 0;
        while (i < f1.size()) {
            FaceInfo f3 = (FaceInfo)f1.elementAt(i);
            int n = f3.v1;
            faceCount[n] = faceCount[n] + 1;
            int n2 = f3.v2;
            faceCount[n2] = faceCount[n2] + 1;
            int n3 = f3.v3;
            faceCount[n3] = faceCount[n3] + 1;
            ++i;
        }
        int[][] vertFace = new int[v1.size()][];
        i = 0;
        while (i < vertFace.length) {
            vertFace[i] = new int[faceCount[i]];
            faceCount[i] = 0;
            ++i;
        }
        i = 0;
        while (i < f1.size()) {
            f = (FaceInfo)f1.elementAt(i);
            int n = f.v1;
            int n4 = faceCount[n];
            faceCount[n] = n4 + 1;
            vertFace[f.v1][n4] = i;
            int n5 = f.v2;
            int n6 = faceCount[n5];
            faceCount[n5] = n6 + 1;
            vertFace[f.v2][n6] = i;
            int n7 = f.v3;
            int n8 = faceCount[n7];
            faceCount[n7] = n8 + 1;
            vertFace[f.v3][n8] = i++;
        }
        i = 0;
        while (i < f1.size()) {
            f = (FaceInfo)f1.elementAt(i);
            if (f.type == 0) {
                f.type = this.classifyFace(f, v1, v2, f2);
                VertexInfo vi1 = (VertexInfo)v1.elementAt(f.v1);
                VertexInfo vi2 = (VertexInfo)v1.elementAt(f.v2);
                VertexInfo vi3 = (VertexInfo)v1.elementAt(f.v3);
                int type = f.type;
                if (vi1.type == 0) {
                    this.markVertex(f.v1, type, v1, f1, vertFace);
                }
                if (vi2.type == 0) {
                    this.markVertex(f.v2, type, v1, f1, vertFace);
                }
                if (vi3.type == 0) {
                    this.markVertex(f.v3, type, v1, f1, vertFace);
                }
            }
            ++i;
        }
    }

    private int classifyFace(FaceInfo f, Vector v1, Vector v2, Vector f2) {
        VertexInfo vi1 = (VertexInfo)v1.elementAt(f.v1);
        VertexInfo vi2 = (VertexInfo)v1.elementAt(f.v2);
        VertexInfo vi3 = (VertexInfo)v1.elementAt(f.v3);
        Vec3 orig = new Vec3();
        Vec3 dir2 = new Vec3(f.norm);
        orig.set(vi1.r.x + vi2.r.x + vi3.r.x, vi1.r.y + vi2.r.y + vi3.r.y, vi1.r.z + vi2.r.z + vi3.r.z);
        orig.scale(0.3333333333333333);
        int first = -1;
        double firstDist = Double.MAX_VALUE;
        do {
            first = -1;
            firstDist = Double.MAX_VALUE;
            int j = 0;
            while (j < f2.size()) {
                FaceInfo fb = (FaceInfo)f2.elementAt(j);
                double dist = this.rayBoxIntersectionDist(orig, dir2, fb.bounds);
                if (!(dist >= firstDist)) {
                    VertexInfo vb1 = (VertexInfo)v2.elementAt(fb.v1);
                    VertexInfo vb2 = (VertexInfo)v2.elementAt(fb.v2);
                    VertexInfo vb3 = (VertexInfo)v2.elementAt(fb.v3);
                    dist = this.rayFaceIntersectionDist(orig, dir2, fb, vb1.r, vb2.r, vb3.r);
                    if (dist < firstDist) {
                        first = j;
                        firstDist = dist;
                    }
                    if (dist == -1.7976931348623157E308) break;
                }
                ++j;
            }
            if (firstDist != -1.7976931348623157E308) continue;
            dir2.x += 1.0E-5 * Math.random();
            dir2.y += 1.0E-5 * Math.random();
            dir2.z += 1.0E-5 * Math.random();
        } while (firstDist == -1.7976931348623157E308);
        if (firstDist == Double.MAX_VALUE) {
            return 3;
        }
        double dot = dir2.dot(((FaceInfo)f2.elementAt((int)first)).norm);
        if (firstDist > -1.0E-10 && firstDist < 1.0E-10) {
            if (dot > 0.0) {
                return 4;
            }
            return 5;
        }
        if (dot > 0.0) {
            return 2;
        }
        return 3;
    }

    private boolean intersect(BoundingBox b1, BoundingBox b2) {
        return !(b1.minx > b2.maxx + 1.0E-10 || b1.maxx < b2.minx - 1.0E-10 || b1.miny > b2.maxy + 1.0E-10 || b1.maxy < b2.miny - 1.0E-10 || b1.minz > b2.maxz + 1.0E-10) && !(b1.maxz < b2.minz - 1.0E-10);
    }

    private double rayBoxIntersectionDist(Vec3 origin, Vec3 direction, BoundingBox bb) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        if (direction.x == 0.0) {
            if (origin.x < bb.minx || origin.x > bb.maxx) {
                return Double.MAX_VALUE;
            }
        } else {
            t1 = (bb.minx - origin.x) / direction.x;
            t2 = (bb.maxx - origin.x) / direction.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return Double.MAX_VALUE;
            }
        }
        if (direction.y == 0.0) {
            if (origin.y < bb.miny || origin.y > bb.maxy) {
                return Double.MAX_VALUE;
            }
        } else {
            t1 = (bb.miny - origin.y) / direction.y;
            t2 = (bb.maxy - origin.y) / direction.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return Double.MAX_VALUE;
            }
        }
        if (direction.z == 0.0) {
            if (origin.z < bb.minz || origin.z > bb.maxz) {
                return Double.MAX_VALUE;
            }
        } else {
            t1 = (bb.minz - origin.z) / direction.z;
            t2 = (bb.maxz - origin.z) / direction.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return Double.MAX_VALUE;
            }
        }
        return mint;
    }

    private double rayFaceIntersectionDist(Vec3 orig, Vec3 dir2, FaceInfo f, Vec3 v1, Vec3 v2, Vec3 v3) {
        double vy;
        double vx;
        Vec2 edge2d2;
        Vec2 edge2d1;
        double vd = f.norm.dot(dir2);
        double v0 = f.norm.x * (v1.x - orig.x) + f.norm.y * (v1.y - orig.y) + f.norm.z * (v1.z - orig.z);
        if (vd > -1.0E-10 && vd < 1.0E-10) {
            if (v0 > -1.0E-10 && v0 < 1.0E-10) {
                return -1.7976931348623157E308;
            }
            return Double.MAX_VALUE;
        }
        double t = v0 / vd;
        if (t < -1.0E-10) {
            return Double.MAX_VALUE;
        }
        Vec3 ri = new Vec3(orig.x + dir2.x * t, orig.y + dir2.y * t, orig.z + dir2.z * t);
        if (f.norm.x > 0.5 || f.norm.x < -0.5) {
            edge2d1 = new Vec2(v1.y - v2.y, v1.z - v2.z);
            edge2d2 = new Vec2(v1.y - v3.y, v1.z - v3.z);
            vx = ri.y - v1.y;
            vy = ri.z - v1.z;
        } else if (f.norm.y > 0.5 || f.norm.y < -0.5) {
            edge2d1 = new Vec2(v1.x - v2.x, v1.z - v2.z);
            edge2d2 = new Vec2(v1.x - v3.x, v1.z - v3.z);
            vx = ri.x - v1.x;
            vy = ri.z - v1.z;
        } else {
            edge2d1 = new Vec2(v1.x - v2.x, v1.y - v2.y);
            edge2d2 = new Vec2(v1.x - v3.x, v1.y - v3.y);
            vx = ri.x - v1.x;
            vy = ri.y - v1.y;
        }
        double denom = 1.0 / edge2d1.cross(edge2d2);
        double v = (edge2d2.x * vy - edge2d2.y * vx) * denom;
        if (v < -1.0E-10 || v > 1.0000000001) {
            return Double.MAX_VALUE;
        }
        double w = (vx * edge2d1.y - vy * edge2d1.x) * denom;
        if (w < -1.0E-10 || w > 1.0000000001) {
            return Double.MAX_VALUE;
        }
        double u = 1.0 - v - w;
        if (u < -1.0E-10 || u > 1.0000000001) {
            return Double.MAX_VALUE;
        }
        return t;
    }

    private void markVertex(int which, int value, Vector v1, Vector f1, int[][] vertFace) {
        VertexInfo v = (VertexInfo)v1.elementAt(which);
        v.type = value;
        int i = 0;
        while (i < vertFace[which].length) {
            FaceInfo f = (FaceInfo)f1.elementAt(vertFace[which][i]);
            if (f.type == 0) {
                f.type = value;
                VertexInfo vi1 = (VertexInfo)v1.elementAt(f.v1);
                VertexInfo vi2 = (VertexInfo)v1.elementAt(f.v2);
                VertexInfo vi3 = (VertexInfo)v1.elementAt(f.v3);
                if (vi1.type == 0) {
                    this.markVertex(f.v1, value, v1, f1, vertFace);
                }
                if (vi2.type == 0) {
                    this.markVertex(f.v2, value, v1, f1, vertFace);
                }
                if (vi3.type == 0) {
                    this.markVertex(f.v3, value, v1, f1, vertFace);
                }
            }
            ++i;
        }
    }

    private double[] interpTextureParams(Vec3 pos, VertexInfo v1, VertexInfo v2, VertexInfo v3, FaceInfo f) {
        double vy;
        double vx;
        Vec2 edge2d2;
        Vec2 edge2d1;
        if (v1.param == null) {
            return null;
        }
        if (f.norm.x > 0.5 || f.norm.x < -0.5) {
            edge2d1 = new Vec2(v1.r.y - v2.r.y, v1.r.z - v2.r.z);
            edge2d2 = new Vec2(v1.r.y - v3.r.y, v1.r.z - v3.r.z);
            vx = pos.y - v1.r.y;
            vy = pos.z - v1.r.z;
        } else if (f.norm.y > 0.5 || f.norm.y < -0.5) {
            edge2d1 = new Vec2(v1.r.x - v2.r.x, v1.r.z - v2.r.z);
            edge2d2 = new Vec2(v1.r.x - v3.r.x, v1.r.z - v3.r.z);
            vx = pos.x - v1.r.x;
            vy = pos.z - v1.r.z;
        } else {
            edge2d1 = new Vec2(v1.r.x - v2.r.x, v1.r.y - v2.r.y);
            edge2d2 = new Vec2(v1.r.x - v3.r.x, v1.r.y - v3.r.y);
            vx = pos.x - v1.r.x;
            vy = pos.y - v1.r.y;
        }
        double denom = 1.0 / edge2d1.cross(edge2d2);
        double v = (edge2d2.x * vy - edge2d2.y * vx) * denom;
        double w = (vx * edge2d1.y - vy * edge2d1.x) * denom;
        double u = 1.0 - v - w;
        double[] param = new double[v1.param.length];
        int i = 0;
        while (i < param.length) {
            param[i] = u * v1.param[i] + v * v2.param[i] + w * v3.param[i];
            ++i;
        }
        return param;
    }

    class FaceInfo {
        int v1;
        int v2;
        int v3;
        int type;
        BoundingBox bounds;
        Vec3 norm;
        float smoothness1;
        float smoothness2;
        float smoothness3;
        double distRoot;

        public FaceInfo(int v1, int v2, int v3, Vector vertices, float s1, float s2, float s3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.smoothness1 = s1;
            this.smoothness2 = s2;
            this.smoothness3 = s3;
            this.type = 0;
            Vec3 vert1 = ((VertexInfo)vertices.elementAt((int)v1)).r;
            Vec3 vert2 = ((VertexInfo)vertices.elementAt((int)v2)).r;
            Vec3 vert3 = ((VertexInfo)vertices.elementAt((int)v3)).r;
            double minx = Math.min(Math.min(vert1.x, vert2.x), vert3.x);
            double miny = Math.min(Math.min(vert1.y, vert2.y), vert3.y);
            double minz = Math.min(Math.min(vert1.z, vert2.z), vert3.z);
            double maxx = Math.max(Math.max(vert1.x, vert2.x), vert3.x);
            double maxy = Math.max(Math.max(vert1.y, vert2.y), vert3.y);
            double maxz = Math.max(Math.max(vert1.z, vert2.z), vert3.z);
            this.bounds = new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
            this.norm = vert2.minus(vert1).cross(vert3.minus(vert1));
            double length = this.norm.length();
            if (length > 0.0) {
                this.norm.scale(1.0 / length);
            }
            this.distRoot = vert1.dot(this.norm);
        }
    }

    class VertexInfo {
        Vec3 r;
        float smoothness;
        double[] param;
        int type;

        public VertexInfo(Vec3 r, float smoothness, double[] param) {
            this.r = r;
            this.smoothness = smoothness;
            this.param = param;
            this.type = 0;
        }

        public VertexInfo(Vec3 r, float smoothness, double[] param, int type) {
            this.r = r;
            this.smoothness = smoothness;
            this.param = param;
            this.type = type;
        }
    }
}

