/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Callback;
import artofillusion.CurveEditorWindow;
import artofillusion.ObjectViewer;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.NullKeyframe;
import artofillusion.animation.Skeleton;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class Curve
extends Object3D
implements Mesh {
    MeshVertex[] vertex;
    float[] smoothness;
    boolean closed;
    BoundingBox bounds;
    int smoothingMethod;
    WireframeMesh cachedWire;

    public Curve(Vec3[] v, float[] smoothness, int smoothingMethod, boolean isClosed) {
        this.vertex = new MeshVertex[v.length];
        int i = 0;
        while (i < v.length) {
            this.vertex[i] = new MeshVertex(v[i]);
            ++i;
        }
        this.smoothness = smoothness;
        this.smoothingMethod = smoothingMethod;
        this.closed = isClosed;
    }

    public Object3D duplicate() {
        Vec3[] v = new Vec3[this.vertex.length];
        float[] s = new float[this.vertex.length];
        int i = 0;
        while (i < this.vertex.length) {
            v[i] = new Vec3(this.vertex[i].r);
            s[i] = this.smoothness[i];
            ++i;
        }
        return new Curve(v, s, this.smoothingMethod, this.closed);
    }

    public void copyObject(Object3D obj) {
        Curve cv = (Curve)obj;
        MeshVertex[] v = cv.getVertices();
        this.vertex = new MeshVertex[v.length];
        this.smoothness = new float[v.length];
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i] = new MeshVertex(new Vec3(v[i].r));
            this.smoothness[i] = cv.smoothness[i];
            ++i;
        }
        this.smoothingMethod = cv.smoothingMethod;
        this.setClosed(cv.closed);
        this.clearCachedMesh();
    }

    protected void findBounds() {
        double maxz;
        double maxy;
        double maxx;
        this.getWireframeMesh();
        Vec3[] points = this.cachedWire.vert;
        double minx = maxx = points[0].x;
        double miny = maxy = points[0].y;
        double minz = maxz = points[0].z;
        int i = 1;
        while (i < points.length) {
            Vec3 v = points[i];
            if (v.x < minx) {
                minx = v.x;
            }
            if (v.x > maxx) {
                maxx = v.x;
            }
            if (v.y < miny) {
                miny = v.y;
            }
            if (v.y > maxy) {
                maxy = v.y;
            }
            if (v.z < minz) {
                minz = v.z;
            }
            if (v.z > maxz) {
                maxz = v.z;
            }
            ++i;
        }
        this.bounds = new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    public BoundingBox getBounds() {
        if (this.bounds == null) {
            this.findBounds();
        }
        return this.bounds;
    }

    public MeshVertex[] getVertices() {
        return this.vertex;
    }

    public Vec3[] getVertexPositions() {
        Vec3[] v = new Vec3[this.vertex.length];
        int i = 0;
        while (i < v.length) {
            v[i] = this.vertex[i].r;
            ++i;
        }
        return v;
    }

    public float[] getSmoothness() {
        return this.smoothness;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void movePoint(int which, Vec3 pos) {
        this.vertex[which].r = pos;
        this.clearCachedMesh();
    }

    public void setVertices(Vec3[] v) {
        int i = 0;
        while (i < v.length) {
            this.vertex[i].r = v[i];
            ++i;
        }
        this.clearCachedMesh();
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
        this.clearCachedMesh();
    }

    public void setSmoothness(float[] s) {
        int i = 0;
        while (i < s.length) {
            this.smoothness[i] = s[i];
            ++i;
        }
        this.clearCachedMesh();
    }

    public void setShape(Vec3[] v, float[] smoothness) {
        if (v.length != this.vertex.length) {
            this.vertex = new MeshVertex[v.length];
        }
        int i = 0;
        while (i < v.length) {
            this.vertex[i] = new MeshVertex(v[i]);
            ++i;
        }
        this.smoothness = smoothness;
        this.clearCachedMesh();
    }

    public void setClosed(boolean isClosed) {
        this.closed = isClosed;
        this.clearCachedMesh();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        Vec3 size = this.bounds.getSize();
        double xscale = size.x == 0.0 ? 1.0 : xsize / size.x;
        double yscale = size.y == 0.0 ? 1.0 : ysize / size.y;
        double zscale = size.z == 0.0 ? 1.0 : zsize / size.z;
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i].r.x *= xscale;
            this.vertex[i].r.y *= yscale;
            this.vertex[i].r.z *= zscale;
            ++i;
        }
        this.clearCachedMesh();
    }

    protected void clearCachedMesh() {
        this.cachedWire = null;
        this.bounds = null;
    }

    public WireframeMesh getWireframeMesh() {
        int[] to;
        int[] from;
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        Curve subdiv = this.smoothingMethod == 0 ? this : this.subdivideCurve().subdivideCurve();
        Vec3[] vert = new Vec3[subdiv.vertex.length];
        int i = 0;
        while (i < vert.length) {
            vert[i] = subdiv.vertex[i].r;
            ++i;
        }
        if (this.closed) {
            from = new int[vert.length];
            to = new int[vert.length];
            from[vert.length - 1] = vert.length - 1;
            to[vert.length - 1] = 0;
        } else {
            from = new int[vert.length - 1];
            to = new int[vert.length - 1];
        }
        i = 0;
        while (i < vert.length - 1) {
            from[i] = i;
            to[i] = i + 1;
            ++i;
        }
        this.cachedWire = new WireframeMesh(vert, from, to);
        return this.cachedWire;
    }

    public Curve subdivideCurve() {
        float[] news;
        Vec3[] newpos;
        if (this.vertex.length < 2) {
            return (Curve)this.duplicate();
        }
        if (this.vertex.length == 2) {
            Vec3[] newpos2 = new Vec3[]{new Vec3(this.vertex[0].r), this.vertex[0].r.plus(this.vertex[1].r).times(0.5), new Vec3(this.vertex[1].r)};
            float[] news2 = new float[]{this.smoothness[0], (this.smoothness[0] + this.smoothness[1]) * 0.5f, this.smoothness[1]};
            return new Curve(newpos2, news2, this.smoothingMethod, this.closed);
        }
        Vec3[] v = new Vec3[this.vertex.length];
        int i = 0;
        while (i < v.length) {
            v[i] = new Vec3(this.vertex[i].r);
            ++i;
        }
        if (this.closed) {
            int i2;
            newpos = new Vec3[v.length * 2];
            news = new float[this.smoothness.length * 2];
            if (this.smoothingMethod == 2) {
                newpos[0] = v[0];
                newpos[1] = Curve.calcInterpPoint(v, this.smoothness, v.length - 1, 0, 1, 2);
                i2 = 2;
                int j = 1;
                while (i2 < newpos.length) {
                    if (i2 % 2 == 0) {
                        newpos[i2] = v[j];
                    } else {
                        newpos[i2] = Curve.calcInterpPoint(v, this.smoothness, j - 1, j, (j + 1) % v.length, (j + 2) % v.length);
                        ++j;
                    }
                    ++i2;
                }
            } else {
                newpos[0] = Curve.calcApproxPoint(v, this.smoothness, v.length - 1, 0, 1);
                i2 = 1;
                while (i2 < v.length - 1) {
                    newpos[i2 * 2 - 1] = v[i2].plus(v[i2 - 1]).times(0.5);
                    newpos[i2 * 2] = Curve.calcApproxPoint(v, this.smoothness, i2 - 1, i2, i2 + 1);
                    ++i2;
                }
                newpos[i2 * 2 - 1] = v[i2].plus(v[i2 - 1]).times(0.5);
                newpos[i2 * 2] = Curve.calcApproxPoint(v, this.smoothness, i2 - 1, i2, 0);
                newpos[i2 * 2 + 1] = v[0].plus(v[i2]).times(0.5);
            }
            i2 = 0;
            while (i2 < this.smoothness.length) {
                news[i2 * 2] = Math.min(this.smoothness[i2] * 2.0f, 1.0f);
                news[i2 * 2 + 1] = 1.0f;
                ++i2;
            }
        } else {
            int i2;
            newpos = new Vec3[v.length * 2 - 1];
            news = new float[this.smoothness.length * 2 - 1];
            if (this.smoothingMethod == 2) {
                newpos[0] = v[0];
                newpos[1] = Curve.calcInterpPoint(v, this.smoothness, 0, 0, 1, 2);
                i2 = 2;
                int j = 1;
                while (i2 < newpos.length - 2) {
                    if (i2 % 2 == 0) {
                        newpos[i2] = v[j];
                    } else {
                        newpos[i2] = Curve.calcInterpPoint(v, this.smoothness, j - 1, j, j + 1, j + 2);
                        ++j;
                    }
                    ++i2;
                }
                newpos[i2] = Curve.calcInterpPoint(v, this.smoothness, j - 1, j, j + 1, j + 1);
                newpos[i2 + 1] = v[j + 1];
            } else {
                newpos[0] = v[0];
                i2 = 1;
                while (i2 < v.length - 1) {
                    newpos[i2 * 2 - 1] = v[i2].plus(v[i2 - 1]).times(0.5);
                    newpos[i2 * 2] = Curve.calcApproxPoint(v, this.smoothness, i2 - 1, i2, i2 + 1);
                    ++i2;
                }
                newpos[i2 * 2 - 1] = v[i2].plus(v[i2 - 1]).times(0.5);
                newpos[i2 * 2] = v[i2];
            }
            i2 = 0;
            while (i2 < this.smoothness.length - 1) {
                news[i2 * 2] = Math.min(this.smoothness[i2] * 2.0f, 1.0f);
                news[i2 * 2 + 1] = 1.0f;
                ++i2;
            }
            news[i2 * 2] = Math.min(this.smoothness[i2] * 2.0f, 1.0f);
        }
        return new Curve(newpos, news, this.smoothingMethod, this.closed);
    }

    public Curve subdivideCurve(int times) {
        Curve c = this;
        int i = 0;
        while (i < times) {
            c = c.subdivideCurve();
            ++i;
        }
        return c;
    }

    public static Vec3 calcInterpPoint(Vec3[] v, float[] s, int i, int j, int k, int m) {
        double w1 = -0.0625 * (double)s[j];
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * (double)s[k];
        double w3 = 0.5 - w4;
        return new Vec3(w1 * v[i].x + w2 * v[j].x + w3 * v[k].x + w4 * v[m].x, w1 * v[i].y + w2 * v[j].y + w3 * v[k].y + w4 * v[m].y, w1 * v[i].z + w2 * v[j].z + w3 * v[k].z + w4 * v[m].z);
    }

    public static Vec3 calcApproxPoint(Vec3[] v, float[] s, int i, int j, int k) {
        double w1 = 0.125 * (double)s[j];
        double w2 = 1.0 - 2.0 * w1;
        return new Vec3(w1 * v[i].x + w2 * v[j].x + w1 * v[k].x, w1 * v[i].y + w2 * v[j].y + w1 * v[k].y, w1 * v[i].z + w2 * v[j].z + w1 * v[k].z);
    }

    public boolean canSetTexture() {
        return false;
    }

    public int canConvertToTriangleMesh() {
        if (this.closed) {
            return 1;
        }
        return 0;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        TriangleMesh mesh = this.triangulateCurve();
        if (mesh != null) {
            mesh = TriangleMesh.optimizeMesh(mesh);
        }
        return mesh;
    }

    private TriangleMesh triangulateCurve() {
        double dir2;
        Vec3[] v = new Vec3[this.vertex.length];
        Vec3 size = this.getBounds().getSize();
        Vec2[] v2 = new Vec2[this.vertex.length];
        int[] index = new int[this.vertex.length];
        int[][] faces = new int[this.vertex.length - 2][3];
        int j = size.x > size.y ? (size.y > size.z ? 2 : 1) : (size.x > size.z ? 2 : 0);
        int i = 0;
        while (i < this.vertex.length) {
            v[i] = this.vertex[i].r;
            v2[i] = this.vertex[i].r.dropAxis(j);
            ++i;
        }
        int min = 0;
        i = 1;
        while (i < v2.length) {
            if (v2[i].x < v2[min].x) {
                min = i;
            }
            ++i;
        }
        i = 0;
        while (i < index.length) {
            index[i] = i;
            ++i;
        }
        int current = min;
        do {
            if ((dir2 = this.triangleDirection(v2, index, v2.length, current)) != 0.0 || (current = (current + 1) % index.length) != min) continue;
            return null;
        } while (dir2 == 0.0);
        int count = index.length;
        i = 0;
        while (i < this.vertex.length - 2) {
            boolean inside;
            double dir22;
            j = current;
            do {
                dir22 = this.triangleDirection(v2, index, count, current);
                inside = this.containsPoints(v2, index, count, current);
                if (!(dir22 * dir2 < 0.0) && !inside || (current = (current + 1) % count) != j) continue;
                return null;
            } while (dir22 * dir2 < 0.0 || inside);
            faces[i][0] = current == 0 ? index[count - 1] : index[current - 1];
            faces[i][1] = index[current];
            faces[i][2] = current == count - 1 ? index[0] : index[current + 1];
            j = current;
            while (j < count - 1) {
                index[j] = index[j + 1];
                ++j;
            }
            current = (current + 1) % --count;
            ++i;
        }
        TriangleMesh mesh = new TriangleMesh(v, faces);
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])mesh.getVertices();
        i = 0;
        while (i < vert.length) {
            vert[i].smoothness = this.smoothness[i];
            ++i;
        }
        mesh.setSmoothingMethod(this.smoothingMethod);
        return mesh;
    }

    double triangleDirection(Vec2[] v2, int[] index, int count, int which) {
        Vec2 va = which == 0 ? v2[index[which]].minus(v2[index[count - 1]]) : v2[index[which]].minus(v2[index[which - 1]]);
        Vec2 vb = which == count - 1 ? v2[index[which]].minus(v2[index[0]]) : v2[index[which]].minus(v2[index[which + 1]]);
        return va.cross(vb);
    }

    boolean containsPoints(Vec2[] v2, int[] index, int count, int which) {
        int prev = which == 0 ? count - 1 : which - 1;
        int next = which == count - 1 ? 0 : which + 1;
        Vec2 va = v2[index[which]].minus(v2[index[prev]]);
        Vec2 vb = v2[index[which]].minus(v2[index[next]]);
        double a = va.cross(vb);
        va.scale(1.0 / a);
        vb.scale(1.0 / a);
        int i = 0;
        while (i < count) {
            double c;
            Vec2 v;
            double b;
            if (i != prev && i != which && i != next && (a = 1.0 - (b = vb.cross(v = v2[index[i]].minus(v2[index[which]]))) - (c = v.cross(va))) >= 0.0 && a <= 1.0 && b >= 0.0 && b <= 1.0 && c >= 0.0 && c <= 1.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vec3[] getNormals() {
        return null;
    }

    public boolean editable() {
        return true;
    }

    public Skeleton getSkeleton() {
        return null;
    }

    public void setSkeleton(Skeleton s) {
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        CurveEditorWindow ed = new CurveEditorWindow(parent, "Curve object '" + info.name + "'", info, cb);
        ((ObjectViewer)ed.getView()).setScene(parent.getScene(), info);
        ed.show();
    }

    public Curve(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.vertex = new MeshVertex[in.readInt()];
        this.smoothness = new float[this.vertex.length];
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i] = new MeshVertex(new Vec3(in));
            this.smoothness[i] = in.readFloat();
            ++i;
        }
        this.closed = in.readBoolean();
        this.smoothingMethod = in.readInt();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeInt(this.vertex.length);
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i].r.writeToFile(out);
            out.writeFloat(this.smoothness[i]);
            ++i;
        }
        out.writeBoolean(this.closed);
        out.writeInt(this.smoothingMethod);
    }

    public Keyframe getPoseKeyframe() {
        return new NullKeyframe();
    }

    public void applyPoseKeyframe(Keyframe k) {
    }
}

