/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.object.Object3D;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public abstract class Light
extends Object3D {
    RGBColor color;
    float intensity;
    float decayRate;
    boolean ambient;

    public Light() {
    }

    public Light(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
    }

    public void setParameters(RGBColor theColor, float theIntensity, boolean isAmbient, float decay) {
        this.color = theColor;
        this.intensity = theIntensity;
        this.ambient = isAmbient;
        this.decayRate = decay;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void getLight(RGBColor light, float distance) {
        double d = distance * this.decayRate;
        light.copy(this.color);
        light.scale((double)this.intensity / (1.0 + d + d * d));
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public float getDecayRate() {
        return this.decayRate;
    }
}

