/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.math.Vec3;

public class MeshVertex {
    public Vec3 r;
    public double[] param;
    public int ikJoint;
    public double ikWeight;

    public MeshVertex(Vec3 p) {
        this.r = p;
        this.ikJoint = -1;
        this.ikWeight = 1.0;
    }

    public MeshVertex(MeshVertex v) {
        this.r = new Vec3(v.r);
        this.ikJoint = v.ikJoint;
        this.ikWeight = v.ikWeight;
        if (v.param == null) {
            return;
        }
        this.param = new double[v.param.length];
        System.arraycopy(v.param, 0, this.param, 0, this.param.length);
    }

    public static MeshVertex blend(MeshVertex v1, MeshVertex v2, double w1, double w2) {
        MeshVertex v = new MeshVertex(new Vec3(w1 * v1.r.x + w2 * v2.r.x, w1 * v1.r.y + w2 * v2.r.y, w1 * v1.r.z + w2 * v2.r.z));
        if (v1.ikJoint == v2.ikJoint) {
            v.ikJoint = v1.ikJoint;
            v.ikWeight = w1 * v1.ikWeight + w2 * v2.ikWeight;
        } else if (v2.ikWeight > v1.ikWeight) {
            v.ikJoint = v2.ikJoint;
            v.ikWeight = v2.ikWeight;
        } else {
            v.ikJoint = v1.ikJoint;
            v.ikWeight = v1.ikWeight;
        }
        if (v1.param == null) {
            return v;
        }
        v.param = new double[v1.param.length];
        int i = 0;
        while (i < v.param.length) {
            v.param[i] = w1 * v1.param[i] + w2 * v2.param[i];
            ++i;
        }
        return v;
    }
}

