/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Callback;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.math.BoundingBox;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class SpotLight
extends Light {
    double radius;
    double angle;
    double falloff;
    double cosangle;
    double exponent;
    static BoundingBox bounds;
    static WireframeMesh mesh;
    static final int SEGMENTS = 8;

    public SpotLight(RGBColor theColor, float theIntensity, double theAngle, double falloffRate, double theRadius) {
        this(theColor, theIntensity, theAngle, falloffRate, theRadius, false, 0.25f);
    }

    public SpotLight(RGBColor theColor, float theIntensity, double theAngle, double falloffRate, double theRadius, boolean isAmbient, float decay) {
        this.setParameters(theColor, theIntensity, isAmbient, decay);
        this.setRadius(theRadius);
        this.setAngle(theAngle);
        this.setFalloff(falloffRate);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double a) {
        this.angle = a;
        this.cosangle = Math.cos(this.angle * Math.PI / 360.0);
    }

    public double getFalloff() {
        return this.falloff;
    }

    public void setFalloff(double f) {
        this.falloff = f;
        this.exponent = f * f * 128.0;
    }

    public double getAngleCosine() {
        return this.cosangle;
    }

    public double getExponent() {
        return this.exponent;
    }

    public Object3D duplicate() {
        return new SpotLight(this.color, this.intensity, this.angle, this.falloff, this.radius, this.ambient, this.decayRate);
    }

    public void copyObject(Object3D obj) {
        SpotLight lt = (SpotLight)obj;
        this.setParameters(lt.color.duplicate(), lt.intensity, lt.ambient, lt.decayRate);
        this.setRadius(lt.radius);
        this.setAngle(lt.angle);
        this.setFalloff(lt.falloff);
    }

    public BoundingBox getBounds() {
        return bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean canSetTexture() {
        return false;
    }

    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    public boolean editable() {
        return true;
    }

    public SpotLight(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setParameters(new RGBColor(in), in.readFloat(), in.readBoolean(), in.readFloat());
        this.setRadius(in.readDouble());
        this.setAngle(in.readDouble());
        this.setFalloff(in.readDouble());
        bounds = new BoundingBox(-0.2, 0.2, -0.2, 0.2, -0.2, 0.2);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        this.color.writeToFile(out);
        out.writeFloat(this.intensity);
        out.writeBoolean(this.ambient);
        out.writeFloat(this.decayRate);
        out.writeDouble(this.radius);
        out.writeDouble(this.angle);
        out.writeDouble(this.falloff);
    }

    public void edit(EditingWindow parent, ObjectInfo info, final Callback cb) {
        final Panel patch = this.color.getSample(50, 30);
        final ValueField intensityField = new ValueField(this.intensity, 0);
        final ValueField radiusField = new ValueField(this.radius, 1);
        final ValueField decayField = new ValueField(this.decayRate, 1);
        final ValueSlider angleSlider = new ValueSlider(0.0, 180.0, 180, this.angle);
        final ValueSlider falloffSlider = new ValueSlider(0.0, 1.0, 100, this.falloff);
        final Checkbox ambientBox = new Checkbox("Ambient", this.ambient);
        final Preview preview = new Preview(100);
        final RGBColor oldColor = this.color.duplicate();
        final Frame parentFrame = (Frame)((Object)parent);
        final Dialog dlg = new Dialog(parentFrame, "Spot Light", true);
        GridBagConstraints gc = new GridBagConstraints();
        dlg.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        dlg.add((Component)new Label("Cone Angle"), gc);
        dlg.add((Component)new Label("Falloff Rate"), gc);
        dlg.add((Component)new Label("Color"), gc);
        dlg.add((Component)new Label("Intensity"), gc);
        dlg.add((Component)new Label("Radius"), gc);
        dlg.add((Component)new Label("Decay Rate"), gc);
        gc.gridx = 1;
        gc.gridwidth = 2;
        gc.fill = 2;
        dlg.add((Component)angleSlider, gc);
        dlg.add((Component)falloffSlider, gc);
        gc.gridwidth = 1;
        dlg.add((Component)patch, gc);
        dlg.add((Component)intensityField, gc);
        dlg.add((Component)radiusField, gc);
        dlg.add((Component)decayField, gc);
        gc.gridwidth = 1;
        dlg.add((Component)ambientBox, gc);
        gc.gridx = 2;
        gc.gridheight = 5;
        gc.fill = 0;
        gc.anchor = 10;
        dlg.add((Component)preview, gc);
        Panel p = new Panel();
        gc.gridx = 0;
        gc.gridheight = 1;
        gc.gridwidth = 3;
        dlg.add((Component)p, gc);
        Button btn = new Button("Ok");
        p.add(btn);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpotLight.this.setParameters(SpotLight.this.color, (float)intensityField.getValue(), ambientBox.getState(), (float)decayField.getValue());
                SpotLight.this.setRadius(radiusField.getValue());
                SpotLight.this.setAngle(angleSlider.getValue());
                SpotLight.this.setFalloff(falloffSlider.getValue());
                dlg.dispose();
                cb.execute();
            }
        });
        btn = new Button("Cancel");
        p.add(btn);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpotLight.this.color.copy(oldColor);
                dlg.dispose();
            }
        });
        patch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser(parentFrame, "Light Color", SpotLight.this.color);
                ((Component)e.getSource()).setBackground(SpotLight.this.color.getColor());
                patch.repaint();
                preview.updateImage(angleSlider.getValue(), falloffSlider.getValue());
            }
        });
        AdjustmentListener al = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                preview.updateImage(angleSlider.getValue(), falloffSlider.getValue());
            }
        };
        angleSlider.addAdjustmentListener(al);
        falloffSlider.addAdjustmentListener(al);
        dlg.pack();
        dlg.show();
    }

    public Keyframe getPoseKeyframe() {
        return new SpotLightKeyframe(this.color, this.intensity, this.decayRate, this.radius, this.angle, this.falloff);
    }

    public void applyPoseKeyframe(Keyframe k) {
        SpotLightKeyframe key = (SpotLightKeyframe)k;
        this.setParameters(key.color.duplicate(), key.intensity, this.ambient, key.decayRate);
        this.setRadius(key.radius);
        this.setAngle(key.angle);
        this.setFalloff(key.falloff);
    }

    public String[] getPoseValueNames() {
        return new String[]{"Intensity", "Decay Rate", "Radius", "Cone Angle", "Falloff Rate"};
    }

    public double[] getDefaultPoseValues() {
        return new double[]{this.intensity, this.decayRate, this.radius, this.angle, this.falloff};
    }

    public double[][] getPoseValueRange() {
        return new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, 180.0}, {0.0, 1.0}};
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        final SpotLightKeyframe key = (SpotLightKeyframe)k;
        final Panel patch = key.color.getSample(50, 30);
        final ValueField intensityField = new ValueField(key.intensity, 0);
        final ValueField radiusField = new ValueField(key.radius, 1);
        final ValueField decayField = new ValueField(key.decayRate, 1);
        final ValueSlider angleSlider = new ValueSlider(0.0, 180.0, 180, key.angle);
        final ValueSlider falloffSlider = new ValueSlider(0.0, 1.0, 100, key.falloff);
        final Preview preview = new Preview(100);
        final RGBColor oldColor = key.color.duplicate();
        final Frame parentFrame = (Frame)((Object)parent);
        final Dialog dlg = new Dialog(parentFrame, "Spot Light Keyframe", true);
        GridBagConstraints gc = new GridBagConstraints();
        dlg.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        dlg.add((Component)new Label("Cone Angle"), gc);
        dlg.add((Component)new Label("Falloff Rate"), gc);
        dlg.add((Component)new Label("Color"), gc);
        dlg.add((Component)new Label("Intensity"), gc);
        dlg.add((Component)new Label("Radius"), gc);
        dlg.add((Component)new Label("Decay Rate"), gc);
        gc.gridx = 1;
        gc.gridwidth = 2;
        gc.fill = 2;
        dlg.add((Component)angleSlider, gc);
        dlg.add((Component)falloffSlider, gc);
        gc.gridwidth = 1;
        dlg.add((Component)patch, gc);
        dlg.add((Component)intensityField, gc);
        dlg.add((Component)radiusField, gc);
        dlg.add((Component)decayField, gc);
        gc.gridx = 2;
        gc.gridheight = 4;
        gc.fill = 0;
        gc.anchor = 10;
        dlg.add((Component)preview, gc);
        Panel p = new Panel();
        gc.gridx = 0;
        gc.gridheight = 1;
        gc.gridwidth = 3;
        dlg.add((Component)p, gc);
        Button btn = new Button("Ok");
        p.add(btn);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                key.intensity = (float)intensityField.getValue();
                key.decayRate = (float)decayField.getValue();
                key.radius = radiusField.getValue();
                key.angle = angleSlider.getValue();
                key.falloff = falloffSlider.getValue();
                dlg.dispose();
            }
        });
        btn = new Button("Cancel");
        p.add(btn);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                key.color.copy(oldColor);
                dlg.dispose();
            }
        });
        patch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser(parentFrame, "Light Color", key.color);
                ((Component)e.getSource()).setBackground(key.color.getColor());
                patch.repaint();
                preview.updateImage(angleSlider.getValue(), falloffSlider.getValue());
            }
        });
        AdjustmentListener al = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                preview.updateImage(angleSlider.getValue(), falloffSlider.getValue());
            }
        };
        angleSlider.addAdjustmentListener(al);
        falloffSlider.addAdjustmentListener(al);
        dlg.pack();
        dlg.show();
    }

    static {
        double[] sine = new double[8];
        double[] cosine = new double[8];
        bounds = new BoundingBox(-0.2, 0.2, -0.2, 0.2, -0.2, 0.2);
        int i = 0;
        while (i < 8) {
            sine[i] = Math.sin((double)i * 2.0 * Math.PI / 8.0);
            cosine[i] = Math.cos((double)i * 2.0 * Math.PI / 8.0);
            ++i;
        }
        Vec3[] vert = new Vec3[25];
        int[] from = new int[24];
        int[] to = new int[24];
        vert[24] = new Vec3(0.0, 0.0, -0.2);
        i = 0;
        while (i < 8) {
            vert[i] = new Vec3(0.075 * cosine[i], 0.075 * sine[i], -0.05);
            vert[i + 8] = new Vec3(0.1 * cosine[i], 0.1 * sine[i], 0.0);
            vert[i + 16] = new Vec3(0.2 * cosine[i], 0.2 * sine[i], 0.2);
            from[i] = 24;
            to[i] = i;
            from[i + 8] = i;
            to[i + 8] = (i + 1) % 8;
            from[i + 16] = i + 8;
            to[i + 16] = i + 16;
            ++i;
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    private class Preview
    extends Canvas {
        MemoryImageSource imageSource;
        int[] pixel;
        int size;
        Image img;

        public Preview(int size) {
            this.size = size;
            this.pixel = new int[size * size];
            this.imageSource = new MemoryImageSource(size, size, this.pixel, 0, size);
            this.imageSource.setAnimated(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.imageSource);
            this.updateImage(SpotLight.this.angle, SpotLight.this.falloff);
        }

        public synchronized void updateImage(double ang, double fall) {
            double center = (double)this.size / 2.0;
            double tn = Math.tan(ang * Math.PI / 360.0);
            double ex = fall * fall * 128.0;
            RGBColor col = new RGBColor(0.0f, 0.0f, 0.0f);
            int i = 0;
            while (i < this.size) {
                int first = (int)Math.abs(((double)i - center) / tn);
                if (first > this.size) {
                    first = this.size;
                }
                int j = 0;
                while (j < first) {
                    this.pixel[i * this.size + j] = -16777216;
                    ++j;
                }
                j = first;
                while (j < this.size) {
                    double cs = (double)j / Math.sqrt((double)(j * j) + ((double)i - center) * ((double)i - center));
                    col.copy(SpotLight.this.color);
                    col.scale(Math.pow(cs, ex));
                    this.pixel[i * this.size + j] = col.getARGB();
                    ++j;
                }
                ++i;
            }
            this.imageSource.newPixels();
            this.repaint();
        }

        public void paint(Graphics g) {
            g.drawImage(this.img, 0, 0, this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.size, this.size);
        }
    }

    public static class SpotLightKeyframe
    implements Keyframe {
        public RGBColor color;
        public float intensity;
        public float decayRate;
        public double radius;
        public double angle;
        public double falloff;

        public SpotLightKeyframe(RGBColor color, float intensity, float decayRate, double radius, double angle, double falloff) {
            this.color = color.duplicate();
            this.intensity = intensity;
            this.decayRate = decayRate;
            this.radius = radius;
            this.angle = angle;
            this.falloff = falloff;
        }

        public Keyframe duplicate() {
            return new SpotLightKeyframe(this.color, this.intensity, this.decayRate, this.radius, this.angle, this.falloff);
        }

        public Keyframe duplicate(Object owner) {
            return this.duplicate();
        }

        public double[] getGraphValues() {
            return new double[]{this.intensity, this.decayRate, this.radius, this.angle, this.falloff};
        }

        public void setGraphValues(double[] values) {
            this.intensity = (float)values[0];
            this.decayRate = (float)values[1];
            this.radius = values[2];
            this.angle = values[3];
            this.falloff = values[4];
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            SpotLightKeyframe k2 = (SpotLightKeyframe)o2;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue());
            return new SpotLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate), weight1 * this.radius + weight2 * k2.radius, weight1 * this.angle + weight2 * k2.angle, weight1 * this.falloff + weight2 * k2.falloff);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            SpotLightKeyframe k2 = (SpotLightKeyframe)o2;
            SpotLightKeyframe k3 = (SpotLightKeyframe)o3;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue());
            return new SpotLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate + weight3 * (double)k3.decayRate), weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius, weight1 * this.angle + weight2 * k2.angle + weight3 * k3.angle, weight1 * this.falloff + weight2 * k2.falloff + weight3 * k3.falloff);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            SpotLightKeyframe k2 = (SpotLightKeyframe)o2;
            SpotLightKeyframe k3 = (SpotLightKeyframe)o3;
            SpotLightKeyframe k4 = (SpotLightKeyframe)o4;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed() + weight4 * (double)k4.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen() + weight4 * (double)k4.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue() + weight4 * (double)k4.color.getBlue());
            return new SpotLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity + weight4 * (double)k4.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate + weight3 * (double)k3.decayRate + weight4 * (double)k4.decayRate), weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius + weight4 * k4.radius, weight1 * this.angle + weight2 * k2.angle + weight3 * k3.angle + weight4 * k4.angle, weight1 * this.falloff + weight2 * k2.falloff + weight3 * k3.falloff + weight4 * k4.falloff);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof SpotLightKeyframe)) {
                return false;
            }
            SpotLightKeyframe key = (SpotLightKeyframe)k;
            return key.color.equals(this.color) && key.intensity == this.intensity && key.decayRate == this.decayRate && key.radius == this.radius && key.angle == this.angle && key.falloff == this.falloff;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            this.color.writeToFile(out);
            out.writeFloat(this.intensity);
            out.writeFloat(this.decayRate);
            out.writeDouble(this.radius);
            out.writeDouble(this.angle);
            out.writeDouble(this.falloff);
        }

        public SpotLightKeyframe(DataInputStream in, Object parent) throws IOException {
            this(new RGBColor(in), in.readFloat(), in.readFloat(), in.readDouble(), in.readDouble(), in.readDouble());
        }
    }
}

