/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Callback;
import artofillusion.ModellingApp;
import artofillusion.ObjectViewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.TriMeshEditorWindow;
import artofillusion.WireframeMesh;
import artofillusion.animation.Actor;
import artofillusion.animation.ActorPose;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.Skeleton;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Vector;

public class TriangleMesh
extends Object3D
implements Mesh {
    Vertex[] vertex;
    Edge[] edge;
    Face[] face;
    Skeleton skeleton;
    boolean closed;
    BoundingBox bounds;
    int smoothingMethod = 1;
    RenderingMesh cachedMesh;
    WireframeMesh cachedWire;
    TextureParameter[] parameter;
    private static double[] LOOP_BETA;
    private static double[][] BUTTERFLY_COEFF;
    private static final int MAX_SUBDIVISIONS = 20;

    public TriangleMesh(Vec3[] v, int[][] faces) {
        this.setSkeleton(new Skeleton());
        Vertex[] vt = new Vertex[v.length];
        int i = 0;
        while (i < v.length) {
            vt[i] = new Vertex(v[i]);
            ++i;
        }
        this.setShape(vt, faces);
    }

    public TriangleMesh(Vertex[] v, int[][] faces) {
        this.setSkeleton(new Skeleton());
        this.setShape(v, faces);
    }

    private TriangleMesh() {
    }

    public Object3D duplicate() {
        TriangleMesh mesh = new TriangleMesh();
        mesh.setTexture(this.theTexture);
        if (this.texMapping != null) {
            mesh.setTextureMapping(this.texMapping.duplicate());
        }
        mesh.setMaterial(this.theMaterial);
        if (this.matMapping != null) {
            mesh.setMaterialMapping(this.matMapping.duplicate());
        }
        mesh.vertex = new Vertex[this.vertex.length];
        mesh.edge = new Edge[this.edge.length];
        mesh.face = new Face[this.face.length];
        int i = 0;
        while (i < this.vertex.length) {
            mesh.vertex[i] = mesh.new Vertex(this.vertex[i]);
            ++i;
        }
        i = 0;
        while (i < this.edge.length) {
            mesh.edge[i] = mesh.new Edge(this.edge[i].v1, this.edge[i].v2, this.edge[i].f1);
            mesh.edge[i].f2 = this.edge[i].f2;
            mesh.edge[i].smoothness = this.edge[i].smoothness;
            ++i;
        }
        i = 0;
        while (i < this.face.length) {
            mesh.face[i] = mesh.new Face(this.face[i].v1, this.face[i].v2, this.face[i].v3, this.face[i].e1, this.face[i].e2, this.face[i].e3);
            ++i;
        }
        mesh.skeleton = this.skeleton.duplicate();
        mesh.setSmoothingMethod(this.smoothingMethod);
        mesh.closed = this.closed;
        return mesh;
    }

    public void copyObject(Object3D obj) {
        TriangleMesh mesh = (TriangleMesh)obj;
        this.parameter = null;
        this.setTexture(mesh.getTexture());
        if (mesh.getTextureMapping() != null) {
            this.setTextureMapping(mesh.getTextureMapping().duplicate());
        }
        this.setMaterial(mesh.getMaterial());
        if (mesh.getMaterialMapping() != null) {
            this.setMaterialMapping(mesh.getMaterialMapping().duplicate());
        }
        this.vertex = new Vertex[mesh.vertex.length];
        this.edge = new Edge[mesh.edge.length];
        this.face = new Face[mesh.face.length];
        int i = 0;
        while (i < mesh.vertex.length) {
            this.vertex[i] = new Vertex(mesh.vertex[i]);
            ++i;
        }
        i = 0;
        while (i < mesh.edge.length) {
            this.edge[i] = new Edge(mesh.edge[i].v1, mesh.edge[i].v2, mesh.edge[i].f1);
            this.edge[i].f2 = mesh.edge[i].f2;
            this.edge[i].smoothness = mesh.edge[i].smoothness;
            ++i;
        }
        i = 0;
        while (i < mesh.face.length) {
            this.face[i] = new Face(mesh.face[i].v1, mesh.face[i].v2, mesh.face[i].v3, mesh.face[i].e1, mesh.face[i].e2, mesh.face[i].e3);
            ++i;
        }
        this.skeleton.copy(mesh.skeleton);
        this.setSmoothingMethod(mesh.getSmoothingMethod());
        this.closed = mesh.closed;
    }

    void findEdges(int[][] faces) {
        int numEdges1 = 0;
        int numEdges2 = 0;
        int numCopied = 0;
        int[][] faceEdges = new int[faces.length][3];
        int[] copiedEdges = new int[faces.length * 3];
        Edge[] edges1 = new Edge[faces.length * 3];
        Edge[] edges2 = new Edge[faces.length * 3];
        this.closed = true;
        int i = 0;
        while (i < faces.length) {
            if (faces[i][0] > faces[i][1]) {
                int n = numEdges1++;
                faceEdges[i][0] = n;
                edges1[n] = new Edge(faces[i][0], faces[i][1], i);
            } else {
                int n = numEdges2++;
                faceEdges[i][0] = n;
                edges2[n] = new Edge(faces[i][0], faces[i][1], i);
                int[] nArray = faceEdges[i];
                nArray[0] = nArray[0] + edges1.length;
            }
            if (faces[i][1] > faces[i][2]) {
                int n = numEdges1++;
                faceEdges[i][1] = n;
                edges1[n] = new Edge(faces[i][1], faces[i][2], i);
            } else {
                int n = numEdges2++;
                faceEdges[i][1] = n;
                edges2[n] = new Edge(faces[i][1], faces[i][2], i);
                int[] nArray = faceEdges[i];
                nArray[1] = nArray[1] + edges1.length;
            }
            if (faces[i][2] > faces[i][0]) {
                int n = numEdges1++;
                faceEdges[i][2] = n;
                edges1[n] = new Edge(faces[i][2], faces[i][0], i);
            } else {
                int n = numEdges2++;
                faceEdges[i][2] = n;
                edges2[n] = new Edge(faces[i][2], faces[i][0], i);
                int[] nArray = faceEdges[i];
                nArray[2] = nArray[2] + edges1.length;
            }
            ++i;
        }
        if (numEdges1 != numEdges2) {
            this.closed = false;
        }
        i = 0;
        while (i < numEdges2) {
            int j = 0;
            while (j < numEdges1 && (edges1[j].v1 != edges2[i].v2 || edges1[j].v2 != edges2[i].v1)) {
                ++j;
            }
            if (j == numEdges1) {
                copiedEdges[i] = numEdges1 + numCopied++;
                edges1[copiedEdges[i]] = edges2[i];
            } else {
                copiedEdges[i] = j;
                edges1[j].f2 = edges2[i].f1;
            }
            ++i;
        }
        if (numCopied > 0) {
            this.closed = false;
        }
        i = 0;
        while (i < faces.length) {
            if (faceEdges[i][0] >= edges1.length) {
                faceEdges[i][0] = copiedEdges[faceEdges[i][0] - edges1.length];
            }
            if (faceEdges[i][1] >= edges1.length) {
                faceEdges[i][1] = copiedEdges[faceEdges[i][1] - edges1.length];
            }
            if (faceEdges[i][2] >= edges1.length) {
                faceEdges[i][2] = copiedEdges[faceEdges[i][2] - edges1.length];
            }
            ++i;
        }
        this.edge = new Edge[numEdges1 + numCopied];
        i = 0;
        while (i < numEdges1 + numCopied) {
            this.edge[i] = edges1[i];
            ++i;
        }
        this.face = new Face[faces.length];
        i = 0;
        while (i < faces.length) {
            this.face[i] = new Face(faces[i][0], faces[i][1], faces[i][2], faceEdges[i][0], faceEdges[i][1], faceEdges[i][2]);
            ++i;
        }
    }

    private void findBounds() {
        double maxz;
        double maxy;
        double maxx;
        Vec3[] vert;
        if (this.cachedMesh != null) {
            vert = this.cachedMesh.vert;
        } else if (this.cachedWire != null) {
            vert = this.cachedWire.vert;
        } else {
            this.getWireframeMesh();
            vert = this.cachedWire.vert;
        }
        double minx = maxx = vert[0].x;
        double miny = maxy = vert[0].y;
        double minz = maxz = vert[0].z;
        int i = 1;
        while (i < vert.length) {
            if (vert[i].x < minx) {
                minx = vert[i].x;
            }
            if (vert[i].x > maxx) {
                maxx = vert[i].x;
            }
            if (vert[i].y < miny) {
                miny = vert[i].y;
            }
            if (vert[i].y > maxy) {
                maxy = vert[i].y;
            }
            if (vert[i].z < minz) {
                minz = vert[i].z;
            }
            if (vert[i].z > maxz) {
                maxz = vert[i].z;
            }
            ++i;
        }
        this.bounds = new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    public BoundingBox getBounds() {
        if (this.bounds == null) {
            this.findBounds();
        }
        return this.bounds;
    }

    public MeshVertex[] getVertices() {
        return this.vertex;
    }

    public Edge[] getEdges() {
        return this.edge;
    }

    public Face[] getFaces() {
        return this.face;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setVertices(Vec3[] v) {
        int i = 0;
        while (i < v.length) {
            this.vertex[i].r = v[i];
            ++i;
        }
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setShape(Vertex[] v, int[][] faces) {
        this.vertex = new Vertex[v.length];
        int i = 0;
        while (i < v.length) {
            this.vertex[i] = new Vertex(v[i]);
            this.vertex[i].firstEdge = -1;
            this.vertex[i].edges = 0;
            ++i;
        }
        if (faces.length == 0) {
            this.edge = new Edge[0];
            this.face = new Face[0];
        } else {
            this.findEdges(faces);
        }
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
        i = 0;
        while (i < this.edge.length) {
            Vertex v1 = this.vertex[this.edge[i].v1];
            Vertex v2 = this.vertex[this.edge[i].v2];
            ++v1.edges;
            ++v2.edges;
            if (this.edge[i].f2 == -1) {
                v1.firstEdge = v2.firstEdge = i;
            } else {
                if (v1.firstEdge == -1) {
                    v1.firstEdge = i;
                }
                if (v2.firstEdge == -1) {
                    v2.firstEdge = i;
                }
            }
            ++i;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        Vec3 size = this.getBounds().getSize();
        double xscale = size.x == 0.0 ? 1.0 : xsize / size.x;
        double yscale = size.y == 0.0 ? 1.0 : ysize / size.y;
        double zscale = size.z == 0.0 ? 1.0 : zsize / size.z;
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i].r.x *= xscale;
            this.vertex[i].r.y *= yscale;
            this.vertex[i].r.z *= zscale;
            ++i;
        }
        if (xscale * yscale * zscale < 0.0) {
            int[][] faces = new int[this.face.length][];
            int i2 = 0;
            while (i2 < faces.length) {
                faces[i2] = new int[]{this.face[i2].v1, this.face[i2].v3, this.face[i2].v2};
                ++i2;
            }
            this.findEdges(faces);
        }
        this.skeleton.scale(xscale, yscale, zscale);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public int[][] findBoundaryEdges() {
        int j;
        Vector<Integer> allEdges = new Vector<Integer>();
        int i = 0;
        while (i < this.edge.length) {
            if (this.edge[i].f2 == -1) {
                allEdges.addElement(new Integer(i));
            }
            ++i;
        }
        Vector boundary = new Vector();
        while (allEdges.size() > 0) {
            Vector<Integer> current = new Vector<Integer>();
            Integer start = (Integer)allEdges.elementAt(0);
            allEdges.removeElementAt(0);
            current.addElement(start);
            int i2 = start;
            j = 0;
            block2: while (j < allEdges.size()) {
                j = 0;
                while (j < allEdges.size()) {
                    int k = (Integer)allEdges.elementAt(j);
                    if (this.edge[i2].v1 == this.edge[k].v1 || this.edge[i2].v1 == this.edge[k].v2 || this.edge[i2].v2 == this.edge[k].v1 || this.edge[i2].v2 == this.edge[k].v2) {
                        current.addElement((Integer)allEdges.elementAt(j));
                        allEdges.removeElementAt(j);
                        i2 = k;
                        --j;
                        continue block2;
                    }
                    ++j;
                }
            }
            boundary.addElement(current);
        }
        int[][] index = new int[boundary.size()][];
        int i3 = 0;
        while (i3 < index.length) {
            Vector current = (Vector)boundary.elementAt(i3);
            index[i3] = new int[current.size()];
            j = 0;
            while (j < index[i3].length) {
                index[i3][j] = (Integer)current.elementAt(j);
                ++j;
            }
            ++i3;
        }
        return index;
    }

    public boolean editable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        TriMeshEditorWindow ed = new TriMeshEditorWindow(parent, "Triangle Mesh '" + info.name + "'", info, cb, true);
        ((ObjectViewer)ed.getView()).setScene(parent.getScene(), info);
        ed.show();
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Callback cb, ObjectInfo realObject) {
        TriMeshEditorWindow ed = new TriMeshEditorWindow(parent, "Gesture '" + info.name + "'", info, cb, false);
        ((ObjectViewer)ed.getView()).setScene(parent.getScene(), realObject);
        ed.show();
    }

    public int canConvertToTriangleMesh() {
        if (this.smoothingMethod == 0 || this.smoothingMethod == 1) {
            return 1;
        }
        return 2;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        if (this.smoothingMethod == 2 || this.smoothingMethod == 3) {
            boolean[] split = new boolean[this.edge.length];
            int i = 0;
            while (i < split.length) {
                split[i] = true;
                ++i;
            }
            if (this.smoothingMethod == 2) {
                return TriangleMesh.subdivideButterfly(this, split, tol);
            }
            return TriangleMesh.subdivideLoop(this, split, tol);
        }
        return this;
    }

    public WireframeMesh getWireframeMesh() {
        Edge[] e;
        Vertex[] v;
        int i;
        TriangleMesh mesh = this;
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        if (this.smoothingMethod == 2 || this.smoothingMethod == 3) {
            boolean[] split = new boolean[this.edge.length];
            i = 0;
            while (i < split.length) {
                split[i] = true;
                ++i;
            }
            mesh = this.smoothingMethod == 2 ? TriangleMesh.subdivideButterfly(mesh, split, ModellingApp.getPreferences().getInteractiveSurfaceError()) : TriangleMesh.subdivideLoop(mesh, split, ModellingApp.getPreferences().getInteractiveSurfaceError());
            v = mesh.vertex;
            e = mesh.edge;
        } else {
            v = this.vertex;
            e = this.edge;
        }
        Vec3[] point = new Vec3[v.length];
        int[] from = new int[e.length];
        int[] to = new int[e.length];
        i = 0;
        while (i < v.length) {
            point[i] = v[i].r;
            ++i;
        }
        i = 0;
        while (i < e.length) {
            from[i] = e[i].v1;
            to[i] = e[i].v2;
            ++i;
        }
        this.cachedWire = new WireframeMesh(point, from, to);
        return this.cachedWire;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        Vec3[] normalArray;
        int j;
        Face[] f;
        Edge[] e;
        Vertex[] v;
        int i;
        TriangleMesh mesh = this;
        Vec3 t1 = new Vec3();
        Vec3 t2 = new Vec3();
        if (interactive && this.cachedMesh != null) {
            return this.cachedMesh;
        }
        if (this.face.length == 0) {
            return new RenderingMesh(new Vec3[]{new Vec3()}, new Vec3[]{null}, new RenderingTriangle[0]);
        }
        if (this.smoothingMethod == 2 || this.smoothingMethod == 3) {
            double tol2 = tol * tol;
            Vec3 diff = new Vec3();
            boolean[] split = new boolean[this.edge.length];
            i = 0;
            while (i < split.length) {
                Vec3 r1 = this.vertex[this.edge[i].v1].r;
                Vec3 r2 = this.vertex[this.edge[i].v2].r;
                diff.set(r1.x - r2.x, r1.y - r2.y, r1.z - r2.z);
                split[i] = diff.length2() > tol2;
                ++i;
            }
            mesh = this.smoothingMethod == 2 ? TriangleMesh.subdivideButterfly(mesh, split, tol) : TriangleMesh.subdivideLoop(mesh, split, tol);
            v = mesh.vertex;
            e = mesh.edge;
            f = mesh.face;
        } else {
            v = this.vertex;
            e = this.edge;
            f = this.face;
        }
        Vec3[] vert = new Vec3[v.length];
        Vector<Vec3> norm = new Vector<Vec3>();
        RenderingTriangle[] tri = new RenderingTriangle[f.length];
        int[] facenorm = new int[f.length * 3];
        int normals = 0;
        int last = 0;
        int k = 0;
        if (this.smoothingMethod != 0) {
            Face tempFace;
            Vec3[] trueNorm = new Vec3[f.length];
            i = 0;
            while (i < f.length) {
                trueNorm[i] = v[f[i].v2].r.minus(v[f[i].v1].r).cross(v[f[i].v3].r.minus(v[f[i].v1].r));
                double length = trueNorm[i].length();
                if (length > 0.0) {
                    trueNorm[i].scale(1.0 / length);
                }
                ++i;
            }
            i = 0;
            while (i < v.length) {
                vert[i] = v[i].r;
                int[] ed = v[i].getEdges();
                if (v[i].smoothness < 1.0f) {
                    norm.addElement(null);
                    j = 0;
                    while (j < ed.length) {
                        k = e[ed[j]].f1;
                        tempFace = f[k];
                        if (tempFace.v1 == i) {
                            facenorm[k * 3] = normals;
                        } else if (tempFace.v2 == i) {
                            facenorm[k * 3 + 1] = normals;
                        } else {
                            facenorm[k * 3 + 2] = normals;
                        }
                        k = e[ed[j]].f2;
                        if (k != -1) {
                            tempFace = f[k];
                            if (tempFace.v1 == i) {
                                facenorm[k * 3] = normals;
                            } else if (tempFace.v2 == i) {
                                facenorm[k * 3 + 1] = normals;
                            } else {
                                facenorm[k * 3 + 2] = normals;
                            }
                        }
                        ++j;
                    }
                    ++normals;
                } else {
                    Vec3 temp;
                    Edge tempEdge;
                    j = 0;
                    k = -1;
                    while (j < ed.length) {
                        tempEdge = e[ed[j]];
                        if (tempEdge.f2 == -1 || tempEdge.smoothness < 1.0f) {
                            if (k != -1) break;
                            k = j;
                        }
                        ++j;
                    }
                    if (j == ed.length) {
                        temp = new Vec3();
                        j = 0;
                        while (j < ed.length) {
                            tempEdge = e[ed[j]];
                            temp.add(trueNorm[tempEdge.f1]);
                            tempFace = f[tempEdge.f1];
                            if (tempFace.v1 == i) {
                                facenorm[tempEdge.f1 * 3] = normals;
                            } else if (tempFace.v2 == i) {
                                facenorm[tempEdge.f1 * 3 + 1] = normals;
                            } else {
                                facenorm[tempEdge.f1 * 3 + 2] = normals;
                            }
                            if (tempEdge.f2 != -1) {
                                tempFace = f[tempEdge.f2];
                                if (tempFace.v1 == i) {
                                    facenorm[tempEdge.f2 * 3] = normals;
                                } else if (tempFace.v2 == i) {
                                    facenorm[tempEdge.f2 * 3 + 1] = normals;
                                } else {
                                    facenorm[tempEdge.f2 * 3 + 2] = normals;
                                }
                            }
                            ++j;
                        }
                        temp.normalize();
                        norm.addElement(temp);
                        ++normals;
                    } else {
                        int first = j = k;
                        tempEdge = e[ed[j]];
                        block6: do {
                            temp = new Vec3();
                            do {
                                j = (j + 1) % ed.length;
                                int m = tempEdge.f1;
                                tempFace = f[m];
                                if (tempFace.e1 != ed[j] && tempFace.e2 != ed[j] && tempFace.e3 != ed[j]) {
                                    m = tempEdge.f2;
                                    if (m == -1) break block6;
                                    tempFace = f[m];
                                }
                                temp.add(trueNorm[m]);
                                if (tempFace.v1 == i) {
                                    facenorm[m * 3] = normals;
                                } else if (tempFace.v2 == i) {
                                    facenorm[m * 3 + 1] = normals;
                                } else {
                                    facenorm[m * 3 + 2] = normals;
                                }
                                tempEdge = e[ed[j]];
                            } while (tempEdge.f2 != -1 && tempEdge.smoothness == 1.0f);
                            last = j;
                            temp.normalize();
                            norm.addElement(temp);
                            ++normals;
                            j = first = last;
                            tempEdge = e[ed[first]];
                        } while (last != k);
                    }
                }
                ++i;
            }
            normalArray = new Vec3[norm.size()];
            i = 0;
            while (i < normalArray.length) {
                normalArray[i] = (Vec3)norm.elementAt(i);
                ++i;
            }
            i = 0;
            while (i < f.length) {
                tempFace = mesh.face[i];
                tri[i] = this.texMapping.mapTriangle(tempFace.v1, tempFace.v2, tempFace.v3, facenorm[i * 3], facenorm[i * 3 + 1], facenorm[i * 3 + 2], vert);
                ++i;
            }
        } else {
            normalArray = new Vec3[]{null};
            i = 0;
            while (i < v.length) {
                vert[i] = v[i].r;
                ++i;
            }
            i = 0;
            while (i < f.length) {
                tri[i] = this.texMapping.mapTriangle(f[i].v1, f[i].v2, f[i].v3, 0, 0, 0, vert);
                ++i;
            }
        }
        RenderingMesh rend = new RenderingMesh(vert, normalArray, tri);
        if (v[0].param != null && v[0].param.length > 0) {
            double[][] param = new double[v.length][info.texParam.length];
            i = 0;
            while (i < info.texParam.length) {
                if (info.texParamPerVertex[i]) {
                    j = 0;
                    while (j < v.length) {
                        param[j][i] = v[j].param[i];
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < v.length) {
                        param[j][i] = info.texParamValue[i];
                        ++j;
                    }
                }
                ++i;
            }
            rend.setParameters(param, this.texMapping);
        }
        if (interactive) {
            this.cachedMesh = rend;
        }
        return rend;
    }

    public void setTextureMapping(TextureMapping mapping) {
        int j2;
        super.setTextureMapping(mapping);
        TextureParameter[] texparam = mapping.getParameters();
        this.cachedMesh = null;
        this.cachedWire = null;
        if (texparam == null || texparam.length == 0) {
            this.parameter = null;
            if (this.vertex != null) {
                int i = 0;
                while (i < this.vertex.length) {
                    this.vertex[i].param = null;
                    ++i;
                }
            }
            return;
        }
        TextureParameter[] newparam = new TextureParameter[texparam.length];
        int i = 0;
        while (i < newparam.length) {
            newparam[i] = texparam[i].duplicate();
            ++i;
        }
        if (this.vertex == null) {
            this.parameter = newparam;
            return;
        }
        if (this.parameter == null || this.parameter.length == 0) {
            this.parameter = newparam;
            i = 0;
            while (i < this.vertex.length) {
                this.vertex[i].param = new double[newparam.length];
                int j2 = 0;
                while (j2 < newparam.length) {
                    if (newparam[j2].type == 0) {
                        this.vertex[i].param[j2] = newparam[j2].defaultVal;
                    } else if (newparam[j2].type == 1) {
                        this.vertex[i].param[j2] = this.vertex[i].r.x;
                    } else if (newparam[j2].type == 2) {
                        this.vertex[i].param[j2] = this.vertex[i].r.y;
                    } else if (newparam[j2].type == 3) {
                        this.vertex[i].param[j2] = this.vertex[i].r.z;
                    }
                    ++j2;
                }
                ++i;
            }
            return;
        }
        int[] index = new int[newparam.length];
        i = 0;
        while (i < newparam.length) {
            j2 = 0;
            while (j2 < this.parameter.length && !this.parameter[j2].equals(newparam[i])) {
                ++j2;
            }
            index[i] = j2;
            ++i;
        }
        i = 0;
        while (i < this.vertex.length) {
            double[] newval = new double[newparam.length];
            j2 = 0;
            while (j2 < newparam.length) {
                if (index[j2] == this.parameter.length) {
                    if (newparam[j2].type == 0) {
                        newval[j2] = newparam[j2].defaultVal;
                    } else if (newparam[j2].type == 1) {
                        newval[j2] = this.vertex[i].r.x;
                    } else if (newparam[j2].type == 2) {
                        newval[j2] = this.vertex[i].r.y;
                    } else if (newparam[j2].type == 3) {
                        newval[j2] = this.vertex[i].r.z;
                    }
                } else {
                    newval[j2] = this.vertex[i].param[index[j2]];
                }
                ++j2;
            }
            this.vertex[i].param = newval;
            ++i;
        }
        this.parameter = newparam;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton s) {
        this.skeleton = s;
    }

    public Vertex blend(Vertex v1, Vertex v2, double w1, double w2) {
        Vertex v = new Vertex(new Vec3(w1 * v1.r.x + w2 * v2.r.x, w1 * v1.r.y + w2 * v2.r.y, w1 * v1.r.z + w2 * v2.r.z));
        if (v1.param == null) {
            return v;
        }
        v.param = new double[v1.param.length];
        int i = 0;
        while (i < v.param.length) {
            v.param[i] = w1 * v1.param[i] + w2 * v2.param[i];
            ++i;
        }
        return v;
    }

    public Vertex blend(Vertex v1, Vertex v2, Vertex v3, double w1, double w2, double w3) {
        Vertex v = new Vertex(new Vec3(w1 * v1.r.x + w2 * v2.r.x + w3 * v3.r.x, w1 * v1.r.y + w2 * v2.r.y + w3 * v3.r.y, w1 * v1.r.z + w2 * v2.r.z + w3 * v3.r.z));
        if (v1.param == null) {
            return v;
        }
        v.param = new double[v1.param.length];
        int i = 0;
        while (i < v.param.length) {
            v.param[i] = w1 * v1.param[i] + w2 * v2.param[i] + w3 * v3.param[i];
            ++i;
        }
        return v;
    }

    public static void setBlend(Vertex v, Vertex v1, Vertex v2, double w1, double w2) {
        v.r.set(w1 * v1.r.x + w2 * v2.r.x, w1 * v1.r.y + w2 * v2.r.y, w1 * v1.r.z + w2 * v2.r.z);
        if (v1.param == null) {
            v.param = null;
            return;
        }
        if (v.param == null || v.param.length != v1.param.length) {
            v.param = new double[v1.param.length];
        }
        int i = 0;
        while (i < v.param.length) {
            v.param[i] = w1 * v1.param[i] + w2 * v2.param[i];
            ++i;
        }
    }

    private static void blendIKParams(Vertex newvert, Vertex v1, Vertex v2) {
        if (v1.ikJoint == v2.ikJoint) {
            newvert.ikJoint = v1.ikJoint;
            newvert.ikWeight = 0.5 * (v1.ikWeight + v2.ikWeight);
        } else if (v1.ikWeight > v2.ikWeight) {
            newvert.ikJoint = v1.ikJoint;
            newvert.ikWeight = v1.ikWeight;
        } else {
            newvert.ikJoint = v2.ikJoint;
            newvert.ikWeight = v2.ikWeight;
        }
    }

    public static TriangleMesh subdivideEdges(TriangleMesh mesh, boolean[] splitEdge, double tol) {
        if (mesh.smoothingMethod == 2) {
            return TriangleMesh.subdivideButterfly(mesh, splitEdge, tol);
        }
        if (mesh.smoothingMethod == 3) {
            return TriangleMesh.subdivideLoop(mesh, splitEdge, tol);
        }
        return TriangleMesh.subdivideLinear(mesh, splitEdge);
    }

    public static TriangleMesh subdivideLinear(TriangleMesh mesh, boolean[] split) {
        int i;
        Vertex[] vertex = mesh.vertex;
        Edge[] edge = mesh.edge;
        Face[] face = mesh.face;
        TriangleMesh newmesh = new TriangleMesh();
        if (split == null) {
            split = new boolean[edge.length];
            i = 0;
            while (i < split.length) {
                split[i] = true;
                ++i;
            }
        }
        int numVert = vertex.length;
        int numEdge = edge.length;
        int numFace = face.length;
        i = 0;
        while (i < edge.length) {
            if (split[i]) {
                ++numVert;
                numEdge += 2;
                ++numFace;
                if (edge[i].f2 != -1) {
                    ++numEdge;
                    ++numFace;
                }
            }
            ++i;
        }
        Vertex[] newvert = new Vertex[numVert];
        Edge[] newedge = new Edge[numEdge];
        Face[] newface = new Face[numFace];
        i = 0;
        while (i < vertex.length) {
            newvert[i] = newmesh.new Vertex(vertex[i]);
            ++i;
        }
        int j = 0;
        while (j < edge.length) {
            if (split[j]) {
                newvert[i] = newmesh.blend(vertex[edge[j].v1], vertex[edge[j].v2], 0.5, 0.5);
                TriangleMesh.blendIKParams(newvert[i++], vertex[edge[j].v1], vertex[edge[j].v2]);
            }
            ++j;
        }
        TriangleMesh.doSubdivide(newmesh, vertex, edge, face, split, newvert, newedge, newface);
        if (mesh.getTexture() != null) {
            newmesh.setTexture(mesh.getTexture());
            newmesh.setTextureMapping(mesh.getTextureMapping().duplicate());
        }
        newmesh.setMaterial(mesh.getMaterial());
        if (mesh.getMaterial() != null) {
            newmesh.setMaterialMapping(mesh.getMaterialMapping().duplicate());
        }
        newmesh.vertex = newvert;
        newmesh.edge = newedge;
        newmesh.face = newface;
        newmesh.closed = mesh.closed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    public static TriangleMesh subdivideLoop(TriangleMesh mesh, boolean[] refineEdge, double tol) {
        boolean done;
        int i;
        Vertex[] vertex = mesh.vertex;
        Edge[] edge = mesh.edge;
        Face[] face = mesh.face;
        TriangleMesh newmesh = new TriangleMesh();
        int[][] f = new int[face.length * 4][];
        Vertex creasePos = newmesh.new Vertex(new Vec3());
        Vertex smoothPos = newmesh.new Vertex(new Vec3());
        Vertex temp = newmesh.new Vertex(new Vec3());
        Vec3 finalPos = new Vec3();
        Vec3 tempVec = new Vec3();
        double tol2 = tol * tol;
        if (refineEdge == null) {
            refineEdge = new boolean[edge.length];
            i = 0;
            while (i < refineEdge.length) {
                refineEdge[i] = true;
                ++i;
            }
        }
        if (mesh.getTexture() != null) {
            newmesh.setTexture(mesh.getTexture());
            newmesh.setTextureMapping(mesh.getTextureMapping().duplicate());
        }
        newmesh.setMaterial(mesh.getMaterial());
        if (mesh.getMaterial() != null) {
            newmesh.setMaterialMapping(mesh.getMaterialMapping().duplicate());
        }
        if (vertex[0].param != null) {
            creasePos.param = new double[vertex[0].param.length];
            smoothPos.param = new double[vertex[0].param.length];
            temp.param = new double[vertex[0].param.length];
        }
        boolean[] refineVert = new boolean[vertex.length];
        i = 0;
        while (i < refineEdge.length) {
            if (refineEdge[i]) {
                refineVert[edge[i].v2] = true;
                refineVert[edge[i].v1] = true;
            }
            ++i;
        }
        int iterations = 0;
        do {
            Edge tempEdge;
            int j;
            double s1;
            double smoothWeight;
            double creaseWeight;
            done = true;
            boolean[] notconverged = new boolean[vertex.length];
            int numVert = vertex.length;
            int numEdge = edge.length;
            int numFace = face.length;
            i = 0;
            while (i < edge.length) {
                if (refineEdge[i]) {
                    ++numVert;
                    numEdge += 2;
                    ++numFace;
                    if (edge[i].f2 != -1) {
                        ++numEdge;
                        ++numFace;
                    }
                }
                ++i;
            }
            Vertex[] newvert = new Vertex[numVert];
            Edge[] newedge = new Edge[numEdge];
            Face[] newface = new Face[numFace];
            double s3 = 0.0;
            double s2 = 0.0;
            i = 0;
            while (i < vertex.length) {
                if (!refineVert[i]) {
                    newvert[i] = newmesh.new Vertex(vertex[i]);
                } else {
                    double beta;
                    double cornerWeight;
                    int[] e = vertex[i].getEdges();
                    if (edge[e[0]].f2 == -1) {
                        cornerWeight = 1.0 - (double)vertex[i].smoothness;
                        creaseWeight = 1.0 - cornerWeight;
                        smoothWeight = 0.0;
                    } else {
                        s2 = s3 = (double)vertex[i].smoothness;
                        s1 = s3;
                        j = 0;
                        while (j < e.length) {
                            if ((double)edge[e[j]].smoothness < s1) {
                                s3 = s2;
                                s2 = s1;
                                s1 = edge[e[j]].smoothness;
                            } else if ((double)edge[e[j]].smoothness < s2) {
                                s3 = s2;
                                s2 = edge[e[j]].smoothness;
                            } else if ((double)edge[e[j]].smoothness < s3) {
                                s3 = edge[e[j]].smoothness;
                            }
                            ++j;
                        }
                        cornerWeight = 1.0 - s3;
                        creaseWeight = 1.0 - s2 - cornerWeight;
                        smoothWeight = 1.0 - cornerWeight - creaseWeight;
                    }
                    temp.clear();
                    if (e.length < LOOP_BETA.length) {
                        beta = LOOP_BETA[e.length];
                    } else {
                        beta = 0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)e.length);
                        beta = (0.625 - beta * beta) / (double)e.length;
                    }
                    j = 0;
                    while (j < e.length) {
                        tempEdge = edge[e[j]];
                        if (tempEdge.v1 == i) {
                            TriangleMesh.setBlend(temp, temp, vertex[tempEdge.v2], 1.0, 1.0);
                        } else {
                            TriangleMesh.setBlend(temp, temp, vertex[tempEdge.v1], 1.0, 1.0);
                        }
                        ++j;
                    }
                    if (smoothWeight > 0.0) {
                        TriangleMesh.setBlend(smoothPos, vertex[i], temp, beta * (1.0 / beta - (double)e.length), beta);
                    }
                    if (edge[e[0]].f2 == -1) {
                        tempEdge = edge[e[0]];
                        if (tempEdge.v1 == i) {
                            TriangleMesh.setBlend(creasePos, vertex[i], vertex[tempEdge.v2], 0.75, 0.125);
                        } else {
                            TriangleMesh.setBlend(creasePos, vertex[i], vertex[tempEdge.v1], 0.75, 0.125);
                        }
                        tempEdge = edge[e[e.length - 1]];
                        if (tempEdge.v1 == i) {
                            TriangleMesh.setBlend(creasePos, creasePos, vertex[tempEdge.v2], 1.0, 0.125);
                        } else {
                            TriangleMesh.setBlend(creasePos, creasePos, vertex[tempEdge.v1], 1.0, 0.125);
                        }
                    } else if (creaseWeight > 0.0) {
                        creasePos.copy(vertex[i]);
                        creasePos.scale(0.75);
                        j = 0;
                        while (j < e.length) {
                            tempEdge = edge[e[j]];
                            if ((double)tempEdge.smoothness < s3) {
                                if (tempEdge.v1 == i) {
                                    TriangleMesh.setBlend(creasePos, creasePos, vertex[tempEdge.v2], 1.0, 0.125);
                                } else {
                                    TriangleMesh.setBlend(creasePos, creasePos, vertex[tempEdge.v1], 1.0, 0.125);
                                }
                            }
                            ++j;
                        }
                    }
                    if (smoothWeight + cornerWeight > 0.0) {
                        beta = 1.0 / (0.375 / beta + (double)e.length);
                        finalPos.set(vertex[i].r);
                        finalPos.scale(1.0 / beta - (double)e.length);
                        finalPos.add(temp.r);
                        finalPos.scale((smoothWeight + cornerWeight) * beta);
                    } else {
                        finalPos.set(0.0, 0.0, 0.0);
                    }
                    if (creaseWeight > 0.0) {
                        tempVec.set(creasePos.r);
                        tempVec.scale(4.0);
                        tempVec.subtract(vertex[i].r);
                        tempVec.scale(creaseWeight / 3.0);
                        finalPos.add(tempVec);
                    }
                    newvert[i] = newmesh.blend(vertex[i], creasePos, smoothPos, cornerWeight, creaseWeight, smoothWeight);
                    newvert[i].smoothness = Math.min(2.0f * vertex[i].smoothness, 1.0f);
                    newvert[i].ikJoint = vertex[i].ikJoint;
                    newvert[i].ikWeight = vertex[i].ikWeight;
                    finalPos.subtract(newvert[i].r);
                    double error = finalPos.length2();
                    if (error > tol2) {
                        notconverged[i] = true;
                        done = false;
                    }
                }
                ++i;
            }
            j = vertex.length;
            i = 0;
            while (i < edge.length) {
                if (refineEdge[i]) {
                    tempEdge = edge[i];
                    TriangleMesh.setBlend(creasePos, vertex[tempEdge.v1], vertex[tempEdge.v2], 1.0, 1.0);
                    if (tempEdge.f2 == -1 || tempEdge.smoothness == 0.0f) {
                        newvert[j] = newmesh.new Vertex(creasePos);
                        newvert[j].scale(0.5);
                    } else {
                        Face tempFace = face[tempEdge.f1];
                        if (tempFace.e1 == i) {
                            smoothPos.copy(vertex[tempFace.v3]);
                        } else if (tempFace.e2 == i) {
                            smoothPos.copy(vertex[tempFace.v1]);
                        } else {
                            smoothPos.copy(vertex[tempFace.v2]);
                        }
                        tempFace = face[tempEdge.f2];
                        if (tempFace.e1 == i) {
                            TriangleMesh.setBlend(smoothPos, smoothPos, vertex[tempFace.v3], 1.0, 1.0);
                        } else if (tempFace.e2 == i) {
                            TriangleMesh.setBlend(smoothPos, smoothPos, vertex[tempFace.v1], 1.0, 1.0);
                        } else {
                            TriangleMesh.setBlend(smoothPos, smoothPos, vertex[tempFace.v2], 1.0, 1.0);
                        }
                        s1 = 1.0 - (double)tempEdge.smoothness;
                        creaseWeight = 0.125 * s1 + 0.375;
                        smoothWeight = 0.125 * (1.0 - s1);
                        newvert[j] = newmesh.blend(creasePos, smoothPos, creaseWeight, smoothWeight);
                    }
                    newvert[j].smoothness = 1.0f;
                    TriangleMesh.blendIKParams(newvert[j], vertex[tempEdge.v1], vertex[tempEdge.v2]);
                    ++j;
                }
                ++i;
            }
            TriangleMesh.doSubdivide(newmesh, vertex, edge, face, refineEdge, newvert, newedge, newface);
            i = 0;
            while (i < newedge.length) {
                newedge[i].smoothness = Math.min(2.0f * newedge[i].smoothness, 1.0f);
                ++i;
            }
            if (!done) {
                refineVert = new boolean[newvert.length];
                refineEdge = new boolean[newedge.length];
                i = 0;
                while (i < newedge.length) {
                    if (newedge[i].v1 < notconverged.length && notconverged[newedge[i].v1]) {
                        refineVert[newedge[i].v2] = true;
                        refineVert[newedge[i].v1] = true;
                    }
                    ++i;
                }
                i = 0;
                while (i < newedge.length) {
                    if ((refineVert[newedge[i].v1] || refineVert[newedge[i].v2]) && newvert[newedge[i].v1].r.distance2(newvert[newedge[i].v2].r) > tol2) {
                        refineEdge[i] = true;
                    }
                    ++i;
                }
            }
            vertex = newvert;
            newmesh.vertex = newvert;
            edge = newedge;
            newmesh.edge = newedge;
            face = newface;
            newmesh.face = newface;
        } while (!done && ++iterations < 20);
        newmesh.closed = mesh.closed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    public static TriangleMesh subdivideButterfly(TriangleMesh mesh, boolean[] refineEdge, double tol) {
        boolean done;
        int i;
        Vertex[] vertex = mesh.vertex;
        Edge[] edge = mesh.edge;
        Face[] face = mesh.face;
        TriangleMesh newmesh = new TriangleMesh();
        Vertex creasePos = newmesh.new Vertex(new Vec3());
        Vertex smoothPos = newmesh.new Vertex(new Vec3());
        Vertex cornerPos = newmesh.new Vertex(new Vec3());
        Vertex temp = newmesh.new Vertex(new Vec3());
        Vec3 axis = new Vec3();
        Vec3 tempVec = new Vec3();
        double tol2 = tol * tol * 9.0;
        if (refineEdge == null) {
            refineEdge = new boolean[edge.length];
            i = 0;
            while (i < refineEdge.length) {
                refineEdge[i] = true;
                ++i;
            }
        }
        if (mesh.getTexture() != null) {
            newmesh.setTexture(mesh.getTexture());
            newmesh.setTextureMapping(mesh.getTextureMapping().duplicate());
        }
        newmesh.setMaterial(mesh.getMaterial());
        if (mesh.getMaterial() != null) {
            newmesh.setMaterialMapping(mesh.getMaterialMapping().duplicate());
        }
        if (vertex[0].param != null) {
            creasePos.param = new double[vertex[0].param.length];
            smoothPos.param = new double[vertex[0].param.length];
            cornerPos.param = new double[vertex[0].param.length];
            temp.param = new double[vertex[0].param.length];
        }
        boolean[] refineVert = new boolean[vertex.length];
        i = 0;
        while (i < refineEdge.length) {
            if (refineEdge[i]) {
                refineVert[edge[i].v2] = true;
                refineVert[edge[i].v1] = true;
            }
            ++i;
        }
        int iterations = 0;
        do {
            int j;
            int[] e;
            double s1;
            done = true;
            boolean[] notconverged = new boolean[edge.length];
            int numVert = vertex.length;
            int numEdge = edge.length;
            int numFace = face.length;
            i = 0;
            while (i < edge.length) {
                if (refineEdge[i]) {
                    ++numVert;
                    numEdge += 2;
                    ++numFace;
                    if (edge[i].f2 != -1) {
                        ++numEdge;
                        ++numFace;
                    }
                }
                ++i;
            }
            Vertex[] newvert = new Vertex[numVert];
            Edge[] newedge = new Edge[numEdge];
            Face[] newface = new Face[numFace];
            int[][] vertEdge = new int[vertex.length][];
            i = 0;
            while (i < vertex.length) {
                vertEdge[i] = vertex[i].getEdges();
                ++i;
            }
            double[] s2 = new double[vertex.length];
            double[] s3 = new double[vertex.length];
            i = 0;
            while (i < vertex.length) {
                s3[i] = 1.0;
                s2[i] = 1.0;
                s1 = 1.0;
                e = vertEdge[i];
                j = 0;
                while (j < e.length) {
                    if (edge[e[j]].f2 == -1) {
                        s3[i] = s2[i];
                        s2[i] = s1;
                        s1 = 0.0;
                    } else if ((double)edge[e[j]].smoothness < s1) {
                        s3[i] = s2[i];
                        s2[i] = s1;
                        s1 = edge[e[j]].smoothness;
                    } else if ((double)edge[e[j]].smoothness < s2[i]) {
                        s3[i] = s2[i];
                        s2[i] = edge[e[j]].smoothness;
                    } else if ((double)edge[e[j]].smoothness < s3[i]) {
                        s3[i] = edge[e[j]].smoothness;
                    }
                    ++j;
                }
                ++i;
            }
            double[] edgeSmoothness = new double[edge.length];
            i = 0;
            while (i < edge.length) {
                edgeSmoothness[i] = edge[i].f2 == -1 ? 0.0 : (double)edge[i].smoothness;
                ++i;
            }
            double[] vertSmoothness = new double[vertex.length];
            boolean[] regular = new boolean[vertex.length];
            i = 0;
            while (i < vertex.length) {
                vertSmoothness[i] = Math.min((double)vertex[i].smoothness, s3[i]);
                regular[i] = vertEdge[i].length == 6 || s2[i] < s3[i];
                newvert[i] = newmesh.new Vertex(vertex[i]);
                newvert[i].smoothness = Math.min(2.0f * vertex[i].smoothness, 1.0f);
                ++i;
            }
            j = vertex.length;
            i = 0;
            while (i < edge.length) {
                if (refineEdge[i]) {
                    int k;
                    Edge tempEdge = edge[i];
                    int v1 = tempEdge.v1;
                    int v2 = tempEdge.v2;
                    double cornerWeight = 1.0 - Math.min(vertSmoothness[v1], vertSmoothness[v2]);
                    double creaseWeight = tempEdge.f2 == -1 ? 1.0 - cornerWeight : Math.max(1.0 - edgeSmoothness[i] - cornerWeight, 0.0);
                    double smoothWeight = 1.0 - cornerWeight - creaseWeight;
                    TriangleMesh.setBlend(cornerPos, vertex[v1], vertex[v2], 0.5, 0.5);
                    if (creaseWeight > 0.0) {
                        creasePos.copy(vertex[v1]);
                        if (s2[v1] < 1.0) {
                            e = vertEdge[v1];
                            if (tempEdge.f2 == -1) {
                                k = e[0] == i ? e.length - 1 : 0;
                            } else {
                                k = 0;
                                while (e[k] == i || edgeSmoothness[e[k]] > s2[v1]) {
                                    ++k;
                                }
                            }
                            TriangleMesh.setBlend(creasePos, creasePos, edge[e[k]].v1 == v1 ? vertex[edge[e[k]].v2] : vertex[edge[e[k]].v1], 1.0 + 0.125 * (double)vertex[v1].smoothness, -0.125 * (double)vertex[v1].smoothness);
                        }
                        temp.copy(vertex[v2]);
                        if (s2[v2] < 1.0) {
                            e = vertEdge[v2];
                            if (tempEdge.f2 == -1) {
                                k = e[0] == i ? e.length - 1 : 0;
                            } else {
                                k = 0;
                                while (e[k] == i || edgeSmoothness[e[k]] > s2[v2]) {
                                    ++k;
                                }
                            }
                            TriangleMesh.setBlend(temp, temp, edge[e[k]].v1 == v2 ? vertex[edge[e[k]].v2] : vertex[edge[e[k]].v1], 1.0 + 0.125 * (double)vertex[v2].smoothness, -0.125 * (double)vertex[v2].smoothness);
                        }
                        TriangleMesh.setBlend(creasePos, creasePos, temp, 0.5, 0.5);
                    }
                    if (smoothWeight > 0.0) {
                        if (regular[v1] && regular[v2]) {
                            int e3;
                            int e2;
                            int v3;
                            smoothPos.copy(cornerPos);
                            Face tempFace = face[tempEdge.f1];
                            if (tempFace.e1 == i) {
                                v3 = tempFace.v3;
                                e2 = tempFace.e2;
                                e3 = tempFace.e3;
                            } else if (tempFace.e2 == i) {
                                v3 = tempFace.v1;
                                e2 = tempFace.e3;
                                e3 = tempFace.e1;
                            } else {
                                v3 = tempFace.v2;
                                e2 = tempFace.e1;
                                e3 = tempFace.e2;
                            }
                            TriangleMesh.setBlend(smoothPos, smoothPos, vertex[v3], 1.0, 0.125);
                            TriangleMesh.findOppositeVertex(temp, tempEdge.f1, e2, edgeSmoothness[e2], vertex, edge, face);
                            TriangleMesh.setBlend(smoothPos, smoothPos, temp, 1.0, -0.0625);
                            TriangleMesh.findOppositeVertex(temp, tempEdge.f1, e3, edgeSmoothness[e3], vertex, edge, face);
                            TriangleMesh.setBlend(smoothPos, smoothPos, temp, 1.0, -0.0625);
                            tempFace = face[tempEdge.f2];
                            if (tempFace.e1 == i) {
                                v3 = tempFace.v3;
                                e2 = tempFace.e2;
                                e3 = tempFace.e3;
                            } else if (tempFace.e2 == i) {
                                v3 = tempFace.v1;
                                e2 = tempFace.e3;
                                e3 = tempFace.e1;
                            } else {
                                v3 = tempFace.v2;
                                e2 = tempFace.e1;
                                e3 = tempFace.e2;
                            }
                            TriangleMesh.setBlend(smoothPos, smoothPos, vertex[v3], 1.0, 0.125);
                            TriangleMesh.findOppositeVertex(temp, tempEdge.f2, e2, edgeSmoothness[e2], vertex, edge, face);
                            TriangleMesh.setBlend(smoothPos, smoothPos, temp, 1.0, -0.0625);
                            TriangleMesh.findOppositeVertex(temp, tempEdge.f2, e3, edgeSmoothness[e3], vertex, edge, face);
                            TriangleMesh.setBlend(smoothPos, smoothPos, temp, 1.0, -0.0625);
                        } else {
                            int n;
                            double[] coeff;
                            smoothPos.clear();
                            if (!regular[v1]) {
                                e = vertEdge[v1];
                                coeff = TriangleMesh.getButterflyCoeff(e.length);
                                n = 0;
                                while (e[n] != i) {
                                    ++n;
                                }
                                k = 0;
                                while (k < e.length) {
                                    tempEdge = edge[e[(n + k) % e.length]];
                                    TriangleMesh.setBlend(smoothPos, smoothPos, tempEdge.v1 == v1 ? vertex[tempEdge.v2] : vertex[tempEdge.v1], 1.0, coeff[k]);
                                    ++k;
                                }
                                TriangleMesh.setBlend(smoothPos, smoothPos, vertex[v1], 1.0, coeff[k]);
                            }
                            if (!regular[v2]) {
                                e = vertEdge[v2];
                                coeff = TriangleMesh.getButterflyCoeff(e.length);
                                n = 0;
                                while (e[n] != i) {
                                    ++n;
                                }
                                k = 0;
                                while (k < e.length) {
                                    tempEdge = edge[e[(n + k) % e.length]];
                                    TriangleMesh.setBlend(smoothPos, smoothPos, tempEdge.v1 == v2 ? vertex[tempEdge.v2] : vertex[tempEdge.v1], 1.0, coeff[k]);
                                    ++k;
                                }
                                TriangleMesh.setBlend(smoothPos, smoothPos, vertex[v2], 1.0, coeff[k]);
                            }
                            if (!regular[v1] && !regular[v2]) {
                                smoothPos.scale(0.5);
                            }
                        }
                    }
                    newvert[j] = newmesh.blend(cornerPos, creasePos, smoothPos, cornerWeight, creaseWeight, smoothWeight);
                    TriangleMesh.blendIKParams(newvert[j], vertex[tempEdge.v1], vertex[tempEdge.v2]);
                    axis.set(vertex[v2].r);
                    axis.subtract(vertex[v1].r);
                    axis.normalize();
                    tempVec.set(newvert[++j - 1].r);
                    tempVec.subtract(vertex[v1].r);
                    s1 = tempVec.dot(axis);
                    axis.scale(s1);
                    tempVec.subtract(axis);
                    double error = tempVec.length2();
                    if (error > tol2) {
                        notconverged[i] = true;
                        done = false;
                    }
                }
                ++i;
            }
            TriangleMesh.doSubdivide(newmesh, vertex, edge, face, refineEdge, newvert, newedge, newface);
            i = 0;
            while (i < newedge.length) {
                newedge[i].smoothness = Math.min(2.0f * newedge[i].smoothness, 1.0f);
                ++i;
            }
            if (!done) {
                refineVert = new boolean[newvert.length];
                refineEdge = new boolean[newedge.length];
                i = 0;
                while (i < edge.length) {
                    if (notconverged[i]) {
                        refineVert[newedge[i].v2] = true;
                        refineVert[edge[i].v2] = true;
                        refineVert[edge[i].v1] = true;
                    }
                    ++i;
                }
                i = 0;
                while (i < newedge.length) {
                    if ((refineVert[newedge[i].v1] || refineVert[newedge[i].v2]) && newvert[newedge[i].v1].r.distance2(newvert[newedge[i].v2].r) > tol2) {
                        refineEdge[i] = true;
                    }
                    ++i;
                }
            }
            vertex = newvert;
            newmesh.vertex = newvert;
            edge = newedge;
            newmesh.edge = newedge;
            face = newface;
            newmesh.face = newface;
        } while (!done && ++iterations < 20);
        newmesh.closed = mesh.closed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    private static void findOppositeVertex(Vertex pos, int whichFace, int whichEdge, double smoothWeight, Vertex[] v, Edge[] e, Face[] f) {
        Face fc;
        if (smoothWeight > 0.0) {
            fc = e[whichEdge].f1 == whichFace ? f[e[whichEdge].f2] : f[e[whichEdge].f1];
            if (fc.e1 == whichEdge) {
                pos.copy(v[fc.v3]);
            } else if (fc.e2 == whichEdge) {
                pos.copy(v[fc.v1]);
            } else {
                pos.copy(v[fc.v2]);
            }
            pos.scale(smoothWeight);
        } else {
            pos.clear();
        }
        if (smoothWeight < 1.0) {
            Vec3 axis = v[e[whichEdge].v1].r.minus(v[e[whichEdge].v2].r);
            axis.normalize();
            fc = f[whichFace];
            Vec3 r = fc.e1 == whichEdge ? v[fc.v3].r : (fc.e2 == whichEdge ? v[fc.v1].r : v[fc.v2].r);
            Vec3 delta = r.minus(v[e[whichEdge].v2].r);
            double dot = delta.dot(axis);
            axis.scale(dot);
            delta.subtract(axis);
            pos.r.x += (1.0 - smoothWeight) * (r.x + axis.x - 2.0 * delta.x);
            pos.r.y += (1.0 - smoothWeight) * (r.y + axis.y - 2.0 * delta.y);
            pos.r.z += (1.0 - smoothWeight) * (r.z + axis.z - 2.0 * delta.z);
        }
    }

    private static final double[] getButterflyCoeff(int numEdges) {
        if (numEdges < BUTTERFLY_COEFF.length) {
            return BUTTERFLY_COEFF[numEdges];
        }
        double[] coeff = new double[numEdges + 1];
        double beta = Math.PI * 2 / (double)numEdges;
        coeff[numEdges] = 1.0;
        int i = 0;
        while (i < numEdges) {
            coeff[i] = (0.25 + Math.cos(beta * (double)i) + 0.5 * Math.cos(2.0 * beta * (double)i)) / (double)numEdges;
            int n = numEdges;
            coeff[n] = coeff[n] - coeff[i];
            ++i;
        }
        return coeff;
    }

    private static final void doSubdivide(TriangleMesh mesh, Vertex[] vertex, Edge[] edge, Face[] face, boolean[] split, Vertex[] newvert, Edge[] newedge, Face[] newface) {
        Face tempFace;
        int v2;
        int v1;
        int[] newEdgeIndex = new int[edge.length];
        int j = edge.length;
        int k = vertex.length;
        int i = 0;
        while (i < edge.length) {
            Edge tempEdge = edge[i];
            v1 = tempEdge.v1;
            v2 = tempEdge.v2;
            if (!split[i]) {
                newedge[i] = mesh.new Edge(v1, v2, -1);
                newedge[i].smoothness = tempEdge.smoothness;
                if (vertex[v1].firstEdge == i) {
                    newvert[v1].firstEdge = i;
                }
                if (vertex[v2].firstEdge == i) {
                    newvert[v2].firstEdge = i;
                }
                newEdgeIndex[i] = i;
            } else {
                newedge[i] = mesh.new Edge(v1, k, -1);
                newedge[j] = mesh.new Edge(v2, k, -1);
                newedge[i].smoothness = newedge[j].smoothness = tempEdge.smoothness;
                if (vertex[v1].firstEdge == i) {
                    newvert[v1].firstEdge = i;
                }
                if (vertex[v2].firstEdge == i) {
                    newvert[v2].firstEdge = j;
                }
                newvert[k].firstEdge = i;
                newEdgeIndex[i] = j++;
                ++k;
            }
            ++i;
        }
        k = face.length;
        i = 0;
        while (i < face.length) {
            int e3;
            int e2;
            int e1;
            int v3;
            int n;
            tempFace = face[i];
            if (split[tempFace.e1]) {
                if (split[tempFace.e2]) {
                    if (split[tempFace.e3]) {
                        n = 3;
                        v1 = tempFace.v1;
                        v2 = tempFace.v2;
                        v3 = tempFace.v3;
                        e1 = tempFace.e1;
                        e2 = tempFace.e2;
                        e3 = tempFace.e3;
                    } else {
                        n = 2;
                        v1 = tempFace.v1;
                        v2 = tempFace.v2;
                        v3 = tempFace.v3;
                        e1 = tempFace.e1;
                        e2 = tempFace.e2;
                        e3 = tempFace.e3;
                    }
                } else if (split[tempFace.e3]) {
                    n = 2;
                    v1 = tempFace.v3;
                    v2 = tempFace.v1;
                    v3 = tempFace.v2;
                    e1 = tempFace.e3;
                    e2 = tempFace.e1;
                    e3 = tempFace.e2;
                } else {
                    n = 1;
                    v1 = tempFace.v1;
                    v2 = tempFace.v2;
                    v3 = tempFace.v3;
                    e1 = tempFace.e1;
                    e2 = tempFace.e2;
                    e3 = tempFace.e3;
                }
            } else if (split[tempFace.e2]) {
                if (split[tempFace.e3]) {
                    n = 2;
                    v1 = tempFace.v2;
                    v2 = tempFace.v3;
                    v3 = tempFace.v1;
                    e1 = tempFace.e2;
                    e2 = tempFace.e3;
                    e3 = tempFace.e1;
                } else {
                    n = 1;
                    v1 = tempFace.v2;
                    v2 = tempFace.v3;
                    v3 = tempFace.v1;
                    e1 = tempFace.e2;
                    e2 = tempFace.e3;
                    e3 = tempFace.e1;
                }
            } else if (split[tempFace.e3]) {
                n = 1;
                v1 = tempFace.v3;
                v2 = tempFace.v1;
                v3 = tempFace.v2;
                e1 = tempFace.e3;
                e2 = tempFace.e1;
                e3 = tempFace.e2;
            } else {
                n = 0;
                v1 = tempFace.v1;
                v2 = tempFace.v2;
                v3 = tempFace.v3;
                e1 = tempFace.e1;
                e2 = tempFace.e2;
                e3 = tempFace.e3;
            }
            switch (n) {
                case 0: {
                    newface[i] = mesh.new Face(v1, v2, v3, e1, e2, e3);
                    break;
                }
                case 1: {
                    newedge[j] = mesh.new Edge(v3, newedge[e1].v2, -1);
                    if (edge[e1].v1 == v1) {
                        newface[i] = mesh.new Face(v1, newedge[e1].v2, v3, e1, j, e3);
                        newface[k] = mesh.new Face(v3, newedge[e1].v2, v2, j, newEdgeIndex[e1], e2);
                    } else {
                        newface[i] = mesh.new Face(v1, newedge[e1].v2, v3, newEdgeIndex[e1], j, e3);
                        newface[k] = mesh.new Face(v3, newedge[e1].v2, v2, j, e1, e2);
                    }
                    ++j;
                    ++k;
                    break;
                }
                case 2: {
                    newedge[j] = mesh.new Edge(newedge[e1].v2, newedge[e2].v2, -1);
                    newedge[j + 1] = mesh.new Edge(v3, newedge[e1].v2, -1);
                    if (edge[e1].v1 == v1) {
                        if (edge[e2].v1 == v2) {
                            newface[i] = mesh.new Face(v1, newedge[e1].v2, v3, e1, j + 1, e3);
                            newface[k] = mesh.new Face(v3, newedge[e1].v2, newedge[e2].v2, j + 1, j, newEdgeIndex[e2]);
                            newface[k + 1] = mesh.new Face(newedge[e2].v2, newedge[e1].v2, v2, j, newEdgeIndex[e1], e2);
                        } else {
                            newface[i] = mesh.new Face(v1, newedge[e1].v2, v3, e1, j + 1, e3);
                            newface[k] = mesh.new Face(v3, newedge[e1].v2, newedge[e2].v2, j + 1, j, e2);
                            newface[k + 1] = mesh.new Face(newedge[e2].v2, newedge[e1].v2, v2, j, newEdgeIndex[e1], newEdgeIndex[e2]);
                        }
                    } else if (edge[e2].v1 == v2) {
                        newface[i] = mesh.new Face(v1, newedge[e1].v2, v3, newEdgeIndex[e1], j + 1, e3);
                        newface[k] = mesh.new Face(v3, newedge[e1].v2, newedge[e2].v2, j + 1, j, newEdgeIndex[e2]);
                        newface[k + 1] = mesh.new Face(newedge[e2].v2, newedge[e1].v2, v2, j, e1, e2);
                    } else {
                        newface[i] = mesh.new Face(v1, newedge[e1].v2, v3, newEdgeIndex[e1], j + 1, e3);
                        newface[k] = mesh.new Face(v3, newedge[e1].v2, newedge[e2].v2, j + 1, j, e2);
                        newface[k + 1] = mesh.new Face(newedge[e2].v2, newedge[e1].v2, v2, j, e1, newEdgeIndex[e2]);
                    }
                    j += 2;
                    k += 2;
                    break;
                }
                case 3: {
                    newedge[j] = mesh.new Edge(newedge[e1].v2, newedge[e2].v2, -1);
                    newedge[j + 1] = mesh.new Edge(newedge[e2].v2, newedge[e3].v2, -1);
                    newedge[j + 2] = mesh.new Edge(newedge[e3].v2, newedge[e1].v2, -1);
                    if (edge[e1].v1 == v1) {
                        if (edge[e2].v1 == v2) {
                            if (edge[e3].v1 == v3) {
                                newface[i] = mesh.new Face(v1, newedge[e1].v2, newedge[e3].v2, e1, j + 2, newEdgeIndex[e3]);
                                newface[k] = mesh.new Face(v2, newedge[e2].v2, newedge[e1].v2, e2, j, newEdgeIndex[e1]);
                                newface[k + 1] = mesh.new Face(v3, newedge[e3].v2, newedge[e2].v2, e3, j + 1, newEdgeIndex[e2]);
                            } else {
                                newface[i] = mesh.new Face(v1, newedge[e1].v2, newedge[e3].v2, e1, j + 2, e3);
                                newface[k] = mesh.new Face(v2, newedge[e2].v2, newedge[e1].v2, e2, j, newEdgeIndex[e1]);
                                newface[k + 1] = mesh.new Face(v3, newedge[e3].v2, newedge[e2].v2, newEdgeIndex[e3], j + 1, newEdgeIndex[e2]);
                            }
                        } else if (edge[e3].v1 == v3) {
                            newface[i] = mesh.new Face(v1, newedge[e1].v2, newedge[e3].v2, e1, j + 2, newEdgeIndex[e3]);
                            newface[k] = mesh.new Face(v2, newedge[e2].v2, newedge[e1].v2, newEdgeIndex[e2], j, newEdgeIndex[e1]);
                            newface[k + 1] = mesh.new Face(v3, newedge[e3].v2, newedge[e2].v2, e3, j + 1, e2);
                        } else {
                            newface[i] = mesh.new Face(v1, newedge[e1].v2, newedge[e3].v2, e1, j + 2, e3);
                            newface[k] = mesh.new Face(v2, newedge[e2].v2, newedge[e1].v2, newEdgeIndex[e2], j, newEdgeIndex[e1]);
                            newface[k + 1] = mesh.new Face(v3, newedge[e3].v2, newedge[e2].v2, newEdgeIndex[e3], j + 1, e2);
                        }
                    } else if (edge[e2].v1 == v2) {
                        if (edge[e3].v1 == v3) {
                            newface[i] = mesh.new Face(v1, newedge[e1].v2, newedge[e3].v2, newEdgeIndex[e1], j + 2, newEdgeIndex[e3]);
                            newface[k] = mesh.new Face(v2, newedge[e2].v2, newedge[e1].v2, e2, j, e1);
                            newface[k + 1] = mesh.new Face(v3, newedge[e3].v2, newedge[e2].v2, e3, j + 1, newEdgeIndex[e2]);
                        } else {
                            newface[i] = mesh.new Face(v1, newedge[e1].v2, newedge[e3].v2, newEdgeIndex[e1], j + 2, e3);
                            newface[k] = mesh.new Face(v2, newedge[e2].v2, newedge[e1].v2, e2, j, e1);
                            newface[k + 1] = mesh.new Face(v3, newedge[e3].v2, newedge[e2].v2, newEdgeIndex[e3], j + 1, newEdgeIndex[e2]);
                        }
                    } else if (edge[e3].v1 == v3) {
                        newface[i] = mesh.new Face(v1, newedge[e1].v2, newedge[e3].v2, newEdgeIndex[e1], j + 2, newEdgeIndex[e3]);
                        newface[k] = mesh.new Face(v2, newedge[e2].v2, newedge[e1].v2, newEdgeIndex[e2], j, e1);
                        newface[k + 1] = mesh.new Face(v3, newedge[e3].v2, newedge[e2].v2, e3, j + 1, e2);
                    } else {
                        newface[i] = mesh.new Face(v1, newedge[e1].v2, newedge[e3].v2, newEdgeIndex[e1], j + 2, e3);
                        newface[k] = mesh.new Face(v2, newedge[e2].v2, newedge[e1].v2, newEdgeIndex[e2], j, e1);
                        newface[k + 1] = mesh.new Face(v3, newedge[e3].v2, newedge[e2].v2, newEdgeIndex[e3], j + 1, e2);
                    }
                    newface[k + 2] = mesh.new Face(newedge[e1].v2, newedge[e2].v2, newedge[e3].v2, j, j + 1, j + 2);
                    j += 3;
                    k += 3;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newface.length) {
            tempFace = newface[i];
            if (newedge[tempFace.e1].f1 == -1) {
                newedge[tempFace.e1].f1 = i;
            } else {
                newedge[tempFace.e1].f2 = i;
            }
            if (newedge[tempFace.e2].f1 == -1) {
                newedge[tempFace.e2].f1 = i;
            } else {
                newedge[tempFace.e2].f2 = i;
            }
            if (newedge[tempFace.e3].f1 == -1) {
                newedge[tempFace.e3].f1 = i;
            } else {
                newedge[tempFace.e3].f2 = i;
            }
            ++i;
        }
        i = 0;
        while (i < newvert.length) {
            newvert[i].edges = 0;
            ++i;
        }
        i = 0;
        while (i < newedge.length) {
            ++newvert[newedge[i].v1].edges;
            ++newvert[newedge[i].v2].edges;
            ++i;
        }
    }

    public static TriangleMesh subdivideFaces(TriangleMesh mesh, boolean[] split) {
        Vertex[] vertex = mesh.vertex;
        Edge[] edge = mesh.edge;
        Face[] face = mesh.face;
        TriangleMesh newmesh = new TriangleMesh();
        Vertex temp = newmesh.new Vertex(new Vec3());
        int numVert = vertex.length;
        int numEdge = edge.length;
        int numFace = face.length;
        int i = 0;
        while (i < split.length) {
            if (split[i]) {
                ++numVert;
                numEdge += 3;
                numFace += 2;
            }
            ++i;
        }
        Vertex[] newvert = new Vertex[numVert];
        Edge[] newedge = new Edge[numEdge];
        Face[] newface = new Face[numFace];
        i = 0;
        while (i < vertex.length) {
            newvert[i] = newmesh.new Vertex(vertex[i]);
            ++i;
        }
        i = 0;
        while (i < edge.length) {
            newedge[i] = newmesh.new Edge(edge[i].v1, edge[i].v2, -1);
            newedge[i].smoothness = edge[i].smoothness;
            ++i;
        }
        i = 0;
        while (i < face.length) {
            if (!split[i]) {
                newface[i] = newmesh.new Face(face[i].v1, face[i].v2, face[i].v3, face[i].e1, face[i].e2, face[i].e3);
            }
            ++i;
        }
        numVert = vertex.length;
        numEdge = edge.length;
        numFace = face.length;
        i = 0;
        while (i < face.length) {
            if (split[i]) {
                newvert[numVert] = newmesh.blend(vertex[face[i].v1], vertex[face[i].v2], vertex[face[i].v3], 0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
                TriangleMesh.blendIKParams(newvert[numVert], vertex[face[i].v1], vertex[face[i].v2]);
                newvert[numVert].firstEdge = numEdge;
                newedge[numEdge] = newmesh.new Edge(face[i].v1, numVert, -1);
                newedge[numEdge + 1] = newmesh.new Edge(face[i].v2, numVert, -1);
                newedge[numEdge + 2] = newmesh.new Edge(face[i].v3, numVert, -1);
                newface[i] = newmesh.new Face(face[i].v1, face[i].v2, numVert, face[i].e1, numEdge + 1, numEdge);
                newface[numFace] = newmesh.new Face(face[i].v2, face[i].v3, numVert, face[i].e2, numEdge + 2, numEdge + 1);
                newface[numFace + 1] = newmesh.new Face(face[i].v3, face[i].v1, numVert, face[i].e3, numEdge, numEdge + 2);
                ++numVert;
                numEdge += 3;
                numFace += 2;
            }
            ++i;
        }
        i = 0;
        while (i < newface.length) {
            Face tempFace = newface[i];
            if (newedge[tempFace.e1].f1 == -1) {
                newedge[tempFace.e1].f1 = i;
            } else {
                newedge[tempFace.e1].f2 = i;
            }
            if (newedge[tempFace.e2].f1 == -1) {
                newedge[tempFace.e2].f1 = i;
            } else {
                newedge[tempFace.e2].f2 = i;
            }
            if (newedge[tempFace.e3].f1 == -1) {
                newedge[tempFace.e3].f1 = i;
            } else {
                newedge[tempFace.e3].f2 = i;
            }
            ++i;
        }
        i = 0;
        while (i < newedge.length) {
            ++newvert[newedge[i].v1].edges;
            ++newvert[newedge[i].v2].edges;
            ++i;
        }
        if (mesh.getTexture() != null) {
            newmesh.setTexture(mesh.getTexture());
            newmesh.setTextureMapping(mesh.getTextureMapping().duplicate());
        }
        newmesh.setMaterial(mesh.getMaterial());
        if (mesh.getMaterial() != null) {
            newmesh.setMaterialMapping(mesh.getMaterialMapping().duplicate());
        }
        newmesh.vertex = newvert;
        newmesh.edge = newedge;
        newmesh.face = newface;
        newmesh.closed = mesh.closed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    public TriangleMesh subdivideToLimit(double tol) {
        TriangleMesh newmesh = this;
        boolean converged = false;
        double tol2 = 2.0 * tol * tol;
        while (!converged) {
            converged = true;
            boolean[] split = new boolean[newmesh.edge.length];
            int i = 0;
            while (i < split.length) {
                Vec3 v1 = newmesh.vertex[newmesh.edge[i].v1].r;
                Vec3 v2 = newmesh.vertex[newmesh.edge[i].v2].r;
                double dx = v1.x - v2.x;
                double dy = v1.y - v2.y;
                double dz = v1.z - v2.z;
                if (dx * dx + dy * dy + dz * dz > tol2) {
                    split[i] = true;
                    converged = false;
                } else {
                    split[i] = false;
                }
                ++i;
            }
            newmesh = this.getSmoothingMethod() == 3 ? TriangleMesh.subdivideLoop(newmesh, split, Double.MAX_VALUE) : (this.getSmoothingMethod() == 2 ? TriangleMesh.subdivideButterfly(newmesh, split, Double.MAX_VALUE) : TriangleMesh.subdivideLinear(newmesh, split));
        }
        return newmesh;
    }

    public TriangleMesh getDisplacedMesh(double tol, double time) {
        TriangleMesh newmesh = this;
        boolean converged = false;
        double tol2 = 2.0 * tol * tol;
        Vec3 t1 = new Vec3();
        Vec3 t2 = new Vec3();
        while (!converged) {
            converged = true;
            boolean[] split = new boolean[newmesh.edge.length];
            int i = 0;
            while (i < split.length) {
                Vec3 v1 = newmesh.vertex[newmesh.edge[i].v1].r;
                Vec3 v2 = newmesh.vertex[newmesh.edge[i].v2].r;
                double dx = v1.x - v2.x;
                double dy = v1.y - v2.y;
                double dz = v1.z - v2.z;
                if (dx * dx + dy * dy + dz * dz > tol2) {
                    split[i] = true;
                    converged = false;
                } else {
                    split[i] = false;
                }
                ++i;
            }
            newmesh = this.getSmoothingMethod() == 3 ? TriangleMesh.subdivideLoop(newmesh, split, Double.MAX_VALUE) : (this.getSmoothingMethod() == 2 ? TriangleMesh.subdivideButterfly(newmesh, split, Double.MAX_VALUE) : TriangleMesh.subdivideLinear(newmesh, split));
        }
        Vertex[] v = newmesh.vertex;
        Edge[] e = newmesh.edge;
        Vec3[] norm = new Vec3[v.length];
        int i = 0;
        while (i < v.length) {
            int[] ed = v[i].getEdges();
            double b = Math.PI * 2 / (double)ed.length;
            t1.set(0.0, 0.0, 0.0);
            t2.set(0.0, 0.0, 0.0);
            int j = 0;
            while (j < ed.length) {
                Edge tempEdge = e[ed[j]];
                if (tempEdge.v1 == i) {
                    t1.add(v[tempEdge.v2].r.times(Math.cos(b * (double)j)));
                    t2.add(v[tempEdge.v2].r.times(Math.sin(b * (double)j)));
                } else {
                    t1.add(v[tempEdge.v1].r.times(Math.cos(b * (double)j)));
                    t2.add(v[tempEdge.v1].r.times(Math.sin(b * (double)j)));
                }
                ++j;
            }
            Vec3 temp = t1.cross(t2);
            b = temp.length();
            if (b == 0.0) {
                temp = null;
            } else if (v[i].clockwise()) {
                temp.scale(-1.0 / b);
            } else {
                temp.scale(1.0 / b);
            }
            norm[i] = temp;
            ++i;
        }
        TextureMapping map = this.getTextureMapping();
        int i2 = 0;
        while (i2 < v.length) {
            double height = map.getDisplacement(v[i2].r, tol, time, v[i2].param);
            v[i2].r.x += height * norm[i2].x;
            v[i2].r.y += height * norm[i2].y;
            v[i2].r.z += height * norm[i2].z;
            ++i2;
        }
        System.gc();
        return newmesh;
    }

    public void makeRightSideOut() {
        Vec3[] norm = this.getNormals();
        Vec3 result = new Vec3();
        int i = 0;
        while (i < norm.length) {
            result.x += this.vertex[i].r.x * norm[i].x;
            result.y += this.vertex[i].r.y * norm[i].y;
            result.z += this.vertex[i].r.z * norm[i].z;
            ++i;
        }
        if (result.x + result.y + result.z < 0.0) {
            this.reverseNormals();
        }
    }

    public void reverseNormals() {
        int i = 0;
        while (i < this.face.length) {
            int temp = this.face[i].v2;
            this.face[i].v2 = this.face[i].v3;
            this.face[i].v3 = temp;
            temp = this.face[i].e1;
            this.face[i].e1 = this.face[i].e3;
            this.face[i].e3 = temp;
            ++i;
        }
        this.cachedMesh = null;
    }

    public Vec3[] getNormals() {
        Vec3[] norm = new Vec3[this.vertex.length];
        int i = 0;
        while (i < norm.length) {
            norm[i] = new Vec3();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.face.length) {
            Vec3 faceNorm = this.vertex[this.face[i2].v2].r.minus(this.vertex[this.face[i2].v1].r).cross(this.vertex[this.face[i2].v3].r.minus(this.vertex[this.face[i2].v1].r));
            double length = faceNorm.length();
            if (length != 0.0) {
                faceNorm.scale(1.0 / length);
                norm[this.face[i2].v1].add(faceNorm);
                norm[this.face[i2].v2].add(faceNorm);
                norm[this.face[i2].v3].add(faceNorm);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < norm.length) {
            norm[i3].normalize();
            ++i3;
        }
        return norm;
    }

    public static TriangleMesh optimizeMesh(TriangleMesh mesh) {
        Face[] face = mesh.face;
        Edge[] edge = mesh.edge;
        Vertex[] vertex = mesh.vertex;
        boolean[] candidate = new boolean[edge.length];
        TriangleMesh newmesh = null;
        int i = 0;
        while (i < edge.length) {
            candidate[i] = true;
            ++i;
        }
        block1: while (true) {
            Vec3[] faceNorm = new Vec3[face.length];
            boolean[] onBoundary = new boolean[vertex.length];
            int[] numEdges = new int[vertex.length];
            int i2 = 0;
            while (i2 < face.length) {
                Face f = face[i2];
                if (candidate[f.e1] || candidate[f.e2] || candidate[f.e3]) {
                    Vec3 v1 = vertex[f.v1].r;
                    Vec3 v2 = vertex[f.v2].r;
                    Vec3 v3 = vertex[f.v3].r;
                    Vec3 d1 = v2.minus(v1);
                    Vec3 d2 = v3.minus(v1);
                    faceNorm[i2] = d1.cross(d2);
                    double length = faceNorm[i2].length();
                    if (length > 0.0) {
                        faceNorm[i2].scale(1.0 / length);
                    } else if (!(v1.equals(v2) || v1.equals(v3) || v2.equals(v3))) {
                        faceNorm[i2] = null;
                    }
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < edge.length) {
                Edge e = edge[i3];
                int n = e.v1;
                numEdges[n] = numEdges[n] + 1;
                int n2 = e.v2;
                numEdges[n2] = numEdges[n2] + 1;
                if (e.f2 == -1) {
                    onBoundary[e.v2] = true;
                    onBoundary[e.v1] = true;
                    candidate[i3] = false;
                } else if (candidate[i3] && faceNorm[e.f1] != null && faceNorm[e.f2] != null && faceNorm[e.f1].dot(faceNorm[e.f2]) < 0.99) {
                    candidate[i3] = false;
                }
                ++i3;
            }
            int[][] swapVert = new int[edge.length][];
            double[][] minAngle = new double[edge.length][];
            int i4 = 0;
            while (i4 < edge.length) {
                if (candidate[i4]) {
                    swapVert[i4] = new int[4];
                    Edge e = edge[i4];
                    Face f1 = face[e.f1];
                    Face f2 = face[e.f2];
                    if (e.v1 == f1.v1 && e.v2 == f1.v2 || e.v1 == f1.v2 && e.v2 == f1.v3 || e.v1 == f1.v3 && e.v2 == f1.v1) {
                        swapVert[i4][0] = e.v1;
                        swapVert[i4][1] = e.v2;
                    } else {
                        swapVert[i4][0] = e.v2;
                        swapVert[i4][1] = e.v1;
                    }
                    swapVert[i4][2] = e.v1 != f1.v1 && e.v2 != f1.v1 ? f1.v1 : (e.v1 != f1.v2 && e.v2 != f1.v2 ? f1.v2 : f1.v3);
                    swapVert[i4][3] = e.v1 != f2.v1 && e.v2 != f2.v1 ? f2.v1 : (e.v1 != f2.v2 && e.v2 != f2.v2 ? f2.v2 : f2.v3);
                    minAngle[i4] = new double[4];
                    Vec3 d1 = vertex[swapVert[i4][1]].r.minus(vertex[swapVert[i4][0]].r);
                    Vec3 d2 = vertex[swapVert[i4][2]].r.minus(vertex[swapVert[i4][0]].r);
                    Vec3 d3 = vertex[swapVert[i4][3]].r.minus(vertex[swapVert[i4][0]].r);
                    Vec3 d4 = vertex[swapVert[i4][2]].r.minus(vertex[swapVert[i4][1]].r);
                    Vec3 d5 = vertex[swapVert[i4][3]].r.minus(vertex[swapVert[i4][1]].r);
                    Vec3 d6 = vertex[swapVert[i4][3]].r.minus(vertex[swapVert[i4][2]].r);
                    d1.normalize();
                    d2.normalize();
                    d3.normalize();
                    d4.normalize();
                    d5.normalize();
                    d6.normalize();
                    double a1 = Math.acos(d1.dot(d2));
                    double a2 = Math.acos(d1.dot(d3));
                    if (a1 + a2 >= Math.PI) {
                        candidate[i4] = false;
                    } else {
                        minAngle[i4][0] = a1 < a2 ? a1 : a2;
                        a1 = Math.acos(-d1.dot(d4));
                        if (a1 + (a2 = Math.acos(-d1.dot(d5))) >= Math.PI) {
                            candidate[i4] = false;
                        } else {
                            minAngle[i4][1] = a1 < a2 ? a1 : a2;
                            a1 = Math.acos(-d6.dot(d2));
                            a2 = Math.acos(-d6.dot(d4));
                            minAngle[i4][2] = a1 < a2 ? a1 : a2;
                            a1 = Math.acos(d6.dot(d3));
                            a2 = Math.acos(d6.dot(d5));
                            minAngle[i4][3] = a1 < a2 ? a1 : a2;
                        }
                    }
                }
                ++i4;
            }
            double[] score = new double[edge.length];
            boolean[] swap = new boolean[edge.length];
            int i5 = 0;
            while (i5 < score.length) {
                if (candidate[i5]) {
                    score[i5] = TriangleMesh.calcSwapScore(minAngle[i5], swapVert[i5], numEdges, onBoundary);
                }
                ++i5;
            }
            block6: while (true) {
                boolean finished = true;
                int best = -1;
                double maxScore = 0.0;
                int i6 = 0;
                while (i6 < candidate.length) {
                    if (candidate[i6] && score[i6] > maxScore) {
                        best = i6;
                        maxScore = score[i6];
                    }
                    ++i6;
                }
                if (best == -1) break;
                swap[best] = true;
                Edge e = edge[best];
                Face f = face[e.f1];
                candidate[f.e3] = false;
                candidate[f.e2] = false;
                candidate[f.e1] = false;
                f = face[e.f2];
                candidate[f.e3] = false;
                candidate[f.e2] = false;
                candidate[f.e1] = false;
                int n = swapVert[best][0];
                numEdges[n] = numEdges[n] - 1;
                int n3 = swapVert[best][1];
                numEdges[n3] = numEdges[n3] - 1;
                int n4 = swapVert[best][2];
                numEdges[n4] = numEdges[n4] + 1;
                int n5 = swapVert[best][3];
                numEdges[n5] = numEdges[n5] + 1;
                int i7 = 0;
                while (true) {
                    if (i7 >= 4) continue block6;
                    int[] vertEdges = vertex[swapVert[best][i7]].getEdges();
                    int j = 0;
                    while (j < vertEdges.length) {
                        if (candidate[vertEdges[j]]) {
                            score[vertEdges[j]] = TriangleMesh.calcSwapScore(minAngle[vertEdges[j]], swapVert[vertEdges[j]], numEdges, onBoundary);
                        }
                        ++j;
                    }
                    ++i7;
                }
                break;
            }
            int[][] newface = new int[face.length][];
            int next = 0;
            int i8 = 0;
            while (i8 < face.length) {
                Face f = face[i8];
                if (!(swap[f.e1] || swap[f.e2] || swap[f.e3])) {
                    newface[next++] = new int[]{f.v1, f.v2, f.v3};
                }
                ++i8;
            }
            int firstSplit = next;
            int i9 = 0;
            while (i9 < edge.length) {
                if (swap[i9]) {
                    newface[next++] = new int[]{swapVert[i9][2], swapVert[i9][0], swapVert[i9][3]};
                    newface[next++] = new int[]{swapVert[i9][2], swapVert[i9][3], swapVert[i9][1]};
                }
                ++i9;
            }
            newmesh = new TriangleMesh(vertex, (int[][])newface);
            Vertex[] newvert = (Vertex[])newmesh.getVertices();
            Edge[] newedge = newmesh.getEdges();
            int i10 = 0;
            while (i10 < edge.length) {
                if (!swap[i10] && (double)edge[i10].smoothness != 1.0) {
                    int[] edges2 = newvert[edge[i10].v1].getEdges();
                    Edge e1 = edge[i10];
                    int k = 0;
                    while (k < edges2.length) {
                        Edge e2 = newedge[edges2[k]];
                        if (e1.v1 == e2.v1 && e1.v2 == e2.v2 || e1.v1 == e2.v2 && e1.v2 == e2.v1) {
                            e2.smoothness = e1.smoothness;
                            break;
                        }
                        ++k;
                    }
                }
                ++i10;
            }
            if (firstSplit == next) break;
            vertex = newvert;
            edge = newedge;
            face = newmesh.getFaces();
            candidate = new boolean[edge.length];
            int i11 = firstSplit;
            while (true) {
                if (i11 >= face.length) continue block1;
                Face f = face[i11];
                candidate[f.e3] = true;
                candidate[f.e2] = true;
                candidate[f.e1] = true;
                ++i11;
            }
            break;
        }
        if (mesh.getTexture() != null) {
            newmesh.setTexture(mesh.getTexture());
            newmesh.setTextureMapping(mesh.getTextureMapping().duplicate());
        }
        newmesh.setMaterial(mesh.getMaterial());
        if (mesh.getMaterial() != null) {
            newmesh.setMaterialMapping(mesh.getMaterialMapping().duplicate());
        }
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    private static double calcSwapScore(double[] minAngle, int[] vert, int[] numEdges, boolean[] onBoundary) {
        double[] s = new double[4];
        int i = 0;
        while (i < 4) {
            int ideal;
            int v = vert[i];
            int n = ideal = onBoundary[v] ? 4 : 6;
            if (i > 1) {
                --ideal;
            }
            s[i] = numEdges[v] > ideal ? minAngle[i] / ((double)(numEdges[v] - ideal) + 1.5) : minAngle[i];
            ++i;
        }
        double currentScore = s[0] < s[1] ? s[0] : s[1];
        double swapScore = s[2] < s[3] ? s[2] : s[3];
        return swapScore - currentScore;
    }

    public TriangleMesh(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.vertex = new Vertex[in.readInt()];
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i] = new Vertex(new Vec3(in));
            this.vertex[i].smoothness = in.readFloat();
            this.vertex[i].ikJoint = in.readInt();
            this.vertex[i].ikWeight = in.readDouble();
            if (this.parameter != null) {
                this.vertex[i].param = new double[this.parameter.length];
                int j = 0;
                while (j < this.parameter.length) {
                    this.vertex[i].param[j] = in.readDouble();
                    ++j;
                }
            }
            ++i;
        }
        this.edge = new Edge[in.readInt()];
        i = 0;
        while (i < this.edge.length) {
            this.edge[i] = new Edge(in.readInt(), in.readInt(), in.readInt());
            this.edge[i].f2 = in.readInt();
            this.edge[i].smoothness = in.readFloat();
            ++i;
        }
        this.face = new Face[in.readInt()];
        i = 0;
        while (i < this.face.length) {
            this.face[i] = new Face(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt());
            ++i;
        }
        this.closed = in.readBoolean();
        this.smoothingMethod = in.readInt();
        i = 0;
        while (i < this.edge.length) {
            Vertex v1 = this.vertex[this.edge[i].v1];
            Vertex v2 = this.vertex[this.edge[i].v2];
            ++v1.edges;
            ++v2.edges;
            if (this.edge[i].f2 == -1) {
                v1.firstEdge = v2.firstEdge = i;
            } else {
                if (v1.firstEdge == -1) {
                    v1.firstEdge = i;
                }
                if (v2.firstEdge == -1) {
                    v2.firstEdge = i;
                }
            }
            ++i;
        }
        this.skeleton = new Skeleton(in);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeInt(this.vertex.length);
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i].r.writeToFile(out);
            out.writeFloat(this.vertex[i].smoothness);
            out.writeInt(this.vertex[i].ikJoint);
            out.writeDouble(this.vertex[i].ikWeight);
            if (this.parameter != null) {
                int j = 0;
                while (j < this.parameter.length) {
                    out.writeDouble(this.vertex[i].param[j]);
                    ++j;
                }
            }
            ++i;
        }
        out.writeInt(this.edge.length);
        i = 0;
        while (i < this.edge.length) {
            out.writeInt(this.edge[i].v1);
            out.writeInt(this.edge[i].v2);
            out.writeInt(this.edge[i].f1);
            out.writeInt(this.edge[i].f2);
            out.writeFloat(this.edge[i].smoothness);
            ++i;
        }
        out.writeInt(this.face.length);
        i = 0;
        while (i < this.face.length) {
            out.writeInt(this.face[i].v1);
            out.writeInt(this.face[i].v2);
            out.writeInt(this.face[i].v3);
            out.writeInt(this.face[i].e1);
            out.writeInt(this.face[i].e2);
            out.writeInt(this.face[i].e3);
            ++i;
        }
        out.writeBoolean(this.closed);
        out.writeInt(this.smoothingMethod);
        this.skeleton.writeToStream(out);
    }

    public Keyframe getPoseKeyframe() {
        return new TriangleMeshKeyframe(this);
    }

    public void applyPoseKeyframe(Keyframe k) {
        TriangleMeshKeyframe key = (TriangleMeshKeyframe)k;
        int i = 0;
        while (i < this.vertex.length) {
            Vertex v = this.vertex[i];
            v.r.set(key.vertPos[i]);
            v.smoothness = key.vertSmoothness[i];
            ++i;
        }
        if (this.parameter != null && this.parameter.length > 0) {
            int i2 = 0;
            while (i2 < this.vertex.length) {
                int j = 0;
                while (j < this.vertex[i2].param.length) {
                    this.vertex[i2].param[j] = key.param[i2][j];
                    ++j;
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < this.edge.length) {
            this.edge[i3].smoothness = key.edgeSmoothness[i3];
            ++i3;
        }
        this.skeleton.copy(key.skeleton);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public Object3D getPosableObject() {
        TriangleMesh m = (TriangleMesh)this.duplicate();
        return new Actor(m);
    }

    static {
        double beta;
        LOOP_BETA = new double[32];
        int i = 3;
        while (i < LOOP_BETA.length) {
            beta = 0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)i);
            TriangleMesh.LOOP_BETA[i] = (0.625 - beta * beta) / (double)i;
            ++i;
        }
        BUTTERFLY_COEFF = new double[32][];
        i = 5;
        while (i < BUTTERFLY_COEFF.length) {
            TriangleMesh.BUTTERFLY_COEFF[i] = new double[i + 1];
            TriangleMesh.BUTTERFLY_COEFF[i][i] = 1.0;
            beta = Math.PI * 2 / (double)i;
            int j = 0;
            while (j < i) {
                TriangleMesh.BUTTERFLY_COEFF[i][j] = (0.25 + Math.cos(beta * (double)j) + 0.5 * Math.cos(2.0 * beta * (double)j)) / (double)i;
                double[] dArray = BUTTERFLY_COEFF[i];
                int n = i;
                dArray[n] = dArray[n] - BUTTERFLY_COEFF[i][j];
                ++j;
            }
            ++i;
        }
        TriangleMesh.BUTTERFLY_COEFF[3] = new double[]{0.4166666666666667, -0.08333333333333333, -0.08333333333333333, 0.75};
        TriangleMesh.BUTTERFLY_COEFF[4] = new double[]{0.375, 0.0, -0.125, 0.0, 0.75};
        TriangleMesh.BUTTERFLY_COEFF[6] = new double[]{1.0, 0.125, -0.125, 0.0, -0.125, 0.125, 0.0};
    }

    public static class TriangleMeshKeyframe
    implements ActorPose {
        Vec3[] vertPos;
        float[] vertSmoothness;
        float[] edgeSmoothness;
        double[][] param;
        Skeleton skeleton;
        TriangleMesh mesh;

        public TriangleMeshKeyframe(TriangleMesh mesh) {
            this.mesh = mesh;
            this.skeleton = mesh.getSkeleton().duplicate();
            this.vertPos = new Vec3[mesh.vertex.length];
            this.vertSmoothness = new float[mesh.vertex.length];
            this.edgeSmoothness = new float[mesh.edge.length];
            int i = 0;
            while (i < this.vertPos.length) {
                Vertex v = mesh.vertex[i];
                this.vertPos[i] = new Vec3(v.r);
                this.vertSmoothness[i] = v.smoothness;
                ++i;
            }
            if (mesh.parameter != null && mesh.parameter.length > 0) {
                this.param = new double[mesh.vertex.length][mesh.parameter.length];
                int i2 = 0;
                while (i2 < this.vertPos.length) {
                    int j = 0;
                    while (j < mesh.parameter.length) {
                        this.param[i2][j] = mesh.vertex[i2].param[j];
                        ++j;
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < this.edgeSmoothness.length) {
                this.edgeSmoothness[i3] = mesh.edge[i3].smoothness;
                ++i3;
            }
        }

        private TriangleMeshKeyframe() {
        }

        public Skeleton getSkeleton() {
            return this.skeleton;
        }

        public void setSkeleton(Skeleton s) {
            this.skeleton = s;
        }

        public Keyframe duplicate() {
            return this.duplicate(this.mesh);
        }

        public Keyframe duplicate(Object owner) {
            int i;
            TriangleMeshKeyframe k = new TriangleMeshKeyframe();
            k.mesh = (TriangleMesh)owner;
            k.skeleton = this.skeleton.duplicate();
            k.vertPos = new Vec3[this.vertPos.length];
            k.vertSmoothness = new float[this.vertSmoothness.length];
            k.edgeSmoothness = new float[this.edgeSmoothness.length];
            int i2 = 0;
            while (i2 < this.vertPos.length) {
                k.vertPos[i2] = new Vec3(this.vertPos[i2]);
                k.vertSmoothness[i2] = this.vertSmoothness[i2];
                ++i2;
            }
            if (this.mesh.parameter != null && this.mesh.parameter.length > 0) {
                k.param = new double[this.param.length][this.mesh.parameter.length];
                i = 0;
                while (i < this.param.length) {
                    int j = 0;
                    while (j < this.mesh.parameter.length) {
                        k.param[i][j] = this.param[i][j];
                        ++j;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < this.edgeSmoothness.length) {
                k.edgeSmoothness[i] = this.edgeSmoothness[i];
                ++i;
            }
            return k;
        }

        public double[] getGraphValues() {
            return new double[0];
        }

        public void setGraphValues(double[] values) {
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            return null;
        }

        public ActorPose blend(ActorPose[] p, double[] weight) {
            TriangleMeshKeyframe total = (TriangleMeshKeyframe)this.duplicate(this.mesh);
            Joint[] joint = this.skeleton.getJoints();
            Joint[] jt = total.skeleton.getJoints();
            Vec3[] root = new Vec3[joint.length];
            Vec3[] newroot = new Vec3[joint.length];
            double[][] rootangles = new double[joint.length][];
            int i = 0;
            while (i < jt.length) {
                if (jt[i].parent == null) {
                    root[i] = joint[i].coords.getOrigin();
                    newroot[i] = new Vec3(jt[i].coords.getOrigin());
                    rootangles[i] = joint[i].coords.getRotationAngles();
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < weight.length) {
                TriangleMeshKeyframe key = (TriangleMeshKeyframe)p[i2];
                Joint[] jt2 = key.skeleton.getJoints();
                int j = 0;
                while (j < jt.length) {
                    jt[j].angle1.pos += weight[i2] * this.findOffset(jt2[j].angle1, joint[j].angle1);
                    jt[j].angle2.pos += weight[i2] * this.findOffset(jt2[j].angle2, joint[j].angle2);
                    jt[j].twist.pos += weight[i2] * this.findOffset(jt2[j].twist, joint[j].twist);
                    jt[j].length.pos += weight[i2] * this.findOffset(jt2[j].length, joint[j].length);
                    if (jt[j].parent == null) {
                        newroot[j].add(jt2[j].coords.getOrigin().minus(root[j]).times(weight[i2]));
                        double[] angles = jt2[j].coords.getRotationAngles();
                        RotationKeyframe rot = new RotationKeyframe(angles[0] - rootangles[j][0], angles[1] - rootangles[j][1], angles[2] - rootangles[j][2]);
                        rot.applyToCoordinates(jt[j].coords, weight[i2], null, null, true, true, true, true);
                    }
                    ++j;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < jt.length) {
                jt[i3].angle1.set(jt[i3].angle1.pos);
                jt[i3].angle2.set(jt[i3].angle2.pos);
                jt[i3].twist.set(jt[i3].twist.pos);
                jt[i3].length.set(jt[i3].length.pos);
                ++i3;
            }
            int i4 = 0;
            while (i4 < jt.length) {
                if (jt[i4].parent == null) {
                    jt[i4].coords.setOrigin(newroot[i4]);
                    jt[i4].recalcCoords(true);
                }
                ++i4;
            }
            Vec3 temp = new Vec3();
            int j = 0;
            while (j < this.vertPos.length) {
                Vertex v = this.mesh.vertex[j];
                int index = this.skeleton.findJointIndex(v.ikJoint);
                if (index != -1) {
                    Joint j1 = joint[index];
                    Joint j2 = jt[index];
                    double wt = j2.parent == null ? 1.0 : v.ikWeight;
                    j1.coords.toLocal().transform(total.vertPos[j]);
                    j2.coords.fromLocal().transform(total.vertPos[j]);
                    if (wt < 1.0) {
                        total.vertPos[j].scale(wt);
                        temp.set(this.vertPos[j]);
                        j1.parent.coords.toLocal().transform(temp);
                        j2.parent.coords.fromLocal().transform(temp);
                        temp.scale(1.0 - wt);
                        total.vertPos[j].add(temp);
                    }
                }
                ++j;
            }
            Vec3 temp1 = new Vec3();
            Vec3 temp2 = new Vec3();
            int i5 = 0;
            while (i5 < weight.length) {
                TriangleMeshKeyframe key = (TriangleMeshKeyframe)p[i5];
                int j2 = 0;
                while (j2 < this.vertPos.length) {
                    Vertex v = this.mesh.vertex[j2];
                    int index = this.skeleton.findJointIndex(v.ikJoint);
                    if (index == -1) {
                        total.vertPos[j2].add(key.vertPos[j2].minus(this.vertPos[j2]).times(weight[i5]));
                    } else {
                        Joint j1 = joint[index];
                        Joint j22 = jt[index];
                        Joint j3 = key.skeleton.getJoint(j1.id);
                        double wt = j1.parent == null ? 1.0 : v.ikWeight;
                        temp1.set(key.vertPos[j2]);
                        temp2.set(this.vertPos[j2]);
                        j3.coords.toLocal().transform(temp1);
                        j1.coords.toLocal().transform(temp2);
                        temp1.subtract(temp2);
                        j22.coords.fromLocal().transformDirection(temp1);
                        temp1.scale(wt * weight[i5]);
                        total.vertPos[j2].add(temp1);
                        if (wt < 1.0) {
                            temp1.set(key.vertPos[j2]);
                            temp2.set(this.vertPos[j2]);
                            j3.parent.coords.toLocal().transform(temp1);
                            j1.parent.coords.toLocal().transform(temp2);
                            temp1.subtract(temp2);
                            j22.parent.coords.fromLocal().transformDirection(temp1);
                            temp1.scale((1.0 - wt) * weight[i5]);
                            total.vertPos[j2].add(temp1);
                        }
                    }
                    int n = j2;
                    total.vertSmoothness[n] = total.vertSmoothness[n] + (float)(weight[i5] * (double)(key.vertSmoothness[j2] - this.vertSmoothness[j2]));
                    ++j2;
                }
                if (this.mesh.parameter != null && this.mesh.parameter.length > 0) {
                    int j3 = 0;
                    while (j3 < this.param.length) {
                        int m = 0;
                        while (m < this.mesh.parameter.length) {
                            double[] dArray = total.param[j3];
                            int n = m;
                            dArray[n] = dArray[n] + weight[i5] * (key.param[j3][m] - this.param[j3][m]);
                            ++m;
                        }
                        ++j3;
                    }
                }
                int j4 = 0;
                while (j4 < this.edgeSmoothness.length) {
                    int n = j4;
                    total.edgeSmoothness[n] = (float)((double)total.edgeSmoothness[n] + weight[i5] * (double)(key.edgeSmoothness[j4] - this.edgeSmoothness[j4]));
                    ++j4;
                }
                ++i5;
            }
            int i6 = 0;
            while (i6 < total.vertSmoothness.length) {
                if ((double)total.vertSmoothness[i6] < 0.0) {
                    total.vertSmoothness[i6] = 0.0f;
                }
                if ((double)total.vertSmoothness[i6] > 1.0) {
                    total.vertSmoothness[i6] = 1.0f;
                }
                ++i6;
            }
            int i7 = 0;
            while (i7 < total.edgeSmoothness.length) {
                if ((double)total.edgeSmoothness[i7] < 0.0) {
                    total.edgeSmoothness[i7] = 0.0f;
                }
                if ((double)total.edgeSmoothness[i7] > 1.0) {
                    total.edgeSmoothness[i7] = 1.0f;
                }
                ++i7;
            }
            return total;
        }

        private double findOffset(Joint.DOF gesture, Joint.DOF defaultPose) {
            double diff = gesture.pos - defaultPose.pos;
            if (gesture.loop) {
                double range = gesture.max - gesture.min;
                while (diff > gesture.max) {
                    diff -= range;
                }
                while (diff < gesture.min) {
                    diff += range;
                }
            }
            return diff;
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof TriangleMeshKeyframe)) {
                return false;
            }
            TriangleMeshKeyframe key = (TriangleMeshKeyframe)k;
            int i = 0;
            while (i < this.vertPos.length) {
                if (!this.vertPos[i].equals(key.vertPos[i])) {
                    return false;
                }
                if (this.vertSmoothness[i] != key.vertSmoothness[i]) {
                    return false;
                }
                ++i;
            }
            if (this.mesh.parameter != null && this.mesh.parameter.length > 0) {
                int i2 = 0;
                while (i2 < this.param.length) {
                    int j = 0;
                    while (j < this.mesh.parameter.length) {
                        if (this.param[i2][j] != key.param[i2][j]) {
                            return false;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < this.edgeSmoothness.length) {
                if (this.edgeSmoothness[i3] != key.edgeSmoothness[i3]) {
                    return false;
                }
                ++i3;
            }
            return this.skeleton.equals(key.skeleton);
        }

        public void textureChanged(TextureParameter[] oldParams, TextureParameter[] newParams) {
            double[][] newval = new double[this.vertPos.length][newParams.length];
            int i = 0;
            while (i < newParams.length) {
                int k;
                int j = 0;
                while (j < oldParams.length && !oldParams[j].equals(newParams[i])) {
                    ++j;
                }
                if (j == oldParams.length || this.param == null) {
                    k = 0;
                    while (k < this.mesh.parameter.length) {
                        if (this.mesh.parameter[k].equals(newParams[i])) {
                            j = 0;
                            while (j < newval.length) {
                                newval[j][i] = this.mesh.vertex[j].param[k];
                                ++j;
                            }
                            break;
                        }
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < newval.length) {
                        newval[k][i] = this.param[k][j];
                        ++k;
                    }
                }
                ++i;
            }
            this.param = newval;
        }

        public void setTextureParameter(TextureParameter p, double[] value) {
            int which = 0;
            while (which < this.mesh.parameter.length && !this.mesh.parameter[which].equals(p)) {
                ++which;
            }
            if (which == this.mesh.parameter.length) {
                return;
            }
            int i = 0;
            while (i < value.length) {
                this.param[i][which] = value[i];
                ++i;
            }
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeShort(0);
            out.writeInt(this.vertPos.length);
            int i = 0;
            while (i < this.vertPos.length) {
                this.vertPos[i].writeToFile(out);
                out.writeFloat(this.vertSmoothness[i]);
                if (this.param != null) {
                    int j = 0;
                    while (j < this.param[i].length) {
                        out.writeDouble(this.param[i][j]);
                        ++j;
                    }
                }
                ++i;
            }
            out.writeInt(this.edgeSmoothness.length);
            int i2 = 0;
            while (i2 < this.edgeSmoothness.length) {
                out.writeFloat(this.edgeSmoothness[i2]);
                ++i2;
            }
            Joint[] joint = this.skeleton.getJoints();
            int i3 = 0;
            while (i3 < joint.length) {
                joint[i3].coords.writeToFile(out);
                out.writeDouble(joint[i3].angle1.pos);
                out.writeDouble(joint[i3].angle2.pos);
                out.writeDouble(joint[i3].twist.pos);
                out.writeDouble(joint[i3].length.pos);
                ++i3;
            }
        }

        public TriangleMeshKeyframe(DataInputStream in, Object parent) throws IOException, InvalidObjectException {
            this();
            short version = in.readShort();
            if (version != 0) {
                throw new InvalidObjectException("");
            }
            this.mesh = (TriangleMesh)parent;
            int numVert = in.readInt();
            this.vertPos = new Vec3[numVert];
            this.vertSmoothness = new float[numVert];
            if (this.mesh.parameter != null && this.mesh.parameter.length > 0) {
                this.param = new double[numVert][this.mesh.parameter.length];
            }
            int i = 0;
            while (i < numVert) {
                this.vertPos[i] = new Vec3(in);
                this.vertSmoothness[i] = in.readFloat();
                if (this.param != null) {
                    int j = 0;
                    while (j < this.param[i].length) {
                        this.param[i][j] = in.readDouble();
                        ++j;
                    }
                }
                ++i;
            }
            this.edgeSmoothness = new float[in.readInt()];
            int i2 = 0;
            while (i2 < this.edgeSmoothness.length) {
                this.edgeSmoothness[i2] = in.readFloat();
                ++i2;
            }
            this.skeleton = this.mesh.getSkeleton().duplicate();
            Joint[] joint = this.skeleton.getJoints();
            int i3 = 0;
            while (i3 < joint.length) {
                joint[i3].coords = new CoordinateSystem(in);
                joint[i3].angle1.pos = in.readDouble();
                joint[i3].angle2.pos = in.readDouble();
                joint[i3].twist.pos = in.readDouble();
                joint[i3].length.pos = in.readDouble();
                ++i3;
            }
        }
    }

    public class Face {
        public int v1;
        public int v2;
        public int v3;
        public int e1;
        public int e2;
        public int e3;

        public Face(int vertex1, int vertex2, int vertex3, int edge1, int edge2, int edge3) {
            this.v1 = vertex1;
            this.v2 = vertex2;
            this.v3 = vertex3;
            this.e1 = edge1;
            this.e2 = edge2;
            this.e3 = edge3;
        }
    }

    public class Edge {
        public int v1;
        public int v2;
        public int f1;
        public int f2;
        public float smoothness;

        public Edge(int vertex1, int vertex2, int face1) {
            this.v1 = vertex1;
            this.v2 = vertex2;
            this.f1 = face1;
            this.f2 = -1;
            this.smoothness = 1.0f;
        }
    }

    public class Vertex
    extends MeshVertex {
        public int edges;
        public int firstEdge;
        public float smoothness;

        public Vertex(Vec3 p) {
            super(p);
            this.edges = 0;
            this.firstEdge = -1;
            this.smoothness = 1.0f;
        }

        public Vertex(Vertex v) {
            super(v);
            this.edges = v.edges;
            this.firstEdge = v.firstEdge;
            this.smoothness = v.smoothness;
        }

        public void copy(Vertex v) {
            this.r.set(v.r);
            this.edges = v.edges;
            this.firstEdge = v.firstEdge;
            this.smoothness = v.smoothness;
            this.ikJoint = v.ikJoint;
            this.ikWeight = v.ikWeight;
            if (v.param == null) {
                this.param = null;
            } else {
                if (this.param == null || this.param.length != v.param.length) {
                    this.param = new double[v.param.length];
                }
                System.arraycopy(v.param, 0, this.param, 0, this.param.length);
            }
        }

        public void scale(double d) {
            this.r.scale(d);
            this.smoothness = (float)((double)this.smoothness * d);
            this.ikWeight *= d;
            if (this.param != null) {
                int i = this.param.length - 1;
                while (i >= 0) {
                    int n = i--;
                    this.param[n] = this.param[n] * d;
                }
            }
        }

        public void clear() {
            this.r.set(0.0, 0.0, 0.0);
            this.smoothness = 0.0f;
            this.ikWeight = 0.0;
            if (this.param != null) {
                int i = this.param.length - 1;
                while (i >= 0) {
                    this.param[i] = 0.0;
                    --i;
                }
            }
        }

        public int[] getEdges() {
            int[] e = new int[this.edges];
            if (this.edges == 0) {
                return e;
            }
            Face f = TriangleMesh.this.face[TriangleMesh.this.edge[this.firstEdge].f1];
            e[0] = this.firstEdge;
            int i = 1;
            while (i < this.edges) {
                e[i] = TriangleMesh.this.vertex[f.v1] == this ? (f.e1 == e[i - 1] ? f.e3 : f.e1) : (TriangleMesh.this.vertex[f.v2] == this ? (f.e1 == e[i - 1] ? f.e2 : f.e1) : (f.e2 == e[i - 1] ? f.e3 : f.e2));
                f = TriangleMesh.this.face[TriangleMesh.this.edge[e[i]].f1] == f && TriangleMesh.this.edge[e[i]].f2 > -1 ? TriangleMesh.this.face[TriangleMesh.this.edge[e[i]].f2] : TriangleMesh.this.face[TriangleMesh.this.edge[e[i]].f1];
                ++i;
            }
            return e;
        }

        public boolean clockwise() {
            Face f = TriangleMesh.this.face[TriangleMesh.this.edge[this.firstEdge].f1];
            if (f.e1 == this.firstEdge) {
                return TriangleMesh.this.vertex[f.v2] == this;
            }
            if (f.e2 == this.firstEdge) {
                return TriangleMesh.this.vertex[f.v3] == this;
            }
            return TriangleMesh.this.vertex[f.v1] == this;
        }
    }
}

