/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Callback;
import artofillusion.ModellingApp;
import artofillusion.ObjectViewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.TubeEditorWindow;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.NullKeyframe;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Vector;

public class Tube
extends Curve {
    double[] thickness;
    int endsStyle;
    RenderingMesh cachedMesh;
    TextureParameter[] parameter;
    public static final int OPEN_ENDS = 0;
    public static final int CLOSED_ENDS = 1;
    public static final int FLAT_ENDS = 2;
    private static final int MAX_SUBDIVISIONS = 20;

    public Tube(Vec3[] v, float[] smoothness, double[] thickness, int smoothingMethod, int endsStyle) {
        super(v, smoothness, smoothingMethod, endsStyle == 1);
        this.thickness = thickness;
        this.endsStyle = endsStyle;
    }

    public Tube(MeshVertex[] v, float[] smoothness, double[] thickness, int smoothingMethod, int endsStyle) {
        super(new Vec3[v.length], smoothness, smoothingMethod, endsStyle == 1);
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i] = new MeshVertex(v[i]);
            ++i;
        }
        this.thickness = thickness;
        this.endsStyle = endsStyle;
    }

    public Tube(Curve c, double[] thickness, int endsStyle) {
        super(new Vec3[c.vertex.length], c.smoothness, c.smoothingMethod, endsStyle == 1);
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i].r = new Vec3(c.vertex[i].r);
            ++i;
        }
        this.thickness = thickness;
        this.endsStyle = endsStyle;
    }

    public Tube(Vec3[] v, double thickness, int smoothingMethod, int endsStyle) {
        super(v, new float[v.length], smoothingMethod, endsStyle == 1);
        this.thickness = new double[v.length];
        this.endsStyle = endsStyle;
        int i = 0;
        while (i < v.length) {
            this.smoothness[i] = 1.0f;
            this.thickness[i] = thickness;
            ++i;
        }
    }

    public Object3D duplicate() {
        Curve c = (Curve)super.duplicate();
        double[] t = new double[this.thickness.length];
        System.arraycopy(this.thickness, 0, t, 0, t.length);
        Tube tube = new Tube(c, t, this.endsStyle);
        tube.setTexture(this.theTexture);
        if (this.texMapping != null) {
            tube.setTextureMapping(this.texMapping.duplicate());
        }
        tube.setMaterial(this.theMaterial);
        if (this.matMapping != null) {
            tube.setMaterialMapping(this.matMapping.duplicate());
        }
        if (this.parameter != null && this.parameter.length > 0) {
            int i = 0;
            while (i < this.vertex.length) {
                tube.vertex[i].param = new double[this.vertex[i].param.length];
                int j = 0;
                while (j < this.vertex[i].param.length) {
                    tube.vertex[i].param[j] = this.vertex[i].param[j];
                    ++j;
                }
                ++i;
            }
        }
        return tube;
    }

    public void copyObject(Object3D obj) {
        Tube t = (Tube)obj;
        super.copyObject(t);
        this.parameter = null;
        this.thickness = new double[t.thickness.length];
        System.arraycopy(t.thickness, 0, this.thickness, 0, this.thickness.length);
        this.endsStyle = t.endsStyle;
        this.setTexture(t.getTexture());
        if (t.getTextureMapping() != null) {
            this.setTextureMapping(t.getTextureMapping().duplicate());
        }
        this.setMaterial(t.getMaterial());
        if (t.getMaterialMapping() != null) {
            this.setMaterialMapping(t.getMaterialMapping().duplicate());
        }
        if (this.parameter != null && this.parameter.length > 0) {
            int i = 0;
            while (i < this.vertex.length) {
                this.vertex[i].param = new double[t.vertex[i].param.length];
                int j = 0;
                while (j < this.vertex[i].param.length) {
                    this.vertex[i].param[j] = t.vertex[i].param[j];
                    ++j;
                }
                ++i;
            }
        }
    }

    public double[] getThickness() {
        return this.thickness;
    }

    public void setThickness(double[] thickness) {
        this.thickness = thickness;
        this.clearCachedMesh();
    }

    public void setShape(MeshVertex[] v, float[] smoothness, double[] thickness) {
        this.vertex = v;
        this.thickness = thickness;
        this.smoothness = smoothness;
        this.clearCachedMesh();
    }

    public int getEndsStyle() {
        return this.endsStyle;
    }

    public void setEndsStyle(int style) {
        this.endsStyle = style;
        this.closed = style == 1;
        this.clearCachedMesh();
    }

    public boolean isClosed() {
        return this.endsStyle != 0 || this.thickness[0] == 0.0 && this.thickness[this.thickness.length - 1] == 0.0;
    }

    public void setClosed(boolean isClosed) {
        super.setClosed(isClosed);
        if (isClosed) {
            this.endsStyle = 1;
        } else if (this.endsStyle == 1) {
            this.endsStyle = 0;
        }
    }

    protected void clearCachedMesh() {
        super.clearCachedMesh();
        this.cachedMesh = null;
    }

    public Tube subdivideTube(double tol) {
        if (this.vertex.length < 3) {
            return this;
        }
        if (this.smoothingMethod == 2) {
            return this.subdivideTubeInterp(tol);
        }
        if (this.smoothingMethod == 3) {
            return this.subdivideTubeApprox(tol);
        }
        return this;
    }

    private Tube subdivideTubeApprox(double tol) {
        int count;
        int i;
        Tube t = this;
        double tol2 = tol * tol;
        boolean[] refine = new boolean[t.vertex.length];
        if (t.closed) {
            i = 0;
            while (i < refine.length) {
                refine[i] = true;
                ++i;
            }
            count = refine.length;
        } else {
            i = 1;
            while (i < refine.length - 1) {
                refine[i] = true;
                ++i;
            }
            count = refine.length - 1;
        }
        int iterations = 0;
        do {
            int len = t.vertex.length;
            MeshVertex[] newvert = new MeshVertex[len + count];
            float[] news = new float[len + count];
            double[] newt = new double[len + count];
            boolean[] newrefine = new boolean[len + count];
            i = 0;
            int j = 0;
            while (j < len) {
                int p1 = j - 1;
                if (p1 < 0) {
                    p1 = t.closed ? len - 1 : 0;
                }
                int p2 = j;
                int p3 = j + 1;
                if (p3 >= len) {
                    int n = p3 = t.closed ? p3 - len : len - 1;
                }
                if (!refine[j]) {
                    newvert[i] = t.vertex[j];
                    newt[i] = t.thickness[j];
                    news[i] = t.smoothness[j];
                } else {
                    newvert[i] = Tube.calcApproxPoint(t.vertex, t.smoothness, p1, p2, p3);
                    newt[i] = Tube.calcApproxThickness(t.thickness, t.smoothness, p1, p2, p3);
                    news[i] = t.smoothness[j] * 2.0f;
                    if (news[i] > 1.0f) {
                        news[i] = 1.0f;
                    }
                }
                ++i;
                if (refine[p2] || refine[p3]) {
                    newvert[i] = MeshVertex.blend(t.vertex[p2], t.vertex[p3], 0.5, 0.5);
                    newt[i] = 0.5 * (t.thickness[p2] + t.thickness[p3]);
                    news[i] = 1.0f;
                    if (newvert[i - 1].r.distance2(t.vertex[j].r) > tol2 && newvert[i].r.distance2(newvert[i - 1].r) > tol2 && (i < 2 || newvert[i - 1].r.distance2(newvert[i - 2].r) > tol2)) {
                        newrefine[i - 1] = true;
                        newrefine[i] = true;
                        if (i > 1) {
                            newrefine[i - 2] = true;
                        }
                    }
                    ++i;
                }
                ++j;
            }
            count = 0;
            j = 0;
            while (j < newrefine.length - 1) {
                if (newrefine[j] || newrefine[j + 1]) {
                    ++count;
                }
                ++j;
            }
            if (t.closed && (newrefine[newrefine.length - 1] || newrefine[0])) {
                ++count;
            }
            t = new Tube(newvert, news, newt, t.smoothingMethod, t.endsStyle);
            refine = newrefine;
        } while (count > 0 && ++iterations < 20);
        return t;
    }

    private Tube subdivideTubeInterp(double tol) {
        Tube t = this;
        double tol2 = tol * tol;
        boolean[] refine = t.closed ? new boolean[t.vertex.length] : new boolean[t.vertex.length - 1];
        int i = 0;
        while (i < refine.length) {
            refine[i] = true;
            ++i;
        }
        int count = refine.length;
        int iterations = 0;
        do {
            int len = t.vertex.length;
            MeshVertex[] newvert = new MeshVertex[len + count];
            float[] news = new float[len + count];
            double[] newt = new double[len + count];
            boolean[] newrefine = new boolean[len + count];
            i = 0;
            int j = 0;
            while (j < len) {
                newvert[i] = t.vertex[j];
                newt[i] = t.thickness[j];
                news[i] = t.smoothness[j] * 2.0f;
                if (news[i] > 1.0f) {
                    news[i] = 1.0f;
                }
                ++i;
                if (j < refine.length && refine[j]) {
                    Vec3 temp;
                    int p4;
                    int p1 = j - 1;
                    if (p1 < 0) {
                        p1 = t.closed ? len - 1 : 0;
                    }
                    int p2 = j;
                    int p3 = j + 1;
                    if (p3 >= len) {
                        int n = p3 = t.closed ? p3 - len : len - 1;
                    }
                    if ((p4 = j + 2) >= len) {
                        p4 = t.closed ? p4 - len : len - 1;
                    }
                    newvert[i] = Tube.calcInterpPoint(t.vertex, t.smoothness, p1, p2, p3, p4);
                    newt[i] = Tube.calcInterpThickness(t.thickness, t.smoothness, p1, p2, p3, p4);
                    news[i] = 1.0f;
                    if (newvert[i].r.distance2(t.vertex[p2].r) > tol2 && newvert[i].r.distance2(t.vertex[p3].r) > tol2 && (temp = t.vertex[p2].r.plus(t.vertex[p3].r).times(0.5)).distance2(newvert[i].r) > tol2) {
                        newrefine[i] = true;
                        if (i > 0) {
                            newrefine[i - 1] = true;
                        }
                    }
                    ++i;
                }
                ++j;
            }
            count = 0;
            j = 0;
            while (j < newrefine.length) {
                if (newrefine[j]) {
                    ++count;
                }
                ++j;
            }
            t = new Tube(newvert, news, newt, t.smoothingMethod, t.endsStyle);
            refine = newrefine;
        } while (count > 0 && ++iterations < 20);
        return t;
    }

    public static MeshVertex calcInterpPoint(MeshVertex[] v, float[] s, int i, int j, int k, int m) {
        double w1 = -0.0625 * (double)s[j];
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * (double)s[k];
        double w3 = 0.5 - w4;
        MeshVertex vert = new MeshVertex(new Vec3(w1 * v[i].r.x + w2 * v[j].r.x + w3 * v[k].r.x + w4 * v[m].r.x, w1 * v[i].r.y + w2 * v[j].r.y + w3 * v[k].r.y + w4 * v[m].r.y, w1 * v[i].r.z + w2 * v[j].r.z + w3 * v[k].r.z + w4 * v[m].r.z));
        if (v[i].param != null) {
            vert.param = new double[v[i].param.length];
            int ind = 0;
            while (ind < vert.param.length) {
                vert.param[ind] = w1 * v[i].param[ind] + w2 * v[j].param[ind] + w3 * v[k].param[ind] + w4 * v[m].param[ind];
                ++ind;
            }
        }
        return vert;
    }

    public static MeshVertex calcApproxPoint(MeshVertex[] v, float[] s, int i, int j, int k) {
        double w1 = 0.125 * (double)s[j];
        double w2 = 1.0 - 2.0 * w1;
        MeshVertex vert = new MeshVertex(new Vec3(w1 * v[i].r.x + w2 * v[j].r.x + w1 * v[k].r.x, w1 * v[i].r.y + w2 * v[j].r.y + w1 * v[k].r.y, w1 * v[i].r.z + w2 * v[j].r.z + w1 * v[k].r.z));
        if (v[i].param != null) {
            vert.param = new double[v[i].param.length];
            int ind = 0;
            while (ind < vert.param.length) {
                vert.param[ind] = w1 * v[i].param[ind] + w2 * v[j].param[ind] + w1 * v[k].param[ind];
                ++ind;
            }
        }
        return vert;
    }

    public static double calcInterpThickness(double[] t, float[] s, int i, int j, int k, int m) {
        double w1 = -0.0625 * (double)s[j];
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * (double)s[k];
        double w3 = 0.5 - w4;
        return w1 * t[i] + w2 * t[j] + w3 * t[k] + w4 * t[m];
    }

    public static double calcApproxThickness(double[] t, float[] s, int i, int j, int k) {
        double w1 = 0.125 * (double)s[j];
        double w2 = 1.0 - 2.0 * w1;
        return w1 * t[i] + w2 * t[j] + w1 * t[k];
    }

    public boolean canSetTexture() {
        return true;
    }

    public int canConvertToTriangleMesh() {
        return 2;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        if (interactive && this.cachedMesh != null) {
            return this.cachedMesh;
        }
        Vector vert = new Vector();
        Vector norm = new Vector();
        Vector face = new Vector();
        this.subdivideSurface(tol, vert, norm, face);
        Vec3[] v = new Vec3[vert.size()];
        int i = 0;
        while (i < v.length) {
            v[i] = ((MeshVertex)vert.elementAt((int)i)).r;
            ++i;
        }
        Object[] n = new Vec3[vert.size()];
        norm.copyInto(n);
        int numnorm = norm.size();
        RenderingTriangle[] tri = new RenderingTriangle[face.size()];
        int i2 = 0;
        while (i2 < tri.length) {
            int[] f = (int[])face.elementAt(i2);
            tri[i2] = f[0] >= numnorm || f[1] >= numnorm || f[2] >= numnorm ? this.texMapping.mapTriangle(f[0], f[1], f[2], numnorm, numnorm, numnorm, v) : this.texMapping.mapTriangle(f[0], f[1], f[2], f[0], f[1], f[2], v);
            ++i2;
        }
        RenderingMesh rend = new RenderingMesh(v, (Vec3[])n, tri);
        if (this.parameter != null && this.parameter.length > 0) {
            double[][] param = new double[v.length][info.texParam.length];
            int i3 = 0;
            while (i3 < info.texParam.length) {
                if (info.texParamPerVertex[i3]) {
                    int j = 0;
                    while (j < v.length) {
                        param[j][i3] = ((MeshVertex)vert.elementAt((int)j)).param[i3];
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < v.length) {
                        param[j][i3] = info.texParamValue[i3];
                        ++j;
                    }
                }
                ++i3;
            }
            rend.setParameters(param, this.texMapping);
        }
        if (interactive) {
            this.cachedMesh = rend;
        }
        return rend;
    }

    public void setTextureMapping(TextureMapping mapping) {
        int j2;
        super.setTextureMapping(mapping);
        TextureParameter[] texparam = mapping.getParameters();
        this.cachedMesh = null;
        this.cachedWire = null;
        if (texparam == null || texparam.length == 0) {
            this.parameter = null;
            if (this.vertex != null) {
                int i = 0;
                while (i < this.vertex.length) {
                    this.vertex[i].param = null;
                    ++i;
                }
            }
            return;
        }
        TextureParameter[] newparam = new TextureParameter[texparam.length];
        int i = 0;
        while (i < newparam.length) {
            newparam[i] = texparam[i].duplicate();
            ++i;
        }
        if (this.vertex == null) {
            this.parameter = newparam;
            return;
        }
        if (this.parameter == null || this.parameter.length == 0) {
            this.parameter = newparam;
            i = 0;
            while (i < this.vertex.length) {
                this.vertex[i].param = new double[newparam.length];
                int j2 = 0;
                while (j2 < newparam.length) {
                    this.vertex[i].param[j2] = newparam[j2].defaultVal;
                    ++j2;
                }
                ++i;
            }
            return;
        }
        int[] index = new int[newparam.length];
        i = 0;
        while (i < newparam.length) {
            j2 = 0;
            while (j2 < this.parameter.length && !this.parameter[j2].equals(newparam[i])) {
                ++j2;
            }
            index[i] = j2;
            ++i;
        }
        i = 0;
        while (i < this.vertex.length) {
            double[] newval = new double[newparam.length];
            j2 = 0;
            while (j2 < newparam.length) {
                newval[j2] = index[j2] == this.parameter.length ? newparam[j2].defaultVal : this.vertex[i].param[index[j2]];
                ++j2;
            }
            this.vertex[i].param = newval;
            ++i;
        }
        this.parameter = newparam;
    }

    public WireframeMesh getWireframeMesh() {
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        this.cachedWire = this.convertToTriangleMesh(ModellingApp.getPreferences().getInteractiveSurfaceError()).getWireframeMesh();
        return this.cachedWire;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        Vector vert = new Vector();
        Vector norm = new Vector();
        Vector face = new Vector();
        this.subdivideSurface(tol, vert, norm, face);
        Vec3[] v = new Vec3[vert.size()];
        int i = 0;
        while (i < v.length) {
            v[i] = ((MeshVertex)vert.elementAt((int)i)).r;
            ++i;
        }
        Object[] n = new Vec3[vert.size()];
        norm.copyInto(n);
        int[][] f = new int[face.size()][];
        face.copyInto((Object[])f);
        int numnorm = norm.size();
        TriangleMesh mesh = new TriangleMesh(v, (int[][])f);
        mesh.setTexture(this.getTexture());
        if (this.getTexture() != null) {
            mesh.setTextureMapping(this.getTextureMapping().duplicate());
        }
        mesh.setMaterial(this.getMaterial());
        if (this.getMaterial() != null) {
            mesh.setMaterialMapping(this.getMaterialMapping().duplicate());
        }
        MeshVertex[] vt = mesh.getVertices();
        int i2 = 0;
        while (i2 < vt.length) {
            MeshVertex v2 = (MeshVertex)vert.elementAt(i2);
            if (v2.param != null) {
                vt[i2].param = new double[v2.param.length];
                int j = 0;
                while (j < v2.param.length) {
                    vt[i2].param[j] = v2.param[j];
                    ++j;
                }
            }
            ++i2;
        }
        TriangleMesh.Edge[] ed = mesh.getEdges();
        TriangleMesh.Face[] fc = mesh.getFaces();
        int i3 = 0;
        while (i3 < fc.length) {
            if (fc[i3].v1 >= numnorm) {
                ed[fc[i3].e2].smoothness = 0.0f;
            }
            if (fc[i3].v2 >= numnorm) {
                ed[fc[i3].e3].smoothness = 0.0f;
            }
            if (fc[i3].v3 >= numnorm) {
                ed[fc[i3].e1].smoothness = 0.0f;
            }
            ++i3;
        }
        return mesh;
    }

    private void subdivideSurface(double tol, Vector vert, Vector norm, Vector face) {
        Tube t = this.subdivideTube(tol);
        Vec3[] pathv = new Vec3[t.vertex.length];
        int i = 0;
        while (i < pathv.length) {
            pathv[i] = t.vertex[i].r;
            ++i;
        }
        double max = 0.0;
        int i2 = 0;
        while (i2 < t.thickness.length) {
            if (t.thickness[i2] > max) {
                max = t.thickness[i2];
            }
            ++i2;
        }
        double r = 0.7 * max;
        int n = 0;
        if (r > tol) {
            n = (int)Math.ceil(Math.PI / Math.acos(1.0 - tol / r));
        }
        if (n < 3) {
            n = 3;
        }
        Vec3[] subdiv = new Curve(pathv, t.smoothness, t.getSmoothingMethod(), t.isClosed()).subdivideCurve().getVertexPositions();
        Vec3[] xdir = new Vec3[subdiv.length];
        Vec3[] zdir = new Vec3[subdiv.length];
        Vec3[] updir = new Vec3[subdiv.length];
        xdir[0] = subdiv[1].minus(subdiv[0]);
        xdir[0].normalize();
        zdir[0] = Math.abs(xdir[0].y) > Math.abs(xdir[0].z) ? xdir[0].cross(Vec3.vz()) : xdir[0].cross(Vec3.vy());
        zdir[0].normalize();
        updir[0] = xdir[0].cross(zdir[0]);
        double zfrac1 = xdir[0].dot(zdir[0]);
        double zfrac2 = Math.sqrt(1.0 - zfrac1 * zfrac1);
        Vec3 dir1 = zdir[0].minus(xdir[0].times(zfrac1));
        dir1.normalize();
        double upfrac1 = xdir[0].dot(updir[0]);
        double upfrac2 = Math.sqrt(1.0 - upfrac1 * upfrac1);
        Vec3 dir2 = updir[0].minus(xdir[0].times(upfrac1));
        dir2.normalize();
        int i3 = 1;
        while (i3 < subdiv.length) {
            xdir[i3] = i3 == subdiv.length - 1 ? (t.closed ? subdiv[0].minus(subdiv[subdiv.length - 2]) : subdiv[subdiv.length - 1].minus(subdiv[subdiv.length - 2])) : subdiv[i3 + 1].minus(subdiv[i3 - 1]);
            xdir[i3].normalize();
            dir1 = dir1.minus(xdir[i3].times(xdir[i3].dot(dir1)));
            dir1.normalize();
            dir2 = dir2.minus(xdir[i3].times(xdir[i3].dot(dir2)));
            dir2.normalize();
            zdir[i3] = xdir[i3].times(zfrac1).plus(dir1.times(zfrac2));
            updir[i3] = xdir[i3].times(upfrac1).plus(dir2.times(upfrac2));
            ++i3;
        }
        double dtheta = Math.PI * 2 / (double)n;
        double theta = 0.0;
        int i4 = 0;
        while (i4 < pathv.length) {
            int k = pathv.length == subdiv.length ? i4 : 2 * i4;
            Vec3 orig = pathv[i4];
            Vec3 z = zdir[k];
            Vec3 up = updir[k];
            r = 0.5 * t.thickness[i4];
            int j = 0;
            while (j < n) {
                double sin = Math.sin(theta);
                double cos = Math.cos(theta);
                Vec3 normal = new Vec3(cos * z.x + sin * up.x, cos * z.y + sin * up.y, cos * z.z + sin * up.z);
                norm.addElement(normal);
                MeshVertex mv = new MeshVertex(new Vec3(orig.x + r * normal.x, orig.y + r * normal.y, orig.z + r * normal.z));
                mv.param = t.vertex[i4].param;
                vert.addElement(mv);
                theta += dtheta;
                ++j;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < pathv.length - 1) {
            int k = i5 * n;
            int j = 0;
            while (j < n - 1) {
                face.addElement(new int[]{k + j, k + j + 1, k + j + n});
                face.addElement(new int[]{k + j + 1, k + j + n + 1, k + j + n});
                ++j;
            }
            face.addElement(new int[]{k + n - 1, k, k + n + n - 1});
            face.addElement(new int[]{k, k + n, k + n + n - 1});
            ++i5;
        }
        if (this.endsStyle == 1) {
            int k = (pathv.length - 1) * n;
            int j = 0;
            while (j < n - 1) {
                face.addElement(new int[]{k + j, k + j + 1, j});
                face.addElement(new int[]{k + j + 1, j + 1, j++});
            }
            face.addElement(new int[]{k + n - 1, k, n - 1});
            face.addElement(new int[]{k, 0, n - 1});
        } else if (this.endsStyle == 2) {
            int k = vert.size();
            vert.addElement(new MeshVertex(t.vertex[0]));
            vert.addElement(new MeshVertex(t.vertex[t.vertex.length - 1]));
            int i6 = 0;
            while (i6 < n - 1) {
                face.addElement(new int[]{i6 + 1, i6++, k});
            }
            int[] nArray = new int[]{0, n - 1, k++};
            face.addElement(nArray);
            int j = n * (pathv.length - 1);
            int i7 = 0;
            while (i7 < n - 1) {
                face.addElement(new int[]{j + i7, j + i7 + 1, k});
                ++i7;
            }
            face.addElement(new int[]{j + n - 1, j, k});
        }
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        TubeEditorWindow ed = new TubeEditorWindow(parent, "Tube object '" + info.name + "'", info, cb);
        ((ObjectViewer)ed.getView()).setScene(parent.getScene(), info);
        ed.show();
    }

    public Tube(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.thickness = new double[this.vertex.length];
        int i = 0;
        while (i < this.vertex.length) {
            this.thickness[i] = in.readDouble();
            if (this.parameter != null) {
                this.vertex[i].param = new double[this.parameter.length];
                int j = 0;
                while (j < this.parameter.length) {
                    this.vertex[i].param[j] = in.readDouble();
                    ++j;
                }
            }
            ++i;
        }
        this.endsStyle = in.readInt();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        int i = 0;
        while (i < this.thickness.length) {
            out.writeDouble(this.thickness[i]);
            if (this.parameter != null) {
                int j = 0;
                while (j < this.parameter.length) {
                    out.writeDouble(this.vertex[i].param[j]);
                    ++j;
                }
            }
            ++i;
        }
        out.writeInt(this.endsStyle);
    }

    public Keyframe getPoseKeyframe() {
        return new NullKeyframe();
    }

    public void applyPoseKeyframe(Keyframe k) {
    }
}

