/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClipModule
extends Module {
    double min = 0.0;
    double max = 1.0;

    public ClipModule(Point position) {
        super("Clip", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Input", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
    }

    public double getAverageValue(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return 0.0;
        }
        double v = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        if (v < this.min) {
            return this.min;
        }
        if (v > this.max) {
            return this.max;
        }
        return v;
    }

    public double getValueError(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return 0.0;
        }
        double v = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        if (v < this.min || v > this.max) {
            return 0.0;
        }
        return this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        double v = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        if (v < this.min || v > this.max) {
            grad.set(0.0, 0.0, 0.0);
        } else {
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        }
    }

    public boolean edit(Frame fr, Scene theScene) {
        ValueField minField = new ValueField(this.min, 0);
        ValueField maxField = new ValueField(this.max, 0);
        ComponentsDialog dlg = new ComponentsDialog((Window)fr, "Set clip range:", new Component[]{minField, maxField}, new String[]{"Minimum", "Maximum"});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.min = minField.getValue();
        this.max = maxField.getValue();
        if (this.min > this.max) {
            new MessageDialog((Window)fr, "The minimum value cannot be greater than the maximum value.");
            this.edit(fr, theScene);
        }
        return true;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.min);
        out.writeDouble(this.max);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.min = in.readDouble();
        this.max = in.readDouble();
    }
}

