/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.Translate;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CoordinateModule
extends Module {
    int coordinate;
    PointInfo point;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int T = 3;
    public static final String[] COORD_NAME = new String[]{"X", "Y", "Z", Translate.text("Time")};

    public CoordinateModule(Point position) {
        this(position, 0);
    }

    public CoordinateModule(Point position, int coordinate) {
        super(COORD_NAME[coordinate], new IOPort[0], new IOPort[]{new IOPort(0, 1, 3, new String[]{COORD_NAME[coordinate]})}, position);
        this.coordinate = coordinate;
    }

    public void setCoordinate(int coordinate) {
        this.coordinate = coordinate;
        this.name = COORD_NAME[coordinate];
        this.output[0].setDescription(new String[]{COORD_NAME[coordinate]});
        this.layout();
    }

    public void init(PointInfo p) {
        this.point = p;
    }

    public double getAverageValue(int which, double blur) {
        switch (this.coordinate) {
            case 0: {
                return this.point.x;
            }
            case 1: {
                return this.point.y;
            }
            case 2: {
                return this.point.z;
            }
        }
        return this.point.t;
    }

    public double getValueError(int which, double blur) {
        switch (this.coordinate) {
            case 0: {
                return 0.5 * this.point.xsize + blur;
            }
            case 1: {
                return 0.5 * this.point.ysize + blur;
            }
            case 2: {
                return 0.5 * this.point.zsize + blur;
            }
        }
        return 0.0;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        switch (this.coordinate) {
            case 0: {
                grad.set(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                grad.set(0.0, 1.0, 0.0);
                break;
            }
            case 2: {
                grad.set(0.0, 0.0, 1.0);
                break;
            }
            default: {
                grad.set(0.0, 0.0, 0.0);
            }
        }
    }

    public Module duplicate() {
        CoordinateModule mod = new CoordinateModule(new Point(this.bounds.x, this.bounds.y), this.coordinate);
        mod.layout();
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.coordinate);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.coordinate = in.readInt();
        this.name = COORD_NAME[this.coordinate];
        this.output[0].setDescription(new String[]{COORD_NAME[this.coordinate]});
        this.layout();
    }
}

