/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class Module {
    IOPort[] input;
    IOPort[] output;
    public Module[] linkFrom;
    public int[] linkFromIndex;
    String name;
    Rectangle bounds;
    boolean checked;
    static Font defaultFont = Font.decode("Serif");
    static FontMetrics defaultMetrics = Toolkit.getDefaultToolkit().getFontMetrics(defaultFont);
    static /* synthetic */ Class class$java$awt$Point;

    public Module(String name, IOPort[] input, IOPort[] output, Point position) {
        this.name = name;
        this.input = input;
        this.output = output;
        this.linkFrom = new Module[input.length];
        this.linkFromIndex = new int[input.length];
        int i = 0;
        while (i < input.length) {
            input[i].setModule(this);
            ++i;
        }
        int i2 = 0;
        while (i2 < output.length) {
            output[i2].setModule(this);
            ++i2;
        }
        this.bounds = new Rectangle(position.x, position.y, 0, 0);
        this.layout();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setPosition(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
        this.layout();
    }

    public IOPort[] getInputPorts() {
        return this.input;
    }

    public IOPort[] getOutputPorts() {
        return this.output;
    }

    public int getInputIndex(IOPort port) {
        int i = 0;
        while (i < this.input.length) {
            if (this.input[i] == port) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getOutputIndex(IOPort port) {
        int i = 0;
        while (i < this.output.length) {
            if (this.output[i] == port) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean inputConnected(int which) {
        return this.linkFrom[which] != null;
    }

    public IOPort getClickedPort(Point pos) {
        int i = 0;
        while (i < this.input.length) {
            if (this.input[i].contains(pos)) {
                return this.input[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.output.length) {
            if (this.output[i2].contains(pos)) {
                return this.output[i2];
            }
            ++i2;
        }
        return null;
    }

    public void setInput(IOPort which, IOPort port) {
        int i = 0;
        while (i < this.input.length) {
            if (this.input[i] == which) {
                if (port == null) {
                    this.linkFrom[i] = null;
                    return;
                }
                Module module = port.getModule();
                int j = 0;
                while (j < module.output.length) {
                    if (module.output[j] == port) {
                        this.linkFrom[i] = module;
                        this.linkFromIndex[i] = j;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void calcSize() {
        this.bounds.width = defaultMetrics.stringWidth(this.name) + 20;
        this.bounds.height = defaultMetrics.getMaxAscent() + defaultMetrics.getMaxDescent() + 20;
        int numtop = 0;
        int numbottom = 0;
        int numleft = 0;
        int i = 0;
        while (i < this.input.length) {
            int j = this.input[i].getLocation();
            if (j == 0) {
                ++numtop;
            } else if (j == 1) {
                ++numbottom;
            } else {
                ++numleft;
            }
            ++i;
        }
        if (Math.max(numtop, numbottom) * 5 * 4 > this.bounds.width) {
            this.bounds.width = Math.max(numtop, numbottom) * 5 * 4;
        }
        if (Math.max(numleft, this.output.length) * 5 * 4 > this.bounds.height) {
            this.bounds.height = Math.max(numleft, this.output.length) * 5 * 4;
        }
    }

    public void layout() {
        int j;
        this.calcSize();
        int numtop = 0;
        int numbottom = 0;
        int numleft = 0;
        int top = 0;
        int bottom = 0;
        int left = 0;
        int i = 0;
        while (i < this.input.length) {
            j = this.input[i].getLocation();
            if (j == 0) {
                ++numtop;
            } else if (j == 1) {
                ++numbottom;
            } else {
                ++numleft;
            }
            ++i;
        }
        i = 0;
        while (i < this.input.length) {
            j = this.input[i].getLocation();
            if (j == 0) {
                this.input[i].setPosition(this.bounds.x + this.bounds.width * ++top / (numtop + 1), this.bounds.y);
            } else if (j == 1) {
                this.input[i].setPosition(this.bounds.x + this.bounds.width * ++bottom / (numbottom + 1), this.bounds.y + this.bounds.height);
            } else {
                this.input[i].setPosition(this.bounds.x, this.bounds.y + this.bounds.height * ++left / (numleft + 1));
            }
            ++i;
        }
        i = 0;
        while (i < this.output.length) {
            this.output[i].setPosition(this.bounds.x + this.bounds.width + 5, this.bounds.y + this.bounds.height * (i + 1) / (this.output.length + 1));
            ++i;
        }
    }

    public void draw(Graphics g) {
        g.setColor(Color.lightGray);
        g.fill3DRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, true);
        int i = 0;
        while (i < this.input.length) {
            this.input[i].draw(g);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.output.length) {
            this.output[i2].draw(g);
            ++i2;
        }
        this.drawContents(g);
    }

    protected void drawContents(Graphics g) {
        g.setColor(Color.black);
        g.setFont(defaultFont);
        g.drawString(this.name, this.bounds.x + (this.bounds.width - defaultMetrics.stringWidth(this.name)) / 2, this.bounds.y + this.bounds.height / 2 + defaultMetrics.getAscent() / 2);
    }

    public boolean checkFeedback() {
        if (this.checked) {
            return true;
        }
        this.checked = true;
        int i = 0;
        while (i < this.linkFrom.length) {
            if (this.linkFrom[i] != null && this.linkFrom[i].checkFeedback()) {
                return true;
            }
            ++i;
        }
        this.checked = false;
        return false;
    }

    public boolean edit(Frame fr, Scene theScene) {
        return false;
    }

    public void init(PointInfo p) {
    }

    public double getAverageValue(int which, double blur) {
        return 0.0;
    }

    public double getValueError(int which, double blur) {
        return 0.0;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        grad.set(0.0, 0.0, 0.0);
    }

    public void getColor(int which, RGBColor color, double blur) {
    }

    public Module duplicate() {
        try {
            Constructor<?> con = this.getClass().getConstructor(class$java$awt$Point == null ? (class$java$awt$Point = Module.class$("java.awt.Point")) : class$java$awt$Point);
            return (Module)con.newInstance(new Point(this.bounds.x, this.bounds.y));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
    }

    public void readFromStream(DataInputStream out, Scene theScene) throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

