/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec2;
import artofillusion.procedural.AbsModule;
import artofillusion.procedural.BiasModule;
import artofillusion.procedural.BlendModule;
import artofillusion.procedural.BlurModule;
import artofillusion.procedural.BrickModule;
import artofillusion.procedural.CellsModule;
import artofillusion.procedural.CheckerModule;
import artofillusion.procedural.ClipModule;
import artofillusion.procedural.ColorDarkenModule;
import artofillusion.procedural.ColorDifferenceModule;
import artofillusion.procedural.ColorLightenModule;
import artofillusion.procedural.ColorModule;
import artofillusion.procedural.ColorProductModule;
import artofillusion.procedural.ColorScaleModule;
import artofillusion.procedural.ColorSumModule;
import artofillusion.procedural.CompareModule;
import artofillusion.procedural.CoordinateModule;
import artofillusion.procedural.CosineModule;
import artofillusion.procedural.DifferenceModule;
import artofillusion.procedural.ExpModule;
import artofillusion.procedural.ExprModule;
import artofillusion.procedural.FunctionModule;
import artofillusion.procedural.GainModule;
import artofillusion.procedural.GridModule;
import artofillusion.procedural.HSVModule;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.InfoBox;
import artofillusion.procedural.InterpModule;
import artofillusion.procedural.JitterModule;
import artofillusion.procedural.Link;
import artofillusion.procedural.LogModule;
import artofillusion.procedural.MarbleModule;
import artofillusion.procedural.MaxModule;
import artofillusion.procedural.MinModule;
import artofillusion.procedural.ModModule;
import artofillusion.procedural.Module;
import artofillusion.procedural.NoiseModule;
import artofillusion.procedural.NumberModule;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PolarModule;
import artofillusion.procedural.PowerModule;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.procedural.ProductModule;
import artofillusion.procedural.RGBModule;
import artofillusion.procedural.RandomModule;
import artofillusion.procedural.RatioModule;
import artofillusion.procedural.ScaleShiftModule;
import artofillusion.procedural.SineModule;
import artofillusion.procedural.SpectrumModule;
import artofillusion.procedural.SphericalModule;
import artofillusion.procedural.SqrtModule;
import artofillusion.procedural.SumModule;
import artofillusion.procedural.TransformModule;
import artofillusion.procedural.TurbulenceModule;
import artofillusion.procedural.WoodModule;
import artofillusion.ui.AutoScroller;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.Translate;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ProcedureEditor
extends Canvas
implements ActionListener,
KeyListener,
MouseListener,
MouseMotionListener {
    private Frame parent;
    private Procedure proc;
    private ProcedureOwner owner;
    private Scene theScene;
    private EditingWindow win;
    private Dimension size;
    private MenuItem undoItem;
    private MenuItem cutItem;
    private MenuItem copyItem;
    private MenuItem pasteItem;
    private MenuItem clearItem;
    private TextField nameField;
    private boolean[] selectedModule;
    private boolean[] selectedLink;
    private boolean draggingLink;
    private boolean draggingModule;
    private boolean draggingBox;
    private boolean undoIsRedo;
    private Point clickPos;
    private Point lastPos;
    private InfoBox inputInfo;
    private InfoBox outputInfo;
    private IOPort dragFromPort;
    private IOPort dragToPort;
    private ScrollPane scroll;
    private Object preview;
    private ByteArrayOutputStream undoBuffer;
    private ByteArrayOutputStream cancelBuffer;
    private static ClipboardSelection clipboard;

    public ProcedureEditor(Procedure proc, ProcedureOwner owner, Scene scene) {
        this.proc = proc;
        this.owner = owner;
        this.theScene = scene;
        this.selectedModule = new boolean[proc.getModules().length];
        this.selectedLink = new boolean[proc.getLinks().length];
        this.inputInfo = new InfoBox();
        this.outputInfo = new InfoBox();
        this.undoBuffer = new ByteArrayOutputStream();
        this.cancelBuffer = new ByteArrayOutputStream();
        this.parent = new Frame(owner.getWindowTitle());
        this.scroll = new ScrollPane();
        this.parent.add((Component)this.scroll, "Center");
        this.scroll.add(this);
        this.scroll.setSize(500, 550);
        new AutoScroller(this, this.scroll, 5, 5);
        this.size = new Dimension(1000, 1000);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        DataOutputStream out = new DataOutputStream(this.cancelBuffer);
        try {
            proc.writeToStream(out, this.theScene);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Panel p = new Panel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.insets = new Insets(0, 0, 0, 5);
        if (owner.canEditName()) {
            p.add((Component)new Label(Translate.text("Name") + ':'), gc);
            gc.fill = 2;
            gc.weightx = 1.0;
            this.nameField = new TextField(owner.getName());
            p.add((Component)this.nameField, gc);
        } else {
            gc.fill = 2;
            gc.weightx = 1.0;
            p.add((Component)new Label(), gc);
        }
        gc.weightx = 0.0;
        p.add((Component)Translate.button("ok", this), gc);
        p.add((Component)Translate.button("cancel", this), gc);
        this.parent.add((Component)p, "North");
        OutputModule[] output = proc.getOutputModules();
        int widest = 0;
        int i = 0;
        while (i < output.length) {
            output[i].calcSize();
            if (output[i].getBounds().width > widest) {
                widest = output[i].getBounds().width;
            }
            ++i;
        }
        int x = this.size.width - widest;
        int y = 10;
        i = 0;
        while (i < output.length) {
            output[i].setWidth(widest);
            output[i].setPosition(x, y);
            y += output[i].getBounds().height + 10;
            ++i;
        }
        MenuBar mb = new MenuBar();
        this.parent.setMenuBar(mb);
        mb.add(this.getEditMenu());
        mb.add(this.getInsertMenu());
        this.updateMenus();
        this.parent.pack();
        this.scroll.setScrollPosition(500 + this.scroll.getVScrollbarWidth(), 0);
        this.scroll.getHAdjustable().setBlockIncrement(100);
        this.scroll.getVAdjustable().setBlockIncrement(100);
        this.scroll.getHAdjustable().setUnitIncrement(10);
        this.scroll.getVAdjustable().setUnitIncrement(10);
        this.parent.show();
        this.preview = owner.getPreview(this);
    }

    private Menu getEditMenu() {
        Menu editMenu = Translate.menu("edit");
        this.undoItem = Translate.menuItem("undo", this);
        editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        editMenu.addSeparator();
        this.cutItem = Translate.menuItem("cut", this);
        editMenu.add(this.cutItem);
        this.copyItem = Translate.menuItem("copy", this);
        editMenu.add(this.copyItem);
        this.pasteItem = Translate.menuItem("paste", this);
        editMenu.add(this.pasteItem);
        this.clearItem = Translate.menuItem("clear", this);
        editMenu.add(this.clearItem);
        editMenu.addSeparator();
        editMenu.add(Translate.menuItem("properties", this));
        return editMenu;
    }

    private Menu getInsertMenu() {
        Menu insertMenu = Translate.menu("insert");
        Menu subMenu = Translate.menu("values");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("numberModule", this));
        subMenu.add(Translate.menuItem("colorModule", this));
        subMenu.add(Translate.menuItem("xModule", this));
        subMenu.add(Translate.menuItem("yModule", this));
        subMenu.add(Translate.menuItem("zModule", this));
        subMenu.add(Translate.menuItem("timeModule", this));
        if (this.owner.allowParameters()) {
            subMenu.add(Translate.menuItem("parameterModule", this));
        }
        subMenu = Translate.menu("functions");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("expressionModule", this));
        subMenu.add(Translate.menuItem("customFunctionModule", this));
        subMenu.add(Translate.menuItem("scaleShiftModule", this));
        subMenu.add(Translate.menuItem("addModule", this));
        subMenu.add(Translate.menuItem("subtractModule", this));
        subMenu.add(Translate.menuItem("multiplyModule", this));
        subMenu.add(Translate.menuItem("divideModule", this));
        subMenu.addSeparator();
        subMenu.add(Translate.menuItem("absModule", this));
        subMenu.add(Translate.menuItem("blurModule", this));
        subMenu.add(Translate.menuItem("clipModule", this));
        subMenu.add(Translate.menuItem("greaterThanModule", this));
        subMenu.add(Translate.menuItem("minModule", this));
        subMenu.add(Translate.menuItem("maxModule", this));
        subMenu.add(Translate.menuItem("interpolateModule", this));
        subMenu.add(Translate.menuItem("modModule", this));
        subMenu.addSeparator();
        subMenu.add(Translate.menuItem("sineModule", this));
        subMenu.add(Translate.menuItem("cosineModule", this));
        subMenu.add(Translate.menuItem("sqrtModule", this));
        subMenu.add(Translate.menuItem("expModule", this));
        subMenu.add(Translate.menuItem("logModule", this));
        subMenu.add(Translate.menuItem("powModule", this));
        subMenu.add(Translate.menuItem("biasModule", this));
        subMenu.add(Translate.menuItem("gainModule", this));
        subMenu.add(Translate.menuItem("randomModule", this));
        subMenu = Translate.menu("colorFunctions");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("customColorFunctionModule", this));
        subMenu.add(Translate.menuItem("blendModule", this));
        subMenu.add(Translate.menuItem("addColorModule", this));
        subMenu.add(Translate.menuItem("subtractColorModule", this));
        subMenu.add(Translate.menuItem("multiplyColorModule", this));
        subMenu.add(Translate.menuItem("lighterModule", this));
        subMenu.add(Translate.menuItem("darkerModule", this));
        subMenu.add(Translate.menuItem("scaleColorModule", this));
        subMenu.add(Translate.menuItem("RGBModule", this));
        subMenu.add(Translate.menuItem("HSVModule", this));
        subMenu = Translate.menu("transforms");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("linearModule", this));
        subMenu.add(Translate.menuItem("polarModule", this));
        subMenu.add(Translate.menuItem("sphericalModule", this));
        subMenu.add(Translate.menuItem("jitterModule", this));
        subMenu = Translate.menu("patterns");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("noiseModule", this));
        subMenu.add(Translate.menuItem("turbulenceModule", this));
        subMenu.add(Translate.menuItem("gridModule", this));
        subMenu.add(Translate.menuItem("cellsModule", this));
        subMenu.add(Translate.menuItem("marbleModule", this));
        subMenu.add(Translate.menuItem("woodModule", this));
        subMenu.add(Translate.menuItem("checkerModule", this));
        subMenu.add(Translate.menuItem("bricksModule", this));
        subMenu.add(Translate.menuItem("imageModule", this));
        return insertMenu;
    }

    public Frame getParentFrame() {
        return this.parent;
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void setEditingWindow(EditingWindow window) {
        this.win = window;
    }

    public EditingWindow getEditingWindow() {
        return this.win;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void paint(Graphics g) {
        OutputModule[] output = this.proc.getOutputModules();
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        int divider = output[0].getBounds().x - 1;
        int i = 0;
        while (i < output.length) {
            output[i].draw(g);
            ++i;
        }
        int i2 = 0;
        while (i2 < module.length) {
            if (!this.selectedModule[i2]) {
                module[i2].draw(g);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < module.length) {
            if (this.selectedModule[i3]) {
                g.setColor(Color.red);
                Rectangle rect = module[i3].getBounds();
                g.drawRect(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
                module[i3].draw(g);
            }
            ++i3;
        }
        g.setColor(Color.black);
        int i4 = 0;
        while (i4 < link.length) {
            if (!this.selectedLink[i4]) {
                Point p1 = link[i4].from.getPosition();
                Point p2 = link[i4].to.getPosition();
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            ++i4;
        }
        g.setColor(Color.red);
        int i5 = 0;
        while (i5 < link.length) {
            if (this.selectedLink[i5]) {
                Point p1 = link[i5].from.getPosition();
                Point p2 = link[i5].to.getPosition();
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            ++i5;
        }
        g.setColor(Color.black);
        g.drawLine(divider, 0, divider, this.size.height);
        if (this.draggingLink) {
            boolean isInput;
            boolean bl = isInput = this.dragFromPort.getType() == 0;
            if (isInput || this.dragToPort != null) {
                this.inputInfo.draw(g);
            }
            if (!isInput || this.dragToPort != null) {
                this.outputInfo.draw(g);
            }
        }
        g.setXORMode(Color.white);
        if (this.draggingBox && this.lastPos != null) {
            Rectangle rect = this.getRectangle(this.clickPos, this.lastPos);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.draggingLink && this.lastPos != null) {
            if (this.dragToPort == null) {
                g.drawLine(this.clickPos.x, this.clickPos.y, this.lastPos.x, this.lastPos.y);
            } else {
                Point pos = this.dragToPort.getPosition();
                g.drawLine(this.clickPos.x, this.clickPos.y, pos.x, pos.y);
            }
        }
        if (this.draggingModule && this.lastPos != null) {
            int dx = this.lastPos.x - this.clickPos.x;
            int dy = this.lastPos.y - this.clickPos.y;
            int i6 = 0;
            while (i6 < this.selectedModule.length) {
                if (this.selectedModule[i6]) {
                    Rectangle rect = module[i6].getBounds();
                    g.drawRect(rect.x + dx, rect.y + dy, rect.width, rect.height);
                }
                ++i6;
            }
        }
    }

    private void updateMenus() {
        boolean anyModule = false;
        boolean anyLink = false;
        int i = 0;
        while (i < this.selectedModule.length) {
            if (this.selectedModule[i]) {
                anyModule = true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.selectedLink.length) {
            if (this.selectedLink[i2]) {
                anyLink = true;
            }
            ++i2;
        }
        this.cutItem.setEnabled(anyModule);
        this.copyItem.setEnabled(anyModule);
        this.pasteItem.setEnabled(clipboard != null);
        this.clearItem.setEnabled(anyModule || anyLink);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Point p = this.scroll.getScrollPosition();
        Dimension dim = this.scroll.getSize();
        p.x += (int)(0.5 * (double)dim.width * Math.random());
        p.y += (int)(0.5 * (double)dim.height * Math.random());
        if (command.equals("cancel")) {
            this.undoBuffer = this.cancelBuffer;
            this.undo();
            this.owner.disposePreview(this.preview);
            this.parent.dispose();
            return;
        }
        if (command.equals("ok")) {
            if (this.owner.canEditName()) {
                this.owner.setName(this.nameField.getText());
            }
            this.owner.acceptEdits(this);
            this.owner.disposePreview(this.preview);
            this.parent.dispose();
            return;
        }
        if (command.equals("undo")) {
            this.undo();
            return;
        }
        if (command.equals("cut")) {
            clipboard = new ClipboardSelection(this.proc, this.selectedModule, this.selectedLink);
            this.deleteSelection();
            this.updateMenus();
            return;
        }
        if (command.equals("copy")) {
            clipboard = new ClipboardSelection(this.proc, this.selectedModule, this.selectedLink);
            this.updateMenus();
            return;
        }
        if (command.equals("paste") && clipboard != null) {
            this.saveState(false);
            clipboard.paste(this);
            this.repaint();
            return;
        }
        if (command.equals("clear")) {
            this.deleteSelection();
            return;
        }
        if (command.equals("properties")) {
            this.owner.editProperties(this);
        }
        this.saveState(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("numberModule")) {
            this.addModule(new NumberModule(p));
        } else if (command.equals("colorModule")) {
            this.addModule(new ColorModule(p));
        } else if (command.equals("xModule")) {
            this.addModule(new CoordinateModule(p, 0));
        } else if (command.equals("yModule")) {
            this.addModule(new CoordinateModule(p, 1));
        } else if (command.equals("zModule")) {
            this.addModule(new CoordinateModule(p, 2));
        } else if (command.equals("timeModule")) {
            this.addModule(new CoordinateModule(p, 3));
        } else if (command.equals("parameterModule")) {
            this.addModule(new ParameterModule(p));
        } else if (command.equals("addModule")) {
            this.addModule(new SumModule(p));
        } else if (command.equals("subtractModule")) {
            this.addModule(new DifferenceModule(p));
        } else if (command.equals("multiplyModule")) {
            this.addModule(new ProductModule(p));
        } else if (command.equals("divideModule")) {
            this.addModule(new RatioModule(p));
        } else if (command.equals("scaleShiftModule")) {
            this.addModule(new ScaleShiftModule(p));
        } else if (command.equals("interpolateModule")) {
            this.addModule(new InterpModule(p));
        } else if (command.equals("greaterThanModule")) {
            this.addModule(new CompareModule(p));
        } else if (command.equals("minModule")) {
            this.addModule(new MinModule(p));
        } else if (command.equals("maxModule")) {
            this.addModule(new MaxModule(p));
        } else if (command.equals("modModule")) {
            this.addModule(new ModModule(p));
        } else if (command.equals("absModule")) {
            this.addModule(new AbsModule(p));
        } else if (command.equals("clipModule")) {
            this.addModule(new ClipModule(p));
        } else if (command.equals("sineModule")) {
            this.addModule(new SineModule(p));
        } else if (command.equals("cosineModule")) {
            this.addModule(new CosineModule(p));
        } else if (command.equals("sqrtModule")) {
            this.addModule(new SqrtModule(p));
        } else if (command.equals("expModule")) {
            this.addModule(new ExpModule(p));
        } else if (command.equals("logModule")) {
            this.addModule(new LogModule(p));
        } else if (command.equals("powModule")) {
            this.addModule(new PowerModule(p));
        } else if (command.equals("biasModule")) {
            this.addModule(new BiasModule(p));
        } else if (command.equals("gainModule")) {
            this.addModule(new GainModule(p));
        } else if (command.equals("randomModule")) {
            this.addModule(new RandomModule(p));
        } else if (command.equals("blurModule")) {
            this.addModule(new BlurModule(p));
        } else if (command.equals("customFunctionModule")) {
            this.addModule(new FunctionModule(p));
        } else if (command.equals("expressionModule")) {
            this.addModule(new ExprModule(p));
        } else if (command.equals("linearModule")) {
            this.addModule(new TransformModule(p));
        } else if (command.equals("polarModule")) {
            this.addModule(new PolarModule(p));
        } else if (command.equals("sphericalModule")) {
            this.addModule(new SphericalModule(p));
        } else if (command.equals("jitterModule")) {
            this.addModule(new JitterModule(p));
        } else if (command.equals("addColorModule")) {
            this.addModule(new ColorSumModule(p));
        } else if (command.equals("subtractColorModule")) {
            this.addModule(new ColorDifferenceModule(p));
        } else if (command.equals("multiplyColorModule")) {
            this.addModule(new ColorProductModule(p));
        } else if (command.equals("lighterModule")) {
            this.addModule(new ColorLightenModule(p));
        } else if (command.equals("darkerModule")) {
            this.addModule(new ColorDarkenModule(p));
        } else if (command.equals("scaleColorModule")) {
            this.addModule(new ColorScaleModule(p));
        } else if (command.equals("blendModule")) {
            this.addModule(new BlendModule(p));
        } else if (command.equals("customColorFunctionModule")) {
            this.addModule(new SpectrumModule(p));
        } else if (command.equals("RGBModule")) {
            this.addModule(new RGBModule(p));
        } else if (command.equals("HSVModule")) {
            this.addModule(new HSVModule(p));
        } else if (command.equals("noiseModule")) {
            this.addModule(new NoiseModule(p));
        } else if (command.equals("turbulenceModule")) {
            this.addModule(new TurbulenceModule(p));
        } else if (command.equals("marbleModule")) {
            this.addModule(new MarbleModule(p));
        } else if (command.equals("woodModule")) {
            this.addModule(new WoodModule(p));
        } else if (command.equals("gridModule")) {
            this.addModule(new GridModule(p));
        } else if (command.equals("cellsModule")) {
            this.addModule(new CellsModule(p));
        } else if (command.equals("checkerModule")) {
            this.addModule(new CheckerModule(p));
        } else if (command.equals("bricksModule")) {
            this.addModule(new BrickModule(p));
        } else if (command.equals("imageModule")) {
            this.addModule(new ImageModule(p));
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    private void addModule(Module mod) {
        this.selectedModule = new boolean[this.selectedModule.length + 1];
        this.selectedModule[this.selectedModule.length - 1] = true;
        int i = 0;
        while (i < this.selectedLink.length) {
            this.selectedLink[i] = false;
            ++i;
        }
        this.proc.addModule(mod);
        this.updateMenus();
    }

    private void addLink(IOPort port1, IOPort port2) {
        IOPort to;
        IOPort from;
        this.selectedLink = new boolean[this.selectedLink.length + 1];
        this.selectedLink[this.selectedLink.length - 1] = true;
        int i = 0;
        while (i < this.selectedModule.length) {
            this.selectedModule[i] = false;
            ++i;
        }
        if (port1.getType() == 1) {
            from = port1;
            to = port2;
        } else {
            from = port2;
            to = port1;
        }
        to.getModule().setInput(to, from);
        this.proc.addLink(new Link(from, to));
        if (this.proc.checkFeedback()) {
            this.proc.deleteLink(this.proc.getLinks().length - 1);
            new MessageDialog((Window)this.parent, new String[]{"The link you have selected cannot be created,", "as it would result in a feedback loop."});
        }
        this.updateMenus();
    }

    public void saveState(boolean redo) {
        this.undoBuffer.reset();
        DataOutputStream out = new DataOutputStream(this.undoBuffer);
        try {
            this.proc.writeToStream(out, this.theScene);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.undoIsRedo = redo & !this.undoIsRedo;
        this.undoItem.setLabel(this.undoIsRedo ? "Redo" : "Undo");
        this.undoItem.setEnabled(true);
    }

    private void undo() {
        byte[] buffer = this.undoBuffer.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        this.saveState(true);
        try {
            this.proc.readFromStream(in, this.theScene);
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.repaint();
        this.updatePreview();
        this.updateMenus();
    }

    public void updatePreview() {
        this.owner.updatePreview(this.preview);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mouseClicked(MouseEvent e) {
        Point pos = e.getPoint();
        if (e.getClickCount() == 2) {
            Module[] module = this.proc.getModules();
            int i = 0;
            while (i < module.length) {
                if (module[i].getBounds().contains(pos)) {
                    this.saveState(false);
                    if (module[i].edit(this.parent, this.theScene)) {
                        this.repaint();
                        this.updatePreview();
                    }
                    return;
                }
                ++i;
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        IOPort port;
        OutputModule[] output = this.proc.getOutputModules();
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        this.requestFocus();
        this.clickPos = e.getPoint();
        this.lastPos = null;
        int i = 0;
        while (i < module.length) {
            port = module[i].getClickedPort(this.clickPos);
            if (port != null) {
                this.startDragLink(port);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < output.length) {
            port = output[i].getClickedPort(this.clickPos);
            if (port != null) {
                this.startDragLink(port);
                return;
            }
            ++i;
        }
        i = module.length - 1;
        while (i >= 0) {
            if (this.selectedModule[i] && module[i].getBounds().contains(this.clickPos)) {
                this.draggingModule = true;
                this.repaint();
                return;
            }
            --i;
        }
        i = module.length - 1;
        while (i >= 0) {
            if (!this.selectedModule[i] && module[i].getBounds().contains(this.clickPos)) {
                this.draggingModule = true;
                if (!e.isShiftDown()) {
                    int j = 0;
                    while (j < this.selectedModule.length) {
                        this.selectedModule[j] = false;
                        ++j;
                    }
                    j = 0;
                    while (j < this.selectedLink.length) {
                        this.selectedLink[j] = false;
                        ++j;
                    }
                }
                this.selectedModule[i] = true;
                this.repaint();
                this.updateMenus();
                return;
            }
            --i;
        }
        i = 0;
        while (i < link.length) {
            Point p1 = link[i].from.getPosition();
            Point p2 = link[i].to.getPosition();
            int tol = 2;
            if (!(this.clickPos.x < p1.x - tol && this.clickPos.x < p2.x - tol || this.clickPos.x > p1.x + tol && this.clickPos.x > p2.x + tol || this.clickPos.y < p1.y - tol && this.clickPos.y < p2.y - tol || this.clickPos.y > p1.y + tol && this.clickPos.y > p2.y + tol)) {
                Vec2 v1 = new Vec2(p2.x - p1.x, p2.y - p1.y);
                Vec2 v2 = new Vec2(this.clickPos.x - p1.x, this.clickPos.y - p1.y);
                v1.normalize();
                double dot = v1.dot(v2);
                v1.scale(dot);
                v2.subtract(v1);
                if (v2.length2() <= (double)(tol * tol)) {
                    if (!e.isShiftDown() && !this.selectedLink[i]) {
                        int j = 0;
                        while (j < this.selectedModule.length) {
                            this.selectedModule[j] = false;
                            ++j;
                        }
                        j = 0;
                        while (j < this.selectedLink.length) {
                            this.selectedLink[j] = false;
                            ++j;
                        }
                    }
                    this.selectedLink[i] = true;
                    this.repaint();
                    this.updateMenus();
                    return;
                }
            }
            ++i;
        }
        if (!e.isShiftDown()) {
            i = 0;
            while (i < this.selectedModule.length) {
                this.selectedModule[i] = false;
                ++i;
            }
            i = 0;
            while (i < this.selectedLink.length) {
                this.selectedLink[i] = false;
                ++i;
            }
        }
        this.draggingBox = true;
        this.repaint();
        this.updateMenus();
    }

    public void mouseReleased(MouseEvent e) {
        Point pos = e.getPoint();
        if (this.draggingLink) {
            this.draggingLink = false;
            if (this.dragToPort != null) {
                this.saveState(false);
                this.addLink(this.dragFromPort, this.dragToPort);
                this.updatePreview();
            }
            this.repaint();
            return;
        }
        if (this.draggingBox) {
            if (this.lastPos == null) {
                this.draggingBox = false;
                this.repaint();
                return;
            }
            Rectangle rect = this.getRectangle(this.clickPos, this.lastPos);
            Module[] module = this.proc.getModules();
            int i = 0;
            while (i < this.selectedModule.length) {
                if (module[i].getBounds().intersects(rect)) {
                    this.selectedModule[i] = true;
                }
                ++i;
            }
            this.draggingBox = false;
            this.repaint();
            this.updateMenus();
            return;
        }
        if (this.draggingModule) {
            this.saveState(false);
            this.draggingModule = false;
            int dx = pos.x - this.clickPos.x;
            int dy = pos.y - this.clickPos.y;
            Module[] module = this.proc.getModules();
            int i = 0;
            while (i < this.selectedModule.length) {
                if (this.selectedModule[i]) {
                    Rectangle rect = module[i].getBounds();
                    module[i].setPosition(rect.x + dx, rect.y + dy);
                }
                ++i;
            }
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        Point pos = e.getPoint();
        if (this.draggingBox) {
            Rectangle rect;
            Graphics g = this.getGraphics();
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.lastPos != null) {
                rect = this.getRectangle(this.clickPos, this.lastPos);
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            this.lastPos = pos;
            rect = this.getRectangle(this.clickPos, this.lastPos);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
            g.dispose();
            return;
        }
        if (this.draggingLink) {
            boolean isInput;
            if (this.dragToPort != null && this.dragToPort.contains(pos)) {
                return;
            }
            Graphics g = this.getGraphics();
            boolean bl = isInput = this.dragFromPort.getType() == 0;
            if (this.dragToPort != null) {
                this.dragToPort = null;
                ((Component)this).update(g);
            }
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.lastPos != null) {
                g.drawLine(this.clickPos.x, this.clickPos.y, this.lastPos.x, this.lastPos.y);
            }
            OutputModule[] output = this.proc.getOutputModules();
            Module[] module = this.proc.getModules();
            int i = 0;
            while (i < module.length) {
                IOPort[] port = isInput ? module[i].getOutputPorts() : module[i].getInputPorts();
                int j = 0;
                while (j < port.length) {
                    if ((isInput || !module[i].inputConnected(j)) && port[j].getValueType() == this.dragFromPort.getValueType() && port[j].contains(pos)) {
                        this.dragToPort = port[j];
                    }
                    ++j;
                }
                if (this.dragToPort != null) break;
                ++i;
            }
            if (!isInput) {
                int i2 = 0;
                while (i2 < output.length) {
                    IOPort[] port = output[i2].getInputPorts();
                    int j = 0;
                    while (j < port.length) {
                        if (!output[i2].inputConnected(j) && port[j].getValueType() == this.dragFromPort.getValueType() && port[j].contains(pos)) {
                            this.dragToPort = port[j];
                        }
                        ++j;
                    }
                    if (this.dragToPort != null) break;
                    ++i2;
                }
            }
            if (this.dragToPort != null) {
                InfoBox info = isInput ? this.outputInfo : this.inputInfo;
                Rectangle rect = info.getBounds();
                pos = this.dragToPort.getPosition();
                if (isInput) {
                    info.setPosition(pos.x - rect.width - 10, pos.y - rect.height / 2);
                } else {
                    info.setPosition(pos.x + 10, pos.y - rect.height / 2);
                }
                info.setText(this.dragToPort.getDescription());
                g.setPaintMode();
                this.repaint();
                g.setColor(Color.black);
                g.setXORMode(Color.white);
            } else {
                g.drawLine(this.clickPos.x, this.clickPos.y, pos.x, pos.y);
            }
            g.dispose();
            this.lastPos = pos;
            return;
        }
        if (!this.draggingModule) {
            return;
        }
        int dx = pos.x - this.clickPos.x;
        int dy = pos.y - this.clickPos.y;
        int lastdx = 0;
        int lastdy = 0;
        Module[] module = this.proc.getModules();
        Graphics g = this.getGraphics();
        if (this.lastPos != null) {
            lastdx = this.lastPos.x - this.clickPos.x;
            lastdy = this.lastPos.y - this.clickPos.y;
        }
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        int i = 0;
        while (i < this.selectedModule.length) {
            if (this.selectedModule[i]) {
                Rectangle rect = module[i].getBounds();
                if (this.lastPos != null) {
                    g.drawRect(rect.x + lastdx, rect.y + lastdy, rect.width, rect.height);
                }
                g.drawRect(rect.x + dx, rect.y + dy, rect.width, rect.height);
            }
            ++i;
        }
        g.dispose();
        this.lastPos = pos;
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void startDragLink(IOPort port) {
        boolean isInput = port.getType() == 0;
        InfoBox info = isInput ? this.inputInfo : this.outputInfo;
        Point pos = port.getPosition();
        this.draggingLink = true;
        this.draggingModule = false;
        this.dragFromPort = port;
        this.dragToPort = null;
        this.clickPos = port.getPosition();
        info.setText(port.getDescription());
        Rectangle rect = info.getBounds();
        if (isInput) {
            info.setPosition(pos.x + 10, pos.y - rect.height / 2);
        } else {
            info.setPosition(pos.x - rect.width - 10, pos.y - rect.height / 2);
        }
        Graphics g = this.getGraphics();
        info.draw(g);
        g.dispose();
        if (isInput) {
            Module module = port.getModule();
            IOPort[] inputs = module.getInputPorts();
            int i = 0;
            while (i < inputs.length) {
                if (inputs[i] == port && module.inputConnected(i)) {
                    this.draggingLink = false;
                }
                ++i;
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key != 8 && key != 127) {
            return;
        }
        this.deleteSelection();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void deleteSelection() {
        this.saveState(false);
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        boolean num = false;
        int i = 0;
        while (i < this.selectedLink.length) {
            int j = 0;
            while (j < this.selectedModule.length) {
                if (module[j] == link[i].from.getModule() && this.selectedModule[j] || module[j] == link[i].to.getModule() && this.selectedModule[j]) {
                    this.selectedLink[i] = true;
                }
                ++j;
            }
            ++i;
        }
        i = this.selectedLink.length - 1;
        while (i >= 0) {
            if (this.selectedLink[i]) {
                this.proc.deleteLink(i);
            }
            --i;
        }
        i = this.selectedModule.length - 1;
        while (i >= 0) {
            if (this.selectedModule[i]) {
                this.proc.deleteModule(i);
            }
            --i;
        }
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.updatePreview();
        this.repaint();
        this.updateMenus();
    }

    public Rectangle getRectangle(Point p1, Point p2) {
        int x = Math.min(p1.x, p2.x);
        int y = Math.min(p1.y, p2.y);
        int width = Math.abs(p1.x - p2.x);
        int height = Math.abs(p1.y - p2.y);
        return new Rectangle(x, y, width, height);
    }

    private static class ClipboardSelection {
        Module[] module;
        Link[] link;

        public ClipboardSelection(Procedure proc, boolean[] selectedModule, boolean[] selectedLink) {
            Vector<Module> mod = new Vector<Module>();
            Vector<Link> ln = new Vector<Link>();
            Module[] allModules = proc.getModules();
            Link[] allLinks = proc.getLinks();
            int i = 0;
            while (i < selectedModule.length) {
                if (selectedModule[i]) {
                    mod.addElement(allModules[i]);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < selectedLink.length) {
                if (mod.indexOf(allLinks[i2].from.getModule()) > -1 && mod.indexOf(allLinks[i2].to.getModule()) > -1) {
                    ln.addElement(allLinks[i2]);
                }
                ++i2;
            }
            this.module = new Module[mod.size()];
            this.link = new Link[ln.size()];
            int i3 = 0;
            while (i3 < this.module.length) {
                this.module[i3] = ((Module)mod.elementAt(i3)).duplicate();
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.link.length) {
                Link thisLink = (Link)ln.elementAt(i4);
                int from = mod.indexOf(thisLink.from.getModule());
                int to = mod.indexOf(thisLink.to.getModule());
                int fromPort = thisLink.getFromPortIndex();
                int toPort = thisLink.getToPortIndex();
                this.link[i4] = new Link(this.module[from].getOutputPorts()[fromPort], this.module[to].getInputPorts()[toPort]);
                ++i4;
            }
        }

        public void paste(ProcedureEditor editor) {
            int numModules = editor.selectedModule.length;
            int numLinks = editor.selectedLink.length;
            Module[] realMod = new Module[this.module.length];
            int i = 0;
            while (i < this.module.length) {
                if (!(this.module[i] instanceof ParameterModule) || editor.owner.allowParameters()) {
                    realMod[i] = this.module[i].duplicate();
                    if (realMod[i] instanceof ImageModule && editor.theScene.indexOf(((ImageModule)realMod[i]).getMap()) == -1) {
                        ((ImageModule)realMod[i]).setMap(null);
                    }
                    Rectangle bounds = realMod[i].getBounds();
                    realMod[i].setPosition(bounds.x - 30, bounds.y + 30);
                    editor.addModule(realMod[i]);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.link.length) {
                int from = 0;
                while (this.module[from] != this.link[i2].from.getModule()) {
                    ++from;
                }
                int to = 0;
                while (this.module[to] != this.link[i2].to.getModule()) {
                    ++to;
                }
                if (realMod[from] != null && realMod[to] != null) {
                    int fromPort = this.link[i2].getFromPortIndex();
                    int toPort = this.link[i2].getToPortIndex();
                    editor.addLink(realMod[from].getOutputPorts()[fromPort], realMod[to].getInputPorts()[toPort]);
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < editor.selectedModule.length) {
                ((ProcedureEditor)editor).selectedModule[i3] = i3 >= numModules;
                ++i3;
            }
            int i4 = 0;
            while (i4 < editor.selectedLink.length) {
                ((ProcedureEditor)editor).selectedLink[i4] = i4 >= numLinks;
                ++i4;
            }
            editor.updateMenus();
        }
    }
}

