/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.script.ScriptRunner;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class ExecuteScriptWindow
extends Frame
implements ActionListener,
KeyListener {
    private LayoutWindow window;
    private TextArea scriptText;
    private String scriptName;
    private static String scriptDir;
    private static String lastScript;

    public ExecuteScriptWindow(LayoutWindow win) {
        this.window = win;
        this.scriptName = "Untitled.bsh";
        if (scriptDir == null) {
            scriptDir = ModellingApp.TOOL_SCRIPT_DIRECTORY;
        }
        this.scriptText = new TextArea(15, 60);
        if (lastScript != null) {
            this.scriptText.setText(lastScript);
        }
        this.scriptText.setFont(ModellingApp.defaultFont);
        this.add((Component)this.scriptText, "Center");
        Panel p = new Panel();
        this.add((Component)p, "South");
        Button b = new Button("Execute");
        p.add(b);
        b.setActionCommand("execute");
        b.addActionListener(this);
        b = new Button("Load...");
        p.add(b);
        b.setActionCommand("load");
        b.addActionListener(this);
        b = new Button("Save...");
        p.add(b);
        b.setActionCommand("save");
        b.addActionListener(this);
        b = new Button("Close");
        p.add(b);
        b.setActionCommand("close");
        b.addActionListener(this);
        this.pack();
        ModellingApp.centerWindow(this);
        this.show();
    }

    public void actionPerformed(ActionEvent ev) {
        String command = ev.getActionCommand();
        if ("execute".equals(command)) {
            this.executeScript();
        }
        if ("load".equals(command)) {
            this.loadScript();
        }
        if ("save".equals(command)) {
            this.saveScript();
        }
        if ("close".equals(command)) {
            lastScript = this.scriptText.getText();
            this.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadScript() {
        FileDialog dlg = new FileDialog((Frame)this, "Select Script to Load", 0);
        dlg.setDirectory(scriptDir);
        dlg.show();
        if (dlg.getFile() == null) {
            return;
        }
        scriptDir = dlg.getDirectory();
        this.setCursor(3);
        File f = new File(dlg.getDirectory(), dlg.getFile());
        try {
            int c;
            BufferedReader in = new BufferedReader(new FileReader(f));
            StringBuffer buf = new StringBuffer();
            while ((c = in.read()) != -1) {
                void var5_6;
                buf.append((char)var5_6);
            }
            in.close();
            this.scriptText.setText(buf.toString());
        }
        catch (Exception ex) {
            new MessageDialog((Window)this, new String[]{"An error occurred while reading the script:", ex.getMessage()});
        }
        this.scriptName = dlg.getFile();
        this.setCursor(0);
    }

    private void saveScript() {
        FileDialog dlg = new FileDialog((Frame)this, "Save Script to File", 1);
        dlg.setFile(this.scriptName);
        dlg.setDirectory(scriptDir);
        dlg.show();
        if (dlg.getFile() == null) {
            return;
        }
        scriptDir = dlg.getDirectory();
        this.setCursor(3);
        File f = new File(dlg.getDirectory(), dlg.getFile());
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(this.scriptText.getText().toCharArray());
            out.close();
        }
        catch (Exception ex) {
            new MessageDialog((Window)this, new String[]{"An error occurred while writing the script:", ex.getMessage()});
        }
        this.scriptName = dlg.getFile();
        EditingWindow[] allWindows = ModellingApp.getWindows();
        int i = 0;
        while (i < allWindows.length) {
            if (allWindows[i] instanceof LayoutWindow) {
                ((LayoutWindow)allWindows[i]).rebuildScriptsMenu();
            }
            ++i;
        }
        this.setCursor(0);
    }

    /*
     * Unable to fully structure code
     */
    private void executeScript() {
        block5: {
            try {
                script = ScriptRunner.parseToolScript(this.scriptText.getText());
                script.execute(this.window);
                break block5;
            }
            catch (Exception e) {
                line = ScriptRunner.displayError(e, this, 1);
                if (line <= -1) break block5;
                text = this.scriptText.getText();
                index = 0;
                i = 0;
                ** while (i < line - 1)
            }
lbl-1000:
            // 1 sources

            {
                next = text.indexOf(10, index);
                if (next == -1) {
                    index = -1;
                    break;
                }
                index = next + 1;
                ++i;
                continue;
            }
lbl19:
            // 2 sources

            if (index > -1) {
                this.scriptText.setCaretPosition(index);
            }
            this.scriptText.requestFocus();
        }
        this.window.updateImage();
        this.toFront();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() != '\r' && e.getKeyChar() != '\n') {
            return;
        }
        String text = this.scriptText.getText();
        int pos = this.scriptText.getCaretPosition() + 1;
        int endWhiteSpace = pos - 1;
        int startLine = pos - 1;
        boolean extraIndent = startLine > 0 && text.charAt(startLine - 1) == '{';
        while (startLine > 0) {
            char c = text.charAt(startLine - 1);
            if (c == '\r' || c == '\n') break;
            --startLine;
            if (Character.isWhitespace(c)) continue;
            endWhiteSpace = startLine;
        }
        if (extraIndent) {
            this.scriptText.insert("  ", pos);
        }
        this.scriptText.insert(text.substring(startLine, endWhiteSpace), pos);
    }
}

