/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.ModellingApp;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;

public class ScriptOutputWindow
extends OutputStream
implements ActionListener {
    Frame window;
    TextArea text;

    public void write(int b) {
        if (this.window == null) {
            this.createWindow();
        } else if (!this.window.isVisible()) {
            this.window.show();
        }
        this.text.append(String.valueOf((char)b));
    }

    public void write(byte[] b, int off, int len) {
        if (this.window == null) {
            this.createWindow();
        } else if (!this.window.isVisible()) {
            this.window.show();
        }
        this.text.append(new String(b, off, len));
    }

    private void createWindow() {
        this.window = new Frame("Script Output");
        this.text = new TextArea(10, 60);
        this.text.setFont(ModellingApp.defaultFont);
        this.window.add((Component)this.text, "Center");
        Panel p = new Panel();
        Button b = new Button("Close");
        p.add(b);
        b.addActionListener(this);
        this.window.add((Component)p, "South");
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ScriptOutputWindow.this.closeWindow();
            }
        });
        this.window.pack();
        this.window.show();
    }

    private void closeWindow() {
        ((Component)this.window).setVisible(false);
        this.text.setText("");
    }

    public void actionPerformed(ActionEvent ev) {
        this.closeWindow();
    }
}

