/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.LayeredTriangle;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import java.awt.Panel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class LayeredMapping
extends TextureMapping {
    LayeredTexture theTexture;
    Texture[] texture;
    TextureMapping[] mapping;
    int[] blendMode;
    int[] fractParamIndex;
    int[] paramStartIndex;
    int[] numParams;
    int[] fractParamID;
    double[] paramTemp;
    TextureSpec tempSpec;
    public static final int BLEND = 0;
    public static final int OVERLAY_BLEND_BUMPS = 1;
    public static final int OVERLAY_ADD_BUMPS = 2;
    static /* synthetic */ Class class$java$io$DataInputStream;
    static /* synthetic */ Class class$artofillusion$texture$Texture;

    public LayeredMapping(Texture tex) {
        this.theTexture = (LayeredTexture)tex;
        this.texture = new Texture[0];
        this.mapping = new TextureMapping[0];
        this.blendMode = new int[0];
        this.fractParamID = new int[0];
        this.paramTemp = new double[0];
        this.tempSpec = new TextureSpec();
    }

    public int getNumLayers() {
        return this.texture.length;
    }

    public Texture[] getLayers() {
        return this.texture;
    }

    public Texture getLayer(int which) {
        return this.texture[which];
    }

    public void setLayer(int which, Texture tex) {
        this.texture[which] = tex;
    }

    public TextureMapping getLayerMapping(int which) {
        return this.mapping[which];
    }

    public void setLayerMapping(int which, TextureMapping map) {
        this.mapping[which] = map;
    }

    public int getLayerMode(int which) {
        return this.blendMode[which];
    }

    public void setLayerMode(int which, int mode) {
        this.blendMode[which] = mode;
    }

    public TextureParameter[] getParameters() {
        TextureParameter[] p;
        Vector<TextureParameter> param = new Vector<TextureParameter>();
        this.fractParamIndex = new int[this.texture.length];
        this.paramStartIndex = new int[this.texture.length];
        this.numParams = new int[this.texture.length];
        int i = 0;
        while (i < this.texture.length) {
            this.fractParamIndex[i] = param.size();
            TextureParameter fractParam = new TextureParameter(this, this.texture[i].getName() + " fraction", 0.0, 1.0, 1.0);
            fractParam.setID(this.fractParamID[i]);
            param.addElement(fractParam);
            p = this.mapping[i].getParameters();
            if (p != null) {
                this.numParams[i] = p.length;
                this.paramStartIndex[i] = param.size();
                int j = 0;
                while (j < p.length) {
                    param.addElement(p[j]);
                    ++j;
                }
                if (p.length > this.paramTemp.length) {
                    this.paramTemp = new double[p.length];
                }
            }
            ++i;
        }
        p = new TextureParameter[param.size()];
        i = 0;
        while (i < p.length) {
            p[i] = (TextureParameter)param.elementAt(i);
            ++i;
        }
        return p;
    }

    public TextureParameter[] getLayerParameters(int which) {
        TextureParameter[] p = this.mapping[which].getParameters();
        TextureParameter[] param = new TextureParameter[p.length + 1];
        param[0] = new TextureParameter(this, this.texture[which].getName() + " fraction", 0.0, 1.0, 1.0);
        param[0].setID(this.fractParamID[which]);
        System.arraycopy(p, 0, param, 1, p.length);
        return param;
    }

    public void addLayer(Texture tex) {
        Texture[] newtexture = new Texture[this.texture.length + 1];
        TextureMapping[] newmapping = new TextureMapping[this.texture.length + 1];
        int[] newblendMode = new int[this.texture.length + 1];
        int[] newFractParamID = new int[this.texture.length + 1];
        newtexture[0] = tex;
        newmapping[0] = tex.getDefaultMapping();
        newblendMode[0] = 0;
        newFractParamID[0] = TextureParameter.getUniqueID();
        int i = 0;
        while (i < this.texture.length) {
            newtexture[i + 1] = this.texture[i];
            newmapping[i + 1] = this.mapping[i];
            newblendMode[i + 1] = this.blendMode[i];
            newFractParamID[i + 1] = this.fractParamID[i];
            ++i;
        }
        this.texture = newtexture;
        this.mapping = newmapping;
        this.blendMode = newblendMode;
        this.fractParamID = newFractParamID;
    }

    public void deleteLayer(int which) {
        Texture[] newtexture = new Texture[this.texture.length - 1];
        TextureMapping[] newmapping = new TextureMapping[this.texture.length - 1];
        int[] newblendMode = new int[this.texture.length - 1];
        int[] newFractParamID = new int[this.texture.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.texture.length) {
            if (i != which) {
                newtexture[j] = this.texture[i];
                newmapping[j] = this.mapping[i];
                newblendMode[j] = this.blendMode[i];
                newFractParamID[j] = this.fractParamID[i];
                ++j;
            }
            ++i;
        }
        this.texture = newtexture;
        this.mapping = newmapping;
        this.blendMode = newblendMode;
        this.fractParamID = newFractParamID;
    }

    public void moveLayer(int which, int pos) {
        Texture[] newtexture = new Texture[this.texture.length];
        TextureMapping[] newmapping = new TextureMapping[this.texture.length];
        int[] newblendMode = new int[this.texture.length];
        int[] newFractParamID = new int[this.texture.length];
        int j = 0;
        int i = 0;
        while (i < newtexture.length) {
            if (j == which) {
                ++j;
            }
            if (i == pos) {
                newtexture[i] = this.texture[which];
                newmapping[i] = this.mapping[which];
                newblendMode[i] = this.blendMode[which];
                newFractParamID[i] = this.fractParamID[which];
            } else {
                newtexture[i] = this.texture[j];
                newmapping[i] = this.mapping[j];
                newblendMode[i] = this.blendMode[j];
                newFractParamID[i] = this.fractParamID[j];
                ++j;
            }
            ++i;
        }
        this.texture = newtexture;
        this.mapping = newmapping;
        this.blendMode = newblendMode;
        this.fractParamID = newFractParamID;
    }

    public void readFromFile(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        int numTextures = in.readInt();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.texture = new Texture[numTextures];
        this.mapping = new TextureMapping[numTextures];
        this.blendMode = new int[numTextures];
        this.fractParamID = new int[numTextures];
        int i = 0;
        while (i < this.texture.length) {
            this.texture[i] = theScene.getTexture(in.readInt());
            this.blendMode[i] = in.readInt();
            this.fractParamID[i] = TextureParameter.getUniqueID();
            try {
                Class mapClass = ModellingApp.getClass(in.readUTF());
                Constructor con = mapClass.getConstructor(class$java$io$DataInputStream == null ? LayeredMapping.class$("java.io.DataInputStream") : class$java$io$DataInputStream, class$artofillusion$texture$Texture == null ? LayeredMapping.class$("artofillusion.texture.Texture") : class$artofillusion$texture$Texture);
                this.mapping[i] = (TextureMapping)con.newInstance(in, this.texture[i]);
            }
            catch (Exception ex) {
                throw new IOException();
            }
            ++i;
        }
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeInt(this.texture.length);
        int i = 0;
        while (i < this.texture.length) {
            out.writeInt(theScene.indexOf(this.texture[i]));
            out.writeInt(this.blendMode[i]);
            out.writeUTF(this.mapping[i].getClass().getName());
            this.mapping[i].writeToFile(out);
            ++i;
        }
    }

    public void writeToFile(DataOutputStream out) throws IOException {
    }

    public static String getName() {
        return "Layered";
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return new LayeredTriangle(v1, v2, v3, n1, n2, n3, vert[v1].x, vert[v1].y, vert[v1].z, vert[v2].x, vert[v2].y, vert[v2].z, vert[v3].x, vert[v3].y, vert[v3].z, this, this.theTexture, vert);
    }

    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        LayeredTriangle lt = (LayeredTriangle)tri;
        int i = 0;
        while (i < lt.layerTriangle.length) {
            if (lt.layerTriangle[i] != null && this.numParams[i] > 0) {
                double[] t1 = new double[this.numParams[i]];
                double[] t2 = new double[this.numParams[i]];
                double[] t3 = new double[this.numParams[i]];
                int j = 0;
                while (j < this.numParams[i]) {
                    t1[j] = p1[this.paramStartIndex[i] + j];
                    t2[j] = p2[this.paramStartIndex[i] + j];
                    t3[j] = p3[this.paramStartIndex[i] + j];
                    ++j;
                }
                this.mapping[i].setParameters(lt.layerTriangle[i], t1, t2, t3, mesh);
            }
            ++i;
        }
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, boolean front, double size, double t, double[] param) {
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        double ft = 1.0;
        spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
        spec.specular.setRGB(0.0f, 0.0f, 0.0f);
        spec.hilight.setRGB(0.0f, 0.0f, 0.0f);
        spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
        spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
        spec.cloudiness = 0.0;
        spec.roughness = 0.0;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
        int i = 0;
        while (i < this.texture.length) {
            if (this.mapping[i].appliesToFace(front)) {
                double f = param[this.fractParamIndex[i]];
                if (this.numParams[i] > 0) {
                    int j = 0;
                    while (j < this.numParams[i]) {
                        this.paramTemp[j] = param[this.paramStartIndex[i] + j];
                        ++j;
                    }
                }
                this.mapping[i].getTextureSpec(pos, this.tempSpec, front, size, t, this.paramTemp);
                float r = rt * (float)f;
                float g = gt * (float)f;
                float b = bt * (float)f;
                spec.diffuse.add(r * this.tempSpec.diffuse.red, g * this.tempSpec.diffuse.green, b * this.tempSpec.diffuse.blue);
                spec.specular.add(r * this.tempSpec.specular.red, g * this.tempSpec.specular.green, b * this.tempSpec.specular.blue);
                spec.hilight.add(r * this.tempSpec.hilight.red, g * this.tempSpec.hilight.green, b * this.tempSpec.hilight.blue);
                spec.emissive.add(r * this.tempSpec.emissive.red, g * this.tempSpec.emissive.green, b * this.tempSpec.emissive.blue);
                if (this.blendMode[i] == 0) {
                    spec.transparent.subtract(r * (1.0f - this.tempSpec.transparent.red), g * (1.0f - this.tempSpec.transparent.green), b * (1.0f - this.tempSpec.transparent.blue));
                    f = ft * f;
                } else {
                    spec.transparent.subtract(r *= 1.0f - this.tempSpec.transparent.red, g *= 1.0f - this.tempSpec.transparent.green, b *= 1.0f - this.tempSpec.transparent.blue);
                    f = Math.max(Math.max(r, g), b);
                }
                spec.roughness += f * this.tempSpec.roughness;
                spec.cloudiness += f * this.tempSpec.cloudiness;
                if (this.blendMode[i] == 2) {
                    this.tempSpec.bumpGrad.scale(param[this.fractParamIndex[i]]);
                } else {
                    this.tempSpec.bumpGrad.scale(f);
                }
                spec.bumpGrad.add(this.tempSpec.bumpGrad);
                rt -= r;
                gt -= g;
                bt -= b;
                ft -= f;
                if (rt <= 0.0f && gt <= 0.0f && bt <= 0.0f) {
                    return;
                }
            }
            ++i;
        }
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        double ft = 1.0;
        spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
        spec.specular.setRGB(0.0f, 0.0f, 0.0f);
        spec.hilight.setRGB(0.0f, 0.0f, 0.0f);
        spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
        spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
        spec.cloudiness = 0.0;
        spec.roughness = 0.0;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
        int i = 0;
        while (i < this.texture.length) {
            double f = param[this.fractParamIndex[i]];
            if (this.numParams[i] > 0) {
                int j = 0;
                while (j < this.numParams[i]) {
                    this.paramTemp[j] = param[this.paramStartIndex[i] + j];
                    ++j;
                }
            }
            this.texture[i].getAverageSpec(this.tempSpec, time, this.paramTemp);
            float r = rt * (float)f;
            float g = gt * (float)f;
            float b = bt * (float)f;
            spec.diffuse.add(r * this.tempSpec.diffuse.red, g * this.tempSpec.diffuse.green, b * this.tempSpec.diffuse.blue);
            spec.specular.add(r * this.tempSpec.specular.red, g * this.tempSpec.specular.green, b * this.tempSpec.specular.blue);
            spec.hilight.add(r * this.tempSpec.hilight.red, g * this.tempSpec.hilight.green, b * this.tempSpec.hilight.blue);
            spec.emissive.add(r * this.tempSpec.emissive.red, g * this.tempSpec.emissive.green, b * this.tempSpec.emissive.blue);
            if (this.blendMode[i] == 0) {
                spec.transparent.subtract(r * (1.0f - this.tempSpec.transparent.red), g * (1.0f - this.tempSpec.transparent.green), b * (1.0f - this.tempSpec.transparent.blue));
                f = ft * f;
            } else {
                spec.transparent.subtract(r *= 1.0f - this.tempSpec.transparent.red, g *= 1.0f - this.tempSpec.transparent.green, b *= 1.0f - this.tempSpec.transparent.blue);
                f = Math.max(Math.max(r, g), b);
            }
            spec.roughness += ft * this.tempSpec.roughness;
            spec.cloudiness += ft * this.tempSpec.cloudiness;
            if (this.blendMode[i] == 2) {
                this.tempSpec.bumpGrad.scale(param[this.fractParamIndex[i]]);
            } else {
                this.tempSpec.bumpGrad.scale(f);
            }
            spec.bumpGrad.add(this.tempSpec.bumpGrad);
            rt -= r;
            gt -= g;
            bt -= b;
            ft -= f;
            if (rt <= 0.0f && gt <= 0.0f && bt <= 0.0f) {
                return;
            }
            ++i;
        }
    }

    public void getTransparency(Vec3 pos, RGBColor trans, boolean front, double size, double t, double[] param) {
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        RGBColor temp = this.tempSpec.transparent;
        trans.setRGB(1.0f, 1.0f, 1.0f);
        int i = 0;
        while (i < this.texture.length) {
            if (this.mapping[i].appliesToFace(front)) {
                double f = param[this.fractParamIndex[i]];
                if (this.numParams[i] > 0) {
                    int j = 0;
                    while (j < this.numParams[i]) {
                        this.paramTemp[j] = param[this.paramStartIndex[i] + j];
                        ++j;
                    }
                }
                this.mapping[i].getTransparency(pos, temp, front, size, t, this.paramTemp);
                float r = rt * (float)f;
                float g = gt * (float)f;
                float b = bt * (float)f;
                if (this.blendMode[i] == 0) {
                    trans.subtract(r * (1.0f - this.tempSpec.transparent.red), g * (1.0f - this.tempSpec.transparent.green), b * (1.0f - this.tempSpec.transparent.blue));
                } else {
                    trans.subtract(r *= 1.0f - this.tempSpec.transparent.red, g *= 1.0f - this.tempSpec.transparent.green, b *= 1.0f - this.tempSpec.transparent.blue);
                }
                rt -= r;
                gt -= g;
                bt -= b;
                if (rt <= 0.0f && gt <= 0.0f && bt <= 0.0f) {
                    return;
                }
            }
            ++i;
        }
    }

    public double getDisplacement(Vec3 pos, double size, double t, double[] param) {
        double ft = 1.0;
        double height = 0.0;
        int i = 0;
        while (i < this.texture.length) {
            double f = param[this.fractParamIndex[i]];
            if (this.numParams[i] > 0) {
                int j = 0;
                while (j < this.numParams[i]) {
                    this.paramTemp[j] = param[this.paramStartIndex[i] + j];
                    ++j;
                }
            }
            double temp = this.mapping[i].getDisplacement(pos, size, t, this.paramTemp);
            f *= ft;
            if (this.blendMode[i] == 1) {
                this.mapping[i].getTransparency(pos, this.tempSpec.transparent, true, size, t, this.paramTemp);
                float min = this.tempSpec.transparent.red;
                if (min > this.tempSpec.transparent.green) {
                    min = this.tempSpec.transparent.green;
                }
                if (min > this.tempSpec.transparent.blue) {
                    min = this.tempSpec.transparent.blue;
                }
                f *= ft * (double)(1.0f - min);
            }
            if (this.blendMode[i] != 2) {
                ft -= f;
            }
            height += temp * f;
            if (ft <= 0.0) {
                return height;
            }
            ++i;
        }
        return height;
    }

    public Texture getTexture() {
        return this.theTexture;
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.theTexture);
    }

    public TextureMapping duplicate(Texture tex) {
        LayeredMapping map = new LayeredMapping(null);
        int layers = this.texture.length;
        map.theTexture = new LayeredTexture(map);
        map.texture = new Texture[layers];
        map.mapping = new TextureMapping[layers];
        map.blendMode = new int[layers];
        map.fractParamID = new int[layers];
        int i = 0;
        while (i < layers) {
            map.texture[i] = this.texture[i];
            map.mapping[i] = this.mapping[i].duplicate();
            map.blendMode[i] = this.blendMode[i];
            map.fractParamID[i] = this.fractParamID[i];
            ++i;
        }
        map.getParameters();
        return map;
    }

    public void copy(TextureMapping theMap) {
        LayeredMapping map = (LayeredMapping)theMap;
        int layers = map.texture.length;
        this.texture = new Texture[layers];
        this.mapping = new TextureMapping[layers];
        this.blendMode = new int[layers];
        this.fractParamID = new int[layers];
        int i = 0;
        while (i < layers) {
            this.texture[i] = map.texture[i];
            this.mapping[i] = map.mapping[i].duplicate();
            this.blendMode[i] = map.blendMode[i];
            this.fractParamID[i] = map.fractParamID[i];
            ++i;
        }
        this.getParameters();
    }

    public Panel getEditingPanel(ObjectInfo obj, MaterialPreviewer preview) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

