/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.texture.NonlinearMapping2D;
import artofillusion.texture.TextureSpec;

public class Nonlinear2DTriangle
extends RenderingTriangle {
    Vec3 t1;
    Vec3 t2;
    Vec3 t3;

    public Nonlinear2DTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3 t1, Vec3 t2, Vec3 t3, NonlinearMapping2D theMapping) {
        super(v1, v2, v3, n1, n2, n3, theMapping);
        this.t1 = t1;
        this.t2 = t2;
        this.t3 = t3;
    }

    public void setParameters(double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        NonlinearMapping2D map = (NonlinearMapping2D)this.mapping;
        if (!map.coordsFromParams || p1[map.numTextureParams] == Double.MAX_VALUE) {
            return;
        }
        this.t1 = new Vec3(p1[map.numTextureParams], p1[map.numTextureParams + 1], p1[map.numTextureParams + 2]);
        map.getPreTransform().transform(this.t1);
        this.t2 = new Vec3(p2[map.numTextureParams], p2[map.numTextureParams + 1], p2[map.numTextureParams + 2]);
        map.getPreTransform().transform(this.t2);
        this.t3 = new Vec3(p3[map.numTextureParams], p3[map.numTextureParams + 1], p3[map.numTextureParams + 2]);
        map.getPreTransform().transform(this.t3);
    }

    public void getTextureSpec(TextureSpec spec, boolean front, double u, double v, double w, double size, double t) {
        if (!this.mapping.appliesToFace(front)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        NonlinearMapping2D map = (NonlinearMapping2D)this.mapping;
        map.getSpecIntermed(spec, this.t1.x * u + this.t2.x * v + this.t3.x * w, this.t1.y * u + this.t2.y * v + this.t3.y * w, this.t1.z * u + this.t2.z * v + this.t3.z * w, size, t, this.getParameters(u, v, w));
    }

    public void getTransparency(RGBColor trans, boolean front, double u, double v, double w, double size, double t) {
        if (!this.mapping.appliesToFace(front)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        NonlinearMapping2D map = (NonlinearMapping2D)this.mapping;
        map.getTransIntermed(trans, this.t1.x * u + this.t2.x * v + this.t3.x * w, this.t1.y * u + this.t2.y * v + this.t3.y * w, this.t1.z * u + this.t2.z * v + this.t3.z * w, size, t, this.getParameters(u, v, w));
    }

    public double getDisplacement(double u, double v, double w, double size, double t) {
        NonlinearMapping2D map = (NonlinearMapping2D)this.mapping;
        return map.getDisplaceIntermed(this.t1.x * u + this.t2.x * v + this.t3.x * w, this.t1.y * u + this.t2.y * v + this.t3.y * w, this.t1.z * u + this.t2.z * v + this.t3.z * w, size, t, this.getParameters(u, v, w));
    }
}

