/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ImageMap;
import artofillusion.math.RGBColor;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.Link;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture3D;
import artofillusion.texture.TextureSpec;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.FloatingDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProceduralTexture3D
extends Texture3D
implements ProcedureOwner {
    Procedure proc;
    PointInfo info;
    double antialiasing;

    public ProceduralTexture3D() {
        this.proc = new Procedure(new OutputModule[]{new OutputModule(Translate.text("Diffuse"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Specular"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Transparent"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Emissive"), Translate.text("black"), 0.0, new RGBColor(0.0f, 0.0f, 0.0f), 1), new OutputModule(Translate.text("Transparency"), "0", 0.0, null, 0), new OutputModule(Translate.text("Specularity"), "0", 0.0, null, 0), new OutputModule(Translate.text("Shininess"), "0", 0.0, null, 0), new OutputModule(Translate.text("Roughness"), "0", 0.0, null, 0), new OutputModule(Translate.text("Cloudiness"), "0", 0.0, null, 0), new OutputModule(Translate.text("BumpHeight"), "0", 0.0, null, 0), new OutputModule(Translate.text("Displacement"), "0", 0.0, null, 0)});
        this.info = new PointInfo();
        this.antialiasing = 1.0;
    }

    public static String getTypeName() {
        return "Procedural 3D";
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        this.getTextureSpec(spec, 0.0, 0.0, 0.0, 1000.0, 1000.0, 1000.0, time, param);
    }

    public void getTextureSpec(TextureSpec spec, double x, double y, double z, double xsize, double ysize, double zsize, double t, double[] param) {
        OutputModule[] output = this.proc.getOutputModules();
        this.info.x = x;
        this.info.y = y;
        this.info.z = z;
        this.info.xsize = xsize * this.antialiasing;
        this.info.ysize = ysize * this.antialiasing;
        this.info.zsize = zsize * this.antialiasing;
        this.info.t = t;
        this.info.param = param;
        this.proc.initForPoint(this.info);
        double transparency = output[4].getAverageValue(0, 0.0);
        double specularity = output[5].getAverageValue(0, 0.0);
        double shininess = output[6].getAverageValue(0, 0.0);
        if (transparency < 0.0) {
            transparency = 0.0;
        }
        if (transparency > 1.0) {
            transparency = 1.0;
        }
        if (specularity < 0.0) {
            specularity = 0.0;
        }
        if (specularity > 1.0) {
            specularity = 1.0;
        }
        if (shininess < 0.0) {
            shininess = 0.0;
        }
        if (shininess > 1.0) {
            shininess = 1.0;
        }
        output[0].getColor(0, spec.diffuse, 0.0);
        output[1].getColor(0, spec.specular, 0.0);
        output[2].getColor(0, spec.transparent, 0.0);
        output[3].getColor(0, spec.emissive, 0.0);
        spec.hilight.copy(spec.specular);
        spec.diffuse.scale((1.0 - transparency) * (1.0 - specularity));
        spec.specular.scale((1.0 - transparency) * specularity);
        spec.hilight.scale((1.0 - transparency) * shininess);
        spec.transparent.scale(transparency);
        spec.roughness = output[7].getAverageValue(0, 0.0);
        spec.cloudiness = output[8].getAverageValue(0, 0.0);
        if (spec.roughness < 0.0) {
            spec.roughness = 0.0;
        }
        if (spec.roughness > 1.0) {
            spec.roughness = 1.0;
        }
        if (spec.cloudiness < 0.0) {
            spec.cloudiness = 0.0;
        }
        if (spec.cloudiness > 1.0) {
            spec.cloudiness = 1.0;
        }
        output[9].getValueGradient(0, spec.bumpGrad, 0.0);
        spec.bumpGrad.scale(0.04);
    }

    public void getTransparency(RGBColor trans, double x, double y, double z, double xsize, double ysize, double zsize, double t, double[] param) {
        OutputModule[] output = this.proc.getOutputModules();
        this.info.x = x;
        this.info.y = y;
        this.info.z = z;
        this.info.xsize = xsize * this.antialiasing;
        this.info.ysize = ysize * this.antialiasing;
        this.info.zsize = zsize * this.antialiasing;
        this.info.t = t;
        this.info.param = param;
        this.proc.initForPoint(this.info);
        double transparency = output[4].getAverageValue(0, 0.0);
        if (transparency < 0.0) {
            transparency = 0.0;
        }
        if (transparency > 1.0) {
            transparency = 1.0;
        }
        output[2].getColor(0, trans, 0.0);
        trans.scale(transparency);
    }

    public Procedure getProcedure() {
        return this.proc;
    }

    public boolean usesImage(ImageMap image) {
        Module[] modules = this.proc.getModules();
        int i = 0;
        while (i < modules.length) {
            if (modules[i] instanceof ImageModule && ((ImageModule)modules[i]).getMap() == image) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean displacementMapped() {
        OutputModule[] output = this.proc.getOutputModules();
        return output[10].inputConnected(0);
    }

    public double getDisplacement(double x, double y, double z, double xsize, double ysize, double zsize, double t, double[] param) {
        OutputModule[] output = this.proc.getOutputModules();
        this.info.x = x;
        this.info.y = y;
        this.info.z = z;
        this.info.xsize = xsize * this.antialiasing;
        this.info.ysize = ysize * this.antialiasing;
        this.info.zsize = zsize * this.antialiasing;
        this.info.t = t;
        this.info.param = param;
        this.proc.initForPoint(this.info);
        return output[10].getAverageValue(0, 0.0);
    }

    public boolean bumpMapped() {
        OutputModule[] output = this.proc.getOutputModules();
        return output[9].inputConnected(0);
    }

    public TextureParameter[] getParameters() {
        Module[] module = this.proc.getModules();
        int count = 0;
        int i = 0;
        while (i < module.length) {
            if (module[i] instanceof ParameterModule) {
                ++count;
            }
            ++i;
        }
        TextureParameter[] params = new TextureParameter[count];
        count = 0;
        int i2 = 0;
        while (i2 < module.length) {
            if (module[i2] instanceof ParameterModule) {
                params[count] = ((ParameterModule)module[i2]).getParameter(this);
                ((ParameterModule)module[i2]).setIndex(count++);
            }
            ++i2;
        }
        return params;
    }

    public Texture duplicate() {
        ProceduralTexture3D tex = new ProceduralTexture3D();
        tex.proc.copy(this.proc);
        tex.setName(this.getName());
        return tex;
    }

    public void edit(Frame fr, Scene sc) {
        new ProcedureEditor(this.proc, this, sc);
    }

    public ProceduralTexture3D(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.setName(in.readUTF());
        this.antialiasing = in.readDouble();
        this.proc = new Procedure(new OutputModule[]{new OutputModule(Translate.text("Diffuse"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Specular"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Transparent"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Emissive"), Translate.text("black"), 0.0, new RGBColor(0.0f, 0.0f, 0.0f), 1), new OutputModule(Translate.text("Transparency"), "0", 0.0, null, 0), new OutputModule(Translate.text("Specularity"), "0", 0.0, null, 0), new OutputModule(Translate.text("Shininess"), "0", 0.0, null, 0), new OutputModule(Translate.text("Roughness"), "0", 0.0, null, 0), new OutputModule(Translate.text("Cloudiness"), "0", 0.0, null, 0), new OutputModule(Translate.text("BumpHeight"), "0", 0.0, null, 0), new OutputModule(Translate.text("Displacement"), "0", 0.0, null, 0)});
        this.proc.readFromStream(in, theScene);
        if (version == 0) {
            OutputModule[] output = this.proc.getOutputModules();
            Module[] input = new Module[output.length];
            int[] index = new int[output.length];
            int i = 0;
            while (i < output.length) {
                int j = i < 6 ? i : i - 1;
                input[i] = output[j].linkFrom[0];
                index[i] = output[j].linkFromIndex[0];
                ++i;
            }
            Link[] link = this.proc.getLinks();
            int i2 = 0;
            while (i2 < link.length) {
                if (link[i2].to.getModule() instanceof OutputModule) {
                    this.proc.deleteLink(i2--);
                    link = this.proc.getLinks();
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < input.length) {
                if (input[i3] != null) {
                    IOPort to = output[i3].getInputPorts()[0];
                    IOPort from = input[i3].getOutputPorts()[index[i3]];
                    this.proc.addLink(new Link(from, to));
                    output[i3].setInput(to, from);
                }
                ++i3;
            }
        }
        this.info = new PointInfo();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.getName());
        out.writeDouble(this.antialiasing);
        this.proc.writeToStream(out, theScene);
    }

    public String getWindowTitle() {
        return "Procedural 3D Texture";
    }

    public Object getPreview(ProcedureEditor editor) {
        FloatingDialog dlg = new FloatingDialog(editor.getParentFrame(), "Preview", false);
        MaterialPreviewer preview = new MaterialPreviewer(this, null, 200, 160);
        dlg.add(preview);
        dlg.pack();
        Rectangle parentBounds = editor.getParentFrame().getBounds();
        Point location = dlg.getLocation();
        location.y = parentBounds.y;
        location.x = parentBounds.x + parentBounds.width;
        ((Component)dlg).setLocation(location);
        dlg.show();
        return preview;
    }

    public void updatePreview(Object preview) {
        ((MaterialPreviewer)preview).render();
    }

    public void disposePreview(Object preview) {
        ((Dialog)((MaterialPreviewer)preview).getParent()).dispose();
    }

    public boolean allowParameters() {
        return true;
    }

    public boolean canEditName() {
        return true;
    }

    public void acceptEdits(ProcedureEditor editor) {
        int i = editor.getScene().indexOf(this);
        if (i > -1) {
            editor.getScene().changeTexture(i);
        }
    }

    public void editProperties(ProcedureEditor editor) {
        ValueField aliasField = new ValueField(this.antialiasing, 1);
        ComponentsDialog dlg = new ComponentsDialog((Window)editor.getParentFrame(), "Set Texture Properties:", new Component[]{aliasField}, new String[]{"Antialiasing"});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.antialiasing = aliasField.getValue();
        editor.updatePreview();
    }
}

