/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.math.RGBColor;
import artofillusion.texture.ProjectionMapping;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

public abstract class Texture2D
extends Texture {
    public static final int DIFFUSE_COLOR_COMPONENT = 0;
    public static final int SPECULAR_COLOR_COMPONENT = 1;
    public static final int TRANSPARENT_COLOR_COMPONENT = 2;
    public static final int HILIGHT_COLOR_COMPONENT = 3;
    public static final int EMISSIVE_COLOR_COMPONENT = 4;

    public abstract void getTextureSpec(TextureSpec var1, double var2, double var4, double var6, double var8, double var10, double[] var12);

    public abstract void getTransparency(RGBColor var1, double var2, double var4, double var6, double var8, double var10, double[] var12);

    public TextureMapping getDefaultMapping() {
        return new ProjectionMapping(this);
    }

    public double getDisplacement(double x, double y, double xsize, double ysize, double t, double[] param) {
        return Double.NaN;
    }

    public boolean displacementMapped() {
        return !Double.isNaN(this.getDisplacement(0.0, 0.0, 0.0, 0.0, 0.0, null));
    }

    public Image createComponentImage(double minu, double maxu, double minv, double maxv, int width, int height, int component, double time, double[] param) {
        int[] pixel = new int[width * height];
        double uscale = (maxu - minu) / (double)width;
        double vscale = (maxv - minv) / (double)height;
        TextureSpec spec = new TextureSpec();
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                double u = minu + (double)i * uscale;
                double v = maxv - (double)j * vscale;
                this.getTextureSpec(spec, u, v, uscale, vscale, time, param);
                int index = i + j * width;
                switch (component) {
                    case 0: {
                        pixel[index] = spec.diffuse.getARGB();
                        break;
                    }
                    case 1: {
                        pixel[index] = spec.specular.getARGB();
                        break;
                    }
                    case 2: {
                        pixel[index] = spec.transparent.getARGB();
                        break;
                    }
                    case 3: {
                        pixel[index] = spec.hilight.getARGB();
                        break;
                    }
                    case 4: {
                        pixel[index] = spec.emissive.getARGB();
                    }
                }
                ++j;
            }
            ++i;
        }
        MemoryImageSource src = new MemoryImageSource(width, height, pixel, 0, width);
        return Toolkit.getDefaultToolkit().createImage(src);
    }
}

