/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureMappingDialog;
import artofillusion.TextureParameter;
import artofillusion.animation.Actor;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVMappedTriangle;
import artofillusion.texture.UVMappingWindow;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UVMapping
extends Mapping2D {
    int numTextureParams;
    TextureParameter uparam;
    TextureParameter vparam;

    public UVMapping(Texture theTexture) {
        super(theTexture);
    }

    public static String getName() {
        return "UV";
    }

    public static boolean legalMapping(Object3D obj, Texture tex) {
        if (obj instanceof Actor) {
            obj = ((Actor)obj).getObject();
        }
        return tex instanceof Texture2D && (obj instanceof TriangleMesh || obj instanceof SplineMesh || obj instanceof Actor);
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return new UVMappedTriangle(v1, v2, v3, n1, n2, n3, this);
    }

    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        UVMappedTriangle uv = (UVMappedTriangle)tri;
        uv.setTextureCoordinates((float)p1[this.numTextureParams], (float)p1[this.numTextureParams + 1], (float)p2[this.numTextureParams], (float)p2[this.numTextureParams + 1], (float)p3[this.numTextureParams], (float)p3[this.numTextureParams + 1], mesh.vert[uv.v1], mesh.vert[uv.v2], mesh.vert[uv.v3]);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, boolean front, double size, double time, double[] param) {
        if (!this.appliesToFace(front)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        this.texture.getTextureSpec(spec, pos.x, pos.y, size, size, time, param);
        if (this.texture.bumpMapped()) {
            double s = spec.bumpGrad.x;
            double t = spec.bumpGrad.y;
            spec.bumpGrad.set(s, t, 0.0);
        }
    }

    public void getTransparency(Vec3 pos, RGBColor trans, boolean front, double size, double time, double[] param) {
        if (!this.appliesToFace(front)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
        } else {
            this.texture.getTransparency(trans, pos.x, pos.y, size, size, time, param);
        }
    }

    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        return this.texture.getDisplacement(pos.x, pos.y, size, size, time, param);
    }

    public Vec2[] findTextureCoordinates(Mesh mesh, TextureParameter[] param) {
        int iu = -1;
        int iv = -1;
        int i = 0;
        while (i < param.length) {
            if (param[i].equals(this.uparam)) {
                iu = i;
            } else if (param[i].equals(this.vparam)) {
                iv = i;
            }
            ++i;
        }
        MeshVertex[] vert = mesh.getVertices();
        Vec2[] uv = new Vec2[vert.length];
        int i2 = 0;
        while (i2 < vert.length) {
            uv[i2] = new Vec2(vert[i2].param[iu], vert[i2].param[iv]);
            ++i2;
        }
        return uv;
    }

    public void setTextureCoordinates(Mesh mesh, TextureParameter[] param, Vec2[] uv) {
        int iu = -1;
        int iv = -1;
        int i = 0;
        while (i < param.length) {
            if (param[i].equals(this.uparam)) {
                iu = i;
            } else if (param[i].equals(this.vparam)) {
                iv = i;
            }
            ++i;
        }
        MeshVertex[] vert = mesh.getVertices();
        int i2 = 0;
        while (i2 < vert.length) {
            vert[i2].param[iu] = uv[i2].x;
            vert[i2].param[iv] = uv[i2].y;
            ++i2;
        }
    }

    public void setTextureCoordinates(Actor actor, TextureParameter[] param, Vec2[] uv) {
        double[] value = new double[uv.length];
        int i = 0;
        while (i < value.length) {
            value[i] = uv[i].x;
            ++i;
        }
        actor.setTextureParameter(this.uparam, value);
        int i2 = 0;
        while (i2 < value.length) {
            value[i2] = uv[i2].y;
            ++i2;
        }
        actor.setTextureParameter(this.vparam, value);
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.texture);
    }

    public TextureMapping duplicate(Texture tex) {
        UVMapping map = new UVMapping(tex);
        map.numTextureParams = this.numTextureParams;
        map.uparam = this.uparam;
        map.vparam = this.vparam;
        return map;
    }

    public void copy(TextureMapping mapping) {
        UVMapping map = (UVMapping)mapping;
        this.numTextureParams = map.numTextureParams;
        this.uparam = map.uparam;
        this.vparam = map.vparam;
    }

    public TextureParameter[] getParameters() {
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 2];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        if (this.uparam == null) {
            this.uparam = new TextureParameter(this, "U", -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
            this.vparam = new TextureParameter(this, "V", -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
            this.uparam.type = 1;
            this.vparam.type = 2;
            this.uparam.assignNewID();
            this.vparam.assignNewID();
        }
        p[this.numTextureParams] = this.uparam;
        p[this.numTextureParams + 1] = this.vparam;
        return p;
    }

    public Panel getEditingPanel(ObjectInfo obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public UVMapping(DataInputStream in, Texture theTexture) throws IOException, InvalidObjectException {
        super(theTexture);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setAppliesTo(in.readShort());
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeShort(this.appliesTo());
    }

    class Editor
    extends Panel
    implements ActionListener,
    ItemListener {
        Choice applyToChoice;
        ObjectInfo theObject;
        MaterialPreviewer preview;

        public Editor(ObjectInfo obj, MaterialPreviewer preview) {
            this.theObject = obj;
            this.preview = preview;
            GridBagConstraints gc = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            gc.gridy = 0;
            gc.gridwidth = 2;
            gc.anchor = 10;
            Button b = new Button("Edit UV Coordinates...");
            this.add((Component)b, gc);
            b.addActionListener(this);
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.insets = new Insets(0, 0, 0, 5);
            this.add((Component)new Label("Apply To:"), gc);
            this.applyToChoice = new Choice();
            this.add((Component)this.applyToChoice, gc);
            this.applyToChoice.add("Front and Back Faces");
            this.applyToChoice.add("Front Faces Only");
            this.applyToChoice.add("Back Faces Only");
            this.applyToChoice.select(UVMapping.this.appliesTo());
            this.applyToChoice.addItemListener(this);
        }

        public void actionPerformed(ActionEvent ev) {
            Container parent = this.getParent();
            while (!(parent instanceof Frame)) {
                parent = parent.getParent();
            }
            new UVMappingWindow((Frame)parent, this.theObject, UVMapping.this);
            parent = this.getParent();
            while (!(parent instanceof TextureMappingDialog) && parent != null) {
                parent = parent.getParent();
            }
            if (parent != null) {
                ((TextureMappingDialog)parent).setPreviewMapping(UVMapping.this);
            }
            this.preview.render();
        }

        public void itemStateChanged(ItemEvent e) {
            UVMapping.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(UVMapping.this.getTexture(), UVMapping.this);
            this.preview.render();
        }
    }
}

