/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.Camera;
import artofillusion.MeshViewer;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.Texture2D;
import artofillusion.texture.UVMappingWindow;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;

public class UVMappingViewer
extends MeshViewer {
    private Texture2D tex;
    private UVMappingWindow window;
    private double minu;
    private double maxu;
    private double minv;
    private double maxv;
    private double time;
    private double[] param;
    private int component;
    private int sampling;
    private int[] selectionDistance;
    private int deselect;
    private boolean[] selected;
    private boolean dragging;
    private boolean tolerant;
    private boolean draggingSelectionBox;
    private Point[] screenVert;
    private Vec2[] coord;
    private int[] vertIndex;
    private static final int MARKER_SIZE = 4;

    public UVMappingViewer(Texture2D tex, UVMappingWindow window, double minu, double maxu, double minv, double maxv, int component, int sampling, double time, double[] param) {
        super(new ObjectInfo(new UVMesh(), new CoordinateSystem(), ""), new Panel());
        this.tex = tex;
        this.window = window;
        this.time = time;
        this.param = param;
        this.selected = new boolean[0];
        this.screenVert = new Point[0];
        this.setParameters(minu, maxu, minv, maxv, component, sampling);
    }

    public void setParameters(double minu, double maxu, double minv, double maxv, int component, int sampling) {
        this.minu = minu;
        this.maxu = maxu;
        this.minv = minv;
        this.maxv = maxv;
        this.component = component;
        this.sampling = sampling;
        Dimension dim = this.getSize();
        this.theImage = null;
        this.adjustCamera();
        this.calcScreenPositions();
        this.repaint();
    }

    private void adjustCamera() {
        Dimension dim = this.getSize();
        double uscale = (double)dim.width / (this.maxu - this.minu);
        double vscale = (double)dim.height / (this.maxv - this.minv);
        this.theCamera.setScreenParamsParallel(1.0, dim.width, dim.height);
        Mat4 worldToView = Mat4.scale(-uscale, vscale, 1.0).times(Mat4.translation(-this.minu - 0.5 * (double)dim.width / uscale, -this.maxv + 0.5 * (double)dim.height / vscale, 0.0));
        Mat4 viewToWorld = Mat4.translation(this.minu + 0.5 * (double)dim.width / uscale, this.maxv - 0.5 * (double)dim.height / vscale, 0.0).times(Mat4.scale(-1.0 / uscale, 1.0 / vscale, 1.0));
        this.theCamera.setViewTransform(worldToView, viewToWorld);
    }

    public void paint(Graphics g) {
        this.drawImage(g, true);
    }

    private synchronized void drawImage(Graphics g, boolean showOverlay) {
        Dimension dim = this.getSize();
        if (dim.width < 1 || dim.height < 1) {
            return;
        }
        if (this.theImage == null || this.theImage.getWidth(this) != dim.width || this.theImage.getHeight(this) != dim.height) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            double uoffset = 0.5 * (double)this.sampling * (this.maxu - this.minu) / (double)dim.width;
            double voffset = 0.5 * (double)this.sampling * (this.maxv - this.minv) / (double)dim.height;
            this.theImage = ((Texture2D)this.tex.duplicate()).createComponentImage(this.minu + uoffset, this.maxu + uoffset, this.minv - voffset, this.maxv - voffset, dim.width / this.sampling, dim.height / this.sampling, this.component, this.time, this.param);
            if (this.sampling > 1) {
                this.theImage = this.theImage.getScaledInstance(dim.width, dim.height, 4);
            }
            this.adjustCamera();
            this.setCursor(Cursor.getDefaultCursor());
        }
        g.drawImage(this.theImage, 0, 0, this);
        int i = 0;
        while (i < this.screenVert.length) {
            int x = this.screenVert[i].x;
            int y = this.screenVert[i].y;
            g.setColor(Color.white);
            g.fillRect(x - 4, y - 1, 9, 3);
            g.fillRect(x - 1, y - 4, 3, 9);
            g.setColor(this.selected[i] ? Color.red : Color.black);
            g.drawLine(x - 4 + 1, y, x + 4 - 1, y);
            g.drawLine(x, y - 4 + 1, x, y + 4 - 1);
            ++i;
        }
        if (showOverlay) {
            this.currentTool.drawOverlay(g, this);
        }
        Toolkit.getDefaultToolkit().sync();
    }

    public void drawImage(Graphics g) {
        this.drawImage(g, false);
    }

    private void calcScreenPositions() {
        Dimension dim = this.getSize();
        UVMesh uvmesh = (UVMesh)this.getObject().object;
        double uscale = (double)dim.width / (this.maxu - this.minu);
        double vscale = (double)dim.height / (this.maxv - this.minv);
        this.screenVert = new Point[uvmesh.vert.length];
        int i = 0;
        while (i < uvmesh.vert.length) {
            int x = (int)((uvmesh.vert[i].r.x - this.minu) * uscale - 0.5);
            int y = (int)((this.maxv - uvmesh.vert[i].r.y) * vscale - 0.5);
            this.screenVert[i] = new Point(x, y);
            ++i;
        }
    }

    public synchronized void updateImage() {
    }

    protected void drawObject(Graphics g) {
    }

    public void drawDraggedSelection(Graphics g, Camera cam, Vec3[] v) {
        Dimension dim = this.getSize();
        double uscale = (double)dim.width / (this.maxu - this.minu);
        double vscale = (double)dim.height / (this.maxv - this.minv);
        int i = 0;
        while (i < this.screenVert.length) {
            int x = (int)((v[i].x - this.minu) * uscale - 0.5);
            int y = (int)((this.maxv - v[i].y) * vscale - 0.5);
            this.screenVert[i] = new Point(x, y);
            ++i;
        }
        this.paint(g);
    }

    public int[] getSelectionDistance() {
        if (this.selectionDistance == null) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    private void findSelectionDistance() {
        this.selectionDistance = new int[this.selected.length];
        int i = 0;
        while (i < this.selected.length) {
            this.selectionDistance[i] = this.selected[i] ? 0 : -1;
            ++i;
        }
    }

    public boolean[] getSelection() {
        boolean[] sel = new boolean[this.coord.length];
        int i = 0;
        while (i < this.selected.length) {
            if (this.selected[i]) {
                sel[this.vertIndex[i]] = true;
            }
            ++i;
        }
        return sel;
    }

    public void setMesh(Mesh mesh) {
        UVMesh obj = (UVMesh)mesh;
        this.setObject(obj);
    }

    public void setDisplayedVertices(Vec2[] coord, boolean[] display) {
        this.coord = coord;
        int count = 0;
        int i = 0;
        while (i < display.length) {
            if (display[i]) {
                ++count;
            }
            ++i;
        }
        this.vertIndex = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 < display.length) {
            if (display[i2]) {
                this.vertIndex[count++] = i2;
            }
            ++i2;
        }
        this.updateVertexPositions(coord);
        this.selected = new boolean[this.vertIndex.length];
        this.selectionDistance = null;
        this.repaint();
    }

    public void updateVertexPositions(Vec2[] coord) {
        Vec2[] shown = new Vec2[this.vertIndex.length];
        int i = 0;
        while (i < shown.length) {
            shown[i] = coord[this.vertIndex[i]];
            ++i;
        }
        ((UVMesh)this.getObject().object).setVertices(shown);
        this.calcScreenPositions();
    }

    public void objectChanged() {
        this.calcScreenPositions();
        super.objectChanged();
        UVMesh uvmesh = (UVMesh)this.getObject().object;
        int i = 0;
        while (i < this.vertIndex.length) {
            this.coord[this.vertIndex[i]] = new Vec2(uvmesh.vert[i].r.x, uvmesh.vert[i].r.y);
            ++i;
        }
        this.window.setTextureCoords(this.coord);
        this.window.updateTextFields();
    }

    public void mousePressed(MouseEvent e) {
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.currentTool;
        if (this.activeTool.whichClicks() == 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            return;
        }
        int i = this.findClickTarget(e.getPoint());
        if (i == -1) {
            this.draggingSelectionBox = true;
            this.beginDraggingSelection(e.getPoint(), false);
            this.sentClick = false;
            return;
        }
        if (this.selected[i]) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, i);
            return;
        }
        if (!e.isShiftDown()) {
            int k = 0;
            while (k < this.selected.length) {
                this.selected[k] = false;
                ++k;
            }
        }
        this.selected[i] = true;
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        if (e.isShiftDown()) {
            this.sentClick = false;
            this.updateImage();
            this.repaint();
        } else {
            this.activeTool.mousePressedOnHandle(e, this, 0, i);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    public void mouseReleased(MouseEvent e) {
        int i;
        this.endDraggingSelection();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            i = 0;
            while (i < this.selected.length) {
                this.selected[i] = false;
                ++i;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel = !e.isControlDown();
            i = 0;
            while (i < this.selected.length) {
                if (this.selectionRegionContains(this.screenVert[i])) {
                    this.selected[i] = newsel;
                }
                ++i;
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            this.selected[this.deselect] = false;
        }
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    private int findClickTarget(Point pos) {
        MeshVertex[] v = ((UVMesh)this.theObject).getVertices();
        int i = v.length - 1;
        while (i >= 0) {
            int dy;
            int dx = this.screenVert[i].x - pos.x;
            if (dx >= -4 && dx <= 4 && (dy = this.screenVert[i].y - pos.y) >= -4 && dy <= 4) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static class UVMesh
    extends Object3D
    implements Mesh {
        public MeshVertex[] vert;

        public UVMesh() {
            this.vert = new MeshVertex[0];
        }

        public UVMesh(Vec2[] uv) {
            this.vert = new MeshVertex[uv.length];
            int i = 0;
            while (i < this.vert.length) {
                this.vert[i] = new MeshVertex(new Vec3(uv[i].x, uv[i].y, 0.0));
                ++i;
            }
        }

        public Object3D duplicate() {
            Vec2[] uv = new Vec2[this.vert.length];
            int i = 0;
            while (i < this.vert.length) {
                uv[i] = new Vec2(this.vert[i].r.x, this.vert[i].r.y);
                ++i;
            }
            return new UVMesh(uv);
        }

        public void copyObject(Object3D obj) {
            UVMesh mesh = (UVMesh)obj;
            this.vert = new MeshVertex[mesh.vert.length];
            int i = 0;
            while (i < mesh.vert.length) {
                this.vert[i] = new MeshVertex(new Vec3(mesh.vert[i].r));
                ++i;
            }
        }

        public MeshVertex[] getVertices() {
            return this.vert;
        }

        public void setVertices(Vec3[] v) {
            this.vert = new MeshVertex[v.length];
            int i = 0;
            while (i < v.length) {
                this.vert[i] = new MeshVertex(v[i]);
                ++i;
            }
        }

        public void setVertices(Vec2[] v) {
            this.vert = new MeshVertex[v.length];
            int i = 0;
            while (i < v.length) {
                this.vert[i] = new MeshVertex(new Vec3(v[i].x, v[i].y, 0.0));
                ++i;
            }
        }

        public BoundingBox getBounds() {
            return null;
        }

        public void setSize(double xsize, double ysize, double zsize) {
        }

        public WireframeMesh getWireframeMesh() {
            return null;
        }

        public Keyframe getPoseKeyframe() {
            return null;
        }

        public void applyPoseKeyframe(Keyframe k) {
        }

        public Vec3[] getNormals() {
            return null;
        }

        public Skeleton getSkeleton() {
            return null;
        }

        public void setSkeleton(Skeleton s) {
        }
    }
}

