/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformTexture;
import artofillusion.texture.UniformTriangle;
import java.awt.Choice;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UniformMapping
extends TextureMapping {
    UniformTexture texture;

    public UniformMapping(Texture theTexture) {
        this.texture = (UniformTexture)theTexture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return new UniformTriangle(v1, v2, v3, n1, n2, n3, this);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, boolean front, double size, double t, double[] param) {
        if (!this.appliesToFace(front)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        this.texture.getTextureSpec(spec);
    }

    public void getTransparency(Vec3 pos, RGBColor trans, boolean front, double size, double t, double[] param) {
        if (!this.appliesToFace(front)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        this.texture.getTransparency(trans);
    }

    public double getDisplacement(Vec3 pos, double size, double t, double[] param) {
        return 0.0;
    }

    public static boolean legalMapping(Object3D obj, Texture tex) {
        return tex instanceof UniformTexture;
    }

    public TextureMapping duplicate() {
        UniformMapping map = new UniformMapping(this.texture);
        map.setAppliesTo(this.appliesTo());
        return map;
    }

    public TextureMapping duplicate(Texture tex) {
        UniformMapping map = new UniformMapping(tex);
        map.setAppliesTo(this.appliesTo());
        return map;
    }

    public void copy(TextureMapping map) {
        this.setAppliesTo(map.appliesTo());
    }

    public Panel getEditingPanel(ObjectInfo obj, final MaterialPreviewer preview) {
        Panel p = new Panel();
        final Choice c = new Choice();
        p.add(new Label("Apply To:"));
        p.add(c);
        c.add("Front and Back Faces");
        c.add("Front Faces Only");
        c.add("Back Faces Only");
        c.select(this.appliesTo());
        c.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                UniformMapping.this.setAppliesTo((short)c.getSelectedIndex());
                preview.setTexture(UniformMapping.this.getTexture(), UniformMapping.this);
                preview.render();
            }
        });
        return p;
    }

    public UniformMapping(DataInputStream in, Texture theTexture) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        if (version == 1) {
            this.setAppliesTo(in.readShort());
        }
        this.texture = (UniformTexture)theTexture;
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(1);
        out.writeShort(this.appliesTo());
    }
}

