/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.Callback;
import artofillusion.ModellingApp;
import artofillusion.ui.Translate;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ComponentsDialog
extends Dialog
implements ActionListener,
KeyListener {
    Component[] comp;
    boolean ok;
    Callback okCallback;
    Callback cancelCallback;

    public ComponentsDialog(Window parent, String prompt, Component[] components, String[] labels) {
        this(parent, prompt, components, labels, null, null);
    }

    public ComponentsDialog(Window parent, String prompt, Component[] components, String[] labels, Callback onOK, Callback onCancel) {
        super(ComponentsDialog.findFrame(parent), onOK == null && onCancel == null);
        GridBagConstraints c = new GridBagConstraints();
        Panel p = new Panel();
        this.comp = components;
        this.okCallback = onOK;
        this.cancelCallback = onCancel;
        this.setLayout(new GridBagLayout());
        c.gridwidth = 2;
        this.add((Component)new Label(prompt), c);
        c.insets.top = 5;
        int i = 0;
        while (i < labels.length) {
            c.gridx = 0;
            if (labels[i] == null) {
                c.gridwidth = 2;
                c.weightx = 0.0;
                c.weighty = 1.0;
                c.anchor = 10;
                c.fill = 0;
                this.add(this.comp[i], c);
            } else {
                c.gridwidth = 1;
                c.insets.right = 5;
                c.weighty = 0.0;
                c.weightx = 0.0;
                c.anchor = 13;
                c.fill = 0;
                this.add((Component)new Label(labels[i]), c);
                c.insets.right = 0;
                c.gridx = 1;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.anchor = 17;
                c.fill = 1;
                this.add(this.comp[i], c);
            }
            ++i;
        }
        this.addAsListener(this);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = labels.length + 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        this.add((Component)p, c);
        p.add(Translate.button("ok", this));
        p.add(Translate.button("cancel", this));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ComponentsDialog.this.ok = false;
                ComponentsDialog.this.closeWindow();
            }
        });
        this.pack();
        this.setResizable(false);
        ModellingApp.centerDialog(this, parent);
        this.show();
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public Insets getInsets() {
        Insets in = super.getInsets();
        return new Insets(in.top + 10, in.left + 10, in.bottom + 10, in.right + 10);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.ok = !command.equals("cancel");
        this.closeWindow();
    }

    private void closeWindow() {
        if (this.ok && this.okCallback != null) {
            this.okCallback.execute();
        }
        if (!this.ok && this.cancelCallback != null) {
            this.cancelCallback.execute();
        }
        this.dispose();
        this.removeAsListener(this);
    }

    public void keyPressed(KeyEvent ev) {
        int code = ev.getKeyCode();
        if (code != 10 && code != 27) {
            return;
        }
        if (code == 10 && ev.getSource() instanceof Button) {
            return;
        }
        this.ok = code == 10;
        this.closeWindow();
    }

    public void keyReleased(KeyEvent ev) {
    }

    public void keyTyped(KeyEvent ev) {
    }

    private void addAsListener(Component c) {
        c.addKeyListener(this);
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.addAsListener(children[i]);
                ++i;
            }
        }
    }

    private void removeAsListener(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.removeAsListener(children[i]);
                ++i;
            }
        }
    }

    private static Frame findFrame(Window win) {
        if (win instanceof Frame || win == null) {
            return (Frame)win;
        }
        return ComponentsDialog.findFrame((Window)win.getParent());
    }
}

