/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ModellingApp;
import artofillusion.ui.Translate;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class EntriesDialog
extends Dialog
implements ActionListener,
KeyListener {
    TextField[] fields;
    String[] initialValues;
    String[] finalValues;

    public EntriesDialog(Window parent, String prompt, String[] labels) {
        this(parent, prompt, labels, new String[labels.length]);
    }

    public EntriesDialog(Window parent, String prompt, String[] labels, String[] initialEntries) {
        super(EntriesDialog.findFrame(parent), true);
        GridBagConstraints c = new GridBagConstraints();
        Panel p = new Panel();
        this.initialValues = initialEntries;
        this.setLayout(new GridBagLayout());
        c.gridwidth = 2;
        this.add((Component)new Label(prompt), c);
        c.anchor = 13;
        c.ipadx = 5;
        c.gridwidth = 1;
        c.gridx = 0;
        this.fields = new TextField[labels.length];
        int i = 0;
        while (i < labels.length) {
            this.add((Component)new Label(labels[i]), c);
            ++i;
        }
        c.fill = 2;
        c.ipadx = 0;
        c.gridx = 1;
        i = 0;
        while (i < labels.length) {
            if (initialEntries[i] == null) {
                this.fields[i] = new TextField();
                this.add((Component)this.fields[i], c);
            } else {
                this.fields[i] = new TextField(initialEntries[i]);
                this.add((Component)this.fields[i], c);
            }
            this.fields[i].addKeyListener(this);
            ++i;
        }
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = labels.length + 1;
        this.add((Component)p, c);
        p.add(Translate.button("ok", this));
        p.add(Translate.button("cancel", this));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EntriesDialog.this.closeWindow(false);
            }
        });
        this.pack();
        this.setResizable(false);
        ModellingApp.centerDialog(this, parent);
        this.fields[0].requestFocus();
        this.fields[0].selectAll();
        this.show();
    }

    public String[] getEntries() {
        return this.finalValues;
    }

    public Insets getInsets() {
        Insets in = super.getInsets();
        return new Insets(in.top + 10, in.left + 10, in.bottom + 10, in.right + 10);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.closeWindow(command.equals("ok"));
    }

    public void keyPressed(KeyEvent ev) {
        int code = ev.getKeyCode();
        if (code != 10 && code != 27) {
            return;
        }
        this.closeWindow(code == 10);
    }

    private void closeWindow(boolean ok) {
        if (ok) {
            this.finalValues = new String[this.fields.length];
            int i = 0;
            while (i < this.fields.length) {
                this.finalValues[i] = this.fields[i].getText();
                ++i;
            }
        } else {
            this.finalValues = null;
        }
        this.dispose();
    }

    public void keyReleased(KeyEvent ev) {
    }

    public void keyTyped(KeyEvent ev) {
    }

    private static Frame findFrame(Window win) {
        if (win instanceof Frame || win == null) {
            return (Frame)win;
        }
        return EntriesDialog.findFrame((Window)win.getParent());
    }
}

