/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Translate {
    private static Locale locale = Locale.getDefault();
    private static ResourceBundle resources;

    public static void setLocale(Locale l) {
        locale = l;
        resources = ResourceBundle.getBundle("artofillusion", locale);
    }

    public static Locale getLocale() {
        return locale;
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{Locale.US, new Locale("es", "ES"), Locale.GERMAN};
    }

    public static Menu menu(String name) {
        try {
            return new Menu(resources.getString("menu." + name));
        }
        catch (MissingResourceException ex) {
            return new Menu(name);
        }
    }

    public static MenuItem menuItem(String name, ActionListener listener) {
        String command = name;
        try {
            command = resources.getString("menu." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        MenuItem item = new MenuItem(command);
        try {
            String shortcut = resources.getString("menu." + name + ".shortcut");
            if (shortcut.length() > 1 && shortcut.charAt(0) == '^') {
                item.setShortcut(new MenuShortcut(shortcut.charAt(1), true));
            } else if (shortcut.length() > 0) {
                item.setShortcut(new MenuShortcut(shortcut.charAt(0)));
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (listener != null) {
            item.setActionCommand(name);
            item.addActionListener(listener);
        }
        return item;
    }

    public static MenuItem menuItem(String name, ActionListener listener, MenuShortcut shortcut) {
        String command = name;
        try {
            command = resources.getString("menu." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        MenuItem item = new MenuItem(command);
        if (shortcut != null) {
            item.setShortcut(shortcut);
        }
        if (listener != null) {
            item.setActionCommand(name);
            item.addActionListener(listener);
        }
        return item;
    }

    public static CheckboxMenuItem checkboxMenuItem(String name, ItemListener listener, boolean state) {
        String command = name;
        try {
            command = resources.getString("menu." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        CheckboxMenuItem item = new CheckboxMenuItem(command, state);
        try {
            String shortcut = resources.getString("menu." + name + ".shortcut");
            if (shortcut.length() > 1 && shortcut.charAt(0) == '^') {
                item.setShortcut(new MenuShortcut(shortcut.charAt(1), true));
            } else if (shortcut.length() > 0) {
                item.setShortcut(new MenuShortcut(shortcut.charAt(0)));
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (listener != null) {
            item.addItemListener(listener);
        }
        return item;
    }

    public static Button button(String name, ActionListener listener) {
        String command = name;
        try {
            command = resources.getString("button." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        Button b = new Button(command);
        if (listener != null) {
            b.setActionCommand(name);
            b.addActionListener(listener);
        }
        return b;
    }

    public static String text(String name) {
        try {
            return resources.getString(name);
        }
        catch (MissingResourceException ex) {
            return name;
        }
    }

    public static String text(String name, Object arg1) {
        String pattern = name;
        try {
            pattern = resources.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return MessageFormat.format(pattern, arg1);
    }

    public static String text(String name, Object arg1, Object arg2) {
        String pattern = name;
        try {
            pattern = resources.getString(name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return MessageFormat.format(pattern, arg1, arg2);
    }

    public static String text(String name, Object[] args) {
        String pattern = name;
        try {
            pattern = resources.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return MessageFormat.format(pattern, args);
    }
}

