/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.LayoutWindow;
import artofillusion.UndoRecord;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeEvent;
import artofillusion.ui.TreeListener;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class TreeList
extends Canvas
implements ItemSelectable,
MouseListener,
MouseMotionListener {
    LayoutWindow window;
    Vector elements;
    Vector showing;
    Vector indent;
    Vector selected;
    int preferredWidth;
    int preferredHeight;
    int yoffset;
    int rowHeight;
    int dragStart;
    int lastDrag;
    int lastIndent;
    boolean updateDisabled;
    boolean moving;
    boolean[] origSelected;
    boolean insertAbove;
    boolean okToInsert;
    boolean allowMultiple;
    ItemListener itemListeners;
    Vector treeListeners;
    PopupMenuManager popupManager;
    UndoRecord undo;
    private static final Polygon openHandle = new Polygon(new int[]{-4, 4, 0}, new int[]{-2, -2, 2}, 3);
    private static final Polygon closedHandle = new Polygon(new int[]{-2, 2, -2}, new int[]{-4, 0, 4}, 3);
    private static final Polygon insertHandle = new Polygon(new int[]{-5, -2, -5}, new int[]{-3, 0, 3}, 3);
    private static final int INDENT_WIDTH = 10;
    private static final int HANDLE_WIDTH = 4;
    private static final int HANDLE_HEIGHT = 8;
    private static final int INSERT_WIDTH = 3;
    private static final int INSERT_HEIGHT = 6;

    public TreeList(LayoutWindow win) {
        this.window = win;
        this.elements = new Vector();
        this.showing = new Vector();
        this.indent = new Vector();
        this.selected = new Vector();
        this.treeListeners = new Vector();
        this.origSelected = new boolean[0];
        this.allowMultiple = true;
        this.buildState();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setPreferredSize(int width, int height) {
        this.preferredWidth = width;
        this.preferredHeight = height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, Math.max(this.preferredHeight, this.rowHeight * this.showing.size()));
    }

    public void setAllowMultiple(boolean allow) {
        this.allowMultiple = allow;
    }

    public void setUpdateEnabled(boolean enabled) {
        boolean bl = this.updateDisabled = !enabled;
        if (enabled) {
            this.buildState();
            this.repaint();
        }
    }

    public void addElement(TreeElement el) {
        this.elements.addElement(el);
        this.buildState();
        if (!this.updateDisabled) {
            this.repaint();
        }
    }

    public void addElement(TreeElement el, int position) {
        this.elements.insertElementAt(el, position);
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    public TreeElement findElement(Object obj) {
        int i = 0;
        while (i < this.elements.size()) {
            TreeElement el = (TreeElement)this.elements.elementAt(i);
            if (el.getObject().equals(obj)) {
                return el;
            }
            TreeElement subElement = this.findElement(obj, el);
            if (subElement != null) {
                return subElement;
            }
            ++i;
        }
        return null;
    }

    private TreeElement findElement(Object obj, TreeElement parent) {
        int i = 0;
        while (i < parent.getNumChildren()) {
            TreeElement el = parent.getChild(i);
            if (el.getObject().equals(obj)) {
                return el;
            }
            TreeElement subElement = this.findElement(obj, el);
            if (subElement != null) {
                return subElement;
            }
            ++i;
        }
        return null;
    }

    public void removeObject(Object obj) {
        int i = this.elements.size() - 1;
        while (i >= 0) {
            TreeElement el = (TreeElement)this.elements.elementAt(i);
            if (el.getObject() == obj) {
                this.elements.removeElementAt(i);
            } else {
                el.removeChild(obj);
            }
            --i;
        }
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    public void removeAllElements() {
        this.elements.removeAllElements();
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    public TreeElement[] getElements() {
        Vector<TreeElement> v = new Vector<TreeElement>();
        int i = 0;
        while (i < this.elements.size()) {
            TreeElement el = (TreeElement)this.elements.elementAt(i);
            v.addElement(el);
            this.addChildrenToVector(el, v);
            ++i;
        }
        TreeElement[] allEl = new TreeElement[v.size()];
        int i2 = 0;
        while (i2 < allEl.length) {
            allEl[i2] = (TreeElement)v.elementAt(i2);
            ++i2;
        }
        return allEl;
    }

    private void addChildrenToVector(TreeElement el, Vector v) {
        int i = 0;
        while (i < el.getNumChildren()) {
            TreeElement child = el.getChild(i);
            v.addElement(child);
            this.addChildrenToVector(child, v);
            ++i;
        }
    }

    public Object[] getSelectedObjects() {
        Object[] sel = new Object[this.selected.size()];
        int i = 0;
        while (i < sel.length) {
            sel[i] = ((TreeElement)this.selected.elementAt(i)).getObject();
            ++i;
        }
        return sel;
    }

    public void deselectAll() {
        int i = 0;
        while (i < this.elements.size()) {
            this.deselectRecursively((TreeElement)this.elements.elementAt(i));
            ++i;
        }
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    private void deselectRecursively(TreeElement el) {
        el.setSelected(false);
        int i = 0;
        while (i < el.getNumChildren()) {
            this.deselectRecursively(el.getChild(i));
            ++i;
        }
    }

    public Object[] getVisibleObjects() {
        Object[] vis = new Object[this.showing.size()];
        int i = 0;
        while (i < vis.length) {
            vis[i] = ((TreeElement)this.showing.elementAt(i)).getObject();
            ++i;
        }
        return vis;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setSelected(Object obj, boolean selected) {
        TreeElement el = obj instanceof TreeElement ? (TreeElement)obj : this.findElement(obj);
        boolean wasDisabled = this.updateDisabled;
        this.updateDisabled = true;
        if (el != null) {
            el.setSelected(selected);
            int i = 0;
            while (i < el.getNumChildren()) {
                TreeElement child = el.getChild(i);
                if (child.selectWithParent()) {
                    this.setSelected(child, selected);
                }
                ++i;
            }
        }
        this.updateDisabled = wasDisabled;
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void expandToShowObject(Object obj) {
        v0 = el = obj instanceof TreeElement != false ? (TreeElement)obj : this.findElement(obj);
        if (el != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            el.setExpanded(true);
lbl5:
            // 2 sources

            ** while ((el = el.getParent()) != null)
        }
lbl6:
        // 1 sources

        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    private void recordUndo() {
        this.undo = new UndoRecord(this.window, false);
    }

    private UndoRecord finishRecording() {
        UndoRecord rec = this.undo;
        this.undo = null;
        return rec;
    }

    private void buildState() {
        if (this.updateDisabled) {
            return;
        }
        this.showing.removeAllElements();
        this.indent.removeAllElements();
        this.selected.removeAllElements();
        int i = 0;
        while (i < this.elements.size()) {
            TreeElement el = (TreeElement)this.elements.elementAt(i);
            this.showing.addElement(el);
            this.indent.addElement(new Integer(0));
            if (el.isSelected()) {
                this.selected.addElement(el);
            }
            this.addChildrenToState(el, 1, el.isExpanded());
            ++i;
        }
        if (this.origSelected.length != this.showing.size()) {
            this.origSelected = new boolean[this.showing.size()];
        }
        if (this.rowHeight > 0) {
            this.invalidate();
            this.getParent().invalidate();
            this.getParent().getParent().validate();
        }
    }

    private void addChildrenToState(TreeElement el, int currentIndent, boolean expanded) {
        int i = 0;
        while (i < el.getNumChildren()) {
            TreeElement child = el.getChild(i);
            if (expanded) {
                this.showing.addElement(child);
                this.indent.addElement(new Integer(currentIndent));
            }
            if (child.isSelected()) {
                this.selected.addElement(child);
            }
            this.addChildrenToState(child, currentIndent + 1, expanded & child.isExpanded());
            ++i;
        }
    }

    public void setYOffset(int offset) {
        this.yoffset = offset;
    }

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        Dimension dim = this.getSize();
        int y = this.yoffset;
        int oldRowHeight = this.rowHeight;
        this.rowHeight = Math.max(fm.getMaxAscent() + fm.getMaxDescent(), 8) + 3;
        if (this.rowHeight != oldRowHeight && this.getParent() != null) {
            this.invalidate();
            this.getParent().validate();
        }
        int i = 0;
        while (i < this.showing.size()) {
            TreeElement el = (TreeElement)this.showing.elementAt(i);
            int x = (Integer)this.indent.elementAt(i) * 10;
            if (el.getNumChildren() > 0) {
                g.setColor(Color.black);
                if (el.isExpanded()) {
                    openHandle.translate(x + 5, y + this.rowHeight / 2);
                    g.drawPolygon(openHandle);
                    openHandle.translate(-x - 5, -y - this.rowHeight / 2);
                } else {
                    closedHandle.translate(x + 5, y + this.rowHeight / 2);
                    g.drawPolygon(closedHandle);
                    closedHandle.translate(-x - 5, -y - this.rowHeight / 2);
                }
            }
            x += 10;
            if (el.isSelected()) {
                g.setColor(el.isGray() ? Color.gray : Color.black);
                g.fillRect(x, y, dim.width - x, this.rowHeight - 3);
                g.setColor(Color.white);
                g.drawString(el.getLabel(), x + 1, y + fm.getMaxAscent());
            } else {
                g.setColor(el.isGray() ? Color.gray : Color.black);
                g.drawString(el.getLabel(), x + 1, y + fm.getMaxAscent());
            }
            y += this.rowHeight;
            ++i;
        }
    }

    public void mousePressed(MouseEvent ev) {
        Point pos = ev.getPoint();
        pos.y -= this.yoffset;
        int row = pos.y / this.rowHeight;
        this.moving = false;
        if (row >= this.showing.size()) {
            this.deselectAll();
            this.buildState();
            if (this.itemListeners != null) {
                this.itemListeners.itemStateChanged(new ItemEvent(this, 701, null, 2));
            }
            return;
        }
        this.dragStart = this.lastDrag = row;
        TreeElement el = (TreeElement)this.showing.elementAt(row);
        int i = pos.x / 10;
        int ind = (Integer)this.indent.elementAt(row);
        if (i == ind && el.getNumChildren() > 0) {
            el.setExpanded(!el.isExpanded());
            this.buildState();
            this.repaint();
            this.sendTreeEvent(new TreeEvent(this, 1));
            this.showPopupIfNeeded(ev);
            return;
        }
        if (i < ind || el.getParent() != null && el.selectWithParent() && el.getParent().isSelected()) {
            this.showPopupIfNeeded(ev);
            return;
        }
        this.moving = !ev.isShiftDown();
        this.okToInsert = false;
        if (this.allowMultiple && ev.isShiftDown()) {
            this.setSelected(el, !el.isSelected());
            if (this.itemListeners != null) {
                this.itemListeners.itemStateChanged(new ItemEvent(this, 701, el.getObject(), el.isSelected() ? 1 : 2));
            }
        } else if (!el.isSelected()) {
            this.deselectAll();
            this.setSelected(el, true);
            if (this.itemListeners != null) {
                this.itemListeners.itemStateChanged(new ItemEvent(this, 701, el.getObject(), 1));
            }
        }
        i = 0;
        while (i < this.origSelected.length) {
            el = (TreeElement)this.showing.elementAt(i);
            this.origSelected[i] = el.isSelected();
            ++i;
        }
        this.buildState();
        this.repaint();
        this.showPopupIfNeeded(ev);
    }

    public void mouseDragged(MouseEvent ev) {
        Point pos = ev.getPoint();
        pos.y -= this.yoffset;
        int row = pos.y / this.rowHeight;
        if (this.moving) {
            TreeElement el;
            boolean above;
            if (this.selected.size() == 0) {
                return;
            }
            boolean bl = above = pos.y - row * this.rowHeight < this.rowHeight / 2;
            if (row >= this.showing.size()) {
                row = this.showing.size();
                above = true;
            }
            if (row < 0) {
                row = 0;
                above = true;
            }
            if (row == this.lastDrag && above == this.insertAbove) {
                return;
            }
            Graphics g = this.getGraphics();
            if (this.okToInsert) {
                g.setColor(this.getBackground());
                this.drawInsertionPoint(g, this.insertAbove ? this.lastDrag : this.lastDrag + 1, this.lastIndent);
            }
            TreeElement parent = null;
            if (row < this.showing.size()) {
                parent = el = (TreeElement)this.showing.elementAt(row);
                this.lastIndent = (Integer)this.indent.elementAt(row);
                if (above) {
                    parent = el.getParent();
                    this.okToInsert = this.dragTargetOk(parent);
                } else {
                    this.okToInsert = this.dragTargetOk(parent);
                    if (this.okToInsert) {
                        ++this.lastIndent;
                    } else {
                        parent = el.getParent();
                        this.okToInsert = this.dragTargetOk(parent);
                    }
                }
            } else {
                this.lastIndent = 0;
            }
            this.okToInsert = true;
            int i = 0;
            while (this.okToInsert && i < this.selected.size()) {
                el = (TreeElement)this.selected.elementAt(i);
                if (el.getParent() == null || !el.getParent().isSelected()) {
                    this.okToInsert &= el.canAcceptAsParent(parent);
                }
                ++i;
            }
            if (this.okToInsert) {
                g.setColor(Color.black);
                this.drawInsertionPoint(g, above ? row : row + 1, this.lastIndent);
            }
            g.dispose();
            this.lastDrag = row;
            this.insertAbove = above;
            return;
        }
        if (row == this.lastDrag || !this.allowMultiple) {
            return;
        }
        this.lastDrag = row;
        int min = Math.max(Math.min(row, this.dragStart), 0);
        int max = Math.min(Math.max(row, this.dragStart), this.showing.size() - 1);
        this.updateDisabled = true;
        int i = 0;
        while (i < this.showing.size()) {
            boolean sel;
            TreeElement el = (TreeElement)this.showing.elementAt(i);
            boolean bl = sel = this.origSelected[i] || i >= min && i <= max || el.getParent() != null && el.getParent().isSelected();
            if (el.isSelected() != sel) {
                this.setSelected(el, sel);
            }
            ++i;
        }
        this.updateDisabled = false;
        this.buildState();
        this.repaint();
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.moving) {
            if (this.okToInsert) {
                TreeElement parent;
                TreeElement el;
                this.recordUndo();
                this.updateDisabled = true;
                int position = 0;
                if (this.lastDrag < this.showing.size()) {
                    parent = el = (TreeElement)this.showing.elementAt(this.lastDrag);
                    if (this.insertAbove || !this.dragTargetOk(el)) {
                        parent = el.getParent();
                        if (parent == null) {
                            position = 0;
                            while (this.elements.elementAt(position) != el) {
                                ++position;
                            }
                        } else {
                            position = 0;
                            while (parent.getChild(position) != el) {
                                ++position;
                            }
                        }
                        if (!this.insertAbove) {
                            ++position;
                        }
                    } else {
                        position = 0;
                    }
                } else {
                    parent = null;
                    position = this.elements.size();
                }
                int i = 0;
                while (i < this.selected.size()) {
                    el = (TreeElement)this.selected.elementAt(i);
                    if (el.getParent() != null && el.getParent().isSelected()) {
                        this.selected.removeElementAt(i);
                        --i;
                    } else {
                        int j;
                        if (el.getParent() == parent && ((j = this.showing.indexOf(el)) < this.lastDrag || !this.insertAbove && j == this.lastDrag)) {
                            --position;
                        }
                        this.removeObject(el.getObject());
                    }
                    ++i;
                }
                if (position < 0) {
                    position = 0;
                }
                if (parent == null) {
                    int i2 = 0;
                    while (i2 < this.selected.size()) {
                        el = (TreeElement)this.selected.elementAt(i2);
                        if (el.getParent() == null || !el.getParent().isSelected()) {
                            this.addElement(el, position++);
                        }
                        ++i2;
                    }
                } else {
                    int i3 = 0;
                    while (i3 < this.selected.size()) {
                        el = (TreeElement)this.selected.elementAt(i3);
                        if (el.getParent() == null || !el.getParent().isSelected()) {
                            parent.addChild(el, position++);
                        }
                        ++i3;
                    }
                }
                this.updateDisabled = false;
                this.buildState();
                this.window.setUndoRecord(this.finishRecording());
                this.repaint();
                this.sendTreeEvent(new TreeEvent(this, 0));
            }
        } else if (this.lastDrag != this.dragStart && this.itemListeners != null) {
            this.itemListeners.itemStateChanged(new ItemEvent(this, 701, ((TreeElement)this.showing.elementAt(this.dragStart)).getObject(), 1));
        }
        Point pos = ev.getPoint();
        this.showPopupIfNeeded(ev);
    }

    private boolean dragTargetOk(TreeElement parent) {
        int i = 0;
        while (i < this.selected.size()) {
            TreeElement el = (TreeElement)this.selected.elementAt(i);
            if (!(el.getParent() != null && el.getParent().isSelected() || el.canAcceptAsParent(parent))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void mouseClicked(MouseEvent ev) {
        if (ev.getClickCount() != 2) {
            return;
        }
        Point pos = ev.getPoint();
        pos.y -= this.yoffset;
        int row = pos.y / this.rowHeight;
        int i = pos.x / 10;
        if (row >= this.showing.size()) {
            return;
        }
        int ind = (Integer)this.indent.elementAt(row);
        TreeElement el = (TreeElement)this.showing.elementAt(row);
        if (i < ind) {
            return;
        }
        this.sendTreeEvent(new TreeEvent(this, 2, el));
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }

    private void drawInsertionPoint(Graphics g, int pos, int indent) {
        int x = (indent + 1) * 10;
        int y = pos * this.rowHeight - 2 + this.yoffset;
        Dimension dim = this.getSize();
        insertHandle.translate(x, y);
        g.fillPolygon(insertHandle);
        insertHandle.translate(-x, -y);
        g.drawLine(x - 2, y, dim.width, y);
    }

    public void addItemListener(ItemListener l) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, l);
    }

    public void addTreeListener(TreeListener l) {
        this.treeListeners.addElement(l);
    }

    public void removeTreeListener(TreeListener l) {
        this.treeListeners.removeElement(l);
    }

    private void sendTreeEvent(TreeEvent ev) {
        int i = 0;
        while (i < this.treeListeners.size()) {
            TreeListener l = (TreeListener)this.treeListeners.elementAt(i);
            if (ev.getID() == 0) {
                l.elementsMoved(new TreeEvent((TreeList)ev.getSource(), ev.getID()));
            }
            if (ev.getID() == 1) {
                l.elementOpenedOrClosed(new TreeEvent((TreeList)ev.getSource(), ev.getID()));
            }
            if (ev.getID() == 2) {
                l.elementDoubleClicked(new TreeEvent((TreeList)ev.getSource(), ev.getID(), ev.getElement()));
            }
            ++i;
        }
    }

    public void setPopupMenuManager(PopupMenuManager manager) {
        this.popupManager = manager;
    }

    private void showPopupIfNeeded(MouseEvent ev) {
        if (!ev.isPopupTrigger() || this.popupManager == null) {
            return;
        }
        Graphics g = this.getGraphics();
        ((Component)this).update(g);
        g.dispose();
        Point pos = ev.getPoint();
        this.popupManager.showPopupMenu(this, pos.x, pos.y);
    }
}

